#############################################################
#
# setserial
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
SETSERIAL_SOURCE:=setserial.tar.gz
SETSERIAL_SITE:=ftp://ftp.gnu.org/gnu/setserial
SETSERIAL_CAT:=zcat
endif

SETSERIAL_DIR:=$(BUILD_DIR)/setserial
SETSERIAL_BINARY:=setserial
SETSERIAL_TARGET_BINARY:=bin/setserial

ifneq ($(USE_CVS),true)
setserial-fetch:
	 $(WGET) -P $(DL_DIR) $(SETSERIAL_SITE)/$(SETSERIAL_SOURCE)

setserial-source: $(DL_DIR)/$(SETSERIAL_SOURCE)
else
setserial-source:
endif

SETSERIAL_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d setserial $(CVS_TAG) $(CVS_PREFIX)setserial

setserial-checkout:
	@$(SETSERIAL_CVSCO)

$(SETSERIAL_DIR)/.unpacked: $(DL_DIR)/$(SETSERIAL_SOURCE)
ifneq ($(USE_CVS),true)
	$(SETSERIAL_CAT) $(DL_DIR)/$(SETSERIAL_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SETSERIAL_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(SETSERIAL_DIR)/
	touch $(SETSERIAL_DIR)/.unpacked

$(SETSERIAL_DIR)/.configured: $(SETSERIAL_DIR)/.unpacked
	(cd $(SETSERIAL_DIR); rm -rf config.cache; \
		autoconf ; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(SETSERIAL_DIR)/.configured

$(SETSERIAL_DIR)/$(SETSERIAL_BINARY): $(SETSERIAL_DIR)/.configured
	$(MAKE) -C $(SETSERIAL_DIR)

$(TARGET_DIR)/$(SETSERIAL_TARGET_BINARY): $(SETSERIAL_DIR)/$(SETSERIAL_BINARY)
	$(MAKE) STRIP=$(TARGET_CROSS)strip DESTDIR=$(TARGET_DIR) -C $(SETSERIAL_DIR) install
	install -d $(DOC_DIR)/doc/setserial
	@for f in README rc.serial ; do \
		install -m0644 $(SETSERIAL_DIR)/$$f $(DOC_DIR)/doc/setserial/$$f ;\
	done

setserial: uclibc $(TARGET_DIR)/$(SETSERIAL_TARGET_BINARY)

setserial-clean:
	-rm -f $(TARGET_DIR)/bin/setserial
	-rm -f $(TARGET_DIR)/usr/man/man8/setserial.8
	-rm -rf $(DOC_DIR)/doc/setserial
	-$(MAKE) -C $(SETSERIAL_DIR) clean

setserial-dirclean:
	rm -rf $(SETSERIAL_DIR)
endif

