#############################################################
#
# pwdb
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PWDB_SOURCE:=pwdb.tar.gz
PWDB_CAT:=zcat
endif

PWDB_DIR:=$(BUILD_DIR)/pwdb
PWDB_BINARY:=libpwdb/libpwdb.so
PWDB_TARGET_BINARY:=lib/libpwdb.so

ifneq ($(USE_CVS),true)
pwdb-source: $(DL_DIR)/$(PWDB_SOURCE)
else
pwdb-source:
endif

PWDB_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d pwdb $(CVS_TAG) $(CVS_PREFIX)pwdb

pwdb-checkout:
	@$(PWDB_CVSCO)

$(PWDB_DIR)/.unpacked: $(DL_DIR)/$(PWDB_SOURCE)
ifneq ($(USE_CVS),true)
	$(PWDB_CAT) $(DL_DIR)/$(PWDB_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PWDB_CVSCO)
endif
	touch $(PWDB_DIR)/.unpacked

$(PWDB_DIR)/$(PWDB_BINARY): $(PWDB_DIR)/.unpacked
	$(MAKE) \
		$(TARGET_CONFIGURE_OPTS) \
		AR="$(TARGET_CROSS)ar -cr" \
		-C $(PWDB_DIR)

$(STAGING_DIR)/$(PWDB_TARGET_BINARY): $(PWDB_DIR)/$(PWDB_BINARY)
	$(MAKE) \
		LDCONFIG= \
		INCLUDED=$(STAGING_DIR)/usr/include/pwdb \
		LIBDIR=$(STAGING_DIR)/lib \
		-C $(PWDB_DIR) \
		install

$(TARGET_DIR)/$(PWDB_TARGET_BINARY): $(STAGING_DIR)/$(PWDB_TARGET_BINARY)
	$(MAKE) \
		LDCONFIG= \
		INCLUDED=$(TARGET_DIR)/usr/include/pwdb \
		LIBDIR=$(TARGET_DIR)/lib \
		-C $(PWDB_DIR) \
		install
	-rm -rf $(TARGET_DIR)/usr/include/pwdb
	install -m0644 $(PWDB_DIR)/conf/pwdb.conf $(TARGET_DIR)/etc

pwdb: uclibc $(TARGET_DIR)/$(PWDB_TARGET_BINARY)

pwdb-clean:
	-rm -f $(STAGING_DIR)/$(PWDB_TARGET_BINARY) \
		$(STAGING_DIR)/usr/lib/libpwdb.* \
		$(TARGET_DIR)/usr/lib/libpwdb.* \
		$(TARGET_DIR)/etc/pwdb.conf
	-rm -rf $(STAGING_DIR)/usr/include/pwdb
	-$(MAKE) -C $(PWDB_DIR) clean

pwdb-dirclean:
	rm -rf $(PWDB_DIR)
endif

