#############################################################
#
# netkitbase
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITBASE_SOURCE:=netkit-base.tar.gz
NETKITBASE_SITE:=ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/
NETKITBASE_DIR:=$(BUILD_DIR)/${shell basename $(NETKITBASE_SOURCE) .tar.gz}

NETKITBASE_CAT:=zcat
else
NETKITBASE_DIR:=$(BUILD_DIR)/netkit-base
endif
NETKITBASE_BINARY:=inetd/inetd
NETKITBASE_TARGET_BINARY:=usr/sbin/inetd

ifneq ($(USE_CVS),true)
netkitbase-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITBASE_SITE)/$(NETKITBASE_SOURCE)

netkitbase-source: $(DL_DIR)/$(NETKITBASE_SOURCE)
else
netkitbase-source:
endif

NETKITBASE_CVSCO:=cd $(BUILD_DIR) && $(CVS)  $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d netkit-base $(CVS_PREFIX)netkit-base

netkitbase-checkout:
	@$(NETKITBASE_CVSCO)

$(NETKITBASE_DIR)/.unpacked: $(DL_DIR)/$(NETKITBASE_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITBASE_CAT) $(DL_DIR)/$(NETKITBASE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITBASE_CVSCO)
endif
	touch $(NETKITBASE_DIR)/.unpacked

$(NETKITBASE_DIR)/.configured: $(NETKITBASE_DIR)/.unpacked
	(cd $(NETKITBASE_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITBASE_DIR)/.configured

$(NETKITBASE_DIR)/$(NETKITBASE_BINARY): $(NETKITBASE_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) SUB=inetd -C $(NETKITBASE_DIR)

$(TARGET_DIR)/$(NETKITBASE_TARGET_BINARY): $(NETKITBASE_DIR)/$(NETKITBASE_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) SUB=inetd -C $(NETKITBASE_DIR) install
	$(STRIP) $(TARGET_DIR)/usr/sbin/inetd
	mkdir -p $(TARGET_DIR)/etc
	cp $(NETKITBASE_DIR)/etc.sample/inetd.conf $(TARGET_DIR)/etc/
	sed -i -e "s/^\([a-z]\)/#\1/;" $(TARGET_DIR)/etc/inetd.conf
	mkdir -p $(DOC_DIR)/doc/netkit-base
	install -m0644 $(NETKITBASE_DIR)/BUGS $(NETKITBASE_DIR)/README \
	    $(DOC_DIR)/doc/netkit-base/

netkitbase: uclibc $(TARGET_DIR)/$(NETKITBASE_TARGET_BINARY)

netkitbase-clean:
	-rm -f $(TARGET_DIR)/usr/sbin/inetd $(TARGET_DIR)/etc/inetd.conf
	-$(MAKE) -C $(NETKITBASE_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-base

netkitbase-dirclean:
	rm -rf $(NETKITBASE_DIR)

