#############################################################
#
# groff
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
GROFF_SOURCE:=groff.tar.gz
GROFF_CAT:=zcat
endif

GROFF_DIR:=$(BUILD_DIR)/groff
GROFF_BINARY:=src/roff/groff/groff
GROFF_TARGET_BINARY:=usr/bin/groff
GROFF_NATIVE_DIR:=$(BUILD_DIR)/groff-native

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(GROFF_SOURCE):
	 $(WGET) -P $(DL_DIR) $(GROFF_SITE)/$(GROFF_SOURCE)

groff-source: $(DL_DIR)/$(GROFF_SOURCE)
else
groff-source:
endif

GROFF_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d groff-native $(CVS_TAG) $(CVS_PREFIX)groff

groff-checkout:
	@$(GROFF_CVSCO)

ifneq ($(USE_CVS),true)
$(GROFF_DIR)/.unpacked: $(GROFF_NATIVE_DIR)/.unpacked
endif

$(GROFF_NATIVE_DIR)/.unpacked: $(DL_DIR)/$(GROFF_SOURCE)
ifneq ($(USE_CVS),true)
	$(GROFF_CAT) $(DL_DIR)/$(GROFF_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	mv $(GROFF_DIR) $(GROFF_NATIVE_DIR)
else
	@$(GROFF_CVSCO)
endif
	touch $(GROFF_NATIVE_DIR)/.unpacked

$(GROFF_NATIVE_DIR)/.configured: $(GROFF_NATIVE_DIR)/.unpacked
	(cd $(GROFF_NATIVE_DIR); rm -rf config.cache; \
		./configure \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(GROFF_NATIVE_DIR)/.configured

$(GROFF_NATIVE_DIR)/$(GROFF_BINARY): $(GROFF_NATIVE_DIR)/.configured
	$(MAKE)	-C $(GROFF_NATIVE_DIR)

$(STAGING_DIR)/$(GROFF_TARGET_BINARY): $(GROFF_NATIVE_DIR)/$(GROFF_BINARY)
	$(MAKE) \
		prefix=$(STAGING_DIR)/usr \
		exec-prefix=$(STAGING_DIR)/usr \
		bindir=$(STAGING_DIR)/usr/bin \
		sbindir=$(STAGING_DIR)/usr/sbin \
		libexecdir=$(STAGING_DIR)/usr/lib \
		sysconfdir=$(STAGING_DIR)/etc \
		datadir=$(STAGING_DIR)/usr/share \
		localstatedir=$(STAGING_DIR)/var \
		mandir=$(STAGING_DIR)/usr/man \
		infodir=$(STAGING_DIR)/usr/info \
		-C $(GROFF_NATIVE_DIR) install

groff-native-clean:
	-$(MAKE) \
		prefix=$(STAGING_DIR)/usr \
		exec-prefix=$(STAGING_DIR)/usr \
		bindir=$(STAGING_DIR)/usr/bin \
		sbindir=$(STAGING_DIR)/usr/sbin \
		libexecdir=$(STAGING_DIR)/usr/lib \
		sysconfdir=$(STAGING_DIR)/etc \
		datadir=$(STAGING_DIR)/usr/share \
		localstatedir=$(STAGING_DIR)/var \
		mandir=$(STAGING_DIR)/usr/man \
		infodir=$(STAGING_DIR)/usr/info \
		-C $(GROFF_DIR) uninstall
	-$(MAKE) -C $(GROFF_NATIVE_DIR) clean

groff-native-dirclean:
	rm -rf $(GROFF_NATIVE_DIR)

$(GROFF_DIR)/.unpacked: $(DL_DIR)/$(GROFF_SOURCE) $(STAGING_DIR)/$(GROFF_TARGET_BINARY)
ifneq ($(USE_CVS),true)
	$(GROFF_CAT) $(DL_DIR)/$(GROFF_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d groff $(CVS_TAG) $(CVS_PREFIX)groff
endif
	cat $(SOURCE_DIR)/groff.patch | patch -p0 -d $(GROFF_DIR)
	cp $(SOURCE_DIR)/config.sub $(GROFF_DIR)/
	touch $(GROFF_DIR)/.unpacked

$(GROFF_DIR)/.configured: $(GROFF_DIR)/.unpacked
	(cd $(GROFF_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(GROFF_DIR)/.configured

$(GROFF_DIR)/$(GROFF_BINARY): $(GROFF_DIR)/.configured
	$(MAKE) \
		TROFFBIN=$(STAGING_DIR)/usr/bin/troff \
		GROFFBIN=$(STAGING_DIR)/usr/bin/groff \
		GROFF_BIN_PATH=$(STAGING_DIR)/usr/bin:$$PATH \
		-C $(GROFF_DIR)

$(TARGET_DIR)/$(GROFF_TARGET_BINARY): $(GROFF_DIR)/$(GROFF_BINARY)
	$(MAKE) \
		prefix=$(TARGET_DIR)/usr \
		exec-prefix=$(TARGET_DIR)/usr \
		bindir=$(TARGET_DIR)/usr/bin \
		sbindir=$(TARGET_DIR)/usr/sbin \
		libexecdir=$(TARGET_DIR)/usr/lib \
		sysconfdir=$(TARGET_DIR)/etc \
		datadir=$(TARGET_DIR)/usr/share \
		localstatedir=$(TARGET_DIR)/var \
		mandir=$(TARGET_DIR)/usr/man \
		infodir=$(TARGET_DIR)/usr/info \
		-C $(GROFF_DIR) install
	install -d $(DOC_DIR)/doc/groff
	@for f in BUG-REPORT COPYING FDL LICENSE README ; do \
		install -m0644 $(GROFF_DIR)/$$f $(DOC_DIR)/doc/groff/$$f ;\
	done

groff: uclibc $(TARGET_DIR)/$(GROFF_TARGET_BINARY)

groff-clean:
	-$(MAKE) \
		prefix=$(TARGET_DIR)/usr \
		exec-prefix=$(TARGET_DIR)/usr \
		bindir=$(TARGET_DIR)/usr/bin \
		sbindir=$(TARGET_DIR)/usr/sbin \
		libexecdir=$(TARGET_DIR)/usr/lib \
		sysconfdir=$(TARGET_DIR)/etc \
		datadir=$(TARGET_DIR)/usr/share \
		localstatedir=$(TARGET_DIR)/var \
		mandir=$(TARGET_DIR)/usr/man \
		infodir=$(TARGET_DIR)/usr/info \
		-C $(GROFF_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/groff
	-$(MAKE) -C $(GROFF_DIR) clean

groff-dirclean:
	rm -rf $(GROFF_DIR)
endif

