#############################################################
#
# uchdp DHCP client and/or server
#
#############################################################
# Copyright (C) 2001-2003 by Erik Andersen <andersen@codepoet.org>
# Copyright (C) 2002 by Tim Riker <Tim@Rikers.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
ifneq ($(USE_CVS),true)
DHCPCD_SOURCE:=dhcpcd.tar.gz
DHCPCD_SITE:=ftp://ftp.phystech.com/pub/
endif

DHCPCD_DIR:=$(BUILD_DIR)/dhcpcd

ifneq ($(USE_CVS),true)
dhcpcd-fetch:
	$(WGET) -P $(DL_DIR) $(DHCPCD_SITE)/$(DHCPCD_SOURCE)

dhcpcd-source: $(DL_DIR)/$(DHCPCD_SOURCE)
else
dhcpcd-source:
endif

DHCPCD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d dhcpcd $(CVS_TAG) $(CVS_PREFIX)dhcpcd

dhcpcd-checkout:
	@$(DHCPCD_CVSCO)

$(DHCPCD_DIR)/.unpacked: $(DL_DIR)/$(DHCPCD_SOURCE)
ifneq ($(USE_CVS),true)
	zcat $(DL_DIR)/$(DHCPCD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(DHCPCD_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(DHCPCD_DIR)/
	touch $(DHCPCD_DIR)/aclocal.m4
	touch $(DHCPCD_DIR)/configure.in
	touch $(DHCPCD_DIR)/Makefile.in
	touch $(DHCPCD_DIR)/.unpacked

$(DHCPCD_DIR)/.configured: $(DHCPCD_DIR)/.unpacked
	(cd $(DHCPCD_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--disable-rpath \
		--disable-dependency-tracking \
	);
	touch $(DHCPCD_DIR)/.configured

$(DHCPCD_DIR)/dhcpcd: $(DHCPCD_DIR)/.configured
	$(MAKE) CROSS_COMPILE="$(TARGET_CROSS)" prefix="$(TARGET_DIR)" -C $(DHCPCD_DIR)

$(TARGET_DIR)/sbin/dhcpcd: $(DHCPCD_DIR)/dhcpcd
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(DHCPCD_DIR) install
	install -d $(DOC_DIR)/doc/dhcpcd
	for f in AUTHORS COPYING NEWS README ; do \
		install -m0644 $(DHCPCD_DIR)/$$f $(DOC_DIR)/doc/dhcpcd/$$f ;\
	done

dhcpcd: uclibc $(TARGET_DIR)/sbin/dhcpcd 

dhcpcd-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(DHCPCD_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/dhcpcd
	-$(MAKE) -C $(DHCPCD_DIR) clean

dhcpcd-dirclean:
	rm -rf $(DHCPCD_DIR)
