#############################################################
#
# acpid
#
#############################################################

ifneq ($(USE_CVS), true)
ACPID_SOURCE:=acpid.tar.gz
ACPID_DIR:=$(BUILD_DIR)/acpid
ACPID_CAT:=zcat
else
ACPID_DIR:=$(BUILD_DIR)/acpid
endif

ACPID_BINARY:=acpid
ACPID_TARGET_BINARY:=usr/sbin/acpid

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(ACPID_SOURCE):

acpid-source: $(DL_DIR)/$(ACPID_SOURCE)
else
acpid-source:
endif

ACPID_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d acpid $(CVS_TAG) $(CVS_PREFIX)acpid

acpid-checkout: 
	@$(ACPID_CVSCO)

$(ACPID_DIR)/.unpacked: $(DL_DIR)/$(ACPID_SOURCE)
ifneq ($(USE_CVS), true)
	$(ACPID_CAT) $(DL_DIR)/$(ACPID_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(ACPID_CVSCO)
endif
	-cat $(SOURCE_DIR)/acpid.patch | patch -d $(ACPID_DIR)
	touch  $(ACPID_DIR)/.unpacked

$(ACPID_DIR)/$(ACPID_BINARY): $(ACPID_DIR)/.unpacked
	$(MAKE) $(TARGET_CONFIGURE_OPTS) CFLAGS_EXTRAS="$(TARGET_CFLAGS)" -C $(ACPID_DIR)

$(TARGET_DIR)/$(ACPID_TARGET_BINARY): $(ACPID_DIR)/$(ACPID_BINARY)
	install -m 0755 $(ACPID_DIR)/acpid $(TARGET_DIR)/$(ACPID_TARGET_BINARY)
	install -m 0644 $(ACPID_DIR)/acpid.8 $(TARGET_DIR)/usr/man/man8
	install -d $(TARGET_DIR)/usr/share/acpid
	for i in README Changelog TODO; do install -m 0644 $(ACPID_DIR)/$$i $(TARGET_DIR)/usr/share/acpid; done
	cp -r $(ACPID_DIR)/samples $(TARGET_DIR)/usr/share/acpid

acpid: uclibc $(TARGET_DIR)/$(ACPID_TARGET_BINARY)

acpid-clean: acpid-uninstall
	-$(MAKE) -C $(ACPID_DIR) clean

acpid-uninstall:
	rm -f $(TARGET_DIR)/usr/sbin/acpid
	rm -f $(TARGET_DIR)/usr/man/man8/acpid.8
	rm -rf $(TARGET_DIR)/usr/share/acpid

acpid-dirclean:
	rm -rf $(ACPID_DIR)

