/*
 * Reimplementation of err/warnx.
 */

char err_rcsid[] = 
  "$Id: err.c,v 1.2 2004/06/04 19:24:31 dlehman Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <err.h>

void err(int eval, const char *fmt, ...) {
    va_list ap;
    va_start(ap, fmt);
    fprintf(stderr, "rup: ");
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "%m\n");
    va_end(ap);
    exit(eval);
}

void warnx(const char *fmt, ...) {
    va_list ap;
    va_start(ap, fmt);
    fprintf(stderr, "rup: ");
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n");
    va_end(ap);
}
