#ifndef _ASM_MMU_CONTEXT_H
#define _ASM_MMU_CONTEXT_H

#include <asm/atomic.h>
#include <asm/pgalloc.h>
#include <asm/tlbflush.h>

extern int init_new_context(struct task_struct *tsk, struct mm_struct *mm);
extern void change_mm_context(mm_context_t *old, mm_context_t *ctx, pgd_t *_pgd);
extern void destroy_context(struct mm_struct *mm);

/*
 * This is called when "tsk" is about to enter lazy TLB mode.
 *
 * mm:  describes the currently active mm context
 * tsk: task which is entering lazy tlb
 * cpu: cpu number which is entering lazy tlb
 *
 * tsk->mm will be NULL
 */
static inline void enter_lazy_tlb(struct mm_struct *mm, struct task_struct *tsk)
{
}

/*
 * This is the actual mm switch as far as the scheduler
 * is concerned.  No registers are touched.
 */
#define switch_mm(prev, next, tsk)						\
do {										\
	if (prev != next)							\
		change_mm_context(&prev->context, &next->context, next->pgd);	\
} while(0)

#define activate_mm(prev, next)						\
do {									\
	change_mm_context(&prev->context, &next->context, next->pgd);	\
} while(0)

#define deactivate_mm(tsk, mm)	do {} while(0)

#endif /* _ASM_MMU_CONTEXT_H */
