<?php
/**
 * XMP Data - Interprete and return XMP data
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @author Jeroen Roos
 * @package Zoph
 */

namespace xmp;

use file;

use ArrayAccess;

/**
 * @author Jeroen Roos
 * @package Zoph
 */
class data implements ArrayAccess  {

    private static $containers = array("rdf:Seq", "rdf:Bag", "rdf:Alt");
    private $xmpdata = array();

    /**
     * Create new xmp/data object
     * @param array data to inject
     */
    public function __construct(array $data=null) {
        $this->xmpdata = $data;
    }

    public function getRDFDescription($off) {
        return $this["x:xmpmeta"]["rdf:RDF"]["rdf:Description"][$off];
    }

    /**
     * For ArrayAccess: does the offset exist
     * @param int|string offset
     * @return bool offset exists
     */
    public function offsetExists($off) {
        return (isset($this[$off]));
    }
    /**
     * For ArrayAccess: Get value of parameter
     * @param int|string offset
     * @return mixed value
     */
    public function offsetGet($off) {
        $data = $this->xmpdata[$off] ?? null;
        if (is_array($data)) {
            $return = array();
            foreach(array_keys($data) as $entry) {
                if (in_array($entry, self::$containers)) {
                    $return[] = $data[$entry];
                }
            }
            if (sizeof($return) > 1) {
                return $return;
            } else if (sizeof($return) == 1) {
                return array_pop($return);
            } else {
                return new self($data);
            }
        } else {
            return $data;
        }
    }

    /**
     * For ArrayAccess: Set value of parameter
     * @param int|string offset
     * @param mixed value
     */
    public function offsetSet($off, $val) {
        $this->xmpdata[$off] = $val;
    }

    /**
     * For ArrayAccess: Unset value of parameter
     * @param int|string offset
     */
    public function offsetUnset($off) {
        unset($this->xmpdata[$off]);
    }

    /**
     * For ObjectAccess: Get value of parameter
     * @param int|string offset
     * @return mixed value
     */
    public function __get($xmp) {
        return $this->offsetGet($off);
    }
}
?>
