.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH joystick __drivermansuffix__ __vendorversion__
.SH NAME
joystick \- Joystick input driver
.SH SYNOPSIS
Snipped for xorg.conf.d(5):

.nf
.B "Section \*qInputClass\*q"
.BI "  Identifier \*q" joystick-all \*q
.BI "  Driver \*q" joystick \*q
.BI "  Option \*qMatchIsJoystick\*q   \*q" on \*q
.BI "  Option \*qMatchDevicePath\*q   \*q" /dev/input/event* \*q
\ \ ...
.B EndSection
.fi


.SH DESCRIPTION
.B joystick
is an __xservername__ input driver for controlling the pointer with a
joystick device.
.TP 3
Use this driver, if you want to
- generate 
.IR "cursor movement" ,
perform button or key events to control desktop and applications

- generate 
.I "cursor key events"
for playing legacy games, that have no native joystick support

.TP 3
.B Do not use, if you want to
- play games, that have native joystick support

- use XI2 applications. The evdev(4) driver will suffice for those in most cases.

.PP
You may mix above scenarios by setting the device 
.IR floating .
The driver reports relative cursor movement, button and key events,
as well as raw axis values through valuators.

.SH SUPPORTED HARDWARE
The joystick input module can be used on top of the following kernel devices:

.nf
.B - Linux's evdev device
.B - Linux's joystick device
.B - BSD's usbhid device
.fi

Every joystick supported by the kernel should be supported by the 
.B joystick
input driver. The joystick is assumed to be calibrated and reporting axis values
between 
.IR "-32768 " and " 32768" .
See the Linux kernel documentation for a complete list of supported devices.

There is no support for
.B force feedback
at the moment.

.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following Driver
.B Options
are supported:
.TP 7
.BI "Option \*qDevice\*q \*q" string \*q
.TP 7
.BI "Option \*qPath\*q \*q" string \*q
Specifies the device through which the joystick can be accessed. This option is mandatory and there is no default setting.

In Linux, joysticks are usually accessible through
.IR /dev/input/jsX " or " /dev/input/eventX .

In *BSD, joysticks are usually recognized as 
.IR /dev/uhidX .
.TP 7
.BI "Option \*qAutoRepeat\*q \*q" "delay rate" \*q
Sets the auto repeat behaviour for key events.
.I delay
is the time in milliseconds before a key starts repeating.
.I rate
is the number of times a key repeats per second.  Default: Xorg default
.TP 7
.BI "Option \*qDebugLevel\*q \*q" integer \*q
Controls the verbosity of the driver for debugging purposes. The higher the DebugLevel, the more output is produced.
Default: 0
.TP 7
.BI "Option \*qMapButton<number>\*q \*q" string \*q
Sets the mapping of a joystick button to the desired action. Button counting starts with 
.IR 1 ,
Possible options are:
.RS 7
.TP 7
.B "none"
Don't do anything
.TP 7
.BI "\*qbutton="<number> \*q
Generate a pointer button event with button
.I number
(starting with 1).
.TP 7
.BI "\*qaxis="[<factor>]<axis> \*q
Where
.I <axis>
is one of:
.B x, y, zx, zy

and 
.I <factor>
is an optional amplifier of the axis, like
.B -, +, -5, 0.4, 1.3, ...
Negative values invert the direction. Default: 1.0
.TP 7
.BI "\*qamplify="<factor> \*q
Amplifies the movement of all axes by the given factor when this button is held down. Different
factors can be combined.
.TP 7
.BI "\*qkey="<scancode>[,<scancode>[,<scancode>[,<scancode>]]]
When button is pressed, a series of keydown events with the specified scancodes is
generated. When the button is released, matching keyup events in the opposite
order are generated. You can specify up to 4 scancodes per button.

See special section about key events below.
.TP 7
.B "\*qdisable-mouse\*q"
.TP 7
.B "\*qdisable-keys\*q"
.TP 7
.B "\*qdisable-all\*q"
Disables either the generation of mouse events, key events or the generation of
all X events by the driver. Press button again to allow the driver to generate 
events again.

You may also set the device
.B floating
from client space to prevent it from generating core events.
.RE
.PP
.TP 7
.BI "Option \*qMapAxis<number>\*q \*q" string \*q
Sets the mapping of the axis to the desired action. Axis counting starts with
.IR 1 ,
the parameter may contain:
.RS 7
.TP 7
.BI "\*qmode="<string> \*q
Where
.I <string>
can be one of:

.B none, relative, accelerated, absolute

.TP 7
.B \*qvaluator\*q
Send extra valuator events for this axis. The valuators will be numbered ascending, starting with 2 (valuator 0 and 1 are reserved for pointer movement). Please consider using the evdev(4) input driver if you are only interested in XI2 features.

The range of the valuators is always 
.IR -32767 " to " 32768 .
Neither
.B mode
nor
.B axis
needs to be set to generate extra valuator events. The axis will be labelled according to its physical axis number, beginning with 
.I 1
, e.g.
.I \*qAxis 1\*q
for the first axis (being the 3rd valuator).
Default: not set.
.TP 7
.BI "\*qaxis="[<factor>]<axis> \*q
Where
.I <axis>
is one of:
.B x, y, zx, zy, key (see keylow/keyhigh)

and 
.I <factor>
is an optional amplifier of the axis, like
.B -, +, -5, 0.4, 1.3, ...
Negative values will invert the movement. Default: 1.0
.TP 7
.BI "\*qkeylow="<scancode>[,<scancode>[,<scancode>[,<scancode>]]]
.TP 7
.BI "\*qkeyhigh="<scancode>[,<scancode>[,<scancode>[,<scancode>]]]
When the axis is moved out of the deadzone, a series of keydown events according 
to the direction of the movement is generated. When the axis is released, matching keyup 
events in opposite order will be generated. You can specify up to 4 scancodes for each direction.

.B keylow
defines the keys to be generated when the axis is moved in negative direction (left or up),
.B keyhigh
defines the keys to be generated when the axis is moved in positive direction (right or down).

If 
.B mode
is set to 
.IR relative :
The driver will emulate autorepeat according to the current value of the axis. A keydown and subsequent keyup event will be generated in short time intervals. To modify that interval and the autorepeat speed, supply the
.BI "\*qaxis="[<factor>]KEY \*q
parameter.

If 
.B mode
is set to 
.IR accelerated :
Keydown and keyup events will be generated repeatedly. The time between a keydown and a keyup event corresponds to the deflection of the axis.
If the axis is deflected by 30%, the key will be considered to be down 300ms out of 1 second. The exact intervals may vary and can be adjusted with the
.I amplify
parameter. If the axis is deflected by 100%, there will only be one keydown event, so the key is considered down all the time.
The keys will be autorepeated according to the Xorg keyboard settings.

See special section about key events below.
.TP 7
.BI "\*qdeadzone="<number> \*q
Sets the unresponsive range of the axis to
.IR <number> .
This can be between
.IR "0" " and " "30000" .
Default: 5000
.RE
.PP
.TP 7
.BI "Option \*qStartKeysEnabled\*q \*q" "boolean" \*q
Set to
.I False
to disable key event generation after startup. You can toggle key event generation with the 
.I disable-keys
button mapping. Default: enabled
.TP 7
.BI "Option \*qStartMouseEnabled\*q \*q" "boolean" \*q
Set to
.I False
to disable mouse event generation after startup. You can toggle mouse event generation with the 
.I disable-mouse
button mapping. Default: enabled
.RE
.PP


.SH "DEFAULT CONFIGURATION"
The default configuration is as follows:

.nf
.BI "  Option \*qDebugLevel\*q        \*q" 0 \*q
.BI "  Option \*qStartKeysEnabled\*q  \*q" True \*q
.BI "  Option \*qStartMouseEnabled\*q \*q" True \*q
.BI "  Option \*qMapButton1\*q        \*q" button=1 \*q
.BI "  Option \*qMapButton2\*q        \*q" button=2 \*q
.BI "  Option \*qMapButton3\*q        \*q" button=3 \*q
.BI "  Option \*qMapButton4\*q        \*q" none \*q
\ \ ...
.BI "  Option \*qMapAxis1\*q          \*q" "mode=relative    axis=+1x  deadzone=5000" \*q
.BI "  Option \*qMapAxis2\*q          \*q" "mode=relative    axis=+1y  deadzone=5000" \*q
.BI "  Option \*qMapAxis3\*q          \*q" "mode=relative    axis=+1zx deadzone=5000" \*q
.BI "  Option \*qMapAxis4\*q          \*q" "mode=relative    axis=+1zy deadzone=5000" \*q
.BI "  Option \*qMapAxis5\*q          \*q" "mode=accelerated axis=+1x  deadzone=5000" \*q
.BI "  Option \*qMapAxis6\*q          \*q" "mode=accelerated axis=+1y  deadzone=5000" \*q
.BI "  Option \*qMapAxis7\*q          \*q" "mode=none" \*q
\ \ ...
.fi

.SH "ACCELERATED AXIS CONFIGURATION"
.B Accelerated
mode should be selected, if the axis is a
.IR "directional pad" ,
which reports only three states: negative, center, positive. It will result in smoothly accelerated movement
when the axis is deflected. An optional factor will affect the acceleration and final speed.

This example will set up the axis as scrolling vertically inverted, with half the speed:
.nf
.BI "  Option \*qMapAxis1\*q     \*q" "mode=accelerated axis=-0.5zy" \*q
.fi

This example maps four buttons to the four pointer directions, so you can use the buttons like a d-pad. The movement will be accelerated
with half the normal speed:
.nf
.BI "  Option \*qMapButton1\*q     \*q" "axis=+0.5x" \*q
.BI "  Option \*qMapButton2\*q     \*q" "axis=-0.5x" \*q
.BI "  Option \*qMapButton3\*q     \*q" "axis=+0.5y" \*q
.BI "  Option \*qMapButton4\*q     \*q" "axis=-0.5y" \*q
.fi

.SH "ABSOLUTE AXIS CONFIGURATION"
In
.B absolute
axis mode, the
.I position of the cursor will match the
.I position of the configured axis, but relative to the previous position of the cursor. You can specify the range in which the cursor can move. The default range is the screen size.

In this example the first axis gets a range from left to the right of the screen. The second axis gets a
total range of 200 pixels, 100 to the top and 100 to the bottom:
.nf 
.BI "  Option \*qMapAxis1\*q     \*q" "mode=absolute axis=x" \*q
.BI "  Option \*qMapAxis2\*q     \*q" "mode=absolute axis=200y" \*q
.fi

.SH "GENERATING KEY EVENTS"
Providing a \*qkey=<scancode>[,<scancode>[...]]\*q option will generate X Events with specified scancodes. When the button/axis is released, the keys will be released in opposite order.

If you want a certain KeySym, look up the matching scancode using
.BR "xmodmap -pk" .
The scancodes depend on the configured keyboard layout. You can also use unused keycodes and map them to a KeySym of your choice using xmodmap(1).

You can specify up to 4 scancodes per joystick button/axis, which can be used for modificators to get the KeySym you want.

Examples:
.nf
.BI "  Option \*qMapButton1\*q     \*q" "key=64,23" \*q
.fi
will generate
.I "Alt_L+Tab"
when the button is pressed.

.nf
.BI "  Option \*qMapButton1\*q     \*q" "key=50,40" \*q
.fi
will generate a 
.I "Shift_L+d"
which will result in an uppercase 
.IR d .

.nf
.BI "  Option \*qMapButton1\*q     \*q" "key=65" \*q
.fi
will result in a
.IR "space " key.

.nf
.BI "  Option  \*qMapAxis1\*q      \*q" "mode=relative    keylow=113  keyhigh=114 axis=0.5key" \*q
.BI "  Option  \*qMapAxis2\*q      \*q" "mode=relative    keylow=111  keyhigh=116" \*q
.BI "  Option  \*qMapAxis3\*q      \*q" "mode=accelerated keylow=113  keyhigh=114" \*q
.BI "  Option  \*qMapAxis4\*q      \*q" "mode=accelerated keylow=111  keyhigh=116" \*q
.fi
will map the first and third axis to the arrow keys
.IR left " and " right
and the second and fourth axis to the arrow keys
.IR up " and " down .

The keys for the first two axes will be generated in an interval according to the value of the axis. The autorepeat speed of the first axis will be half the speed of that of the second axis.
The keys for the third and fourth axis are generated once when the axis moves out of the deadzone and when it moves back into the deadzone. X.Org will autorepeat those keys according to current keyboard settings.

.SH "XI2 Events"
If you only care about raw valuator events instead of using the joystick to control the cursor, consider using the evdev(4)
input driver. If you still use the
.B joystick
driver for raw events, make sure to unmap all axes/buttons and add the
.B valuator
option to the axes:

.nf
.BI "  Option  \*qMapAxis1\*q      \*q" "mode=none valuator" \*q
.BI "  Option  \*qMapAxis2\*q      \*q" "mode=none valuator" \*q
.BI "  Option  \*qMapAxis3\*q      \*q" "mode=none valuator" \*q
.BI "  Option  \*qMapAxis4\*q      \*q" "mode=none valuator" \*q
\ \ ...
.BI "  Option  \*qMapButton1\*q      \*q" "button=1" \*q
.BI "  Option  \*qMapButton2\*q      \*q" "button=2" \*q
.BI "  Option  \*qMapButton3\*q      \*q" "button=3" \*q
.BI "  Option  \*qMapButton4\*q      \*q" "button=4" \*q
.BI "  Option  \*qMapButton5\*q      \*q" "button=5" \*q
\ \ ...
.fi

Remember, that valuators 0 and 1 are reserved for pointer movement, additional axes will start with valuator 2.

You might also want to set the device "floating" to stop it from reporting core events:
.nf
.BI "  Option  \*qFloating\*q      \*q" "true" \*q
.fi

.SH "NOTES"
It is not recommended to enable the
.B joystick
input driver by default unless explicitly requested by the user.

Configuration through
.I InputClass
sections is recommended in X servers 1.8 and later. See xorg.conf.d(5) for more details. An example xorg.conf.d(5) snipped is provided in 
.I ${sourcecode}/config/50-joystick-all.conf


Configuration through hal fdi files is recommended in X servers 1.5,
1.6 and 1.7. An example hal policy file is still provided in 
.I ${sourcecode}/config/50-x11-input-joystick.fdi
to be placed in
.IR /etc/hal/fdi/policy .


.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorg.conf.d(5), Xserver(__appmansuffix__), X(__miscmansuffix__), xmodmap(1)
.SH AUTHORS
Sascha Hlusiak (2007-2012),
.fi
Frederic Lepied (1995-1999)
