#!/usr/bin/env python
import vtk
from vtk.test import Testing
from vtk.util.misc import vtkGetDataRoot
VTK_DATA_ROOT = vtkGetDataRoot()

#
# Test butterfly subdivision of point data
#
sphere = vtk.vtkSphereSource()
sphere.SetPhiResolution(11)
sphere.SetThetaResolution(11)
colorIt = vtk.vtkElevationFilter()
colorIt.SetInputConnection(sphere.GetOutputPort())
colorIt.SetLowPoint(0,0,-.5)
colorIt.SetHighPoint(0,0,.5)
butterfly = vtk.vtkButterflySubdivisionFilter()
butterfly.SetInputConnection(colorIt.GetOutputPort())
butterfly.SetNumberOfSubdivisions(3)
lut = vtk.vtkLookupTable()
lut.SetNumberOfColors(256)
lut.Build()
mapper = vtk.vtkPolyDataMapper()
mapper.SetInputConnection(butterfly.GetOutputPort())
mapper.SetLookupTable(lut)
actor = vtk.vtkActor()
actor.SetMapper(mapper)
linear = vtk.vtkLinearSubdivisionFilter()
linear.SetInputConnection(colorIt.GetOutputPort())
linear.SetNumberOfSubdivisions(3)
mapper2 = vtk.vtkPolyDataMapper()
mapper2.SetInputConnection(linear.GetOutputPort())
mapper2.SetLookupTable(lut)
actor2 = vtk.vtkActor()
actor2.SetMapper(mapper2)
mapper3 = vtk.vtkPolyDataMapper()
mapper3.SetInputConnection(colorIt.GetOutputPort())
mapper3.SetLookupTable(lut)
actor3 = vtk.vtkActor()
actor3.SetMapper(mapper3)
ren1 = vtk.vtkRenderer()
ren2 = vtk.vtkRenderer()
ren3 = vtk.vtkRenderer()
renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren1)
renWin.AddRenderer(ren2)
renWin.AddRenderer(ren3)
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)
ren1.AddActor(actor)
ren1.SetBackground(1,1,1)
ren2.AddActor(actor2)
ren2.SetBackground(1,1,1)
ren3.AddActor(actor3)
ren3.SetBackground(1,1,1)
renWin.SetSize(600,200)
aCamera = vtk.vtkCamera()
aCamera.Azimuth(70)
aLight = vtk.vtkLight()
aLight.SetPosition(aCamera.GetPosition())
aLight.SetFocalPoint(aCamera.GetFocalPoint())
ren1.SetActiveCamera(aCamera)
ren1.AddLight(aLight)
ren1.ResetCamera()
aCamera.Dolly(1.4)
ren1.ResetCameraClippingRange()
ren2.SetActiveCamera(aCamera)
ren2.AddLight(aLight)
ren3.SetActiveCamera(aCamera)
ren3.AddLight(aLight)
ren3.SetViewport(0,0,.33,1)
ren2.SetViewport(.33,0,.67,1)
ren1.SetViewport(.67,0,1,1)
iren.Initialize()
def flat (__vtk__temp0=0,__vtk__temp1=0):
    actor.GetProperty().SetInterpolationToFlat()
    actor2.GetProperty().SetInterpolationToFlat()
    actor3.GetProperty().SetInterpolationToFlat()
    renWin.Render()

def smooth (__vtk__temp0=0,__vtk__temp1=0):
    actor.GetProperty().SetInterpolationToGouraud()
    actor2.GetProperty().SetInterpolationToGouraud()
    actor3.GetProperty().SetInterpolationToGouraud()
    renWin.Render()

# --- end of script --
