/**
	@license GNU GPLv2
	PROJECT "trovacap"
	Copyright  2006 Danilo Cicerone

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation,
	Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

/**
	@file dlg_help.h
	@author Danilo Cicerone info@digitazero.org
	@date 2006-12-05
	@version 0.2.2
*/

#ifndef PGRHELP_H
#define PGRHELP_H

#include <FL/Fl.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Help_View.H>
#include <FL/Fl_Window.H>

#include <string>

using namespace std;

class WinHelp
{
	public:
		WinHelp();
		~WinHelp();
		void show();
		void hide();
		int visible();
		int standby();

	private:
		const static int winW = 800;

		const static int winH = 600;

		Fl_Window *dlg_help;

		Fl_Help_View *hlp_html;

		Fl_Button *btn_annulla;

		static void
		cb_btn_annulla(Fl_Button*, void*);

		inline void
		ex_annulla();
};

#endif
