.\"
.\" ${SOELIM} this-file | ${TBL} | ${TROFF} ${MSMACROS}
.\"
.\" C is a non-proportional font; if different at your site, change C
.\" to something more appropriate.  Then use .Cw to reference the font.
.\" For in-line references, use \f\*(cW
.fp 4 C \" this should be a non-proportional font
.ds cW 4
.fp 5 CB \" this should be a bold non-proportional font
.ds cB 5
.\"
.\" revision date - change whenever this file is edited
.ds Rd 28 August 1993
.\" document revision number - change each time document is released
.ds Rn 1.05
.\"
.nr PO 1.25i	\" page offset 1.25 inches
.nr PD .5v	\" inter-paragraph distance
.\"
.EH 'WRPRC Configuration Distribution'- % -''
.OH ''- % -'WRPRC Configuration Distribution'
.OF 'Revision date:\0\0\*(Rd''Printed:\0\0\n(dy \*(MO 19\n(yr'
.EF 'Revision date:\0\0\*(Rd''Printed:\0\0\n(dy \*(MO 19\n(yr'
.\"
.\" Ft - font reference
.\" $1 = font to which to use for .ft switches
.\" $2 = font for inline \f switches
.\" $3 = thing to put in the given font
.\" $4 = goes immediately after $3
.\" $5 = goes immediately before $4
.\" if $3-$5 are empty, simply switch font w/o switching back
.de Ft
.nr PQ \\n(.f
.ie \(ts\\$3\\$4\\$5\(ts\(ts .ft \\$1
.el \&\\$5\\f\\$2\\$3\\f\\n(PQ\&\\$4
..
.\"
.\" Cw - constant width font
.de Cw
.Ft \\*(cW \\*(cW "\\$1" "\\$2" "\\$3"
..
.\"
.\" Cb - constant bold font
.de Cb
.Ft \\*(cB \\*(cB "\\$1" "\\$2" "\\$3"
..
.\"
.\" I - italic font
.de I
.Ft I I "\\$1" "\\$2" "\\$3"
..
.\"
.\" B - bold font
.de B
.Ft B B "\\$1" "\\$2" "\\$3"
..
.\" start of section of code
.de cS
.br
.ie "\\$1"0" .DS "L" "\\$2" "\\$3"
.el .DS "\\$1" "\\$2" "\\$3"
.ps -2
.vs -2
.Cw
.\" 8n doesn't work.  How come?
.\".ta 8n +8n +8n +8n +8n +8n +8n +8n +8n
.nr Cw 8*\\w`n`
.ta \\n(Cwu +\\n(Cwu +\\n(Cwu +\\n(Cwu +\\n(Cwu +\\n(Cwu +\\n(Cwu +\\n(Cwu +\\n(Cwu
.rr Cw
..
.\" end of section of code
.de cE
.ft R
.vs +2
.ps +2
.br
.DE
..
.TL
WRPRC Configuration Project
.sp .4v
Installation Notes
.AU
Paul DuBois
dubois@primate.wisc.edu
.AI
Wisconsin Regional Primate Research Center
Document revision:\0\0\*(Rn
Revision date:\0\0\*(Rd
.LP
.NH
Introduction
.LP
This document describes how to install the WRPRC configuration distribution,
which includes:
.DS
.I imake
.I makedepend
.I imkmf
.I msub
a set of general-purpose configuration files
documentation
.DE
In addition, the following are also included if you need them on your
system:
.DS
.I soelim
.I mkdirhier
.I bsdinst
.DE
The distribution is known to compile on the following systems:
.DS
VAX running Ultrix 3.1
Mips M/120 running RISC/os 4.01 (BSD or System V environments)
SPARCstation 2 running SunOS 4.1.1 (Rev. B)
.DE
This release might run successfully on earlier or later
versions of these systems; try it and see.
Let me know.
.LP
This document doesn't motivate or justify the architecture of the configuration
files.
They are derived from those distributed with X11R4.
The general philosophy underlying them is described in another
document,
.I "Using imake for Multiple Projects"
(included in this distribution).
.NH
Distribution Layout
.LP
There are two main directories with which you should be concerned,
.I config
and
.I util .
The
.I config
directory contains configuration files and the source for
.I imake .
The
.I util
directory contains four subdirectories of interest:
.I makedepend ,
the C source for the
.I makedepend
program;
.I scripts ,
containing shell scripts for
the script version of
.I makedepend
as well as for
.I imkmf
and some other miscellaneous things;
.I msub ,
a program for generating scripts from templates using values of
.I Makefile
variables; and
.I soelim ,
if one doesn't come with your version of
UNIX.
.NH
Initial Configuration
.LP
If you've used
.I imake
before (e.g., to install the X Window System), you probably won't have
much trouble installing the WRPRC configuration distribution.
The way it builds itself is quite similar.
Otherwise, be sure to read
.I config/README
very carefully and proceed with caution.
.LP
Every
.I Makefile
is generated by
.I imake
from an
.I Imakefile
in the same directory.
There are also several other files used by
.I imake
which are found in
.I config .
Change into that directory and browse around.
The files are:
.LP
.TS
center tab(:);
lfB lfB
lfI lfI .
Configuration-group Baseline Files:Dummy Project-specific Override Files
Imake.tmpl:Imake.ptmpl
ProjectGroup.tmpl:ProjectGroup.ptmpl
*.cf:*.pcf
site.def:site.pdef
Imake.rules:Imake.prules
.TE
.LP
.I Imake.tmpl
contains overall configuration defaults describing your system.
.I ProjectGroup.tmpl
contains defaults for the group of projects configured with
this set of configuration files.
The
.I *.cf
files contain vendor-dependent defaults.
.I Imake.rules
contains rules
for turning
.I Imakefile
definitions into
.I Makefile
dependencies.
.LP
The dummy override files supplied with the distribution are all empty,
as they exist only to prevent file-inclusion errors.
Individual projects may supply their own private versions of these files
to override or extend the configuration information provided in the baseline
files.
.LP
The only vendor-specific
.I .cf
files currently supported are
.I mipsriscos.cf ,
.I sun.cf
and
.I ultrix.cf .
The
.I hp.cf
file might work but it has seen only pre-``snake'' testing, and not much
of that.
.LP
For advice on supporting other systems, take a look at
.I config/Imake.tmpl .
Also, the
.I unsupported
directory in
.I config
contains a number of other vendor files from the X11R4
distribution.
These are included in case you want to compile the distribution on one
of those systems, as a hint on how to start, but they will not work without
modification.
If you do this, please send me the
.I .cf
and
.I .pcf
files, as well as a description of any other changes you find necesssary.
.LP
If you want to read more about configuring software with
.I imake ,
a paper which may be helpful is
\fIUsing Imake to Configure the X Window System, Version 11, Release 4\fR,
which discusses the issues involved in detail.
This paper is available for anonymous FTP on
.I ftp.primate.wisc.edu
in the
.I pub/imake-stuff
directory.
.LP
If you can use one of the supported
.I .cf
files, you may only need to edit
.I site.def.
Take a look at it, and see what
.I config/README
says about it.
Be sure to
.B read
the
.I .cf
file you plan to use; even if it requires no modification,
you may need to set some environment or bootstrap variables.
.NH
The Build
.LP
Once all the above is done, change into the top-level source
directory and, if you're intrepid, type the following command:
.cS
% make World BOOTSTRAPCFLAGS=\fIvalue\fR >& make.world &
.cE
.LP
The value of
.Cw BOOTSTRAPCFLAGS
should be as follows:
.LP
SunOS 4.1.1:
.cS
% make World BOOTSTRAPCFLAGS=
.cE
Mips RISC/os 4.0, 4.01:
.cS
% make World BOOTSTRAPCFLAGS=-Dmipsriscos
.cE
Ultrix 3.1:
.cS
% make World BOOTSTRAPCFLAGS=
.cE
.LP
Note: it is important to specify the value of
.Cw BOOTSTRAPCFLAGS ,
even if it's empty.
.LP
A more modest approach is to do the build in stages, as follows (this is
roughly what
.I make
.I World
does):
.LP
Change into the configuration directory:
.cS
% cd config
.cE
Get
.I imake
to compile (read
.I config/README
first):
.cS
% make -f Makefile.ini BOOTSTRAPCFLAGS=\fIvalue\fR
.cE
If that works, edit
.I site.def
and (possibly) the
.I .cf
file, then:
.cS
% cd ..
% make Makefile
% make Makefiles
% make clean
.cE
Build
.I makedepend .
If you define
.Cw UseCCMakeDepend :
.cS
% cd ../util/scripts
% make makedepend
.cE
If you don't:
.cS
% cd ../util/makedepend
% make
.cE
Make sure
.I makedepend
works:
.cS
% cd ../..
% make depend
.cE
(After running
.I make
.I depend ,
look at some Makefiles to see if the header file dependencies look correct.)
.sp .5v
Build everything:
.cS
% make all
.cE
If you have problems, contact me for assistance.
.NH
Installation
.LP
Once everything builds properly, type
.I make
.I install
to install the configuration files (you may need to become
.I root
first).
Installation puts the configuration files into
.I /usr/lib/config/WRPRC
by default.
All of the programs must be installed by hand:
.I imake ,
.I imkmf ,
.I makedepend
and
.I msub .
To install
.I makedepend ,
you need to know whether the compiled version or the script version
was built.
Look at
.I make.world
to find out if you don't know.
.LP
.DS
.ta 2i
\fBProgram	Where to find it\fR
\fIimake\fP	\fIconfig\fP
\fImakedepend\fP	\fIutil/makedepend\fP (or) \fIutil/scripts\fP
	(depending on which version gets built on your system)
\fIimkmf\fP	\fIutil/scripts\fP
\fImsub\fP	\fIutil/msub\fP
.DE
.LP
If your system doesn't understand the
.Cw #! '' ``
mechanism for starting
shell scripts, you may have to replace the first line of
.I imkmf
with a line that says
.Cw : '' ``
instead.
Ditto for
.I makedepend ,
if you use the script version.
.LP
If you have previously installed
.I imake
and/or
.I makedepend
(e.g., from the X Window System or Kerberos), you may not need to install the
versions included with this release.
However, it shouldn't hurt to do so.
.LP
Mips systems running RISC/os are weird;
see notes later in this document for some
installation suggestions.
.NH
Miscellaneous
.NH 2
bsdinst
.LP
This is a compatibility script for systems without a BSD-style
.I install
program.
You should install it if you have a System V-style
.I install ,
because they behave differently.
.NH 2
soelim
.LP
If your system doesn't have
.I soelim
and you want to use it,
you can build and install a version using the source in
.I util/soelim .
.NH 2
xmkmf Compatibility
.LP
It is possible to set up the directory named by
.Cw PubConfigPath
so that
.I imkmf
can be
used to configure other systems (i.e., rebuild the Makefiles) such as
X11R4.
This is done by making a link under
.Cw PubConfigPath
pointing to the installed X11R4 configuration files.
Assuming
.Cw PubConfigPath
is
.I /usr/lib/config
and the X11R4 configuration files are installed under
.I /usr/lib/X11/config ,
do the following:
.LP
.cS
% cd /usr/lib/config
% ln -s /usr/lib/X11/config X11
.cE
.LP
These steps establish the X11R4 configuration files as
the default project group.
You can then say run these command
in the X11R4 top-level directory to build the X11 Makefiles:
.LP
.cS
% imkmf -C X11
% make Makefiles
.cE
.LP
It should be possible to do the same for other systems such as Kerberos V5
and Motif 1.1.2; unfortunately, the stock configuration files for each
appear to assume, in slightly different ways, that they will not be used
with
.Cw UseInstalled
defined.
(That is, I think they are broken; easily fixed, but
broken as distributed.)
.LP
.NH 2
Mips RISC/os Systems
.LP
You'll probably need to look at
.I imakemdep.h
and
.I mipsriscos.cf
in the
.I config
directory to understand this section.
After you get done reading it, you may wonder why you'd even bother with
all this messing around.
The answer is that you mess with
.I imake
once, and then it helps you forever.
Without
.I imake
you repeat your labors for each project.
.LP
Mips RISC/os supports program development under either the System V or BSD
environments.
It is desirable to compile the tools so that they support
configuration for either environment.
There are essentially two problems:
(i) compiling
.I imake ;
(ii) compiling
and using
.I makedepend .
.SH
imake
.LP
There are a couple of approaches one might take for compiling
.I imake :
(i) compile it twice, once for each environment.
It each case it would be compiled to pass
.I \-Dmipsriscos
(the trigger symbol) and also an environment type symbol to
.I cpp
so the correct information would be selected from the configuration files.
(ii) compile a generic
.I imake
that passes only
.I \-Dmipsriscos
to
.I cpp ,
but that can be told on the fly at configuration time which environment to use.
.LP
The problem in either case is how to specify the environment.
RISC/os
.I cc
takes a
.I \-systype
option, so that you can specify
.I "\-systype sysv"
or
.I "\-systype bsd43"
to select an environment other than your default.
These also cause the effect of
.I \-DSYSTYPE_SYSV
or
.I \-DSYSTYPE_BSD43 .
It seems likely that this mechanism could be used to compile
.I imake .
.LP
However, the
.I \-systype
option can't be passed in
.Cw BOOTSTRAPCFLAGS ,
since
.I imake
takes a
.I \-s
option, and it interprets
.I \-systype
to mean that output is to be written to a file named ``ystype''.
Not so good.
.Cw BOOTSTRAPCFLAGS
is basically for
.I \-D 's
and
.I \-U 's.
How about passing the
.Cw SYSTYPE_SYSV
or
.Cw SYSTYPE_BSD43
flags?
No good, either.
.I cc
will defined one or the other of them anyway, even if you don't
specify a
.I \-systype
to force which one.
Thus, you might end up with both
.Cw SYSTYPE_SYSV
and
.Cw SYSTYPE_BSD43
defined.
That's not much help in compiling
.I imake ,
or in getting
.I imake
to pass the right defines to
.I cpp
for selecting information from configuration files.
.LP
Nevertheless, it's possible to do an end run around this problem by using
some other symbol.
.Cw SYSV
works well.
If the project is built with
.LP
.cS
% make World BOOTSTRAPCFLAGS="-Dmipsriscos -DSYSV"
.cE
.LP
then a System V specific
.I imake
is compiled (one that always passes
.I \-DSYSV
to
.I cpp ).
This is probably what you should do if you always and only want to use
the System V environment on your machine, and everyone else does, too.
.LP
If the project is built with
.LP
.cS
% make World BOOTSTRAPCFLAGS=-Dmipsriscos
.cE
.LP
then
.I imake
does not pass
.I \-DSYSV
to
.I cpp
and the BSD configuration information will be selected.
This is probably what you should do if you always and only want to use
the BSD environment on your machine, and everyone else does, too.
.LP
If you want to support a mixed environment, then compile for whichever
one is most prevalent.
To configure your Makefiles for a particular environment, rebuild them
with
.I imkmf .
.LP
For System V:
.cS
% imkmf -DSYSV -C WRPRC .
% make Makefiles
.cE
For BSD:
.cS
% imkmf -USYSV -C WRPRC .
% make Makefiles
.cE
.LP
.I imkmf
passes the SYSV argument to
.I imake
(which passes it to
.I cpp ).
.I mipsriscos.cf
is set up to select the configuration environment based on whether SYSV
is defined or not.
.SH
makedepend
.LP
There are two versions of
.I makedepend ;
a slow shell script version, and a fast compiled version.
The shell script version works for either environment, but it's a
pig.
The compiled version can be compiled under
either environment (by hacking
.I util/makedepend/Imakefile ),
but to make sure it
.I works
properly under either environment, it has to know the proper include-file
hierarchy root.
This means that the value of
.Cw INCLUDEPATH
must be passed to it, which is achieved by setting
.Cw StandardIncludes
to
.Cw \fI\-I\fP$(INCLUDEPATH) .
.NH 2
Some Changes From Previous Releases
.SH
Release 1.03
.LP
There was no
.I imkmf
in releases of this project prior to 1.03.
A modified version of
.I xmkmf
was used.
If you installed that one, you can throw it away and
reinstall the
.I xmkmf
distributed with X11R4.
.LP
On Mips RISC/os systems, the public configuration files were stored
under
.I /usr/lib/config
or
.I /bsd43/usr/lib/config ,
depending on the environment.
Since the files can be used to configure projects either way (for
either environment),
there's no need to store them both places.
Now
.I /usr/lib/config
is the default for both environments; you can toss any superfluous ones
in
.I /bsd43/usr/lib/config .
.LP
Also on Mips systems, it was previously recommended that the script
version of
.I makedepend
be used for the System V environment, and the compiled version for the
BSD environment, and that they be installed as
.I makedepend.sysv
and
.I makedepend.bsd .
The
.I mipsriscos.cf
file was set up to configure these names according to the configuration
environment if
.Cw UseInstalled
was defined.
That's all in the past;
.I util/makedepend/Imakefile
was hacked so that
.I makedepend
would compile under the System V environment (it wouldn't before).
You can toss out any old versions of
.I makedepend.sysv
or
.I makedepend.bsd .
