# opTeX commands
# Matthew Bertucci 2025/02/25 for v1.17

#include:plaintex
#include:luatex

## Page layout ##
\margins/%<⟨pg⟩ ⟨fmt⟩%> (%<left,right,top,bot%>)%<⟨unit⟩%>
\magscale[factor]
\headlinedist
\footlinedist
\pgbackground
\draft
\fnote{text}
\fnotemark%<⟨numeric-label⟩%>
\fnotetext{text}
\mnote{text}
\mnote up %<⟨dimen⟩%>{%<text%>}
\fixmnotes%<⟨\right|\left⟩%>
\left#S
\right#S
\mnotesize
\fnotenumglobal
\fnotenumpages
\fnotenumchapters

## Fonts ##
\fontfam[family-name]
\fontfamsub[family][by-family]
\caps
\cond
\bi
\currvar
\em
\typosize[%<fontsize%>/%<baselineskip%>]
\ptunit
\typoscale[%<font-factor%>/%<baselineskip-factor%>]
\mainfosize
\mainbaselineskip
\scalemain
\thefontsize[font-size]
\thefontscale[factor]
\setfontsize{size-spec}

## Math ##
\noloadmath
\loadmath{[%<font-file%>]}
\loadmath %<⟨factor⟩%>{[%<font-file%>]}
\script#m
\frak#m
\bbchar#m
\misans#m
\mbisans#m
\normalmath
\boldmath
\mathbox{text}#m
\bbig#m
\bbigl#m
\bbigm#m
\bbigr#m
\setmathstyle
\usemathstyle

# documented in optex-math.pdf (math symbols listed at bottom)
\cramped#m
\mathstyles{arg}
\currstyle
\dobystyle{display}{text%plain}{script}{scriptscript}
\stylenum
\omicron#m
\vardelta#m
\varkappa#m
\Alpha#m
\Beta#m
\Epsilon#m
\Zeta#m
\Eta#m
\Iota#m
\Kappa#m
\Mu#m
\Nu#m
\Omicron#m
\Rho#m
\Tau#m
\Chi#m
\>#*
\adots#m
\lmfil={%<code%>}
\displaylines to %<⟨dimen⟩%>{%<⟨line⟩%> \cr %<... ⟨line⟩%> \cr}#m
\eqspace=%<⟨dimen⟩%>
\eqlines{code}
\eqstyle{code}
\loadboldmath{[bold-font-file]} \to {[normal-font-file]}
\addUmathfont{cmd}{[normal-font]}{features}{[bold-font]}{features}{factor}#d
\themathcodeclass%<⟨math-char⟩%>
\themathcodefam%<⟨math-char⟩%>
\themathcodechar%<⟨math-char⟩%>
\thedelcodefam%<⟨math-char⟩%>
\thedelcodechar%<⟨math-char⟩%>
\mathchars %<\famname ⟨list of sequences⟩%> ;

## Typical elements of the document ##
# NOTE: \chap{title} etc. are not proper syntax but must be listed here
# for texstudio to recognize them as sectioning commands.
\tit %<⟨Document title⟩%>
\chap %<⟨Chapter title⟩%>#L1
\chap[%<label%>] %<⟨Chapter title⟩%>#L1
\chap{title}#SL1
\chap[label%labeldef]{title}#S
\sec %<⟨Section title⟩%>#L2
\sec[%<label%>] %<⟨Section title⟩%>#L2
\sec{title}#SL2
\sec[label%labeldef]{title}#S
\secc %<⟨Subsection title⟩%>#L3
\secc[%<label%>] %<⟨Subsection title⟩%>#L3
\secc{title}#SL3
\secc[label%labeldef]{title}#S
\nl
\nonum
\notoc
\eqmark
\eqmark[label%labeldef]
\caption/t %<⟨table caption⟩%>
\caption/t [%<label%>] %<⟨table caption⟩%>
\caption/f %<⟨figure caption⟩%>
\caption/f [%<label%>] %<⟨figure caption⟩%>
\cskip
\numberedpar %<⟨letter⟩%>{%<text%>}
\label[label%labeldef]
\ref[label%ref]
\ref[label%ref]{text}
\pgref[label%ref]
\pgref[label%ref]{text}
\wlabel{text}
\showlabels
\hyperlinks %<⟨color-in⟩ ⟨color-out⟩%>
\fnotelinks %<⟨color-fnt⟩ ⟨color-fnf⟩%>
\dest[%<type%>:%<label%>]
\ilink[%<type%>:%<label%>]{%<text%>}
\url{URL}#U
\ulink[URL]{text}#U
\outlines{level}
\insertoutline{text}
\thisoutline{text}
\begitems
\enditems
\style %<⟨type⟩%>
\defaultitem={%<text%>}
\iindent
\ilevel
\everylist={%<code%>}
\novspaces
\begblock
\endblock
\table{declaration}{data%text}
\fL
\fR
\fC
\fS
\fX
\crl
\crll
\crli
\crlli
\crlp{list}
\tskip%<⟨dimen⟩%>
\everytable={%<code%>}
\thistable={%<code%>}
\tabiteml={%<code%>}
\tabitemr={%<code%>}
\tabstrut={%<code%>}
\tablinespace
\vvkern
\hhkern
\tabskipl
\tabskipr
\mspan%<⟨number⟩%>[%<declaration%>]{%<text%>}
\frame{text}
\vspan%<⟨number⟩%>{%<text%>}
\rulewidth
\begtt
\endtt
\verbchar%<⟨char⟩%>
\code{text%definition}
\ttline
\everytt={%<code%>}
\everyintt={%<code%>}
\ttindent
\verbinput (%<lines%>) %<⟨file⟩%>
\hisyntax{language}
\commentchars%<⟨first⟩⟨second⟩%>

## Autogenerated lists ##
\maketoc
\regmacro{case-toc}{case-mark}{case-outline}
\makeindex
\ii %<⟨entry⟩%>
\ii %<⟨entry⟩%>/%<⟨subentry⟩%>
\iid %<⟨entry⟩%>
\iitype %<⟨letter⟩%>
\begmulti %<⟨number of columns⟩%>
\endmulti
\iis %<⟨equivalent⟩%> {%<text%>}
\cite[bibid]#c
\shortcitations
\sortcitations
\nonumcitations
\rcite[bibid]#c
\ecite[bibid]{text}#c
\bib[citekey]
\usebib/c (%<style%>) %<⟨bib-base⟩%>
\usebib/s (%<style%>) %<⟨bib-base⟩%>
\nocite[bibid]#c
\bibpart{name}
\bibnum=%<⟨number⟩%>
\readbibs{bib-bases}#*

## Graphics ##
\Blue
\Red
\Brown
\Green
\Yellow
\Cyan
\Magenta
\White
\Grey
\LightGrey
\Black
\setcmykcolor{c m y k}
\setrgbcolor{r g b}
\setgreycolor{factor}
\morecolors
# commands defined by \morecolors listed at bottom
\onlyrgb
\onlycmyk
\colordef %<\cmd%> {%<definition%>}
\colordef{cmd}{def}#Sd
\rgbcolordef %<\cmd%> {%<definition%>}
\rgbcolordef{cmd}{def}#Sd
\cmykcolordef %<\cmd%> {%<definition%>}
\cmykcolordef{cmd}{def}#Sd
\transparency%<⟨number⟩%>
\inspic{imagefile}#g
\picw=%<⟨dimen⟩%>
\picwidth
\picheight
\picparams={%<parameters%>}
\picdir={%<directory%>}
\inkinspic{%<filename%>.pdf%file}
\pdfscale{horizontal-factor}{vertical-factor}
\pdfrotate{degrees}
\transformbox{transformation}{text}
\rotbox{degrees}{text}
\inoval{text}
\inoval[settings]{text}
\ovalparams={%<settings%>}
\roundness
\fcolor
\lcolor
\lwidth
\shadow
\overlapmargins
\incircle{text}
\incircle[settings]{text}
\circleparams={%<settings%>}
\ratio
\ignoremargins
\clipinoval %<⟨x⟩ ⟨y⟩ ⟨width⟩ ⟨height⟩%> {%<text%>}
\clipincircle %<⟨x⟩ ⟨y⟩ ⟨width⟩ ⟨height⟩%> {%<text%>}
\puttext %<⟨x⟩ ⟨y⟩%> {%<text%>}
\putpic %<⟨x⟩ ⟨y⟩ ⟨width⟩ ⟨height⟩%> {%<imagefile%>}
\nospec

## Others ##
\enlang#*
\enuslang#*
\engblang#*
\belang#*
\bglang#*
\calang#*
\hrlang#*
\cslang#*
\dalang#*
\nllang#*
\etlang#*
\filang#*
\fislang#*
\frlang#*
\delang#*
\deolang#*
\gswlang#*
\elmlang#*
\elplang#*
\grclang#*
\hulang#*
\islang#*
\galang#*
\itlang#*
\lalang#*
\laclang#*
\lallang#*
\lvlang#*
\ltlang#*
\mklang#*
\pllang#*
\ptlang#*
\rolang#*
\rmlang#*
\rulang#*
\srllang#*
\srclang#*
\sklang#*
\sllang#*
\eslang#*
\svlang#*
\uklang#*
\cylang#*
\aflang#*
\hylang#*
\aslang#*
\eulang#*
\bnlang#*
\nblang#*
\coplang#*
\culang#*
\eolang#*
\ethilang#*
\furlang#*
\gllang#*
\kalang#*
\gulang#*
\hilang#*
\idlang#*
\ialang#*
\knlang#*
\kmrlang#*
\mllang#*
\mrlang#*
\mnlang#*
\nnlang#*
\oclang#*
\orlang#*
\pilang#*
\palang#*
\pmslang#*
\zhlang#*
\salang#*
\talang#*
\telang#*
\thlang#*
\trlang#*
\tklang#*
\hsblang#*
\langlist
\uselanguage{language}
\ehyph#S
\chyph#S
\shyph#S
\enquotes#*
\csquotes#*
\frquotes#*
\dequotes#*
\skquotes#*
\altquotes
\report
\letter
\slides
\author %<⟨authors⟩%>
\subject %<⟨subject⟩%>
\address
\load[filename-list%file]
\lorem[%<number%>]
\lorem[%<from%>-%<to%>]
\lipsum[%<number%>]#*
\lipsum[%<from%>-%<to%>]#*
\ConTeXt
\OpTeX
\LaTeX
\LuaTeX
\LuaHBTeX
\XeTeX
\lastpage
\totalpages
\useOpTeX
\useoptex#S

## API for macro writers ##
\addto%<\macro%>{%<text%>}
\adef%<⟨char⟩%>{%<body%>}
\afterfi{text}
\afterxfi{text}
\xfipoint
\aheadto%<\macro%>{%<text%>}
\basefilename %<⟨filename⟩%>
\bp{dimen expression}
\bp[digits]{dimen expression}
\casesof %<⟨token⟩ ⟨list of cases⟩%>
\cs{string}
\cstochar%<⟨\sequence⟩%>
\currfile
\eoldef
\eoldef{cmd}#Sd
\eqbox[label]{text}
\expr{expression}
\expr[digits]{expression}
\fontdef%<\macro%>{%<font spec%>}
\fontdef{cmd}#Sd
\fontlet%<\macro1%>=%<\macro2%>
\fontlet{cmd}#Sd
\foreach %<⟨list⟩%>\do %<⟨parameters⟩%>{%<what%>}
\foreachdef%<\macro ⟨parameters⟩%>{%<what%>}
\foreachdef{cmd}#Sd
\fornum %<⟨from⟩..⟨to⟩%>\do {%<what%>}
\incr %<⟨counter⟩%>
\decr %<⟨counter⟩%>
\ignoreit{arg}
\ignoresecond{arg1}{arg2}
\isempty
\istoksempty
\isequal
\iskv{key%plain}
\ismacro
\isdefined
\isinlist
\isfile
\isfont
\isnextchar %<⟨char⟩%>{%<text1%>}{%<text2%>}
\kv{key%plain}
\kvdict={%<name%>}
\kvx{key%plain}{code}
\nnum{number}
\nokvx{code}
\nospaceafter %<\macro%>
\nospacefuturelet
\nospacefuturelet{cmd}#Sd
\opinput{file}#i
\optdef%<\macro%>[%<opt-default%>] %<⟨parameters⟩%>{%<body%>}
\optdef{cmd}#Sd
\opwarning{text}
\posx[label]
\posy[label]
\posg[label]
\private
\public
\qcasesof{%<string%>}%<⟨list of cases⟩%>
\readkv{%<list%>}
\replstring%<\macro%>{%<stringA%>}{%<stringB%>}
\sdef{string%definition}{def}#S
\sdef{%<string%>}%<⟨parameters⟩%>{%<body%>}
\setctable
\restorectable
\setpos[label]
\slet{stringA%definition}{stringB%definition}
\sxdef{string%definition}{def}#S
\sxdef{%<string%>}%<⟨parameters⟩%>{%<body%>}
\trycs{string%definition}{text}
\trykv{key%plain}{code}
\useit{arg}
\usesecond{arg1}{arg2}
\wterm{text}
\xargs %<⟨what⟩ ⟨token1⟩ ⟨token2⟩ ...%>
\xcasesof %<⟨list of pairs⟩%>
\xloop

## Compatibility with Plain TEX ##
\oldaccents#*
\secant#m

## miscellaneous (not in main section of documentation) ##
\<#*
\activequotes
\activettchar#S
\addextgstate{arg1}{arg2}#*
\addpageresource#*
\ADDR#*
\AU#*
\backgroundpic{imagefile}#g
\bibmark#*
\biboptions#*
\bibtexhook#*
\bolder#*
\boldify
\boxlines
\bracedparam
\bslash
\catalogexclude#*
\catalogmathsample#*
\catalognextfam#*
\catalogonly#*
\catalogsample#*
\clqq#S
\cnvinfo{data}
\colnum
\colsep
\crqq#S
\CS#*
\csplain#*
\defaultoptsize
\docgen %<⟨package⟩%>
\doloadmath
\dunhill#*
\ea#*
\ED#*
\EDN#*
\endlayers
\eqboxsize
\everycaptionf={%<code%>}
\everycaptiont={%<code%>}
\everyii={%<code%>}
\everyitem={%<code%>}
\everymnote={%<code%>}
\everytocline={%<code%>}
\famvardef{cmd}{⟨family selector⟩ ⟨font modifiers⟩ ⟨variant selector⟩}#d
\flqq#S
\fnotenum
\fontsel
\fontspreload#*
\fornumstep %<⟨num⟩%>:%<⟨from⟩..⟨to⟩%>\do {%<what%>}
\frqq#S
\fw#*
\gpageno
\hicolor
\hicolors={%<list of color declarations%>}
\ignorept#*
\ignoreslash#*
\ignslash#*
\iindex{word}
\ilistskipamount
\initunifonts#*
\inlinkcolor#*
\itemnum
\itemskipamount
\layernum
\layers %<⟨number⟩%>
\letfont{cmd}#Sd
\link[type:spec]{color}{text}#S
\lipsumtext[number]#*
\listskipamount#S
\loadtrick %<⟨csname⟩%>
\localcolor
\mathcodes %<⟨family⟩%> {%<list-of-pairs%>}
\mathsboff
\mathsbon
\mfontsrule
\mnoteindent
\mnoteskip
\moddef
\moddef{cmd}#Sd
\nbb
\nbold#*
\nbpar
\newcurrfontsize{size spec}
\newmarks
\newmarks{cmd}#Sd
\newpublic%<⟨do⟩ ⟨\sequence⟩%>
\nextpages={%<code%>}
\NO#*
\nobibwarning[list of bib-labels]
\nolanginput{lang-tag}
\nolocalcolor
\normalcatcodes
\olistskipamount
\openref
\OPmac#*
\OPmacversion#S
\opt
\optexcatcodes
\optexversion#*
\outlinkcolor#*
\pageresources#*
\pcent
\pdfunidef%<\macro%>{%<text%>}
\pdfunidef{cmd}#Sd
\pg.
\pg;
\pg+
\pgbottomskip
\plaintexcatcodes
\plaintexsetting#*
\PP#*
\promile#S
\pshow%<⟨num⟩%>
\ptmunit
\PUBL#*
\quotes
\quoteschars%<⟨lqq⟩⟨rqq⟩⟨lq⟩⟨rq⟩%>
\quotset#*
\refdecl{definitions}
\removespaces
\replfromto{from}{to}{replacement}
\replthis{pattern}{replacement}
\resetmod
\resizethefont
\rgbcmykmap{r g b}{c m y k}
\runningfnotes#S
\sans#*
\scantoeol
\secl%<⟨number⟩%>
\setff{font-feature}
\setfontcolor#S
\setletterspace{number}
\setmathsizes[%<text-size%>/%<script-size%>/%<scriptscript-size%>]
\setwordspace{scale}
\setwsp#*
\sfont%<⟨control sequence⟩%> = [%<fontname%>]%<:⟨opt1;opt2;...⟩%>
\sfont{cmd}#Sd
\shadowlevels
\shordcitations
\skiptoeol
\slant#*
\slideopen
\slideshow
\subtit %<⟨Document subtitle⟩%>
\tabspaces
\tenbi
\thetransparency#*
\titskip
\tmpdim#*
\tmpnum#*
\tocrefnum
\today
\Transparent
\tsize
\ttcond#*
\ttlight#*
\ttprop#*
\ttset#*
\ttshift
\ufont%<⟨control sequence⟩%> = [%<fontname%>]%<:⟨opt1;opt2;...⟩%>
\ufont{cmd}#Sd
\upital#*
\upper{text}#*
\Urange %<⟨from⟩-⟨to⟩%>
\useK
\uslang#S
\uv#S
\visiblesp
\voidbox#*
\VOL#*
\wideformat
\xfontname#*
\xlink#*
\Xrefversion{version}#*
\YEAR#*

# loaded by \load[doc]
\bgverbcolor#S
\docfile#S
\enddocument#S
\fnamecolor#S
\lt#S
\maxlines#S
\mlinkcolor#S
\printdoc %<⟨filename⟩%>#S
\printdoctail %<⟨filename⟩%>#S
\seccc %<⟨subsubsection title⟩%>#S
\secccc#S
\ulinkcolor#S
\vitt{file}#Si

# loaded by \load[math]
\bigp#*m
\bbigp#*m
\Bigp#*m
\biggp#*m
\Biggp#*m
\autop#*m
\normalp#*m
\smartdots#*
\smartvert#*
\N#*m
\Z#*m
\Q#*m
\R#*m
\C#*m
\sgn#*m
\argmin#*m
\argmax#*m
\grad#*m
\rank#*m
\tr#*m
\diag#*m
\Span#*m
\Rng#*m
\Null#*m
\Ker#*m
\Res#*m
\tg#*m
\cotg#*m
\arctg#*m
\arccotg#*m
\frac{numerator}{denominator}#*m
\dfrac{numerator}{denominator}#*m
\tfrac{numerator}{denominator}#*m
\eqsystem{equations}#*m
\eqsystem[settings]{equations}#*m
\eqskip#*
\eqsep#*
\eqfil#*
\toright#*m
\toleft#*m
\subeqmark %<suffix%>#*m
\scriptspaces{s-rel}{s-bin}{ss-rel}{ss-bin}#*
\interval#*
\rmsbsp#*
\bfserif#*
\flexipa#*
\partialsymbolvars#*
\mrmpartial#*
\rmchars{list}#*
\vargreek{list}#*
\enablefic#*
\finalitalcorr#*
\textvariables#*
\textdigits#*
\textmoremath#*
\replacemissingchars %<\family%>#*
\mathclap{formula}#*
\mathrlap{formula}#*
\mathllap{formula}#*
\mathselector{command}{fontspecA}{fontspecB}{factor}{features}#d
\mathsetup{options%keyvals}#*
#keyvals:\mathsetup
dots
interval
vert
rmsbsp
bfserif
flexipa
rmchars={%<list%>}
vargreek={%<list%>}
text={%<list%>}
mstyle=%<style%>
bstyle=%<style%>
enablefic
#endkeyvals

# loaded by \load[mte]
\enablemte#*
\disablemte#*
\setfpfactor %<⟨factor⟩⟨space⟩%>#*
\setfxfactor %<⟨factor⟩⟨space⟩%>#*

# availability depends on font
\Adventor#S
\Alegreya#S
\alter#S
\angular#S
\Baskervald#S
\Baskerville#S
\Besley#S
\BodoniModa#S
\Bonum#S
\book#S
\bs#S
\calli#S
\ccond#S
\Clara#S
\Comicneue#S
\Culmus#S
\Cursor#S
\Dejavu#S
\displ#S
\DraftingMono#S
\EBGaramond#S
\eexpd#S
\elight#S
\Erewhon#S
\expd#S
\extend#S
\FBembo#S
\Fraunces#S
\Garamondl#S
\Gentium#S
\GFSBodoni#S
\hair#S
\Heros#S
\Heuristica#S
\initials#S
\Iwona#S
\Jost#S
\Kerkis#S
\keybr#S
\kf#S
\ki#S
\Kpfonts#S
\Kurier#S
\Lato#S
\lf#S
\li#S
\Libertine#S
\Libertinus#S
\Librecaslon#S
\Lido#S
\light#S
\LMfonts#S
\medium#S
\Merriweather#S
\mono#S
\Montserrat#S
\Neohellenic#S
\NewCM#S
\nocaps#S
\nocond#S
\noexpd#S
\normal#S
\noswash#S
\Oldstandard#S
\onum#S
\osize#S
\Overlock#S
\Pagella#S
\Plex#S
\Poltawski#S
\Raleway#S
\Roboto#S
\sanssemi#S
\Schola#S
\semibold#S
\serif#S
\Sourcepro#S
\stencil#S
\Stix#S
\StixTwo#S
\swash#S
\Technika#S
\Termes#S
\tf#S
\thin#S
\ti#S
\XCharter#S
\Xits#S
\xlight#S

## pdftex commands implemented in optex
\ifpdfabsdim
\ifpdfabsnum
\ifpdfprimitive
\pdfadjustspacing
\pdfannot
\pdfcatalog{action spec}
\pdfcolorstack
\pdfcolorstackinit
\pdfcompresslevel
\pdfcopyfont
\pdfcreationdate
\pdfdecimaldigits
\pdfdest
\pdfdestmargin
\pdfdraftmode
\pdfendlink
\pdfendthread
\pdffontattr
\pdffontexpand
\pdffontname
\pdffontobjnum
\pdffontsize
\pdfgamma
\pdfgentounicode
\pdfglyphtounicode{glyphname}{codepoint}
\pdfhorigin
\pdfimageaddfilename
\pdfimageapplygamma
\pdfimagegamma
\pdfimagehicolor
\pdfimageresolution
\pdfincludechars
\pdfinclusioncopyfonts
\pdfinclusionerrorlevel
\pdfinfo{info}
\pdfinsertht
\pdflastannot
\pdflastlinedepth
\pdflastlink
\pdflastobj
\pdflastxform
\pdflastximage
\pdflastximagepages
\pdflastxpos
\pdflastypos
\pdflinkmargin
\pdfliteral{literal}
\pdfmajorversion
\pdfmapfile{file}
\pdfmapline{map spec}
\pdfminorversion
\pdfmovechars
\pdfnames{action spec}
\pdfnoligatures
\pdfnormaldeviate
\pdfobj{object type spec}
\pdfobjcompresslevel
\pdfoutline
\pdfoutput
\pdfpageattr{attributes}
\pdfpagebox
\pdfpageheight
\pdfpageref
\pdfpageresources{resources}
\pdfpagesattr{attributes}
\pdfpagewidth
\pdfpkmode
\pdfpkresolution
\pdfprimitive
\pdfprotrudechars
\pdfpxdimen
\pdfrandomseed
\pdfrefobj
\pdfrefxform
\pdfrefximage
\pdfrestore
\pdfretval
\pdfsave
\pdfsavepos
\pdfsetmatrix{a b c d}
\pdfsetrandomseed
\pdfstartlink
\pdfstartthread
\pdftexrevision
\pdftexversion
\pdfthread
\pdfthreadmargin
\pdftrailer{text%plain}
\pdfuniformdeviate
\pdfuniqueresname
\pdfvorigin
\pdfxform
\pdfxformattr
\pdfxformname
\pdfxformresources
\pdfximage{file}

## Math symbols (not supported in latin modern marked with #S) ##
# for math- and text-mode
\Angstrom
\ast
\backdprime
\backprime
\backslash
\backtrprime
\blacksquare
\blanksymbol
\bullet
\cdotp
\checkmark
\dagger
\ddagger
\div
\divslash
\downarrow
\dprime
\eighthnote
\equal
\eth
\euro
\fracslash
\gets
\greater
\infty
\ldotp
\leftarrow
\less
\lnot
\maltese
\mathampersand
\mathatsign
\mathcolon
\mathcomma
\mathdollar
\matheth
\mathexclam
\mathhyphen
\mathoctothorpe
\mathparagraph
\mathpercent
\mathperiod
\mathplus
\mathquestion
\mathratio
\mathsection
\mathsemicolon
\mathslash
\mathsterling
\mathvisiblespace
\mathyen
\mho
\minus
\neg
\pm
\prime
\qprime
\rightarrow
\smblkcircle
\smwhtcircle
\sphericalangle
\square
\surd
\tieconcat#S
\times
\to
\trprime
\unicodeadots
\unicodecdots
\unicodeddots
\unicodeellipsis
\unicodevdots
\uparrow

# for math-mode only
\centerdot#Sm
\lozenge#Sm
\longdivisionsign#Sm
\upalpha#m
\upbeta#m
\upgamma#m
\updelta#m
\upepsilon#m
\upvarepsilon#m
\upzeta#m
\upeta#m
\uptheta#m
\upiota#m
\upkappa#m
\uplambda#m
\upmu#m
\upnu#m
\upxi#m
\upomicron#m
\uppi#m
\uprho#m
\upvarrho#m
\upvarsigma#m
\upsigma#m
\uptau#m
\upupsilon#m
\upvarphi#m
\upchi#m
\uppsi#m
\upomega#m
\upvartheta#m
\upphi#m
\upvarpi#m
\blacklozenge#Sm
\circlearrowright#Sm
\circlearrowleft#Sm
\doteqdot#Sm
\varpropto#Sm
\smallsmile#Sm
\smallfrown#Sm
\circledplus#*m
\circledminus#*m
\circledtimes#*m
\circledslash#*m
\circleddot#*m
\circledS#Sm
\lvertneqq#m
\gvertneqq#m
\nleqslant#m
\ngeqslant#m
\npreceq#m
\nsucceq#m
\nleqq#m
\ngeqq#m
\diagup#m
\diagdown#m
\varsubsetneq#m
\varsupsetneq#m
\nsubseteqq#m
\nsupseteqq#m
\varsubsetneqq#m
\varsupsetneqq#m
\llless#Sm
\gggtr#Sm
\Box#Sm
\nshortmid#m
\nshortparallel#m
\ntriangleleft#m
\ntriangleright#m
\shortmid#m
\shortparallel#m
\thicksim#m
\thickapprox#m
\digamma#m
\rhd#Sm
\lhd#Sm
\unrhd#Sm
\unlhd#Sm
\restriction#Sm
\doublecup#Sm
\doublecap#Sm
\mathring{a}#m
\dbkarow#Sm
\drbkarow#Sm
\hksearow#Sm
\hkswarow#Sm
\lparen#m
\rparen#m
\lbrack#m
\rbrack#m
\lbrace#m
\vert#m
\rbrace#m
\Zbar#Sm
\grave{a}#m
\acute{a}#m
\hat{a}#m
\widehat{a}#m
\tilde{a}#m
\widetilde{a}#m
\bar{a}#m
\overbar{a}#m
\wideoverbar{a}#m
\breve{a}#m
\widebreve{a}#m
\dot{a}#m
\ddot{a}#m
\ovhook{a}#m
\ocirc{a}#m
\check{a}#m
\widecheck{a}#m
\candra{a}#Sm
\oturnedcomma{a}#Sm
\ocommatopright{a}#Sm
\droang{a}#Sm
\wideutilde{a}#m
\mathunderbar{a}#m
\notaccent#m
\underleftrightarrow{a}#m
\mupAlpha#m
\mupBeta#m
\mupGamma#m
\mupDelta#m
\mupEpsilon#m
\mupZeta#m
\mupEta#m
\mupTheta#m
\mupIota#m
\mupKappa#m
\mupLambda#m
\mupMu#m
\mupNu#m
\mupXi#m
\mupOmicron#m
\mupPi#m
\mupRho#m
\mupSigma#m
\mupTau#m
\mupUpsilon#m
\mupPhi#m
\mupChi#m
\mupPsi#m
\mupOmega#m
\mupalpha#m
\mupbeta#m
\mupgamma#m
\mupdelta#m
\mupvarepsilon#m
\mupzeta#m
\mupeta#m
\muptheta#m
\mupiota#m
\mupkappa#m
\muplambda#m
\mupmu#m
\mupnu#m
\mupxi#m
\mupomicron#m
\muppi#m
\muprho#m
\mupvarsigma#m
\mupsigma#m
\muptau#m
\mupupsilon#m
\mupvarphi#m
\mupchi#m
\muppsi#m
\mupomega#m
\mupvartheta#m
\mupphi#m
\mupvarpi#m
\upDigamma#Sm
\updigamma#Sm
\mupvarkappa#m
\mupvarrho#m
\mupvarTheta#m
\mupepsilon#m
\upbackepsilon#Sm
\backepsilon#Sm
\horizbar#m
\Vert#m
\twolowline#m
\enleadertwodots#Sm
\caretinsert#Sm
\Exclam#Sm
\hyphenbullet#Sm
\Question#Sm
\closure#Sm
\leftharpoonaccent{a}#m
\overleftharpoon{a}#m
\rightharpoonaccent{a}#m
\overrightharpoon{a}#m
\vertoverlay{a}#m
\overleftarrow{a}#m
\overrightarrow{a}#m
\vec{a}#m
\dddot{a}#m
\ddddot{a}#m
\enclosecircle#m
\enclosesquare#m
\enclosediamond#m
\overleftrightarrow{a}#m
\enclosetriangle#m
\annuity{a}#Sm
\threeunderdot{a}#m
\widebridgeabove{a}#m
\underrightharpoondown{a}#m
\underleftharpoondown{a}#m
\underleftarrow{a}#m
\underrightarrow{a}#m
\asteraccent{a}#m
\BbbC#m
\Eulerconst#m
\mscrg#Sm
\mscrH#m
\mfrakH#m
\BbbH#m
\Planckconst#m
\hslash#m
\mscrI#m
\Im#m
\mscrL#m
\ell#m
\BbbN#m
\wp#m
\BbbP#m
\BbbQ#m
\mscrR#m
\Re#m
\BbbR#m
\BbbZ#m
\mfrakZ#m
\turnediota#Sm
\mscrB#m
\mfrakC#m
\mscre#Sm
\mscrE#m
\mscrF#m
\Finv#m
\mscrM#m
\mscro#Sm
\aleph#m
\beth#m
\gimel#m
\daleth#m
\Bbbpi#m
\Bbbgamma#m
\BbbGamma#m
\BbbPi#m
\Bbbsum#m
\Game#Sm
\sansLturned#Sm
\sansLmirrored#Sm
\Yup#Sm
\mitBbbD#m
\mitBbbd#m
\mitBbbe#m
\mitBbbi#m
\mitBbbj#m
\PropertyLine#Sm
\upand#Sm
\leftrightarrow#m
\updownarrow#m
\nwarrow#m
\nearrow#m
\searrow#m
\swarrow#m
\nleftarrow#m
\nrightarrow#m
\leftwavearrow#Sm
\rightwavearrow#Sm
\twoheadleftarrow#m
\twoheaduparrow#m
\twoheadrightarrow#m
\twoheaddownarrow#m
\leftarrowtail#m
\rightarrowtail#m
\mapsfrom#m
\mapsup#m
\mapsto#m
\mapsdown#m
\updownarrowbar#Sm
\hookleftarrow#m
\hookrightarrow#m
\looparrowleft#m
\looparrowright#m
\leftrightsquigarrow#m
\nleftrightarrow#m
\downzigzagarrow#Sm
\Lsh#m
\Rsh#m
\Ldsh#m
\Rdsh#m
\linefeed#m
\carriagereturn#m
\curvearrowleft#m
\curvearrowright#m
\barovernorthwestarrow#Sm
\barleftarrowrightarrowbar#Sm
\acwopencirclearrow#m
\cwopencirclearrow#m
\leftharpoonup#m
\leftharpoondown#m
\upharpoonright#m
\upharpoonleft#m
\rightharpoonup#m
\rightharpoondown#m
\downharpoonright#m
\downharpoonleft#m
\rightleftarrows#m
\updownarrows#m
\leftrightarrows#m
\leftleftarrows#m
\upuparrows#m
\rightrightarrows#m
\downdownarrows#m
\leftrightharpoons#m
\rightleftharpoons#m
\nLeftarrow#m
\nLeftrightarrow#m
\nRightarrow#m
\Leftarrow#m
\Uparrow#m
\Rightarrow#m
\Downarrow#m
\Leftrightarrow#m
\Updownarrow#m
\Nwarrow#m
\Nearrow#m
\Searrow#m
\Swarrow#m
\Lleftarrow#m
\Rrightarrow#m
\leftsquigarrow#m
\rightsquigarrow#m
\nHuparrow#Sm
\nHdownarrow#Sm
\leftdasharrow#Sm
\updasharrow#Sm
\rightdasharrow#Sm
\downdasharrow#Sm
\barleftarrow#Sm
\rightarrowbar#Sm
\leftwhitearrow#m
\upwhitearrow#m
\rightwhitearrow#m
\downwhitearrow#m
\whitearrowupfrombar#Sm
\circleonrightarrow#Sm
\downuparrows#m
\rightthreearrows#m
\nvleftarrow#Sm
\nvrightarrow#Sm
\nvleftrightarrow#Sm
\nVleftarrow#Sm
\nVrightarrow#Sm
\nVleftrightarrow#Sm
\leftarrowtriangle#Sm
\rightarrowtriangle#Sm
\leftrightarrowtriangle#Sm
\forall#m
\complement#m
\partial#m
\exists#m
\nexists#m
\varnothing#m
\increment#m
\nabla#m
\in#m
\notin#m
\smallin#m
\ni#m
\nni#m
\smallni#m
\QED#m
\prod#m
\coprod#m
\sum#m
\mp#m
\dotplus#m
\smallsetminus#m
\vysmwhtcircle#m
\vysmblkcircle#m
\sqrt{arg}#m
\cuberoot{arg}#Sm
\fourthroot{arg}#Sm
\propto#m
\rightangle#m
\angle#m
\measuredangle#m
\mid#m
\nmid#m
\parallel#m
\nparallel#m
\wedge#m
\vee#m
\cap#m
\cup#m
\int#m
\iint#m
\iiint#m
\oint#m
\oiint#m
\oiiint#m
\intclockwise#m
\varointclockwise#m
\ointctrclockwise#m
\therefore#m
\because#m
\Colon#m
\dotminus#m
\dashcolon#m
\dotsminusdots#m
\kernelcontraction#m
\sim#m
\backsim#m
\invlazys#m
\sinewave#m
\wr#m
\nsim#m
\eqsim#m
\simeq#m
\nsime#m
\sime#m
\nsimeq#m
\cong#m
\simneqq#m
\ncong#m
\approx#m
\napprox#m
\approxeq#m
\approxident#m
\backcong#m
\asymp#m
\Bumpeq#m
\bumpeq#m
\doteq#m
\Doteq#m
\fallingdotseq#m
\risingdotseq#m
\coloneq#m
\eqcolon#m
\eqcirc#m
\circeq#m
\arceq#m
\wedgeq#m
\veeeq#m
\stareq#m
\triangleq#m
\eqdef#m
\measeq#m
\questeq#m
\ne#m
\equiv#m
\nequiv#m
\Equiv#m
\leq#m
\geq#m
\leqq#m
\geqq#m
\lneqq#m
\gneqq#m
\ll#m
\gg#m
\between#m
\nasymp#m
\nless#m
\ngtr#m
\nleq#m
\ngeq#m
\lesssim#m
\gtrsim#m
\nlesssim#m
\ngtrsim#m
\lessgtr#m
\gtrless#m
\nlessgtr#m
\ngtrless#m
\prec#m
\succ#m
\preccurlyeq#m
\succcurlyeq#m
\precsim#m
\succsim#m
\nprec#m
\nsucc#m
\subset#m
\supset#m
\nsubset#m
\nsupset#m
\subseteq#m
\supseteq#m
\nsubseteq#m
\nsupseteq#m
\subsetneq#m
\supsetneq#m
\cupleftarrow#m
\cupdot#m
\uplus#m
\sqsubset#m
\sqsupset#m
\sqsubseteq#m
\sqsupseteq#m
\sqcap#m
\sqcup#m
\oplus#m
\ominus#m
\otimes#m
\oslash#m
\odot#m
\circledcirc#m
\circledast#m
\circledequal#m
\circleddash#m
\boxplus#m
\boxminus#m
\boxtimes#m
\boxdot#m
\vdash#m
\dashv#m
\top#m
\bot#m
\assert#m
\models#m
\vDash#m
\Vdash#m
\Vvdash#m
\VDash#m
\nvdash#m
\nvDash#m
\nVdash#m
\nVDash#m
\prurel#Sm
\scurel#Sm
\vartriangleleft#m
\vartriangleright#m
\trianglelefteq#m
\trianglerighteq#m
\origof#m
\imageof#m
\multimap#m
\hermitmatrix#m
\intercal#m
\veebar#m
\barwedge#m
\barvee#m
\measuredrightangle#m
\varlrtriangle#m
\bigwedge#m
\bigvee#m
\bigcap#m
\bigcup#m
\smwhtdiamond#m
\cdot#m
\star#m
\divideontimes#m
\bowtie#m
\ltimes#m
\rtimes#m
\leftthreetimes#m
\rightthreetimes#m
\backsimeq#m
\curlyvee#m
\curlywedge#m
\Subset#m
\Supset#m
\Cap#m
\Cup#m
\pitchfork#Sm
\equalparallel#m
\lessdot#m
\gtrdot#m
\lll#m
\ggg#m
\lesseqgtr#m
\gtreqless#m
\eqless#m
\eqgtr#m
\curlyeqprec#m
\curlyeqsucc#m
\npreccurlyeq#m
\nsucccurlyeq#m
\nsqsubseteq#m
\nsqsupseteq#m
\sqsubsetneq#m
\sqsupsetneq#m
\lnsim#m
\gnsim#m
\varTheta#m
\precnsim#m
\succnsim#m
\nvartriangleleft#m
\nvartriangleright#m
\ntrianglelefteq#m
\ntrianglerighteq#m
\disin#Sm
\varisins#Sm
\isins#Sm
\isindot#Sm
\varisinobar#Sm
\isinobar#Sm
\isinvb#Sm
\isinE#Sm
\nisd#Sm
\varnis#Sm
\nis#Sm
\varniobar#Sm
\niobar#Sm
\bagmember#Sm
\diameter#m
\house#Sm
\varbarwedge#m
\vardoublebarwedge#m
\lceil#m
\rceil#m
\lfloor#m
\rfloor#m
\invnot#m
\sqlozenge#Sm
\profline#Sm
\profsurf#Sm
\viewdata#Sm
\turnednot#m
\ulcorner#*m
\urcorner#*m
\llcorner#*m
\lrcorner#*m
\inttop#*m
\intbottom#*m
\frown#m
\smile#m
\varhexagonlrbonds#Sm
\conictaper#Sm
\topbot#Sm
\obar#Sm
\APLnotslash#Sm
\APLnotbackslash#Sm
\APLboxupcaret#Sm
\APLboxquestion#Sm
\rangledownzigzagarrow#Sm
\hexagon#Sm
\lparenuend#*m
\lparenextender#*m
\lparenlend#*m
\rparenuend#*m
\rparenextender#*m
\rparenlend#*m
\lbrackuend#*m
\lbrackextender#*m
\lbracklend#*m
\rbrackuend#*m
\rbrackextender#*m
\rbracklend#*m
\lbraceuend#*m
\lbracemid#*m
\lbracelend#*m
\vbraceextender#*m
\rbraceuend#*m
\rbracemid#*m
\rbracelend#*m
\intextender#Sm
\harrowextender#Sm
\lmoustache#Sm
\rmoustache#Sm
\sumtop#*m
\sumbottom#*m
\overbracket{arg}#m
\underbracket{arg}#m
\bbrktbrk#Sm
\sqrtbottom#m
\lvboxline#Sm
\rvboxline#Sm
\varcarriagereturn#Sm
\overparen{arg}#m
\underparen{arg}#m
\overbrace{arg}#m
\underbrace{arg}#m
\obrbrak#m
\ubrbrak#m
\trapezium#Sm
\benzenr#Sm
\strns#Sm
\fltns#Sm
\accurrent#Sm
\elinters#Sm
\bdtriplevdash#Sm
\blockuphalf#Sm
\blocklowhalf#Sm
\blockfull#m
\blocklefthalf#Sm
\blockrighthalf#Sm
\blockqtrshaded#m
\blockhalfshaded#m
\blockthreeqtrshaded#m
\mdlgblksquare#m
\mdlgwhtsquare#m
\squoval#Sm
\blackinwhitesquare#Sm
\squarehfill#Sm
\squarevfill#Sm
\squarehvfill#Sm
\squarenwsefill#Sm
\squareneswfill#Sm
\squarecrossfill#Sm
\smblksquare#m
\smwhtsquare#m
\hrectangleblack#m
\hrectangle#m
\vrectangleblack#Sm
\vrectangle#Sm
\parallelogramblack#Sm
\parallelogram#Sm
\bigblacktriangleup#m
\bigtriangleup#m
\blacktriangle#m
\vartriangle#Sm
\blacktriangleright#m
\triangleright#m
\smallblacktriangleright#Sm
\smalltriangleright#Sm
\blackpointerright#Sm
\whitepointerright#Sm
\bigblacktriangledown#m
\bigtriangledown#m
\blacktriangledown#Sm
\triangledown#Sm
\blacktriangleleft#m
\triangleleft#m
\smallblacktriangleleft#Sm
\smalltriangleleft#Sm
\blackpointerleft#Sm
\whitepointerleft#Sm
\mdlgblkdiamond#Sm
\mdlgwhtdiamond#Sm
\blackinwhitediamond#Sm
\fisheye#Sm
\mdlgwhtlozenge#m
\mdlgwhtcircle#m
\dottedcircle#Sm
\circlevertfill#Sm
\bullseye#Sm
\mdlgblkcircle#m
\circlelefthalfblack#Sm
\circlerighthalfblack#Sm
\circlebottomhalfblack#Sm
\circletophalfblack#Sm
\circleurquadblack#Sm
\blackcircleulquadwhite#Sm
\blacklefthalfcircle#Sm
\blackrighthalfcircle#Sm
\inversebullet#Sm
\inversewhitecircle#Sm
\invwhiteupperhalfcircle#Sm
\invwhitelowerhalfcircle#Sm
\ularc#Sm
\urarc#Sm
\lrarc#Sm
\llarc#Sm
\topsemicircle#Sm
\botsemicircle#Sm
\lrblacktriangle#Sm
\llblacktriangle#Sm
\ulblacktriangle#Sm
\urblacktriangle#Sm
\squareleftblack#Sm
\squarerightblack#Sm
\squareulblack#Sm
\squarelrblack#Sm
\boxbar#Sm
\trianglecdot#Sm
\triangleleftblack#Sm
\trianglerightblack#Sm
\lgwhtcircle#m
\squareulquad#Sm
\squarellquad#Sm
\squarelrquad#Sm
\squareurquad#Sm
\circleulquad#Sm
\circlellquad#Sm
\circlelrquad#Sm
\circleurquad#Sm
\ultriangle#Sm
\urtriangle#Sm
\lltriangle#Sm
\mdwhtsquare#Sm
\mdblksquare#Sm
\mdsmwhtsquare#Sm
\mdsmblksquare#Sm
\lrtriangle#Sm
\bigstar#Sm
\bigwhitestar#Sm
\astrosun#Sm
\danger#Sm
\blacksmiley#Sm
\sun#Sm
\rightmoon#Sm
\leftmoon#Sm
\female#Sm
\male#Sm
\spadesuit#m
\heartsuit#m
\diamondsuit#m
\clubsuit#m
\varspadesuit#m
\varheartsuit#m
\vardiamondsuit#m
\varclubsuit#m
\quarternote#Sm
\twonotes#Sm
\flat#m
\natural#m
\sharp#m
\acidfree#Sm
\dicei#Sm
\diceii#Sm
\diceiii#Sm
\diceiv#Sm
\dicev#Sm
\dicevi#Sm
\circledrightdot#Sm
\circledtwodots#Sm
\blackcircledrightdot#Sm
\blackcircledtwodots#Sm
\Hermaphrodite#Sm
\mdwhtcircle#Sm
\mdblkcircle#Sm
\mdsmwhtcircle#Sm
\neuter#Sm
\circledstar#Sm
\varstar#Sm
\dingasterisk#Sm
\lbrbrak#Sm
\rbrbrak#Sm
\draftingarrow#Sm
\threedangle#Sm
\whiteinwhitetriangle#Sm
\perp#m
\subsetcirc#Sm
\supsetcirc#Sm
\lbag#Sm
\rbag#Sm
\veedot#Sm
\bsolhsub#Sm
\suphsol#Sm
\longdivision{arg}#Sm
\diamondcdot#Sm
\wedgedot#Sm
\upin#Sm
\pullback#Sm
\pushout#Sm
\leftouterjoin#Sm
\rightouterjoin#Sm
\fullouterjoin#Sm
\bigbot#m
\bigtop#m
\DashVDash#m
\dashVdash#m
\multimapinv#m
\vlongdash#m
\longdashv#m
\cirbot#Sm
\lozengeminus#m
\concavediamond#m
\concavediamondtickleft#m
\concavediamondtickright#m
\whitesquaretickleft#Sm
\whitesquaretickright#Sm
\lBrack#m
\rBrack#m
\langle#m
\rangle#m
\lAngle#m
\rAngle#m
\Lbrbrak#Sm
\Rbrbrak#Sm
\lgroup#m
\rgroup#m
\UUparrow#Sm
\DDownarrow#Sm
\acwgapcirclearrow#Sm
\cwgapcirclearrow#Sm
\rightarrowonoplus#m
\longleftarrow#m
\longrightarrow#m
\longleftrightarrow#m
\Longleftarrow#m
\Longrightarrow#m
\Longleftrightarrow#m
\longmapsfrom#m
\longmapsto#m
\Longmapsfrom#m
\Longmapsto#m
\longrightsquigarrow#m
\nvtwoheadrightarrow#Sm
\nVtwoheadrightarrow#Sm
\nvLeftarrow#Sm
\nvRightarrow#Sm
\nvLeftrightarrow#Sm
\twoheadmapsto#Sm
\Mapsfrom#m
\Mapsto#m
\downarrowbarred#Sm
\uparrowbarred#Sm
\Uuparrow#Sm
\Ddownarrow#Sm
\leftbkarrow#Sm
\rightbkarrow#Sm
\leftdbkarrow#Sm
\dbkarrow#Sm
\drbkarrow#Sm
\rightdotarrow#Sm
\baruparrow#Sm
\downarrowbar#Sm
\nvrightarrowtail#Sm
\nVrightarrowtail#Sm
\twoheadrightarrowtail#Sm
\nvtwoheadrightarrowtail#Sm
\nVtwoheadrightarrowtail#Sm
\lefttail#Sm
\righttail#Sm
\leftdbltail#Sm
\rightdbltail#Sm
\diamondleftarrow#Sm
\rightarrowdiamond#Sm
\diamondleftarrowbar#Sm
\barrightarrowdiamond#Sm
\nwsearrow#Sm
\neswarrow#Sm
\hknwarrow#Sm
\hknearrow#Sm
\hksearrow#Sm
\hkswarrow#Sm
\tona#Sm
\toea#Sm
\tosa#Sm
\towa#Sm
\rdiagovfdiag#Sm
\fdiagovrdiag#Sm
\seovnearrow#Sm
\neovsearrow#Sm
\fdiagovnearrow#Sm
\rdiagovsearrow#Sm
\neovnwarrow#Sm
\nwovnearrow#Sm
\rightcurvedarrow#Sm
\uprightcurvearrow#Sm
\downrightcurvedarrow#Sm
\leftdowncurvedarrow#Sm
\rightdowncurvedarrow#Sm
\cwrightarcarrow#Sm
\acwleftarcarrow#Sm
\acwoverarcarrow#Sm
\acwunderarcarrow#Sm
\curvearrowrightminus#Sm
\curvearrowleftplus#Sm
\cwundercurvearrow#Sm
\ccwundercurvearrow#Sm
\acwcirclearrow#Sm
\cwcirclearrow#Sm
\rightarrowshortleftarrow#Sm
\leftarrowshortrightarrow#Sm
\shortrightarrowleftarrow#Sm
\rightarrowplus#Sm
\leftarrowplus#Sm
\rightarrowx#Sm
\leftrightarrowcircle#Sm
\twoheaduparrowcircle#Sm
\leftrightharpoonupdown#Sm
\leftrightharpoondownup#Sm
\updownharpoonrightleft#Sm
\updownharpoonleftright#Sm
\leftrightharpoonupup#Sm
\updownharpoonrightright#Sm
\leftrightharpoondowndown#Sm
\updownharpoonleftleft#Sm
\barleftharpoonup#Sm
\rightharpoonupbar#Sm
\barupharpoonright#Sm
\downharpoonrightbar#Sm
\barleftharpoondown#Sm
\rightharpoondownbar#Sm
\barupharpoonleft#Sm
\downharpoonleftbar#Sm
\leftharpoonupbar#Sm
\barrightharpoonup#Sm
\upharpoonrightbar#Sm
\bardownharpoonright#Sm
\leftharpoondownbar#Sm
\barrightharpoondown#Sm
\upharpoonleftbar#Sm
\bardownharpoonleft#Sm
\leftharpoonsupdown#Sm
\upharpoonsleftright#Sm
\rightharpoonsupdown#Sm
\downharpoonsleftright#Sm
\leftrightharpoonsup#Sm
\leftrightharpoonsdown#Sm
\rightleftharpoonsup#Sm
\rightleftharpoonsdown#Sm
\leftharpoonupdash#Sm
\dashleftharpoondown#Sm
\rightharpoonupdash#Sm
\dashrightharpoondown#Sm
\updownharpoonsleftright#Sm
\downupharpoonsleftright#Sm
\rightimply#Sm
\equalrightarrow#Sm
\similarrightarrow#Sm
\leftarrowsimilar#Sm
\rightarrowsimilar#Sm
\rightarrowapprox#Sm
\ltlarr#Sm
\leftarrowless#Sm
\gtrarr#Sm
\subrarr#Sm
\leftarrowsubset#Sm
\suplarr#Sm
\leftfishtail#Sm
\rightfishtail#Sm
\upfishtail#Sm
\downfishtail#Sm
\Vvert#Sm
\mdsmblkcircle#Sm
\typecolon#Sm
\lBrace#Sm
\rBrace#Sm
\lParen#Sm
\rParen#Sm
\llparenthesis#Sm
\rrparenthesis#Sm
\llangle#Sm
\rrangle#Sm
\lbrackubar#Sm
\rbrackubar#Sm
\lbrackultick#Sm
\rbracklrtick#Sm
\lbracklltick#Sm
\rbrackurtick#Sm
\langledot#Sm
\rangledot#Sm
\lparenless#Sm
\rparengtr#Sm
\Lparengtr#Sm
\Rparenless#Sm
\lblkbrbrak#Sm
\rblkbrbrak#Sm
\fourvdots#Sm
\vzigzag#Sm
\measuredangleleft#Sm
\rightanglesqr#Sm
\rightanglemdot#Sm
\angles#Sm
\angdnr#Sm
\gtlpar#Sm
\sphericalangleup#Sm
\turnangle#Sm
\revangle#Sm
\angleubar#Sm
\revangleubar#Sm
\wideangledown#Sm
\wideangleup#Sm
\measanglerutone#Sm
\measanglelutonw#Sm
\measanglerdtose#Sm
\measangleldtosw#Sm
\measangleurtone#Sm
\measangleultonw#Sm
\measangledrtose#Sm
\measangledltosw#Sm
\revemptyset#Sm
\emptysetobar#Sm
\emptysetocirc#Sm
\emptysetoarr#Sm
\emptysetoarrl#Sm
\circlehbar#Sm
\circledvert#Sm
\circledparallel#Sm
\obslash#Sm
\operp#Sm
\obot#Sm
\olcross#Sm
\odotslashdot#Sm
\uparrowoncircle#Sm
\circledwhitebullet#Sm
\circledbullet#Sm
\olessthan#Sm
\ogreaterthan#Sm
\cirscir#Sm
\cirE#Sm
\boxdiag#Sm
\boxbslash#Sm
\boxast#Sm
\boxcircle#Sm
\boxbox#Sm
\boxonbox#Sm
\triangleodot#Sm
\triangleubar#Sm
\triangles#Sm
\triangleserifs#Sm
\rtriltri#Sm
\ltrivb#Sm
\vbrtri#Sm
\lfbowtie#Sm
\rfbowtie#Sm
\fbowtie#Sm
\lftimes#Sm
\rftimes#Sm
\hourglass#Sm
\blackhourglass#Sm
\lvzigzag#Sm
\rvzigzag#Sm
\Lvzigzag#Sm
\Rvzigzag#Sm
\iinfin#Sm
\tieinfty#Sm
\nvinfty#Sm
\dualmap#Sm
\laplac#Sm
\lrtriangleeq#Sm
\shuffle#Sm
\eparsl#Sm
\smeparsl#Sm
\eqvparsl#Sm
\gleichstark#Sm
\thermod#Sm
\downtriangleleftblack#Sm
\downtrianglerightblack#Sm
\blackdiamonddownarrow#Sm
\mdlgblklozenge#Sm
\circledownarrow#Sm
\blackcircledownarrow#Sm
\errbarsquare#Sm
\errbarblacksquare#Sm
\errbardiamond#Sm
\errbarblackdiamond#Sm
\errbarcircle#Sm
\errbarblackcircle#Sm
\ruledelayed#Sm
\setminus#m
\dsol#Sm
\rsolbar#Sm
\xsol#Sm
\xbsol#Sm
\doubleplus#Sm
\tripleplus#Sm
\lcurvyangle#Sm
\rcurvyangle#Sm
\tplus#Sm
\tminus#Sm
\bigodot#m
\bigoplus#m
\bigotimes#m
\bigcupdot#m
\biguplus#m
\bigsqcap#m
\bigsqcup#m
\conjquant#Sm
\disjquant#Sm
\bigtimes#m
\modtwosum#Sm
\sumint#Sm
\iiiint#m
\intbar#Sm
\intBar#Sm
\fint#Sm
\cirfnint#Sm
\awint#m
\rppolint#Sm
\scpolint#Sm
\npolint#Sm
\pointint#Sm
\sqint#Sm
\intlarhk#Sm
\intx#Sm
\intcap#Sm
\intcup#Sm
\upint#Sm
\lowint#Sm
\Join#Sm
\bigtriangleleft#Sm
\zcmp#Sm
\zpipe#Sm
\zproject#Sm
\ringplus#Sm
\plushat#Sm
\simplus#Sm
\plusdot#Sm
\plussim#Sm
\plussubtwo#Sm
\plustrif#Sm
\commaminus#Sm
\minusdot#Sm
\minusfdots#Sm
\minusrdots#Sm
\opluslhrim#Sm
\oplusrhrim#Sm
\vectimes#m
\dottimes#Sm
\timesbar#Sm
\btimes#Sm
\smashtimes#Sm
\otimeslhrim#Sm
\otimesrhrim#Sm
\otimeshat#Sm
\Otimes#Sm
\odiv#Sm
\triangleplus#Sm
\triangleminus#Sm
\triangletimes#Sm
\intprod#Sm
\intprodr#Sm
\fcmp#Sm
\amalg#m
\capdot#Sm
\uminus#Sm
\barcup#Sm
\barcap#Sm
\capwedge#Sm
\cupvee#Sm
\cupovercap#Sm
\capovercup#Sm
\cupbarcap#Sm
\capbarcup#Sm
\twocups#Sm
\twocaps#Sm
\closedvarcup#Sm
\closedvarcap#Sm
\Sqcap#Sm
\Sqcup#Sm
\closedvarcupsmashprod#Sm
\wedgeodot#Sm
\veeodot#Sm
\Wedge#Sm
\Vee#Sm
\wedgeonwedge#Sm
\veeonvee#Sm
\bigslopedvee#Sm
\bigslopedwedge#Sm
\veeonwedge#Sm
\wedgemidvert#Sm
\veemidvert#Sm
\midbarwedge#Sm
\midbarvee#Sm
\doublebarwedge#Sm
\wedgebar#Sm
\wedgedoublebar#Sm
\varveebar#Sm
\doublebarvee#Sm
\veedoublebar#Sm
\dsub#Sm
\rsub#Sm
\eqdot#Sm
\dotequiv#Sm
\equivVert#Sm
\equivVvert#Sm
\dotsim#Sm
\simrdots#Sm
\simminussim#Sm
\congdot#Sm
\asteq#Sm
\hatapprox#Sm
\approxeqq#Sm
\eqqplus#Sm
\pluseqq#Sm
\eqqsim#Sm
\Coloneq#Sm
\eqeq#Sm
\eqeqeq#Sm
\ddotseq#Sm
\equivDD#Sm
\ltcir#Sm
\gtcir#Sm
\ltquest#Sm
\gtquest#Sm
\leqslant#m
\geqslant#m
\lesdot#Sm
\gesdot#Sm
\lesdoto#Sm
\gesdoto#Sm
\lesdotor#Sm
\gesdotol#Sm
\lessapprox#m
\gtrapprox#m
\lneq#m
\gneq#m
\lnapprox#m
\gnapprox#m
\lesseqqgtr#m
\gtreqqless#m
\lsime#Sm
\gsime#Sm
\lsimg#Sm
\gsiml#Sm
\lgE#Sm
\glE#Sm
\lesges#Sm
\gesles#Sm
\eqslantless#m
\eqslantgtr#m
\elsdot#Sm
\egsdot#Sm
\eqqless#Sm
\eqqgtr#Sm
\eqqslantless#Sm
\eqqslantgtr#Sm
\simless#Sm
\simgtr#Sm
\simlE#Sm
\simgE#Sm
\Lt#Sm
\Gt#Sm
\partialmeetcontraction#Sm
\glj#Sm
\gla#Sm
\ltcc#Sm
\gtcc#Sm
\lescc#Sm
\gescc#Sm
\smt#Sm
\lat#Sm
\smte#Sm
\late#Sm
\bumpeqq#Sm
\preceq#m
\succeq#m
\precneq#Sm
\succneq#Sm
\preceqq#Sm
\succeqq#Sm
\precneqq#Sm
\succneqq#Sm
\precapprox#Sm
\succapprox#Sm
\precnapprox#Sm
\succnapprox#Sm
\Prec#Sm
\Succ#Sm
\subsetdot#Sm
\supsetdot#Sm
\subsetplus#Sm
\supsetplus#Sm
\submult#Sm
\supmult#Sm
\subedot#Sm
\supedot#Sm
\subseteqq#Sm
\supseteqq#Sm
\subsim#Sm
\supsim#Sm
\subsetapprox#Sm
\supsetapprox#Sm
\subsetneqq#Sm
\supsetneqq#Sm
\lsqhook#Sm
\rsqhook#Sm
\csub#Sm
\csup#Sm
\csube#Sm
\csupe#Sm
\subsup#Sm
\supsub#Sm
\subsub#Sm
\supsup#Sm
\suphsub#Sm
\supdsub#Sm
\forkv#Sm
\topfork#Sm
\mlcp#Sm
\forks#Sm
\forksnot#Sm
\shortlefttack#Sm
\shortdowntack#Sm
\shortuptack#Sm
\perps#Sm
\vDdash#Sm
\dashV#Sm
\Dashv#Sm
\DashV#Sm
\varVdash#Sm
\Barv#Sm
\vBar#Sm
\vBarv#Sm
\barV#Sm
\Vbar#Sm
\Not#Sm
\bNot#Sm
\revnmid#Sm
\cirmid#Sm
\midcir#Sm
\topcir#Sm
\nhpar#Sm
\parsim#Sm
\interleave#Sm
\nhVvert#Sm
\threedotcolon#Sm
\lllnest#Sm
\gggnest#Sm
\leqqslant#Sm
\geqqslant#Sm
\trslash#Sm
\biginterleave#Sm
\sslash#Sm
\talloblong#Sm
\bigtalloblong#Sm
\squaretopblack#Sm
\squarebotblack#Sm
\squareurblack#Sm
\squarellblack#Sm
\diamondleftblack#Sm
\diamondrightblack#Sm
\diamondtopblack#Sm
\diamondbotblack#Sm
\dottedsquare#m
\lgblksquare#Sm
\lgwhtsquare#Sm
\vysmblksquare#Sm
\vysmwhtsquare#Sm
\pentagonblack#Sm
\pentagon#Sm
\varhexagon#Sm
\varhexagonblack#Sm
\hexagonblack#Sm
\lgblkcircle#Sm
\mdblkdiamond#Sm
\mdwhtdiamond#Sm
\mdblklozenge#Sm
\mdwhtlozenge#Sm
\smblkdiamond#Sm
\smblklozenge#Sm
\smwhtlozenge#Sm
\blkhorzoval#Sm
\whthorzoval#Sm
\blkvertoval#Sm
\whtvertoval#Sm
\circleonleftarrow#Sm
\leftthreearrows#m
\leftarrowonoplus#Sm
\longleftsquigarrow#m
\nvtwoheadleftarrow#Sm
\nVtwoheadleftarrow#Sm
\twoheadmapsfrom#Sm
\twoheadleftdbkarrow#Sm
\leftdotarrow#Sm
\nvleftarrowtail#Sm
\nVleftarrowtail#Sm
\twoheadleftarrowtail#Sm
\nvtwoheadleftarrowtail#Sm
\nVtwoheadleftarrowtail#Sm
\leftarrowx#Sm
\leftcurvedarrow#Sm
\equalleftarrow#Sm
\bsimilarleftarrow#Sm
\leftarrowbackapprox#Sm
\rightarrowgtr#Sm
\rightarrowsupset#Sm
\LLeftarrow#Sm
\RRightarrow#Sm
\bsimilarrightarrow#Sm
\rightarrowbackapprox#Sm
\similarleftarrow#Sm
\leftarrowapprox#Sm
\leftarrowbsimilar#Sm
\rightarrowbsimilar#Sm
\medwhitestar#Sm
\medblackstar#Sm
\smwhitestar#Sm
\rightpentagonblack#Sm
\rightpentagon#Sm
\postalmark#Sm
\hzigzag#Sm
\mbfA#m
\mbfB#m
\mbfC#m
\mbfD#m
\mbfE#m
\mbfF#m
\mbfG#m
\mbfH#m
\mbfI#m
\mbfJ#m
\mbfK#m
\mbfL#m
\mbfM#m
\mbfN#m
\mbfO#m
\mbfP#m
\mbfQ#m
\mbfR#m
\mbfS#m
\mbfT#m
\mbfU#m
\mbfV#m
\mbfW#m
\mbfX#m
\mbfY#m
\mbfZ#m
\mbfa#m
\mbfb#m
\mbfc#m
\mbfd#m
\mbfe#m
\mbff#m
\mbfg#m
\mbfh#m
\mbfi#m
\mbfj#m
\mbfk#m
\mbfl#m
\mbfm#m
\mbfn#m
\mbfo#m
\mbfp#m
\mbfq#m
\mbfr#m
\mbfs#m
\mbft#m
\mbfu#m
\mbfv#m
\mbfw#m
\mbfx#m
\mbfy#m
\mbfz#m
\mitA#m
\mitB#m
\mitC#m
\mitD#m
\mitE#m
\mitF#m
\mitG#m
\mitH#m
\mitI#m
\mitJ#m
\mitK#m
\mitL#m
\mitM#m
\mitN#m
\mitO#m
\mitP#m
\mitQ#m
\mitR#m
\mitS#m
\mitT#m
\mitU#m
\mitV#m
\mitW#m
\mitX#m
\mitY#m
\mitZ#m
\mita#m
\mitb#m
\mitc#m
\mitd#m
\mite#m
\mitf#m
\mitg#m
\miti#m
\mitj#m
\mitk#m
\mitl#m
\mitm#m
\mitn#m
\mito#m
\mitp#m
\mitq#m
\mitr#m
\mits#m
\mitt#m
\mitu#m
\mitv#m
\mitw#m
\mitx#m
\mity#m
\mitz#m
\mbfitA#m
\mbfitB#m
\mbfitC#m
\mbfitD#m
\mbfitE#m
\mbfitF#m
\mbfitG#m
\mbfitH#m
\mbfitI#m
\mbfitJ#m
\mbfitK#m
\mbfitL#m
\mbfitM#m
\mbfitN#m
\mbfitO#m
\mbfitP#m
\mbfitQ#m
\mbfitR#m
\mbfitS#m
\mbfitT#m
\mbfitU#m
\mbfitV#m
\mbfitW#m
\mbfitX#m
\mbfitY#m
\mbfitZ#m
\mbfita#m
\mbfitb#m
\mbfitc#m
\mbfitd#m
\mbfite#m
\mbfitf#m
\mbfitg#m
\mbfith#m
\mbfiti#m
\mbfitj#m
\mbfitk#m
\mbfitl#m
\mbfitm#m
\mbfitn#m
\mbfito#m
\mbfitp#m
\mbfitq#m
\mbfitr#m
\mbfits#m
\mbfitt#m
\mbfitu#m
\mbfitv#m
\mbfitw#m
\mbfitx#m
\mbfity#m
\mbfitz#m
\mscrA#m
\mscrC#m
\mscrD#m
\mscrG#m
\mscrJ#m
\mscrK#m
\mscrN#m
\mscrO#m
\mscrP#m
\mscrQ#m
\mscrS#m
\mscrT#m
\mscrU#m
\mscrV#m
\mscrW#m
\mscrX#m
\mscrY#m
\mscrZ#m
\mscra#Sm
\mscrb#Sm
\mscrc#Sm
\mscrd#Sm
\mscrf#Sm
\mscrh#Sm
\mscri#Sm
\mscrj#Sm
\mscrk#Sm
\mscrl#Sm
\mscrm#Sm
\mscrn#Sm
\mscrp#Sm
\mscrq#Sm
\mscrr#Sm
\mscrs#Sm
\mscrt#Sm
\mscru#Sm
\mscrv#Sm
\mscrw#Sm
\mscrx#Sm
\mscry#Sm
\mscrz#Sm
\mbfscrA#m
\mbfscrB#m
\mbfscrC#m
\mbfscrD#m
\mbfscrE#m
\mbfscrF#m
\mbfscrG#m
\mbfscrH#m
\mbfscrI#m
\mbfscrJ#m
\mbfscrK#m
\mbfscrL#m
\mbfscrM#m
\mbfscrN#m
\mbfscrO#m
\mbfscrP#m
\mbfscrQ#m
\mbfscrR#m
\mbfscrS#m
\mbfscrT#m
\mbfscrU#m
\mbfscrV#m
\mbfscrW#m
\mbfscrX#m
\mbfscrY#m
\mbfscrZ#m
\mbfscra#Sm
\mbfscrb#Sm
\mbfscrc#Sm
\mbfscrd#Sm
\mbfscre#Sm
\mbfscrf#Sm
\mbfscrg#Sm
\mbfscrh#Sm
\mbfscri#Sm
\mbfscrj#Sm
\mbfscrk#Sm
\mbfscrl#Sm
\mbfscrm#Sm
\mbfscrn#Sm
\mbfscro#Sm
\mbfscrp#Sm
\mbfscrq#Sm
\mbfscrr#Sm
\mbfscrs#Sm
\mbfscrt#Sm
\mbfscru#Sm
\mbfscrv#Sm
\mbfscrw#Sm
\mbfscrx#Sm
\mbfscry#Sm
\mbfscrz#Sm
\mfrakA#m
\mfrakB#m
\mfrakD#m
\mfrakE#m
\mfrakF#m
\mfrakG#m
\mfrakJ#m
\mfrakK#m
\mfrakL#m
\mfrakM#m
\mfrakN#m
\mfrakO#m
\mfrakP#m
\mfrakQ#m
\mfrakS#m
\mfrakT#m
\mfrakU#m
\mfrakV#m
\mfrakW#m
\mfrakX#m
\mfrakY#m
\mfraka#m
\mfrakb#m
\mfrakc#m
\mfrakd#m
\mfrake#m
\mfrakf#m
\mfrakg#m
\mfrakh#m
\mfraki#m
\mfrakj#m
\mfrakk#m
\mfrakl#m
\mfrakm#m
\mfrakn#m
\mfrako#m
\mfrakp#m
\mfrakq#m
\mfrakr#m
\mfraks#m
\mfrakt#m
\mfraku#m
\mfrakv#m
\mfrakw#m
\mfrakx#m
\mfraky#m
\mfrakz#m
\BbbA#m
\BbbB#m
\BbbD#m
\BbbE#m
\BbbF#m
\BbbG#m
\BbbI#m
\BbbJ#m
\BbbK#m
\BbbL#m
\BbbM#m
\BbbO#m
\BbbS#m
\BbbT#m
\BbbU#m
\BbbV#m
\BbbW#m
\BbbX#m
\BbbY#m
\Bbba#m
\Bbbb#m
\Bbbc#m
\Bbbd#m
\Bbbe#m
\Bbbf#m
\Bbbg#m
\Bbbh#m
\Bbbi#m
\Bbbj#m
\Bbbk#m
\Bbbl#m
\Bbbm#m
\Bbbn#m
\Bbbo#m
\Bbbp#m
\Bbbq#m
\Bbbr#m
\Bbbs#m
\Bbbt#m
\Bbbu#m
\Bbbv#m
\Bbbw#m
\Bbbx#m
\Bbby#m
\Bbbz#m
\mbffrakA#m
\mbffrakB#m
\mbffrakC#m
\mbffrakD#m
\mbffrakE#m
\mbffrakF#m
\mbffrakG#m
\mbffrakH#m
\mbffrakI#m
\mbffrakJ#m
\mbffrakK#m
\mbffrakL#m
\mbffrakM#m
\mbffrakN#m
\mbffrakO#m
\mbffrakP#m
\mbffrakQ#m
\mbffrakR#m
\mbffrakS#m
\mbffrakT#m
\mbffrakU#m
\mbffrakV#m
\mbffrakW#m
\mbffrakX#m
\mbffrakY#m
\mbffrakZ#m
\mbffraka#m
\mbffrakb#m
\mbffrakc#m
\mbffrakd#m
\mbffrake#m
\mbffrakf#m
\mbffrakg#m
\mbffrakh#m
\mbffraki#m
\mbffrakj#m
\mbffrakk#m
\mbffrakl#m
\mbffrakm#m
\mbffrakn#m
\mbffrako#m
\mbffrakp#m
\mbffrakq#m
\mbffrakr#m
\mbffraks#m
\mbffrakt#m
\mbffraku#m
\mbffrakv#m
\mbffrakw#m
\mbffrakx#m
\mbffraky#m
\mbffrakz#m
\msansA#m
\msansB#m
\msansC#m
\msansD#m
\msansE#m
\msansF#m
\msansG#m
\msansH#m
\msansI#m
\msansJ#m
\msansK#m
\msansL#m
\msansM#m
\msansN#m
\msansO#m
\msansP#m
\msansQ#m
\msansR#m
\msansS#m
\msansT#m
\msansU#m
\msansV#m
\msansW#m
\msansX#m
\msansY#m
\msansZ#m
\msansa#m
\msansb#m
\msansc#m
\msansd#m
\msanse#m
\msansf#m
\msansg#m
\msansh#m
\msansi#m
\msansj#m
\msansk#m
\msansl#m
\msansm#m
\msansn#m
\msanso#m
\msansp#m
\msansq#m
\msansr#m
\msanss#m
\msanst#m
\msansu#m
\msansv#m
\msansw#m
\msansx#m
\msansy#m
\msansz#m
\mbfsansA#m
\mbfsansB#m
\mbfsansC#m
\mbfsansD#m
\mbfsansE#m
\mbfsansF#m
\mbfsansG#m
\mbfsansH#m
\mbfsansI#m
\mbfsansJ#m
\mbfsansK#m
\mbfsansL#m
\mbfsansM#m
\mbfsansN#m
\mbfsansO#m
\mbfsansP#m
\mbfsansQ#m
\mbfsansR#m
\mbfsansS#m
\mbfsansT#m
\mbfsansU#m
\mbfsansV#m
\mbfsansW#m
\mbfsansX#m
\mbfsansY#m
\mbfsansZ#m
\mbfsansa#m
\mbfsansb#m
\mbfsansc#m
\mbfsansd#m
\mbfsanse#m
\mbfsansf#m
\mbfsansg#m
\mbfsansh#m
\mbfsansi#m
\mbfsansj#m
\mbfsansk#m
\mbfsansl#m
\mbfsansm#m
\mbfsansn#m
\mbfsanso#m
\mbfsansp#m
\mbfsansq#m
\mbfsansr#m
\mbfsanss#m
\mbfsanst#m
\mbfsansu#m
\mbfsansv#m
\mbfsansw#m
\mbfsansx#m
\mbfsansy#m
\mbfsansz#m
\mitsansA#m
\mitsansB#m
\mitsansC#m
\mitsansD#m
\mitsansE#m
\mitsansF#m
\mitsansG#m
\mitsansH#m
\mitsansI#m
\mitsansJ#m
\mitsansK#m
\mitsansL#m
\mitsansM#m
\mitsansN#m
\mitsansO#m
\mitsansP#m
\mitsansQ#m
\mitsansR#m
\mitsansS#m
\mitsansT#m
\mitsansU#m
\mitsansV#m
\mitsansW#m
\mitsansX#m
\mitsansY#m
\mitsansZ#m
\mitsansa#m
\mitsansb#m
\mitsansc#m
\mitsansd#m
\mitsanse#m
\mitsansf#m
\mitsansg#m
\mitsansh#m
\mitsansi#m
\mitsansj#m
\mitsansk#m
\mitsansl#m
\mitsansm#m
\mitsansn#m
\mitsanso#m
\mitsansp#m
\mitsansq#m
\mitsansr#m
\mitsanss#m
\mitsanst#m
\mitsansu#m
\mitsansv#m
\mitsansw#m
\mitsansx#m
\mitsansy#m
\mitsansz#m
\mbfitsansA#m
\mbfitsansB#m
\mbfitsansC#m
\mbfitsansD#m
\mbfitsansE#m
\mbfitsansF#m
\mbfitsansG#m
\mbfitsansH#m
\mbfitsansI#m
\mbfitsansJ#m
\mbfitsansK#m
\mbfitsansL#m
\mbfitsansM#m
\mbfitsansN#m
\mbfitsansO#m
\mbfitsansP#m
\mbfitsansQ#m
\mbfitsansR#m
\mbfitsansS#m
\mbfitsansT#m
\mbfitsansU#m
\mbfitsansV#m
\mbfitsansW#m
\mbfitsansX#m
\mbfitsansY#m
\mbfitsansZ#m
\mbfitsansa#m
\mbfitsansb#m
\mbfitsansc#m
\mbfitsansd#m
\mbfitsanse#m
\mbfitsansf#m
\mbfitsansg#m
\mbfitsansh#m
\mbfitsansi#m
\mbfitsansj#m
\mbfitsansk#m
\mbfitsansl#m
\mbfitsansm#m
\mbfitsansn#m
\mbfitsanso#m
\mbfitsansp#m
\mbfitsansq#m
\mbfitsansr#m
\mbfitsanss#m
\mbfitsanst#m
\mbfitsansu#m
\mbfitsansv#m
\mbfitsansw#m
\mbfitsansx#m
\mbfitsansy#m
\mbfitsansz#m
\mttA#m
\mttB#m
\mttC#m
\mttD#m
\mttE#m
\mttF#m
\mttG#m
\mttH#m
\mttI#m
\mttJ#m
\mttK#m
\mttL#m
\mttM#m
\mttN#m
\mttO#m
\mttP#m
\mttQ#m
\mttR#m
\mttS#m
\mttT#m
\mttU#m
\mttV#m
\mttW#m
\mttX#m
\mttY#m
\mttZ#m
\mtta#m
\mttb#m
\mttc#m
\mttd#m
\mtte#m
\mttf#m
\mttg#m
\mtth#m
\mtti#m
\mttj#m
\mttk#m
\mttl#m
\mttm#m
\mttn#m
\mtto#m
\mttp#m
\mttq#m
\mttr#m
\mtts#m
\mttt#m
\mttu#m
\mttv#m
\mttw#m
\mttx#m
\mtty#m
\mttz#m
\imath#m
\jmath#m
\mbfAlpha#m
\mbfBeta#m
\mbfGamma#m
\mbfDelta#m
\mbfEpsilon#m
\mbfZeta#m
\mbfEta#m
\mbfTheta#m
\mbfIota#m
\mbfKappa#m
\mbfLambda#m
\mbfMu#m
\mbfNu#m
\mbfXi#m
\mbfOmicron#m
\mbfPi#m
\mbfRho#m
\mbfvarTheta#m
\mbfSigma#m
\mbfTau#m
\mbfUpsilon#m
\mbfPhi#m
\mbfChi#m
\mbfPsi#m
\mbfOmega#m
\mbfnabla#m
\mbfalpha#m
\mbfbeta#m
\mbfgamma#m
\mbfdelta#m
\mbfvarepsilon#m
\mbfzeta#m
\mbfeta#m
\mbftheta#m
\mbfiota#m
\mbfkappa#m
\mbflambda#m
\mbfmu#m
\mbfnu#m
\mbfxi#m
\mbfomicron#m
\mbfpi#m
\mbfrho#m
\mbfvarsigma#m
\mbfsigma#m
\mbftau#m
\mbfupsilon#m
\mbfvarphi#m
\mbfchi#m
\mbfpsi#m
\mbfomega#m
\mbfpartial#m
\mbfepsilon#m
\mbfvartheta#m
\mbfvarkappa#m
\mbfphi#m
\mbfvarrho#m
\mbfvarpi#m
\mitAlpha#m
\mitBeta#m
\mitGamma#m
\mitDelta#m
\mitEpsilon#m
\mitZeta#m
\mitEta#m
\mitTheta#m
\mitIota#m
\mitKappa#m
\mitLambda#m
\mitMu#m
\mitNu#m
\mitXi#m
\mitOmicron#m
\mitPi#m
\mitRho#m
\mitvarTheta#m
\mitSigma#m
\mitTau#m
\mitUpsilon#m
\mitPhi#m
\mitChi#m
\mitPsi#m
\mitOmega#m
\mitnabla#m
\mitalpha#m
\mitbeta#m
\mitgamma#m
\mitdelta#m
\mitvarepsilon#m
\mitzeta#m
\miteta#m
\mittheta#m
\mitiota#m
\mitkappa#m
\mitlambda#m
\mitmu#m
\mitnu#m
\mitxi#m
\mitomicron#m
\mitpi#m
\mitrho#m
\mitvarsigma#m
\mitsigma#m
\mittau#m
\mitupsilon#m
\mitvarphi#m
\mitchi#m
\mitpsi#m
\mitomega#m
\mitpartial#m
\mitepsilon#m
\mitvartheta#m
\mitvarkappa#m
\mitphi#m
\mitvarrho#m
\mitvarpi#m
\mbfitAlpha#m
\mbfitBeta#m
\mbfitGamma#m
\mbfitDelta#m
\mbfitEpsilon#m
\mbfitZeta#m
\mbfitEta#m
\mbfitTheta#m
\mbfitIota#m
\mbfitKappa#m
\mbfitLambda#m
\mbfitMu#m
\mbfitNu#m
\mbfitXi#m
\mbfitOmicron#m
\mbfitPi#m
\mbfitRho#m
\mbfitvarTheta#m
\mbfitSigma#m
\mbfitTau#m
\mbfitUpsilon#m
\mbfitPhi#m
\mbfitChi#m
\mbfitPsi#m
\mbfitOmega#m
\mbfitnabla#m
\mbfitalpha#m
\mbfitbeta#m
\mbfitgamma#m
\mbfitdelta#m
\mbfitvarepsilon#m
\mbfitzeta#m
\mbfiteta#m
\mbfittheta#m
\mbfitiota#m
\mbfitkappa#m
\mbfitlambda#m
\mbfitmu#m
\mbfitnu#m
\mbfitxi#m
\mbfitomicron#m
\mbfitpi#m
\mbfitrho#m
\mbfitvarsigma#m
\mbfitsigma#m
\mbfittau#m
\mbfitupsilon#m
\mbfitvarphi#m
\mbfitchi#m
\mbfitpsi#m
\mbfitomega#m
\mbfitpartial#m
\mbfitepsilon#m
\mbfitvartheta#m
\mbfitvarkappa#m
\mbfitphi#m
\mbfitvarrho#m
\mbfitvarpi#m
\mbfsansAlpha#m
\mbfsansBeta#m
\mbfsansGamma#m
\mbfsansDelta#m
\mbfsansEpsilon#m
\mbfsansZeta#m
\mbfsansEta#m
\mbfsansTheta#m
\mbfsansIota#m
\mbfsansKappa#m
\mbfsansLambda#m
\mbfsansMu#m
\mbfsansNu#m
\mbfsansXi#m
\mbfsansOmicron#m
\mbfsansPi#m
\mbfsansRho#m
\mbfsansvarTheta#m
\mbfsansSigma#m
\mbfsansTau#m
\mbfsansUpsilon#m
\mbfsansPhi#m
\mbfsansChi#m
\mbfsansPsi#m
\mbfsansOmega#m
\mbfsansnabla#m
\mbfsansalpha#m
\mbfsansbeta#m
\mbfsansgamma#m
\mbfsansdelta#m
\mbfsansvarepsilon#m
\mbfsanszeta#m
\mbfsanseta#m
\mbfsanstheta#m
\mbfsansiota#m
\mbfsanskappa#m
\mbfsanslambda#m
\mbfsansmu#m
\mbfsansnu#m
\mbfsansxi#m
\mbfsansomicron#m
\mbfsanspi#m
\mbfsansrho#m
\mbfsansvarsigma#m
\mbfsanssigma#m
\mbfsanstau#m
\mbfsansupsilon#m
\mbfsansvarphi#m
\mbfsanschi#m
\mbfsanspsi#m
\mbfsansomega#m
\mbfsanspartial#m
\mbfsansepsilon#m
\mbfsansvartheta#m
\mbfsansvarkappa#m
\mbfsansphi#m
\mbfsansvarrho#m
\mbfsansvarpi#m
\mbfitsansAlpha#m
\mbfitsansBeta#m
\mbfitsansGamma#m
\mbfitsansDelta#m
\mbfitsansEpsilon#m
\mbfitsansZeta#m
\mbfitsansEta#m
\mbfitsansTheta#m
\mbfitsansIota#m
\mbfitsansKappa#m
\mbfitsansLambda#m
\mbfitsansMu#m
\mbfitsansNu#m
\mbfitsansXi#m
\mbfitsansOmicron#m
\mbfitsansPi#m
\mbfitsansRho#m
\mbfitsansvarTheta#m
\mbfitsansSigma#m
\mbfitsansTau#m
\mbfitsansUpsilon#m
\mbfitsansPhi#m
\mbfitsansChi#m
\mbfitsansPsi#m
\mbfitsansOmega#m
\mbfitsansnabla#m
\mbfitsansalpha#m
\mbfitsansbeta#m
\mbfitsansgamma#m
\mbfitsansdelta#m
\mbfitsansvarepsilon#m
\mbfitsanszeta#m
\mbfitsanseta#m
\mbfitsanstheta#m
\mbfitsansiota#m
\mbfitsanskappa#m
\mbfitsanslambda#m
\mbfitsansmu#m
\mbfitsansnu#m
\mbfitsansxi#m
\mbfitsansomicron#m
\mbfitsanspi#m
\mbfitsansrho#m
\mbfitsansvarsigma#m
\mbfitsanssigma#m
\mbfitsanstau#m
\mbfitsansupsilon#m
\mbfitsansvarphi#m
\mbfitsanschi#m
\mbfitsanspsi#m
\mbfitsansomega#m
\mbfitsanspartial#m
\mbfitsansepsilon#m
\mbfitsansvartheta#m
\mbfitsansvarkappa#m
\mbfitsansphi#m
\mbfitsansvarrho#m
\mbfitsansvarpi#m
\mbfDigamma#Sm
\mbfdigamma#Sm
\mbfzero#m
\mbfone#m
\mbftwo#m
\mbfthree#m
\mbffour#m
\mbffive#m
\mbfsix#m
\mbfseven#m
\mbfeight#m
\mbfnine#m
\Bbbzero#m
\Bbbone#m
\Bbbtwo#m
\Bbbthree#m
\Bbbfour#m
\Bbbfive#m
\Bbbsix#m
\Bbbseven#m
\Bbbeight#m
\Bbbnine#m
\msanszero#m
\msansone#m
\msanstwo#m
\msansthree#m
\msansfour#m
\msansfive#m
\msanssix#m
\msansseven#m
\msanseight#m
\msansnine#m
\mbfsanszero#m
\mbfsansone#m
\mbfsanstwo#m
\mbfsansthree#m
\mbfsansfour#m
\mbfsansfive#m
\mbfsanssix#m
\mbfsansseven#m
\mbfsanseight#m
\mbfsansnine#m
\mttzero#m
\mttone#m
\mtttwo#m
\mttthree#m
\mttfour#m
\mttfive#m
\mttsix#m
\mttseven#m
\mtteight#m
\mttnine#m
\arabicmaj#Sm
\arabichad#Sm

# commands defined by \morecolors
\AntiqueWhite#*
\AntiqueWhiteB#*
\AntiqueWhiteC#*
\AntiqueWhiteD#*
\Aquamarine#*
\AquamarineB#*
\AquamarineC#*
\AquamarineD#*
\Azure#*
\AzureB#*
\AzureC#*
\AzureD#*
\Bisque#*
\BisqueB#*
\BisqueC#*
\BisqueD#*
\Blue#*
\BlueB#*
\BlueC#*
\BlueD#*
\Brown#*
\BrownB#*
\BrownC#*
\BrownD#*
\Burlywood#*
\BurlywoodB#*
\BurlywoodC#*
\BurlywoodD#*
\CadetBlue#*
\CadetBlueB#*
\CadetBlueC#*
\CadetBlueD#*
\Chartreuse#*
\ChartreuseB#*
\ChartreuseC#*
\ChartreuseD#*
\Chocolate#*
\ChocolateB#*
\ChocolateC#*
\ChocolateD#*
\Coral#*
\CoralB#*
\CoralC#*
\CoralD#*
\Cornsilk#*
\CornsilkB#*
\CornsilkC#*
\CornsilkD#*
\Cyan#*
\CyanB#*
\CyanC#*
\CyanD#*
\DarkGoldenrod#*
\DarkGoldenrodB#*
\DarkGoldenrodC#*
\DarkGoldenrodD#*
\DarkOliveGreen#*
\DarkOliveGreenB#*
\DarkOliveGreenC#*
\DarkOliveGreenD#*
\DarkOrange#*
\DarkOrangeB#*
\DarkOrangeC#*
\DarkOrangeD#*
\DarkOrchid#*
\DarkOrchidB#*
\DarkOrchidC#*
\DarkOrchidD#*
\DarkSeaGreen#*
\DarkSeaGreenB#*
\DarkSeaGreenC#*
\DarkSeaGreenD#*
\DarkSlateGray#*
\DarkSlateGrayB#*
\DarkSlateGrayC#*
\DarkSlateGrayD#*
\DeepPink#*
\DeepPinkB#*
\DeepPinkC#*
\DeepPinkD#*
\DeepSkyBlue#*
\DeepSkyBlueB#*
\DeepSkyBlueC#*
\DeepSkyBlueD#*
\DodgerBlue#*
\DodgerBlueB#*
\DodgerBlueC#*
\DodgerBlueD#*
\Firebrick#*
\FirebrickB#*
\FirebrickC#*
\FirebrickD#*
\Gold#*
\GoldB#*
\GoldC#*
\GoldD#*
\Goldenrod#*
\GoldenrodB#*
\GoldenrodC#*
\GoldenrodD#*
\Green#*
\GreenB#*
\GreenC#*
\GreenD#*
\Honeydew#*
\HoneydewB#*
\HoneydewC#*
\HoneydewD#*
\HotPink#*
\HotPinkB#*
\HotPinkC#*
\HotPinkD#*
\IndianRed#*
\IndianRedB#*
\IndianRedC#*
\IndianRedD#*
\Ivory#*
\IvoryB#*
\IvoryC#*
\IvoryD#*
\Khaki#*
\KhakiB#*
\KhakiC#*
\KhakiD#*
\LavenderBlush#*
\LavenderBlushB#*
\LavenderBlushC#*
\LavenderBlushD#*
\LemonChiffon#*
\LemonChiffonB#*
\LemonChiffonC#*
\LemonChiffonD#*
\LightBlue#*
\LightBlueB#*
\LightBlueC#*
\LightBlueD#*
\LightCyan#*
\LightCyanB#*
\LightCyanC#*
\LightCyanD#*
\LightGoldenrod#*
\LightGoldenrodB#*
\LightGoldenrodC#*
\LightGoldenrodD#*
\LightPink#*
\LightPinkB#*
\LightPinkC#*
\LightPinkD#*
\LightSalmon#*
\LightSalmonB#*
\LightSalmonC#*
\LightSalmonD#*
\LightSkyBlue#*
\LightSkyBlueB#*
\LightSkyBlueC#*
\LightSkyBlueD#*
\LightSteelBlue#*
\LightSteelBlueB#*
\LightSteelBlueC#*
\LightSteelBlueD#*
\LightYellow#*
\LightYellowB#*
\LightYellowC#*
\LightYellowD#*
\Magenta#*
\MagentaB#*
\MagentaC#*
\MagentaD#*
\Maroon#*
\MaroonB#*
\MaroonC#*
\MaroonD#*
\MediumOrchid#*
\MediumOrchidB#*
\MediumOrchidC#*
\MediumOrchidD#*
\MediumPurple#*
\MediumPurpleB#*
\MediumPurpleC#*
\MediumPurpleD#*
\MistyRose#*
\MistyRoseB#*
\MistyRoseC#*
\MistyRoseD#*
\NavajoWhite#*
\NavajoWhiteB#*
\NavajoWhiteC#*
\NavajoWhiteD#*
\OliveDrab#*
\OliveDrabB#*
\OliveDrabC#*
\OliveDrabD#*
\Orange#*
\OrangeB#*
\OrangeC#*
\OrangeD#*
\OrangeRed#*
\OrangeRedB#*
\OrangeRedC#*
\OrangeRedD#*
\Orchid#*
\OrchidB#*
\OrchidC#*
\OrchidD#*
\PaleGreen#*
\PaleGreenB#*
\PaleGreenC#*
\PaleGreenD#*
\PaleTurquoise#*
\PaleTurquoiseB#*
\PaleTurquoiseC#*
\PaleTurquoiseD#*
\PaleVioletRed#*
\PaleVioletRedB#*
\PaleVioletRedC#*
\PaleVioletRedD#*
\PeachPuff#*
\PeachPuffB#*
\PeachPuffC#*
\PeachPuffD#*
\Pink#*
\PinkB#*
\PinkC#*
\PinkD#*
\Plum#*
\PlumB#*
\PlumC#*
\PlumD#*
\Purple#*
\PurpleB#*
\PurpleC#*
\PurpleD#*
\Red#*
\RedB#*
\RedC#*
\RedD#*
\RosyBrown#*
\RosyBrownB#*
\RosyBrownC#*
\RosyBrownD#*
\RoyalBlue#*
\RoyalBlueB#*
\RoyalBlueC#*
\RoyalBlueD#*
\Salmon#*
\SalmonB#*
\SalmonC#*
\SalmonD#*
\SeaGreen#*
\SeaGreenB#*
\SeaGreenC#*
\SeaGreenD#*
\Seashell#*
\SeashellB#*
\SeashellC#*
\SeashellD#*
\Sienna#*
\SiennaB#*
\SiennaC#*
\SiennaD#*
\SkyBlue#*
\SkyBlueB#*
\SkyBlueC#*
\SkyBlueD#*
\SlateBlue#*
\SlateBlueB#*
\SlateBlueC#*
\SlateBlueD#*
\SlateGray#*
\SlateGrayB#*
\SlateGrayC#*
\SlateGrayD#*
\Snow#*
\SnowB#*
\SnowC#*
\SnowD#*
\SpringGreen#*
\SpringGreenB#*
\SpringGreenC#*
\SpringGreenD#*
\SteelBlue#*
\SteelBlueB#*
\SteelBlueC#*
\SteelBlueD#*
\Tan#*
\TanB#*
\TanC#*
\TanD#*
\Thistle#*
\ThistleB#*
\ThistleC#*
\ThistleD#*
\Tomato#*
\TomatoB#*
\TomatoC#*
\TomatoD#*
\Turquoise#*
\TurquoiseB#*
\TurquoiseC#*
\TurquoiseD#*
\VioletRed#*
\VioletRedB#*
\VioletRedC#*
\VioletRedD#*
\Wheat#*
\WheatB#*
\WheatC#*
\WheatD#*
\Yellow#*
\YellowB#*
\YellowC#*
\YellowD#*
\Green#*
\Grey#*
\Maroon#*
\Purple#*
