#!/usr/bin/env python
# Copyright (c) 2018-2019 Satpy developers
#
# This file is part of satpy.
#
# satpy is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# satpy is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# satpy.  If not, see <http://www.gnu.org/licenses/>.
"""Mimic TPW Color enhancements."""

from trollimage.colormap import Colormap


def nrl_colors(img, **kwargs):
    """TPW color table based on NRL Color table (0-76 mm)."""
    nrl_tpw_colors = {"colors": [[0.0, [188, 132, 98]],
                                 [0.27472527472527475, [188, 130, 99]],
                                 [0.5494505494505495, [187, 128, 100]],
                                 [0.8241758241758242, [186, 125, 101]],
                                 [1.098901098901099, [185, 124, 102]],
                                 [1.3736263736263736, [184, 122, 103]],
                                 [1.6483516483516485, [183, 120, 103]],
                                 [1.9230769230769234, [182, 119, 104]],
                                 [2.197802197802198, [182, 118, 106]],
                                 [2.4725274725274726, [181, 116, 107]],
                                 [2.7472527472527473, [180, 114, 108]],
                                 [3.0219780219780223, [179, 114, 108]],
                                 [3.296703296703297, [178, 113, 109]],
                                 [3.5714285714285716, [177, 111, 110]],
                                 [3.8461538461538467, [177, 110, 111]],
                                 [4.120879120879121, [176, 108, 111]],
                                 [4.395604395604396, [176, 106, 110]],
                                 [4.670329670329671, [175, 104, 110]],
                                 [4.945054945054945, [174, 103, 111]],
                                 [5.21978021978022, [174, 101, 111]],
                                 [5.4945054945054945, [173, 99, 111]],
                                 [5.76923076923077, [172, 97, 111]],
                                 [6.043956043956045, [171, 95, 112]],
                                 [6.318681318681319, [171, 93, 112]],
                                 [6.593406593406594, [171, 91, 113]],
                                 [6.868131868131869, [170, 90, 113]],
                                 [7.142857142857143, [169, 88, 114]],
                                 [7.417582417582418, [169, 86, 114]],
                                 [7.692307692307693, [168, 85, 115]],
                                 [7.967032967032968, [167, 83, 115]],
                                 [8.241758241758243, [166, 81, 116]],
                                 [8.516483516483516, [166, 80, 118]],
                                 [8.791208791208792, [165, 78, 119]],
                                 [9.065934065934067, [165, 76, 120]],
                                 [9.340659340659341, [164, 75, 120]],
                                 [9.615384615384617, [164, 74, 121]],
                                 [9.89010989010989, [163, 72, 123]],
                                 [10.164835164835166, [162, 70, 124]],
                                 [10.43956043956044, [161, 69, 125]],
                                 [10.714285714285715, [160, 67, 126]],
                                 [10.989010989010989, [160, 66, 128]],
                                 [11.263736263736265, [159, 64, 130]],
                                 [11.53846153846154, [159, 63, 131]],
                                 [11.813186813186814, [158, 61, 132]],
                                 [12.08791208791209, [158, 60, 134]],
                                 [12.362637362637363, [157, 58, 136]],
                                 [12.637362637362639, [156, 57, 137]],
                                 [12.912087912087912, [155, 56, 139]],
                                 [13.186813186813188, [155, 54, 141]],
                                 [13.461538461538463, [154, 52, 142]],
                                 [13.736263736263737, [154, 52, 144]],
                                 [14.010989010989013, [153, 50, 146]],
                                 [14.285714285714286, [153, 49, 148]],
                                 [14.560439560439562, [152, 47, 150]],
                                 [14.835164835164836, [150, 46, 151]],
                                 [15.109890109890111, [147, 45, 150]],
                                 [15.384615384615387, [144, 44, 150]],
                                 [15.65934065934066, [142, 44, 152]],
                                 [15.934065934065936, [138, 48, 156]],
                                 [16.20879120879121, [135, 50, 159]],
                                 [16.483516483516485, [132, 52, 161]],
                                 [16.75824175824176, [131, 56, 164]],
                                 [17.032967032967033, [126, 60, 168]],
                                 [17.30769230769231, [123, 62, 171]],
                                 [17.582417582417584, [121, 65, 173]],
                                 [17.857142857142858, [117, 69, 177]],
                                 [18.131868131868135, [114, 71, 180]],
                                 [18.40659340659341, [111, 74, 182]],
                                 [18.681318681318682, [109, 77, 185]],
                                 [18.956043956043956, [104, 82, 190]],
                                 [19.230769230769234, [101, 84, 193]],
                                 [19.505494505494507, [98, 86, 195]],
                                 [19.78021978021978, [96, 89, 198]],
                                 [20.05494505494506, [93, 92, 200]],
                                 [20.329670329670332, [90, 95, 204]],
                                 [20.604395604395606, [87, 98, 207]],
                                 [20.87912087912088, [83, 103, 211]],
                                 [21.153846153846157, [80, 105, 214]],
                                 [21.42857142857143, [77, 108, 216]],
                                 [21.703296703296704, [74, 110, 220]],
                                 [21.978021978021978, [71, 114, 222]],
                                 [22.252747252747255, [68, 116, 225]],
                                 [22.52747252747253, [65, 120, 228]],
                                 [22.802197802197803, [61, 125, 233]],
                                 [23.07692307692308, [57, 127, 235]],
                                 [23.351648351648354, [55, 130, 239]],
                                 [23.626373626373628, [52, 133, 242]],
                                 [23.9010989010989, [49, 137, 245]],
                                 [24.17582417582418, [47, 139, 247]],
                                 [24.450549450549453, [44, 142, 250]],
                                 [24.725274725274726, [40, 146, 255]],
                                 [25.000000000000004, [40, 148, 255]],
                                 [25.274725274725277, [42, 150, 255]],
                                 [25.54945054945055, [46, 154, 255]],
                                 [25.824175824175825, [50, 158, 255]],
                                 [26.098901098901102, [52, 159, 255]],
                                 [26.373626373626376, [55, 163, 255]],
                                 [26.64835164835165, [59, 167, 255]],
                                 [26.923076923076927, [61, 169, 255]],
                                 [27.1978021978022, [65, 173, 255]],
                                 [27.472527472527474, [70, 178, 255]],
                                 [27.747252747252748, [73, 182, 255]],
                                 [28.021978021978025, [76, 185, 255]],
                                 [28.2967032967033, [79, 188, 255]],
                                 [28.571428571428573, [82, 192, 255]],
                                 [28.84615384615385, [86, 195, 255]],
                                 [29.120879120879124, [88, 199, 255]],
                                 [29.395604395604398, [91, 201, 255]],
                                 [29.67032967032967, [95, 205, 255]],
                                 [29.94505494505495, [97, 207, 255]],
                                 [30.219780219780223, [101, 210, 255]],
                                 [30.494505494505496, [104, 213, 255]],
                                 [30.769230769230774, [107, 216, 255]],
                                 [31.043956043956047, [110, 218, 255]],
                                 [31.31868131868132, [114, 222, 255]],
                                 [31.593406593406595, [115, 223, 255]],
                                 [31.868131868131872, [119, 227, 255]],
                                 [32.142857142857146, [123, 231, 255]],
                                 [32.41758241758242, [125, 233, 255]],
                                 [32.69230769230769, [127, 236, 255]],
                                 [32.96703296703297, [133, 241, 255]],
                                 [33.24175824175825, [136, 244, 255]],
                                 [33.51648351648352, [139, 247, 255]],
                                 [33.791208791208796, [143, 252, 255]],
                                 [34.065934065934066, [145, 254, 255]],
                                 [34.34065934065934, [148, 255, 254]],
                                 [34.61538461538462, [148, 255, 247]],
                                 [34.89010989010989, [148, 255, 241]],
                                 [35.16483516483517, [148, 255, 235]],
                                 [35.439560439560445, [148, 255, 229]],
                                 [35.714285714285715, [148, 255, 223]],
                                 [35.98901098901099, [148, 255, 217]],
                                 [36.26373626373627, [148, 255, 210]],
                                 [36.53846153846154, [148, 255, 205]],
                                 [36.81318681318682, [148, 255, 199]],
                                 [37.08791208791209, [148, 255, 193]],
                                 [37.362637362637365, [148, 255, 187]],
                                 [37.63736263736264, [148, 255, 181]],
                                 [37.91208791208791, [148, 255, 174]],
                                 [38.18681318681319, [148, 255, 168]],
                                 [38.46153846153847, [148, 255, 162]],
                                 [38.73626373626374, [148, 255, 156]],
                                 [39.010989010989015, [148, 255, 150]],
                                 [39.28571428571429, [151, 255, 148]],
                                 [39.56043956043956, [157, 255, 148]],
                                 [39.83516483516484, [163, 255, 148]],
                                 [40.10989010989012, [169, 255, 148]],
                                 [40.38461538461539, [175, 255, 148]],
                                 [40.659340659340664, [181, 255, 148]],
                                 [40.934065934065934, [188, 255, 148]],
                                 [41.20879120879121, [197, 255, 148]],
                                 [41.48351648351649, [203, 255, 148]],
                                 [41.75824175824176, [209, 255, 148]],
                                 [42.032967032967036, [215, 255, 148]],
                                 [42.307692307692314, [221, 255, 148]],
                                 [42.582417582417584, [227, 255, 148]],
                                 [42.85714285714286, [233, 255, 148]],
                                 [43.13186813186814, [239, 255, 148]],
                                 [43.40659340659341, [244, 255, 148]],
                                 [43.681318681318686, [250, 255, 148]],
                                 [43.956043956043956, [254, 254, 146]],
                                 [44.23076923076923, [255, 251, 143]],
                                 [44.50549450549451, [255, 249, 141]],
                                 [44.78021978021978, [255, 247, 139]],
                                 [45.05494505494506, [255, 242, 134]],
                                 [45.329670329670336, [255, 239, 131]],
                                 [45.604395604395606, [255, 236, 128]],
                                 [45.87912087912088, [255, 233, 125]],
                                 [46.15384615384616, [255, 231, 122]],
                                 [46.42857142857143, [255, 227, 120]],
                                 [46.70329670329671, [255, 225, 117]],
                                 [46.978021978021985, [255, 221, 113]],
                                 [47.252747252747255, [255, 218, 110]],
                                 [47.52747252747253, [255, 216, 108]],
                                 [47.8021978021978, [255, 211, 103]],
                                 [48.07692307692308, [255, 209, 101]],
                                 [48.35164835164836, [255, 206, 98]],
                                 [48.62637362637363, [255, 204, 96]],
                                 [48.901098901098905, [255, 199, 91]],
                                 [49.17582417582418, [255, 196, 87]],
                                 [49.45054945054945, [255, 193, 85]],
                                 [49.72527472527473, [255, 191, 82]],
                                 [50.00000000000001, [255, 188, 80]],
                                 [50.27472527472528, [255, 185, 77]],
                                 [50.549450549450555, [255, 182, 74]],
                                 [50.82417582417583, [255, 179, 70]],
                                 [51.0989010989011, [255, 176, 68]],
                                 [51.37362637362638, [255, 173, 64]],
                                 [51.64835164835165, [255, 171, 61]],
                                 [51.92307692307693, [255, 167, 58]],
                                 [52.197802197802204, [255, 164, 55]],
                                 [52.472527472527474, [255, 161, 52]],
                                 [52.74725274725275, [255, 158, 49]],
                                 [53.02197802197803, [255, 154, 46]],
                                 [53.2967032967033, [255, 151, 42]],
                                 [53.57142857142858, [255, 148, 40]],
                                 [53.846153846153854, [252, 144, 39]],
                                 [54.120879120879124, [249, 140, 39]],
                                 [54.3956043956044, [246, 136, 39]],
                                 [54.67032967032967, [243, 132, 39]],
                                 [54.94505494505495, [240, 128, 39]],
                                 [55.219780219780226, [237, 125, 39]],
                                 [55.494505494505496, [234, 121, 39]],
                                 [55.769230769230774, [231, 118, 39]],
                                 [56.04395604395605, [227, 114, 39]],
                                 [56.31868131868132, [225, 111, 39]],
                                 [56.5934065934066, [222, 108, 39]],
                                 [56.868131868131876, [219, 104, 39]],
                                 [57.142857142857146, [216, 101, 39]],
                                 [57.41758241758242, [213, 97, 39]],
                                 [57.6923076923077, [210, 95, 39]],
                                 [57.96703296703297, [206, 91, 39]],
                                 [58.24175824175825, [204, 89, 39]],
                                 [58.51648351648352, [200, 86, 39]],
                                 [58.791208791208796, [198, 83, 39]],
                                 [59.06593406593407, [194, 80, 39]],
                                 [59.34065934065934, [192, 78, 39]],
                                 [59.61538461538462, [188, 75, 39]],
                                 [59.8901098901099, [185, 73, 39]],
                                 [60.16483516483517, [182, 70, 39]],
                                 [60.439560439560445, [179, 68, 39]],
                                 [60.71428571428572, [176, 66, 39]],
                                 [60.98901098901099, [173, 63, 39]],
                                 [61.26373626373627, [171, 62, 39]],
                                 [61.53846153846155, [169, 59, 39]],
                                 [61.81318681318682, [167, 57, 40]],
                                 [62.087912087912095, [165, 56, 40]],
                                 [62.362637362637365, [165, 54, 40]],
                                 [62.63736263736264, [163, 52, 40]],
                                 [62.91208791208792, [161, 50, 41]],
                                 [63.18681318681319, [159, 48, 42]],
                                 [63.46153846153847, [159, 47, 42]],
                                 [63.736263736263744, [157, 46, 43]],
                                 [64.01098901098902, [155, 44, 43]],
                                 [64.28571428571429, [154, 44, 45]],
                                 [64.56043956043956, [156, 45, 48]],
                                 [64.83516483516485, [157, 46, 52]],
                                 [65.10989010989012, [159, 48, 55]],
                                 [65.38461538461539, [160, 50, 58]],
                                 [65.65934065934067, [162, 52, 62]],
                                 [65.93406593406594, [164, 53, 65]],
                                 [66.20879120879121, [165, 55, 69]],
                                 [66.4835164835165, [167, 57, 72]],
                                 [66.75824175824177, [169, 59, 76]],
                                 [67.03296703296704, [171, 61, 80]],
                                 [67.3076923076923, [172, 63, 83]],
                                 [67.58241758241759, [174, 65, 87]],
                                 [67.85714285714286, [176, 67, 91]],
                                 [68.13186813186813, [177, 69, 95]],
                                 [68.40659340659342, [179, 71, 98]],
                                 [68.68131868131869, [181, 73, 102]],
                                 [68.95604395604396, [182, 75, 106]],
                                 [69.23076923076924, [184, 78, 109]],
                                 [69.50549450549451, [186, 80, 114]],
                                 [69.78021978021978, [188, 82, 117]],
                                 [70.05494505494507, [189, 85, 121]],
                                 [70.32967032967034, [191, 87, 125]],
                                 [70.6043956043956, [193, 90, 129]],
                                 [70.87912087912089, [194, 92, 132]],
                                 [71.15384615384616, [196, 95, 137]],
                                 [71.42857142857143, [198, 97, 140]],
                                 [71.70329670329672, [199, 100, 144]],
                                 [71.97802197802199, [201, 103, 148]],
                                 [72.25274725274726, [203, 105, 152]],
                                 [72.52747252747254, [205, 108, 155]],
                                 [72.80219780219781, [206, 110, 159]],
                                 [73.07692307692308, [208, 114, 163]],
                                 [73.35164835164836, [210, 116, 167]],
                                 [73.62637362637363, [211, 120, 171]],
                                 [73.9010989010989, [213, 122, 174]],
                                 [74.17582417582418, [215, 125, 178]],
                                 [74.45054945054946, [216, 128, 182]],
                                 [74.72527472527473, [218, 131, 185]],
                                 [75.0, [220, 135, 189]],
                                 ]}
    kwargs['palettes'].update(nrl_tpw_colors)
    palette = kwargs['palettes']
    palette['colors'] = tuple(map(tuple, palette['colors']))

    cm = Colormap(*palette['colors'])
    img.palettize(cm)


def total_precipitable_water(img, **kwargs):
    """Palettizes images from MIMIC TPW data.

    This modifies the image's data so the correct colors
    can be applied to it, and then palettizes the image.
    """
    palette = kwargs['palettes']
    palette['colors'] = tuple(map(tuple, palette['colors']))

    cm = Colormap(*palette['colors'])
    img.palettize(cm)
