---
layout: post
title: Polyglot 1.4.0
lang: zh-CN
---

Polyglot [1.4.0 版本](https://rubygems.org/gems/jekyll-polyglot/versions/1.4.0)现已推出！

{% highlight yaml %}
gem install jekyll-polyglot
{% endhighlight %}

## `href` 属性的静态去相对化

本版本新增了一个 Liquid 块标签 `{% raw %} {% static_href %}href="..."{% endstatic_href %} {% endraw %}`。该块标签可用于创建不受 Polyglot 相对化影响的锚点标签中的href属性。

Jekyll-Polyglot 在相对化处理上有些生硬，所以如果你想要制作一些明确的静态 URL 内容（比如[制作一个语言切换器](https://github.com/untra/polyglot/blob/main/site/_includes/sidebar.html#L40-L42)）该 Liquid 标签可以帮助你构建那些不会被扭曲的 `href="..."` 标签。

## 独占式网站语言生成

Polyglot 1.4.0 添加了对 `lang-exclusive: [ ]` 前页内容字段的支持。如果对文档添加该前页内容字段，将会限制 Jekyll 仅对指明的语言的子站点生成该文档。

{% highlight yaml %}
---
lang-exclusive: ['{{ site.active_lang }}']
---
{% endhighlight %}

这是一种控制哪些语言可以查看该文档的方法，即使该文档在默认语言站点中可能没有相对应的版本。

## 重命名部分 Liquid 标签

`{% raw %} {% static_href %} {% endraw %}` 标签现在也可以使用 `{% raw %} {% Static_Href %} {% endraw %}` 。现存的 `{% raw %} {% I18n_Headers %} {% endraw %}` 标签也可以用 `{% raw %} {% i18n_headers %} {% endraw %}` 来使用。

## 想要看到你的语言吗？

我在募集愿意为 [Jekyll-Polyglot 主页](https://polyglot.untra.io/) 提供属于您的母语版本的志愿者！如果您觉得本软件对您有用，且希望本官方站点以您的语言呈现，请在 [GitHub issues](https://github.com/untra/polyglot/issues)上联系我。
