---
layout: post
title: Polyglot 1.8.0 - Community Contributions Release
lang: en
---

Get excited for Jekyll-Polyglot 1.8.0, which has a few feature improvements and recognizes community documentation and contributions!

## language specific permalinks

One new feature is to give pages language specific permalinks and to retain their association to other relative pages. This new feature is again improved by **[antoniovazquezblanco](https://github.com/antoniovazquezblanco)**, who is a gentleman and a scholar.

## sitemap generation & i18n SEO

This release also recognizes the quality [sitemap.xml]({{ site.url }}/sitemap.xml) and [robots.txt]({{ site.url }}/robots.txt) solution provided by **[jerturowetz](https://github.com/jerturowetz)**. This website now demonstrates and captures more SEO power by using these to be crawlable as a static jekyll website by search providers. See the example website files [here](https://github.com/untra/polyglot/tree/master/site).

## jekyll :polyglot :post_write hook

Github user **[obfusk](https://github.com/obfusk)** contributed a [tiny PR](https://github.com/untra/polyglot/pull/142) a few years back:

With polyglot `:site, :post_write` like these run for each child processes:

```rb
Jekyll::Hooks.register :site, :post_write do |site|
  ...
end
```

This release adds a custom `:post_write` hook that runs exactly once, after all languages been processed (whether or not `parallel_localization` is used):

```rb
Jekyll::Hooks.register :polyglot, :post_write do |site|
  # do something amazing here!
end
```

This feature is helpful for complex jekyll static sites that make additional use of [jekyll hook plugins](https://jekyllrb.com/docs/plugins/hooks/).

She also contributed a fix for [additional logging when language subprocesses crash](https://github.com/untra/polyglot/pull/145). Thanks for this contribution!

## localized variables and portuguese translation.

**[george-gca](https://github.com/george-gca)** is a talented and awesome guy, contributing [an entire blogpost](/2024/02/29/localized-variables/) on how best to localize rich text from site data. He also provided a [site brazilian translation](https://polyglot.untra.io/pt-BR/). 

