# PySNMP SMI module. Autogenerated from smidump -f python BRIDGE-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:44 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( MacAddress, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "MacAddress", "TextualConvention")

# Types

class BridgeId(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8
    
class Timeout(TextualConvention, Integer32):
    displayHint = "d"
    

# Objects

dot1dBridge = ModuleIdentity((1, 3, 6, 1, 2, 1, 17)).setRevisions(("2005-09-19 00:00","1993-07-31 00:00","1991-12-31 00:00",))
if mibBuilder.loadTexts: dot1dBridge.setOrganization("IETF Bridge MIB Working Group")
if mibBuilder.loadTexts: dot1dBridge.setContactInfo("Email: bridge-mib@ietf.org\n\nK.C. Norseth (Editor)\nL-3 Communications\nTel: +1 801-594-2809\nEmail: kenyon.c.norseth@L-3com.com\nPostal: 640 N. 2200 West.\nSalt Lake City, Utah 84116-0850\n\n\n\n\nLes Bell (Editor)\n3Com Europe Limited\nPhone: +44 1442 438025\nEmail: elbell@ntlworld.com\nPostal: 3Com Centre, Boundary Way\nHemel Hempstead\nHerts.  HP2 7YU\nUK\n\nSend comments to <bridge-mib@ietf.org>")
if mibBuilder.loadTexts: dot1dBridge.setDescription("The Bridge MIB module for managing devices that support\nIEEE 802.1D.\n\nCopyright (C) The Internet Society (2005).  This version of\nthis MIB module is part of RFC 4188; see the RFC itself for\nfull legal notices.")
dot1dNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 0))
dot1dBase = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 1))
dot1dBaseBridgeAddress = MibScalar((1, 3, 6, 1, 2, 1, 17, 1, 1), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBaseBridgeAddress.setDescription("The MAC address used by this bridge when it must be\nreferred to in a unique fashion.  It is recommended\nthat this be the numerically smallest MAC address of\nall ports that belong to this bridge.  However, it is only\n\n\n\nrequired to be unique.  When concatenated with\ndot1dStpPriority, a unique BridgeIdentifier is formed,\nwhich is used in the Spanning Tree Protocol.")
dot1dBaseNumPorts = MibScalar((1, 3, 6, 1, 2, 1, 17, 1, 2), Integer32()).setMaxAccess("readonly").setUnits("ports")
if mibBuilder.loadTexts: dot1dBaseNumPorts.setDescription("The number of ports controlled by this bridging\nentity.")
dot1dBaseType = MibScalar((1, 3, 6, 1, 2, 1, 17, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,2,3,)).subtype(namedValues=NamedValues(("unknown", 1), ("transparent-only", 2), ("sourceroute-only", 3), ("srt", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBaseType.setDescription("Indicates what type of bridging this bridge can\nperform.  If a bridge is actually performing a\ncertain type of bridging, this will be indicated by\nentries in the port table for the given type.")
dot1dBasePortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 1, 4))
if mibBuilder.loadTexts: dot1dBasePortTable.setDescription("A table that contains generic information about every\nport that is associated with this bridge.  Transparent,\nsource-route, and srt ports are included.")
dot1dBasePortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 1, 4, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dBasePort"))
if mibBuilder.loadTexts: dot1dBasePortEntry.setDescription("A list of information for each port of the bridge.")
dot1dBasePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePort.setDescription("The port number of the port for which this entry\ncontains bridge management information.")
dot1dBasePortIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortIfIndex.setDescription("The value of the instance of the ifIndex object,\ndefined in IF-MIB, for the interface corresponding\nto this port.")
dot1dBasePortCircuit = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 3), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortCircuit.setDescription("For a port that (potentially) has the same value of\ndot1dBasePortIfIndex as another port on the same bridge.\nThis object contains the name of an object instance\nunique to this port.  For example, in the case where\nmultiple ports correspond one-to-one with multiple X.25\nvirtual circuits, this value might identify an (e.g.,\nthe first) object instance associated with the X.25\nvirtual circuit corresponding to this port.\n\nFor a port which has a unique value of\ndot1dBasePortIfIndex, this object can have the value\n{ 0 0 }.")
dot1dBasePortDelayExceededDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortDelayExceededDiscards.setDescription("The number of frames discarded by this port due\nto excessive transit delay through the bridge.  It\nis incremented by both transparent and source\nroute bridges.")
dot1dBasePortMtuExceededDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortMtuExceededDiscards.setDescription("The number of frames discarded by this port due\nto an excessive size.  It is incremented by both\ntransparent and source route bridges.")
dot1dStp = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 2))
dot1dStpProtocolSpecification = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("decLb100", 2), ("ieee8021d", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpProtocolSpecification.setDescription("An indication of what version of the Spanning Tree\nProtocol is being run.  The value 'decLb100(2)'\nindicates the DEC LANbridge 100 Spanning Tree protocol.\nIEEE 802.1D implementations will return 'ieee8021d(3)'.\nIf future versions of the IEEE Spanning Tree Protocol\nthat are incompatible with the current version\nare released a new value will be defined.")
dot1dStpPriority = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPriority.setDescription("The value of the write-able portion of the Bridge ID\n(i.e., the first two octets of the (8 octet long) Bridge\nID).  The other (last) 6 octets of the Bridge ID are\ngiven by the value of dot1dBaseBridgeAddress.\nOn bridges supporting IEEE 802.1t or IEEE 802.1w,\npermissible values are 0-61440, in steps of 4096.")
dot1dStpTimeSinceTopologyChange = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 3), TimeTicks()).setMaxAccess("readonly").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpTimeSinceTopologyChange.setDescription("The time (in hundredths of a second) since the\nlast time a topology change was detected by the\nbridge entity.\nFor RSTP, this reports the time since the tcWhile\ntimer for any port on this Bridge was nonzero.")
dot1dStpTopChanges = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpTopChanges.setDescription("The total number of topology changes detected by\nthis bridge since the management entity was last\nreset or initialized.")
dot1dStpDesignatedRoot = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 5), BridgeId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpDesignatedRoot.setDescription("The bridge identifier of the root of the spanning\ntree, as determined by the Spanning Tree Protocol,\nas executed by this node.  This value is used as\nthe Root Identifier parameter in all Configuration\nBridge PDUs originated by this node.")
dot1dStpRootCost = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpRootCost.setDescription("The cost of the path to the root as seen from\nthis bridge.")
dot1dStpRootPort = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpRootPort.setDescription("The port number of the port that offers the lowest\ncost path from this bridge to the root bridge.")
dot1dStpMaxAge = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 8), Timeout()).setMaxAccess("readonly").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpMaxAge.setDescription("The maximum age of Spanning Tree Protocol information\nlearned from the network on any port before it is\ndiscarded, in units of hundredths of a second.  This is\nthe actual value that this bridge is currently using.")
dot1dStpHelloTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 9), Timeout()).setMaxAccess("readonly").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpHelloTime.setDescription("The amount of time between the transmission of\nConfiguration bridge PDUs by this node on any port when\nit is the root of the spanning tree, or trying to become\nso, in units of hundredths of a second.  This is the\nactual value that this bridge is currently using.")
dot1dStpHoldTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 10), Integer32()).setMaxAccess("readonly").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpHoldTime.setDescription("This time value determines the interval length\nduring which no more than two Configuration bridge\nPDUs shall be transmitted by this node, in units\nof hundredths of a second.")
dot1dStpForwardDelay = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 11), Timeout()).setMaxAccess("readonly").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpForwardDelay.setDescription("This time value, measured in units of hundredths of a\nsecond, controls how fast a port changes its spanning\nstate when moving towards the Forwarding state.  The\nvalue determines how long the port stays in each of the\nListening and Learning states, which precede the\nForwarding state.  This value is also used when a\ntopology change has been detected and is underway, to\nage all dynamic entries in the Forwarding Database.\n[Note that this value is the one that this bridge is\ncurrently using, in contrast to\ndot1dStpBridgeForwardDelay, which is the value that this\nbridge and all others would start using if/when this\nbridge were to become the root.]")
dot1dStpBridgeMaxAge = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 12), Timeout().subtype(subtypeSpec=ValueRangeConstraint(600, 4000))).setMaxAccess("readwrite").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpBridgeMaxAge.setDescription("The value that all bridges use for MaxAge when this\nbridge is acting as the root.  Note that 802.1D-1998\nspecifies that the range for this parameter is related\nto the value of dot1dStpBridgeHelloTime.  The\ngranularity of this timer is specified by 802.1D-1998 to\nbe 1 second.  An agent may return a badValue error if a\nset is attempted to a value that is not a whole number\nof seconds.")
dot1dStpBridgeHelloTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 13), Timeout().subtype(subtypeSpec=ValueRangeConstraint(100, 1000))).setMaxAccess("readwrite").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpBridgeHelloTime.setDescription("The value that all bridges use for HelloTime when this\nbridge is acting as the root.  The granularity of this\ntimer is specified by 802.1D-1998 to be 1 second.  An\nagent may return a badValue error if a set is attempted\n\n\n\nto a value that is not a whole number of seconds.")
dot1dStpBridgeForwardDelay = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 14), Timeout().subtype(subtypeSpec=ValueRangeConstraint(400, 3000))).setMaxAccess("readwrite").setUnits("centi-seconds")
if mibBuilder.loadTexts: dot1dStpBridgeForwardDelay.setDescription("The value that all bridges use for ForwardDelay when\nthis bridge is acting as the root.  Note that\n802.1D-1998 specifies that the range for this parameter\nis related to the value of dot1dStpBridgeMaxAge.  The\ngranularity of this timer is specified by 802.1D-1998 to\nbe 1 second.  An agent may return a badValue error if a\nset is attempted to a value that is not a whole number\nof seconds.")
dot1dStpPortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 2, 15))
if mibBuilder.loadTexts: dot1dStpPortTable.setDescription("A table that contains port-specific information\nfor the Spanning Tree Protocol.")
dot1dStpPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 2, 15, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dStpPort"))
if mibBuilder.loadTexts: dot1dStpPortEntry.setDescription("A list of information maintained by every port about\nthe Spanning Tree Protocol state for that port.")
dot1dStpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPort.setDescription("The port number of the port for which this entry\ncontains Spanning Tree Protocol management information.")
dot1dStpPortPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortPriority.setDescription("The value of the priority field that is contained in\nthe first (in network byte order) octet of the (2 octet\nlong) Port ID.  The other octet of the Port ID is given\nby the value of dot1dStpPort.\nOn bridges supporting IEEE 802.1t or IEEE 802.1w,\npermissible values are 0-240, in steps of 16.")
dot1dStpPortState = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,6,4,5,2,)).subtype(namedValues=NamedValues(("disabled", 1), ("blocking", 2), ("listening", 3), ("learning", 4), ("forwarding", 5), ("broken", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortState.setDescription("The port's current state, as defined by application of\nthe Spanning Tree Protocol.  This state controls what\naction a port takes on reception of a frame.  If the\nbridge has detected a port that is malfunctioning, it\nwill place that port into the broken(6) state.  For\nports that are disabled (see dot1dStpPortEnable), this\nobject will have a value of disabled(1).")
dot1dStpPortEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortEnable.setDescription("The enabled/disabled status of the port.")
dot1dStpPortPathCost = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortPathCost.setDescription("The contribution of this port to the path cost of\npaths towards the spanning tree root which include\nthis port.  802.1D-1998 recommends that the default\nvalue of this parameter be in inverse proportion to\n\n\n\nthe speed of the attached LAN.\n\nNew implementations should support dot1dStpPortPathCost32.\nIf the port path costs exceeds the maximum value of this\nobject then this object should report the maximum value,\nnamely 65535.  Applications should try to read the\ndot1dStpPortPathCost32 object if this object reports\nthe maximum value.")
dot1dStpPortDesignatedRoot = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 6), BridgeId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedRoot.setDescription("The unique Bridge Identifier of the Bridge\nrecorded as the Root in the Configuration BPDUs\ntransmitted by the Designated Bridge for the\nsegment to which the port is attached.")
dot1dStpPortDesignatedCost = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedCost.setDescription("The path cost of the Designated Port of the segment\nconnected to this port.  This value is compared to the\nRoot Path Cost field in received bridge PDUs.")
dot1dStpPortDesignatedBridge = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 8), BridgeId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedBridge.setDescription("The Bridge Identifier of the bridge that this\nport considers to be the Designated Bridge for\nthis port's segment.")
dot1dStpPortDesignatedPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedPort.setDescription("The Port Identifier of the port on the Designated\nBridge for this port's segment.")
dot1dStpPortForwardTransitions = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortForwardTransitions.setDescription("The number of times this port has transitioned\nfrom the Learning state to the Forwarding state.")
dot1dStpPortPathCost32 = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 200000000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortPathCost32.setDescription("The contribution of this port to the path cost of\npaths towards the spanning tree root which include\nthis port.  802.1D-1998 recommends that the default\nvalue of this parameter be in inverse proportion to\nthe speed of the attached LAN.\n\nThis object replaces dot1dStpPortPathCost to support\nIEEE 802.1t.")
dot1dSr = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 3))
dot1dTp = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 4))
dot1dTpLearnedEntryDiscards = MibScalar((1, 3, 6, 1, 2, 1, 17, 4, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpLearnedEntryDiscards.setDescription("The total number of Forwarding Database entries that\nhave been or would have been learned, but have been\ndiscarded due to a lack of storage space in the\nForwarding Database.  If this counter is increasing, it\nindicates that the Forwarding Database is regularly\nbecoming full (a condition that has unpleasant\nperformance effects on the subnetwork).  If this counter\nhas a significant value but is not presently increasing,\nit indicates that the problem has been occurring but is\nnot persistent.")
dot1dTpAgingTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 4, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(10, 1000000))).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: dot1dTpAgingTime.setDescription("The timeout period in seconds for aging out\ndynamically-learned forwarding information.\n802.1D-1998 recommends a default of 300 seconds.")
dot1dTpFdbTable = MibTable((1, 3, 6, 1, 2, 1, 17, 4, 3))
if mibBuilder.loadTexts: dot1dTpFdbTable.setDescription("A table that contains information about unicast\nentries for which the bridge has forwarding and/or\nfiltering information.  This information is used\nby the transparent bridging function in\ndetermining how to propagate a received frame.")
dot1dTpFdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 4, 3, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dTpFdbAddress"))
if mibBuilder.loadTexts: dot1dTpFdbEntry.setDescription("Information about a specific unicast MAC address\nfor which the bridge has some forwarding and/or\nfiltering information.")
dot1dTpFdbAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 1), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpFdbAddress.setDescription("A unicast MAC address for which the bridge has\nforwarding and/or filtering information.")
dot1dTpFdbPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpFdbPort.setDescription("Either the value '0', or the port number of the port on\nwhich a frame having a source address equal to the value\nof the corresponding instance of dot1dTpFdbAddress has\nbeen seen.  A value of '0' indicates that the port\nnumber has not been learned, but that the bridge does\nhave some forwarding/filtering information about this\naddress (e.g., in the dot1dStaticTable).  Implementors\nare encouraged to assign the port value to this object\nwhenever it is learned, even for addresses for which the\ncorresponding value of dot1dTpFdbStatus is not\nlearned(3).")
dot1dTpFdbStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(4,2,1,5,3,)).subtype(namedValues=NamedValues(("other", 1), ("invalid", 2), ("learned", 3), ("self", 4), ("mgmt", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpFdbStatus.setDescription("The status of this entry.  The meanings of the\nvalues are:\n    other(1) - none of the following.  This would\n        include the case where some other MIB object\n        (not the corresponding instance of\n        dot1dTpFdbPort, nor an entry in the\n        dot1dStaticTable) is being used to determine if\n        and how frames addressed to the value of the\n        corresponding instance of dot1dTpFdbAddress are\n        being forwarded.\n    invalid(2) - this entry is no longer valid (e.g.,\n        it was learned but has since aged out), but has\n        not yet been flushed from the table.\n    learned(3) - the value of the corresponding instance\n        of dot1dTpFdbPort was learned, and is being\n        used.\n    self(4) - the value of the corresponding instance of\n        dot1dTpFdbAddress represents one of the bridge's\n        addresses.  The corresponding instance of\n        dot1dTpFdbPort indicates which of the bridge's\n        ports has this address.\n    mgmt(5) - the value of the corresponding instance of\n        dot1dTpFdbAddress is also the value of an\n        existing instance of dot1dStaticAddress.")
dot1dTpPortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 4, 4))
if mibBuilder.loadTexts: dot1dTpPortTable.setDescription("A table that contains information about every port that\nis associated with this transparent bridge.")
dot1dTpPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 4, 4, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dTpPort"))
if mibBuilder.loadTexts: dot1dTpPortEntry.setDescription("A list of information for each port of a transparent\nbridge.")
dot1dTpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPort.setDescription("The port number of the port for which this entry\ncontains Transparent bridging management information.")
dot1dTpPortMaxInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortMaxInfo.setDescription("The maximum size of the INFO (non-MAC) field that\n\n\n\nthis port will receive or transmit.")
dot1dTpPortInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortInFrames.setDescription("The number of frames that have been received by this\nport from its segment.  Note that a frame received on the\ninterface corresponding to this port is only counted by\nthis object if and only if it is for a protocol being\nprocessed by the local bridging function, including\nbridge management frames.")
dot1dTpPortOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortOutFrames.setDescription("The number of frames that have been transmitted by this\nport to its segment.  Note that a frame transmitted on\nthe interface corresponding to this port is only counted\nby this object if and only if it is for a protocol being\nprocessed by the local bridging function, including\nbridge management frames.")
dot1dTpPortInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortInDiscards.setDescription("Count of received valid frames that were discarded\n(i.e., filtered) by the Forwarding Process.")
dot1dStatic = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 5))
dot1dStaticTable = MibTable((1, 3, 6, 1, 2, 1, 17, 5, 1))
if mibBuilder.loadTexts: dot1dStaticTable.setDescription("A table containing filtering information configured\ninto the bridge by (local or network) management\nspecifying the set of ports to which frames received\nfrom specific ports and containing specific destination\naddresses are allowed to be forwarded.  The value of\nzero in this table, as the port number from which frames\nwith a specific destination address are received, is\nused to specify all ports for which there is no specific\nentry in this table for that particular destination\naddress.  Entries are valid for unicast and for\ngroup/broadcast addresses.")
dot1dStaticEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 5, 1, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dStaticAddress"), (0, "BRIDGE-MIB", "dot1dStaticReceivePort"))
if mibBuilder.loadTexts: dot1dStaticEntry.setDescription("Filtering information configured into the bridge by\n(local or network) management specifying the set of\nports to which frames received from a specific port and\ncontaining a specific destination address are allowed to\nbe forwarded.")
dot1dStaticAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 1), MacAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticAddress.setDescription("The destination MAC address in a frame to which this\nentry's filtering information applies.  This object can\ntake the value of a unicast address, a group address, or\nthe broadcast address.")
dot1dStaticReceivePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticReceivePort.setDescription("Either the value '0', or the port number of the port\nfrom which a frame must be received in order for this\nentry's filtering information to apply.  A value of zero\nindicates that this entry applies on all ports of the\nbridge for which there is no other applicable entry.")
dot1dStaticAllowedToGoTo = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 512))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticAllowedToGoTo.setDescription("The set of ports to which frames received from a\nspecific port and destined for a specific MAC address,\nare allowed to be forwarded.  Each octet within the\nvalue of this object specifies a set of eight ports,\nwith the first octet specifying ports 1 through 8, the\nsecond octet specifying ports 9 through 16, etc.  Within\neach octet, the most significant bit represents the\nlowest numbered port, and the least significant bit\nrepresents the highest numbered port.  Thus, each port\nof the bridge is represented by a single bit within the\nvalue of this object.  If that bit has a value of '1',\nthen that port is included in the set of ports; the port\nis not included if its bit has a value of '0'.  (Note\nthat the setting of the bit corresponding to the port\nfrom which a frame is received is irrelevant.)  The\ndefault value of this object is a string of ones of\nappropriate length.\n\n\n\n\nThe value of this object may exceed the required minimum\nmaximum message size of some SNMP transport (484 bytes,\nin the case of SNMP over UDP, see RFC 3417, section 3.2).\nSNMP engines on bridges supporting a large number of\nports must support appropriate maximum message sizes.")
dot1dStaticStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,5,1,4,)).subtype(namedValues=NamedValues(("other", 1), ("invalid", 2), ("permanent", 3), ("deleteOnReset", 4), ("deleteOnTimeout", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticStatus.setDescription("This object indicates the status of this entry.\nThe default value is permanent(3).\n    other(1) - this entry is currently in use but the\n        conditions under which it will remain so are\n        different from each of the following values.\n    invalid(2) - writing this value to the object\n        removes the corresponding entry.\n    permanent(3) - this entry is currently in use and\n        will remain so after the next reset of the\n        bridge.\n    deleteOnReset(4) - this entry is currently in use\n        and will remain so until the next reset of the\n        bridge.\n    deleteOnTimeout(5) - this entry is currently in use\n        and will remain so until it is aged out.")
dot1dConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 8))
dot1dGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 8, 1))
dot1dCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 8, 2))

# Augmentions

# Notifications

newRoot = NotificationType((1, 3, 6, 1, 2, 1, 17, 0, 1)).setObjects(*() )
if mibBuilder.loadTexts: newRoot.setDescription("The newRoot trap indicates that the sending agent has\nbecome the new root of the Spanning Tree; the trap is\nsent by a bridge soon after its election as the new\n\n\n\nroot, e.g., upon expiration of the Topology Change Timer,\nimmediately subsequent to its election.  Implementation\nof this trap is optional.")
topologyChange = NotificationType((1, 3, 6, 1, 2, 1, 17, 0, 2)).setObjects(*() )
if mibBuilder.loadTexts: topologyChange.setDescription("A topologyChange trap is sent by a bridge when any of\nits configured ports transitions from the Learning state\nto the Forwarding state, or from the Forwarding state to\nthe Blocking state.  The trap is not sent if a newRoot\ntrap is sent for the same transition.  Implementation of\nthis trap is optional.")

# Groups

dot1dBaseBridgeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 1)).setObjects(*(("BRIDGE-MIB", "dot1dBaseType"), ("BRIDGE-MIB", "dot1dBaseNumPorts"), ("BRIDGE-MIB", "dot1dBaseBridgeAddress"), ) )
if mibBuilder.loadTexts: dot1dBaseBridgeGroup.setDescription("Bridge level information for this device.")
dot1dBasePortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 2)).setObjects(*(("BRIDGE-MIB", "dot1dBasePortMtuExceededDiscards"), ("BRIDGE-MIB", "dot1dBasePortIfIndex"), ("BRIDGE-MIB", "dot1dBasePort"), ("BRIDGE-MIB", "dot1dBasePortDelayExceededDiscards"), ("BRIDGE-MIB", "dot1dBasePortCircuit"), ) )
if mibBuilder.loadTexts: dot1dBasePortGroup.setDescription("Information for each port on this device.")
dot1dStpBridgeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 3)).setObjects(*(("BRIDGE-MIB", "dot1dStpHoldTime"), ("BRIDGE-MIB", "dot1dStpForwardDelay"), ("BRIDGE-MIB", "dot1dStpRootPort"), ("BRIDGE-MIB", "dot1dStpTimeSinceTopologyChange"), ("BRIDGE-MIB", "dot1dStpTopChanges"), ("BRIDGE-MIB", "dot1dStpPriority"), ("BRIDGE-MIB", "dot1dStpDesignatedRoot"), ("BRIDGE-MIB", "dot1dStpBridgeHelloTime"), ("BRIDGE-MIB", "dot1dStpHelloTime"), ("BRIDGE-MIB", "dot1dStpBridgeMaxAge"), ("BRIDGE-MIB", "dot1dStpProtocolSpecification"), ("BRIDGE-MIB", "dot1dStpMaxAge"), ("BRIDGE-MIB", "dot1dStpBridgeForwardDelay"), ("BRIDGE-MIB", "dot1dStpRootCost"), ) )
if mibBuilder.loadTexts: dot1dStpBridgeGroup.setDescription("Bridge level Spanning Tree data for this device.")
dot1dStpPortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 4)).setObjects(*(("BRIDGE-MIB", "dot1dStpPortDesignatedRoot"), ("BRIDGE-MIB", "dot1dStpPortDesignatedCost"), ("BRIDGE-MIB", "dot1dStpPort"), ("BRIDGE-MIB", "dot1dStpPortDesignatedBridge"), ("BRIDGE-MIB", "dot1dStpPortPathCost"), ("BRIDGE-MIB", "dot1dStpPortPriority"), ("BRIDGE-MIB", "dot1dStpPortForwardTransitions"), ("BRIDGE-MIB", "dot1dStpPortDesignatedPort"), ("BRIDGE-MIB", "dot1dStpPortState"), ("BRIDGE-MIB", "dot1dStpPortEnable"), ) )
if mibBuilder.loadTexts: dot1dStpPortGroup.setDescription("Spanning Tree data for each port on this device.")
dot1dStpPortGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 5)).setObjects(*(("BRIDGE-MIB", "dot1dStpPortDesignatedRoot"), ("BRIDGE-MIB", "dot1dStpPortPathCost32"), ("BRIDGE-MIB", "dot1dStpPortDesignatedCost"), ("BRIDGE-MIB", "dot1dStpPort"), ("BRIDGE-MIB", "dot1dStpPortDesignatedBridge"), ("BRIDGE-MIB", "dot1dStpPortPriority"), ("BRIDGE-MIB", "dot1dStpPortForwardTransitions"), ("BRIDGE-MIB", "dot1dStpPortDesignatedPort"), ("BRIDGE-MIB", "dot1dStpPortState"), ("BRIDGE-MIB", "dot1dStpPortEnable"), ) )
if mibBuilder.loadTexts: dot1dStpPortGroup2.setDescription("Spanning Tree data for each port on this device.")
dot1dStpPortGroup3 = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 6)).setObjects(*(("BRIDGE-MIB", "dot1dStpPortPathCost32"), ) )
if mibBuilder.loadTexts: dot1dStpPortGroup3.setDescription("Spanning Tree data for devices supporting 32-bit\npath costs.")
dot1dTpBridgeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 7)).setObjects(*(("BRIDGE-MIB", "dot1dTpAgingTime"), ("BRIDGE-MIB", "dot1dTpLearnedEntryDiscards"), ) )
if mibBuilder.loadTexts: dot1dTpBridgeGroup.setDescription("Bridge level Transparent Bridging data.")
dot1dTpFdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 8)).setObjects(*(("BRIDGE-MIB", "dot1dTpFdbPort"), ("BRIDGE-MIB", "dot1dTpFdbStatus"), ("BRIDGE-MIB", "dot1dTpFdbAddress"), ) )
if mibBuilder.loadTexts: dot1dTpFdbGroup.setDescription("Filtering Database information for the Bridge.")
dot1dTpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 9)).setObjects(*(("BRIDGE-MIB", "dot1dTpPort"), ("BRIDGE-MIB", "dot1dTpPortInDiscards"), ("BRIDGE-MIB", "dot1dTpPortInFrames"), ("BRIDGE-MIB", "dot1dTpPortMaxInfo"), ("BRIDGE-MIB", "dot1dTpPortOutFrames"), ) )
if mibBuilder.loadTexts: dot1dTpGroup.setDescription("Dynamic Filtering Database information for each port of\nthe Bridge.")
dot1dStaticGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 10)).setObjects(*(("BRIDGE-MIB", "dot1dStaticAddress"), ("BRIDGE-MIB", "dot1dStaticReceivePort"), ("BRIDGE-MIB", "dot1dStaticAllowedToGoTo"), ("BRIDGE-MIB", "dot1dStaticStatus"), ) )
if mibBuilder.loadTexts: dot1dStaticGroup.setDescription("Static Filtering Database information for each port of\nthe Bridge.")
dot1dNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 11)).setObjects(*(("BRIDGE-MIB", "newRoot"), ("BRIDGE-MIB", "topologyChange"), ) )
if mibBuilder.loadTexts: dot1dNotificationGroup.setDescription("Group of objects describing notifications (traps).")

# Compliances

bridgeCompliance1493 = ModuleCompliance((1, 3, 6, 1, 2, 1, 17, 8, 2, 1)).setObjects(*(("BRIDGE-MIB", "dot1dTpBridgeGroup"), ("BRIDGE-MIB", "dot1dStpPortGroup"), ("BRIDGE-MIB", "dot1dTpGroup"), ("BRIDGE-MIB", "dot1dNotificationGroup"), ("BRIDGE-MIB", "dot1dStaticGroup"), ("BRIDGE-MIB", "dot1dStpBridgeGroup"), ("BRIDGE-MIB", "dot1dBasePortGroup"), ("BRIDGE-MIB", "dot1dTpFdbGroup"), ("BRIDGE-MIB", "dot1dBaseBridgeGroup"), ) )
if mibBuilder.loadTexts: bridgeCompliance1493.setDescription("The compliance statement for device support of bridging\nservices, as per RFC1493.")
bridgeCompliance4188 = ModuleCompliance((1, 3, 6, 1, 2, 1, 17, 8, 2, 2)).setObjects(*(("BRIDGE-MIB", "dot1dTpBridgeGroup"), ("BRIDGE-MIB", "dot1dTpFdbGroup"), ("BRIDGE-MIB", "dot1dStpPortGroup2"), ("BRIDGE-MIB", "dot1dTpGroup"), ("BRIDGE-MIB", "dot1dStaticGroup"), ("BRIDGE-MIB", "dot1dStpBridgeGroup"), ("BRIDGE-MIB", "dot1dStpPortGroup3"), ("BRIDGE-MIB", "dot1dBasePortGroup"), ("BRIDGE-MIB", "dot1dNotificationGroup"), ("BRIDGE-MIB", "dot1dBaseBridgeGroup"), ) )
if mibBuilder.loadTexts: bridgeCompliance4188.setDescription("The compliance statement for device support of bridging\nservices.  This supports 32-bit Path Cost values and the\nmore restricted bridge and port priorities, as per IEEE\n802.1t.\n\nFull support for the 802.1D management objects requires that\nthe SNMPv2-MIB [RFC3418] objects sysDescr, and sysUpTime, as\nwell as the IF-MIB [RFC2863] objects ifIndex, ifType,\nifDescr, ifPhysAddress, and ifLastChange are implemented.")

# Exports

# Module identity
mibBuilder.exportSymbols("BRIDGE-MIB", PYSNMP_MODULE_ID=dot1dBridge)

# Types
mibBuilder.exportSymbols("BRIDGE-MIB", BridgeId=BridgeId, Timeout=Timeout)

# Objects
mibBuilder.exportSymbols("BRIDGE-MIB", dot1dBridge=dot1dBridge, dot1dNotifications=dot1dNotifications, dot1dBase=dot1dBase, dot1dBaseBridgeAddress=dot1dBaseBridgeAddress, dot1dBaseNumPorts=dot1dBaseNumPorts, dot1dBaseType=dot1dBaseType, dot1dBasePortTable=dot1dBasePortTable, dot1dBasePortEntry=dot1dBasePortEntry, dot1dBasePort=dot1dBasePort, dot1dBasePortIfIndex=dot1dBasePortIfIndex, dot1dBasePortCircuit=dot1dBasePortCircuit, dot1dBasePortDelayExceededDiscards=dot1dBasePortDelayExceededDiscards, dot1dBasePortMtuExceededDiscards=dot1dBasePortMtuExceededDiscards, dot1dStp=dot1dStp, dot1dStpProtocolSpecification=dot1dStpProtocolSpecification, dot1dStpPriority=dot1dStpPriority, dot1dStpTimeSinceTopologyChange=dot1dStpTimeSinceTopologyChange, dot1dStpTopChanges=dot1dStpTopChanges, dot1dStpDesignatedRoot=dot1dStpDesignatedRoot, dot1dStpRootCost=dot1dStpRootCost, dot1dStpRootPort=dot1dStpRootPort, dot1dStpMaxAge=dot1dStpMaxAge, dot1dStpHelloTime=dot1dStpHelloTime, dot1dStpHoldTime=dot1dStpHoldTime, dot1dStpForwardDelay=dot1dStpForwardDelay, dot1dStpBridgeMaxAge=dot1dStpBridgeMaxAge, dot1dStpBridgeHelloTime=dot1dStpBridgeHelloTime, dot1dStpBridgeForwardDelay=dot1dStpBridgeForwardDelay, dot1dStpPortTable=dot1dStpPortTable, dot1dStpPortEntry=dot1dStpPortEntry, dot1dStpPort=dot1dStpPort, dot1dStpPortPriority=dot1dStpPortPriority, dot1dStpPortState=dot1dStpPortState, dot1dStpPortEnable=dot1dStpPortEnable, dot1dStpPortPathCost=dot1dStpPortPathCost, dot1dStpPortDesignatedRoot=dot1dStpPortDesignatedRoot, dot1dStpPortDesignatedCost=dot1dStpPortDesignatedCost, dot1dStpPortDesignatedBridge=dot1dStpPortDesignatedBridge, dot1dStpPortDesignatedPort=dot1dStpPortDesignatedPort, dot1dStpPortForwardTransitions=dot1dStpPortForwardTransitions, dot1dStpPortPathCost32=dot1dStpPortPathCost32, dot1dSr=dot1dSr, dot1dTp=dot1dTp, dot1dTpLearnedEntryDiscards=dot1dTpLearnedEntryDiscards, dot1dTpAgingTime=dot1dTpAgingTime, dot1dTpFdbTable=dot1dTpFdbTable, dot1dTpFdbEntry=dot1dTpFdbEntry, dot1dTpFdbAddress=dot1dTpFdbAddress, dot1dTpFdbPort=dot1dTpFdbPort, dot1dTpFdbStatus=dot1dTpFdbStatus, dot1dTpPortTable=dot1dTpPortTable, dot1dTpPortEntry=dot1dTpPortEntry, dot1dTpPort=dot1dTpPort, dot1dTpPortMaxInfo=dot1dTpPortMaxInfo, dot1dTpPortInFrames=dot1dTpPortInFrames, dot1dTpPortOutFrames=dot1dTpPortOutFrames, dot1dTpPortInDiscards=dot1dTpPortInDiscards, dot1dStatic=dot1dStatic, dot1dStaticTable=dot1dStaticTable, dot1dStaticEntry=dot1dStaticEntry, dot1dStaticAddress=dot1dStaticAddress, dot1dStaticReceivePort=dot1dStaticReceivePort, dot1dStaticAllowedToGoTo=dot1dStaticAllowedToGoTo, dot1dStaticStatus=dot1dStaticStatus, dot1dConformance=dot1dConformance, dot1dGroups=dot1dGroups, dot1dCompliances=dot1dCompliances)

# Notifications
mibBuilder.exportSymbols("BRIDGE-MIB", newRoot=newRoot, topologyChange=topologyChange)

# Groups
mibBuilder.exportSymbols("BRIDGE-MIB", dot1dBaseBridgeGroup=dot1dBaseBridgeGroup, dot1dBasePortGroup=dot1dBasePortGroup, dot1dStpBridgeGroup=dot1dStpBridgeGroup, dot1dStpPortGroup=dot1dStpPortGroup, dot1dStpPortGroup2=dot1dStpPortGroup2, dot1dStpPortGroup3=dot1dStpPortGroup3, dot1dTpBridgeGroup=dot1dTpBridgeGroup, dot1dTpFdbGroup=dot1dTpFdbGroup, dot1dTpGroup=dot1dTpGroup, dot1dStaticGroup=dot1dStaticGroup, dot1dNotificationGroup=dot1dNotificationGroup)

# Compliances
mibBuilder.exportSymbols("BRIDGE-MIB", bridgeCompliance1493=bridgeCompliance1493, bridgeCompliance4188=bridgeCompliance4188)
