/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.PlayingSpace;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PlayingSpaceWithParticipants
extends AbstractTextBlock
implements TextBlock {
    private final PlayingSpace playingSpace;
    private Dimension2D cacheDimension;
    private double ymin;
    private double ymax;

    public PlayingSpaceWithParticipants(PlayingSpace playingSpace) {
        this.playingSpace = Objects.requireNonNull(playingSpace);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.cacheDimension == null) {
            double width = this.playingSpace.getMaxX(stringBounder).getCurrentValue() - this.playingSpace.getMinX(stringBounder).getCurrentValue();
            int factor = this.playingSpace.isShowFootbox() ? 2 : 1;
            double height = this.playingSpace.getPreferredHeight(stringBounder) + (double)factor * this.playingSpace.getLivingSpaces().getHeadHeight(stringBounder);
            this.cacheDimension = new Dimension2DDouble(width, height);
        }
        return this.cacheDimension;
    }

    @Override
    public void drawU(UGraphic ug) {
        UClip clip;
        StringBounder stringBounder = ug.getStringBounder();
        SimpleContext2D context = new SimpleContext2D(false);
        double height = this.playingSpace.getPreferredHeight(stringBounder);
        LivingSpaces livingSpaces = this.playingSpace.getLivingSpaces();
        double headHeight = livingSpaces.getHeadHeight(stringBounder);
        if (this.ymax == 0.0) {
            this.playingSpace.drawBackground(ug.apply(UTranslate.dy(headHeight)));
        } else {
            clip = new UClip(-1000.0, this.ymin, Double.MAX_VALUE, this.ymax - this.ymin + 1.0);
            this.playingSpace.drawBackground(ug.apply(UTranslate.dy(headHeight)).apply(clip));
        }
        livingSpaces.drawLifeLines(ug.apply(UTranslate.dy(headHeight)), height, context);
        livingSpaces.drawHeads(ug, context, VerticalAlignment.BOTTOM);
        if (this.playingSpace.isShowFootbox()) {
            livingSpaces.drawHeads(ug.apply(UTranslate.dy(height + headHeight)), context, VerticalAlignment.TOP);
        }
        if (this.ymax == 0.0) {
            this.playingSpace.drawForeground(ug.apply(UTranslate.dy(headHeight)));
        } else {
            clip = new UClip(-1000.0, this.ymin, Double.MAX_VALUE, this.ymax - this.ymin + 1.0);
            this.playingSpace.drawForeground(ug.apply(UTranslate.dy(headHeight)).apply(clip));
        }
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.playingSpace.getMinX(stringBounder);
    }

    public int getNbPages() {
        return this.playingSpace.getNbPages();
    }

    public void setIndex(int index) {
        List<Double> yNewPages = this.playingSpace.yNewPages();
        this.ymin = yNewPages.get(index);
        this.ymax = yNewPages.get(index + 1);
    }

    private List<Double> yNewPages() {
        return this.playingSpace.yNewPages();
    }

    private void drawNewPages(UGraphic ug) {
        ug = ug.apply(HColorUtils.BLUE);
        for (Double change : this.yNewPages()) {
            if (change == 0.0 || change == Double.MAX_VALUE) continue;
            ug.apply(UTranslate.dy(change)).draw(ULine.hline(100.0));
        }
    }
}

