/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.nwdiag.legacy.NServerLegacy;
import net.sourceforge.plantuml.nwdiag.next.NBox;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NwGroup {
    public static final HColorSet colors = HColorSet.instance();
    private final Set<String> names = new HashSet<String>();
    private final String name;
    private HColor color;
    private String description;
    private NBox nbox;

    public final NBox getNbox(Map<String, NServerLegacy> servers) {
        if (this.nbox == null) {
            this.nbox = new NBox();
            for (Map.Entry<String, NServerLegacy> ent : servers.entrySet()) {
                if (!this.names.contains(ent.getKey())) continue;
                this.nbox.add(ent.getValue().getBar());
            }
        }
        return this.nbox;
    }

    public void addName(String name) {
        this.names.add(name);
    }

    public String toString() {
        return this.name;
    }

    public NwGroup(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final HColor getColor() {
        return this.color;
    }

    public final void setColor(HColor color) {
        this.color = color;
    }

    public final void setDescription(String value) {
        this.description = value;
    }

    public final FontConfiguration getGroupDescriptionFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    protected final String getDescription() {
        return this.description;
    }

    public final Set<String> names() {
        return Collections.unmodifiableSet(this.names);
    }
}

