.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_SELECT" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_select \- loop over the result of a query

.SH SYNOPSIS

.nf
pg_select [\fI-rowbyrow\fR] [\fI-nodotfields\fR] [\fI-withoutnulls\fR] [\fI-paramarray var\fR] [\fI-variables\fR] [\fI-params\fR paramList] [\fI-count\fR countVar] \fIconn\fR \fIcommandString\fR \fIarrayVar\fR \fIprocedure\fR
.fi
.SH "DESCRIPTION"
.PP
\fBpg_select\fR submits a query
(\fBSELECT\fR statement) to the
PostgreSQL server and executes a given
chunk of code for each row in the result.  The
\fIcommandString\fR must be a
\fBSELECT\fR statement; anything else returns an
error.  The \fIarrayVar\fR variable is an array
name used in the loop.  For each row,
\fIarrayVar\fR is filled in with the row values,
using the column names as the array indices.  Then the
\fIprocedure\fR is executed.
.PP
In addition to the column values, the following special entries are
made in the array (unless the [-nodotfields] flag is provided):
.TP
\fB\&.headers\fR
A list of the column names returned by the query.
.TP
\fB\&.numcols\fR
The number of columns returned by the query.
.TP
\fB\&.tupno\fR
The current row number, starting at zero and incrementing for
each iteration of the loop body.
.PP
If the [-param] flag is provided, then it contains a list of parameters that will replace "$1", "$2" and so
on in the query string, as if it were a prepared statement. Be sure to properly escape or quote the "$" in the query. :)
.PP
If the [-paramarray] flag is provided, then a substitution is performed on the query, securely replacing
each back-quote delimited name with the corresponding entry from the named array. If the array does not contain the named element,
then NULL is substituted (similarly to the way an array created by -withoutnulls is generated).
Each such name must occur in a location where a value or field name could appear.
.PP
If the [-variables] flag is provided, then embedded Tcl variables are passed as parameters. Variables can be flagged with ':' and array references and namespaces are supported. Complex variable names can usually be embedded with :{nasty-name-here} though no attempt at duplicating Tcl brace-escaping is made.
If the variable does not exist, then NULL is substituted.
.PP
Notes: This substitution is performed by generating a positional parameter list and calling PQExecParams with a modified query containing
$1, $2, ... where the original `names` appeared. This is a straight substitution, so if this mechanism is used the back-quote
character (`) can not appear elsewhere in the query, even in a quoted string. There are a maximum of 99,999 names.
.SH "ARGUMENTS"
.TP
\fB[-params list]\fR
Perform parameter substitution using PQexecParams or PQSendQueryParams.
.TP
\fB[-paramarray arrayname]\fR
Perform parameter substitution via `quoted` elements of the array using PQexecParams or PQSendQueryParams.
.TP
\fB[-variables]\fR
Substitute Tcl variables found in the SQL string using PQexecParams or PQSendQueryParams.
.TP
\fB[-rowbyrow]\fR
Perform the select in row-by-row mode. This means that the code block is called immediately results
become available, rather than waiting for the query to complete. 
.TP
\fB[-nodotfields]\fR
Suppress generation of the pseudo-fields .headers, .numcols, and .tupno.
.TP
\fB[-withoutnulls]\fR
If specified null columns will be unset from the array rather than being defined and containing the null string, typically an empty string.
.TP
\fB[-count countVar]\fR
Set the variable "countVar" to the number of tuples returned for use in the block.
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to execute the query.
.TP
\fB\fIcommandString\fB\fR
The SQL query to execute.
.TP
\fB\fIarrayVar\fB\fR
An array variable for returned rows.
.TP
\fB\fIprocedure\fB\fR
The procedure to run for each returned row.
.SH "RETURN VALUE"
.PP
Number of rows actually processed.
.SH "EXAMPLES"
.PP
This examples assumes that the table \fBtable1\fR has
columns \fBcontrol\fR and \fBname\fR (and
perhaps others):

.nf
pg_select $pgconn "SELECT * FROM table1;" array {
    puts [format "%5d %s" $array(control) $array(name)]
}
.fi
.PP
This example demonstrates how to use named parameters to securely perform queries on an SQL database:

.nf
# An array imported from some hive of scum and villainy like a web form.
set form(first) {Andrew'); DROP TABLE students;--}
set form(last) {Randall}

# Secure extraction of data
pg_select -paramarray form $pgconn "SELECT * from students WHERE firstname = `first` AND lastname = `last`;" row {
    lappend candidates $row(student_id) $row(firstname) $row(lastname) $row(age)
}
.fi
