message(STATUS "Build external project ipp-crypto")

set(IPP_CRYPTO_URL https://github.com/intel/ipp-crypto.git)
set(IPP_CRYPTO_TAG "ippcp_2021.5")
set(IPP_CRYPTO_PREFIX ipp_crypto)
set(IPP_CRYPTO_ARCH intel64)
set(IPP_CRYPTO_CONFIG_TYPE RELEASE)
set(IPP_CRYPTO_SOURCE_DIR ${CMAKE_CURRENT_BINARY_DIR}/_deps/${IPP_CRYPTO_PREFIX}-src)
set(IPP_CRYPTO_BIN_DIR ${CMAKE_CURRENT_BINARY_DIR}/_deps/${IPP_CRYPTO_PREFIX}-build)
set(IPP_CRYPTO_INCLUDE_DIR ${CMAKE_CURRENT_BINARY_DIR}/_deps/${IPP_CRYPTO_PREFIX}-src/include)

set(IPP_CRYPTO_CONFIGURE_ARGS -DCMAKE_BUILD_TYPE=${IPP_CRYPTO_CONFIG_TYPE} -DCMAKE_INSTALL_PREFIX=${IPP_CRYPTO_BIN_DIR}/bin)
if (WIN32)
  set(IPP_CRYPTO_ARCH ${CMAKE_GENERATOR_PLATFORM})
  list(APPEND IPP_CRYPTO_CONFIGURE_ARGS -A${CMAKE_GENERATOR_PLATFORM})
else()
  list(APPEND IPP_CRYPTO_CONFIGURE_ARGS -DARCH=${IPP_CRYPTO_ARCH})
endif()

set(IPP_CRYPTO_BUILD_COMMAND)
if (WIN32)
  set(IPP_CRYPTO_BUILD_COMMAND ${CMAKE_COMMAND} --build . --parallel 4 --target ALL_BUILD --config ${IPP_CRYPTO_CONFIG_TYPE})
else()
  set(IPP_CRYPTO_BUILD_COMMAND make all)
endif()

include(ExternalProject)
ExternalProject_Add(ippcp
  PREFIX ${IPP_CRYPTO_PREFIX}
  GIT_REPOSITORY ${IPP_CRYPTO_URL}
  GIT_TAG ${IPP_CRYPTO_TAG}
  SOURCE_DIR ${IPP_CRYPTO_SOURCE_DIR}
  BINARY_DIR ${IPP_CRYPTO_BIN_DIR}
  CONFIGURE_COMMAND ${CMAKE_COMMAND} ${IPP_CRYPTO_CONFIGURE_ARGS} ${IPP_CRYPTO_SOURCE_DIR}
  BUILD_COMMAND ${IPP_CRYPTO_BUILD_COMMAND}
  INSTALL_COMMAND ""
)

set(IPP_CRYPTO_LIB_DIR ${IPP_CRYPTO_BIN_DIR}/.build/${IPP_CRYPTO_CONFIG_TYPE}/lib)
add_library(ippcp_s SHARED IMPORTED)
set_target_properties(ippcp_s PROPERTIES
     MAP_IMPORTED_CONFIG_RELEASE ${IPP_CRYPTO_CONFIG_TYPE}
     MAP_IMPORTED_CONFIG_DEBUG ${IPP_CRYPTO_CONFIG_TYPE}
     MAP_IMPORTED_CONFIG_RELWITHDEBUGINFO ${IPP_CRYPTO_CONFIG_TYPE}
     MAP_IMPORTED_CONFIG_MINSIZEREL ${IPP_CRYPTO_CONFIG_TYPE}
)
if (WIN32)
  set_target_properties(ippcp_s PROPERTIES
    IMPORTED_IMPLIB "${IPP_CRYPTO_LIB_DIR}/ippcp.lib"
    IMPORTED_LOCATION "${IPP_CRYPTO_LIB_DIR}/ippcp.dll"
    IMPORTED_IMPLIB_${IPP_CRYPTO_CONFIG_TYPE} "${IPP_CRYPTO_LIB_DIR}/ippcp.lib"
    IMPORTED_LOCATION_${IPP_CRYPTO_CONFIG_TYPE} "${IPP_CRYPTO_LIB_DIR}/ippcp.dll"
  )
else()
  set(IPP_CRYPTO_LIB_PATH "${IPP_CRYPTO_LIB_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}ippcp${CMAKE_SHARED_LIBRARY_SUFFIX}")
  set_target_properties(ippcp_s PROPERTIES
    IMPORTED_LOCATION ${IPP_CRYPTO_LIB_PATH}
    IMPORTED_LOCATION_${IPP_CRYPTO_CONFIG_TYPE} ${IPP_CRYPTO_LIB_PATH}
  )
endif()
add_dependencies(ippcp_s ippcp)
