import os
from setuptools import setup, find_packages
from distutils.sysconfig import get_config_vars

def file_contents(fp):
    fd = open(fp, 'r')
    content = fd.read()
    fd.close()
    return content

def get_nagios_plugin_dir():
    exec_prefix, libdir = get_config_vars('exec_prefix', 'LIBDIR')
    if libdir.startswith(exec_prefix + '/'):
        libdir = libdir[len(exec_prefix)+1:]
    return os.path.join(libdir, 'nagios/plugins')

setup(
    name = "nordugrid-arc-nagios-plugins",
    version = file_contents('VERSION').strip(),
    description = 'Nagios Probes for Arc CEs',
    url = 'http://www.nordugrid.org/',
    author = 'Petter Urkedal',
    author_email = 'urkedal@nbi.dk',

    requires = ['cryptography', 'ldap3'],
    packages = find_packages(),

    data_files = [
        (get_nagios_plugin_dir(), [
            'plugins/check_arcce_clean',
            'plugins/check_arcce_monitor',
            'plugins/check_arcce_submit',
            'plugins/check_aris',
            'plugins/check_egiis',
            'plugins/check_arcservice',
            'plugins/check_gridstorage',
        ]),
        ('/etc/arc/nagios', ['config/20-dist.ini']),
        ('/etc/arc/nagios/20-dist.d', ['config/20-dist.d/default.xrsl.j2']),
        ('/etc/arc/nagios', ['config/60-egi.ini']),
        ('/etc/arc/nagios/60-egi.d', ['config/60-egi.d/arcce_igtf.py']),
    ],
)
