/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Chi-squared distribution excess kurtosis.
*
* @module @stdlib/stats/base/dists/chisquare/kurtosis
*
* @example
* var kurtosis = require( '@stdlib/stats/base/dists/chisquare/kurtosis' );
*
* var v = kurtosis( 11.0 );
* // returns ~1.091
*
* v = kurtosis( 1.5 );
* // returns 8.0
*/

// MODULES //

var kurtosis = require( './kurtosis.js' );


// EXPORTS //

module.exports = kurtosis;
