/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Fifteen observations of the vertical semidiameter of Venus, made by Lieutenant Herndon, with the meridian circle at Washington, in the year 1846.
*
* @module @stdlib/datasets/herndon-venus-semidiameters
*
* @example
* var data = require( '@stdlib/datasets/herndon-venus-semidiameters' );
*
* var d = data();
* // returns [ -0.30, -0.44, ..., 0.39, 0.10 ]
*/

// MODULES //

var data = require( './main.js' );


// EXPORTS //

module.exports = data;
