/*
 * nheko Copyright (C) 2017  Konstantinos Sideris <siderisk@auth.gr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "emoji/Provider.h"

using namespace emoji;

const std::vector<Emoji> emoji::Provider::people = {
  // People
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x80"), "grinning face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x83"),
        "grinning face with big eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x84"),
        "grinning face with smiling eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x81"),
        "beaming face with smiling eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x86"),
        "grinning squinting face",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x85"),
        "grinning face with sweat",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa3"),
        "rolling on the floor laughing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x82"),
        "face with tears of joy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x82"),
        "slightly smiling face",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x83"), "upside-down face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x89"), "winking face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x8a"),
        "smiling face with smiling eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x87"),
        "smiling face with halo",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb0"),
        "smiling face with hearts",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x8d"),
        "smiling face with heart-eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa9"), "star-struck", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x98"), "face blowing a kiss", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x97"), "kissing face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\xba"), "smiling face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x9a"),
        "kissing face with closed eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x99"),
        "kissing face with smiling eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb2"),
        "smiling face with tear",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x8b"), "face savoring food", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x9b"), "face with tongue", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x9c"),
        "winking face with tongue",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xaa"), "zany face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x9d"),
        "squinting face with tongue",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x91"), "money-mouth face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x97"), "hugging face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xad"),
        "face with hand over mouth",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xab"), "shushing face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x94"), "thinking face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x90"), "zipper-mouth face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa8"),
        "face with raised eyebrow",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x90"), "neutral face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x91"), "expressionless face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb6"), "face without mouth", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x8f"), "smirking face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x92"), "unamused face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x84"),
        "face with rolling eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xac"), "grimacing face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa5"), "lying face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x8c"), "relieved face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x94"), "pensive face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xaa"), "sleepy face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa4"), "drooling face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb4"), "sleeping face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb7"),
        "face with medical mask",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x92"),
        "face with thermometer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x95"),
        "face with head-bandage",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa2"), "nauseated face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xae"), "face vomiting", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa7"), "sneezing face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb5"), "hot face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb6"), "cold face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb4"), "woozy face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb5"), "dizzy face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xaf"), "exploding head", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa0"), "cowboy hat face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb3"), "partying face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb8"), "disguised face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x8e"),
        "smiling face with sunglasses",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x93"), "nerd face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x90"), "face with monocle", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x95"), "confused face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x9f"), "worried face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x81"),
        "slightly frowning face",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\xb9"), "frowning face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xae"),
        "face with open mouth",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xaf"), "hushed face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb2"), "astonished face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb3"), "flushed face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xba"), "pleading face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa6"),
        "frowning face with open mouth",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa7"), "anguished face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa8"), "fearful face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb0"),
        "anxious face with sweat",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa5"),
        "sad but relieved face",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa2"), "crying face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xad"), "loudly crying face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb1"),
        "face screaming in fear",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x96"), "confounded face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa3"), "persevering face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x9e"), "disappointed face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x93"),
        "downcast face with sweat",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa9"), "weary face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xab"), "tired face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb1"), "yawning face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa4"),
        "face with steam from nose",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa1"), "pouting face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xa0"), "angry face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xac"),
        "face with symbols on mouth",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\x88"),
        "smiling face with horns",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbf"),
        "angry face with horns",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x80"), "skull", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\xa0"), "skull and crossbones", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa9"), "pile of poo", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa1"), "clown face", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb9"), "ogre", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xba"), "goblin", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbb"), "ghost", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbd"), "alien", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbe"), "alien monster", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x96"), "robot", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xba"), "grinning cat", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb8"),
        "grinning cat with smiling eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xb9"),
        "cat with tears of joy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xbb"),
        "smiling cat with heart-eyes",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xbc"), "cat with wry smile", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xbd"), "kissing cat", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x80"), "weary cat", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xbf"), "crying cat", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x98\xbe"), "pouting cat", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x88"), "see-no-evil monkey", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x89"), "hear-no-evil monkey", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8a"),
        "speak-no-evil monkey",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x8b"), "kiss mark", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x8c"), "love letter", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x98"), "heart with arrow", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x9d"), "heart with ribbon", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x96"), "sparkling heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x97"), "growing heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x93"), "beating heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x9e"), "revolving hearts", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x95"), "two hearts", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x9f"), "heart decoration", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9d\xa3"), "heart exclamation", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x94"), "broken heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9d\xa4"), "red heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa1"), "orange heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x9b"), "yellow heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x9a"), "green heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x99"), "blue heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x9c"), "purple heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8e"), "brown heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\xa4"), "black heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8d"), "white heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xaf"), "hundred points", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa2"), "anger symbol", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa5"), "collision", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xab"), "dizzy", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa6"), "sweat droplets", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa8"), "dashing away", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb3"), "hole", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa3"), "bomb", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xac"), "speech balloon", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x81\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x97\xa8"),
        "eye in speech bubble",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x81\xe2\x80\x8d\xf0\x9f\x97\xa8"),
        "eye in speech bubble",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xa8"), "left speech bubble", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xaf"), "right anger bubble", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xad"), "thought balloon", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa4"), "zzz", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8b"), "waving hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbb"),
        "waving hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbc"),
        "waving hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbd"),
        "waving hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbe"),
        "waving hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbf"),
        "waving hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9a"), "raised back of hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbb"),
        "raised back of hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbc"),
        "raised back of hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbd"),
        "raised back of hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbe"),
        "raised back of hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbf"),
        "raised back of hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x90"),
        "hand with fingers splayed",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x90\xf0\x9f\x8f\xbb"),
        "hand with fingers splayed: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x90\xf0\x9f\x8f\xbc"),
        "hand with fingers splayed: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x90\xf0\x9f\x8f\xbd"),
        "hand with fingers splayed: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x90\xf0\x9f\x8f\xbe"),
        "hand with fingers splayed: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x90\xf0\x9f\x8f\xbf"),
        "hand with fingers splayed: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8b"), "raised hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8b\xf0\x9f\x8f\xbb"),
        "raised hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8b\xf0\x9f\x8f\xbc"),
        "raised hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8b\xf0\x9f\x8f\xbd"),
        "raised hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8b\xf0\x9f\x8f\xbe"),
        "raised hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8b\xf0\x9f\x8f\xbf"),
        "raised hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x96"), "vulcan salute", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x96\xf0\x9f\x8f\xbb"),
        "vulcan salute: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x96\xf0\x9f\x8f\xbc"),
        "vulcan salute: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x96\xf0\x9f\x8f\xbd"),
        "vulcan salute: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x96\xf0\x9f\x8f\xbe"),
        "vulcan salute: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x96\xf0\x9f\x8f\xbf"),
        "vulcan salute: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8c"), "OK hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbb"),
        "OK hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbc"),
        "OK hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbd"),
        "OK hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbe"),
        "OK hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbf"),
        "OK hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8c"), "pinched fingers", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8c\xf0\x9f\x8f\xbb"),
        "pinched fingers: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8c\xf0\x9f\x8f\xbc"),
        "pinched fingers: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8c\xf0\x9f\x8f\xbd"),
        "pinched fingers: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8c\xf0\x9f\x8f\xbe"),
        "pinched fingers: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8c\xf0\x9f\x8f\xbf"),
        "pinched fingers: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8f"), "pinching hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8f\xf0\x9f\x8f\xbb"),
        "pinching hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8f\xf0\x9f\x8f\xbc"),
        "pinching hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8f\xf0\x9f\x8f\xbd"),
        "pinching hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8f\xf0\x9f\x8f\xbe"),
        "pinching hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x8f\xf0\x9f\x8f\xbf"),
        "pinching hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8c"), "victory hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8c\xf0\x9f\x8f\xbb"),
        "victory hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8c\xf0\x9f\x8f\xbc"),
        "victory hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8c\xf0\x9f\x8f\xbd"),
        "victory hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8c\xf0\x9f\x8f\xbe"),
        "victory hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8c\xf0\x9f\x8f\xbf"),
        "victory hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9e"), "crossed fingers", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbb"),
        "crossed fingers: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbc"),
        "crossed fingers: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbd"),
        "crossed fingers: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbe"),
        "crossed fingers: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbf"),
        "crossed fingers: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9f"), "love-you gesture", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbb"),
        "love-you gesture: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbc"),
        "love-you gesture: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbd"),
        "love-you gesture: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbe"),
        "love-you gesture: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbf"),
        "love-you gesture: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x98"), "sign of the horns", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbb"),
        "sign of the horns: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbc"),
        "sign of the horns: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbd"),
        "sign of the horns: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbe"),
        "sign of the horns: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbf"),
        "sign of the horns: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x99"), "call me hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbb"),
        "call me hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbc"),
        "call me hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbd"),
        "call me hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbe"),
        "call me hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbf"),
        "call me hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x88"),
        "backhand index pointing left",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x88\xf0\x9f\x8f\xbb"),
        "backhand index pointing left: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x88\xf0\x9f\x8f\xbc"),
        "backhand index pointing left: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x88\xf0\x9f\x8f\xbd"),
        "backhand index pointing left: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x88\xf0\x9f\x8f\xbe"),
        "backhand index pointing left: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x88\xf0\x9f\x8f\xbf"),
        "backhand index pointing left: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x89"),
        "backhand index pointing right",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x89\xf0\x9f\x8f\xbb"),
        "backhand index pointing right: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x89\xf0\x9f\x8f\xbc"),
        "backhand index pointing right: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x89\xf0\x9f\x8f\xbd"),
        "backhand index pointing right: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x89\xf0\x9f\x8f\xbe"),
        "backhand index pointing right: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x89\xf0\x9f\x8f\xbf"),
        "backhand index pointing right: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x86"),
        "backhand index pointing up",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x86\xf0\x9f\x8f\xbb"),
        "backhand index pointing up: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x86\xf0\x9f\x8f\xbc"),
        "backhand index pointing up: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x86\xf0\x9f\x8f\xbd"),
        "backhand index pointing up: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x86\xf0\x9f\x8f\xbe"),
        "backhand index pointing up: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x86\xf0\x9f\x8f\xbf"),
        "backhand index pointing up: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x95"), "middle finger", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x95\xf0\x9f\x8f\xbb"),
        "middle finger: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x95\xf0\x9f\x8f\xbc"),
        "middle finger: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x95\xf0\x9f\x8f\xbd"),
        "middle finger: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x95\xf0\x9f\x8f\xbe"),
        "middle finger: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x95\xf0\x9f\x8f\xbf"),
        "middle finger: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x87"),
        "backhand index pointing down",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x87\xf0\x9f\x8f\xbb"),
        "backhand index pointing down: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x87\xf0\x9f\x8f\xbc"),
        "backhand index pointing down: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x87\xf0\x9f\x8f\xbd"),
        "backhand index pointing down: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x87\xf0\x9f\x8f\xbe"),
        "backhand index pointing down: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x87\xf0\x9f\x8f\xbf"),
        "backhand index pointing down: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\x9d"), "index pointing up", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\x9d\xf0\x9f\x8f\xbb"),
        "index pointing up: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\x9d\xf0\x9f\x8f\xbc"),
        "index pointing up: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\x9d\xf0\x9f\x8f\xbd"),
        "index pointing up: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\x9d\xf0\x9f\x8f\xbe"),
        "index pointing up: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x98\x9d\xf0\x9f\x8f\xbf"),
        "index pointing up: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8d"), "thumbs up", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbb"),
        "thumbs up: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbc"),
        "thumbs up: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbd"),
        "thumbs up: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbe"),
        "thumbs up: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbf"),
        "thumbs up: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8e"), "thumbs down", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbb"),
        "thumbs down: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbc"),
        "thumbs down: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbd"),
        "thumbs down: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbe"),
        "thumbs down: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbf"),
        "thumbs down: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8a"), "raised fist", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8a\xf0\x9f\x8f\xbb"),
        "raised fist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8a\xf0\x9f\x8f\xbc"),
        "raised fist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8a\xf0\x9f\x8f\xbd"),
        "raised fist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8a\xf0\x9f\x8f\xbe"),
        "raised fist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8a\xf0\x9f\x8f\xbf"),
        "raised fist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8a"), "oncoming fist", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbb"),
        "oncoming fist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbc"),
        "oncoming fist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbd"),
        "oncoming fist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbe"),
        "oncoming fist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbf"),
        "oncoming fist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9b"), "left-facing fist", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbb"),
        "left-facing fist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbc"),
        "left-facing fist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbd"),
        "left-facing fist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbe"),
        "left-facing fist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbf"),
        "left-facing fist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9c"), "right-facing fist", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbb"),
        "right-facing fist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbc"),
        "right-facing fist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbd"),
        "right-facing fist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbe"),
        "right-facing fist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbf"),
        "right-facing fist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8f"), "clapping hands", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbb"),
        "clapping hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbc"),
        "clapping hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbd"),
        "clapping hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbe"),
        "clapping hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbf"),
        "clapping hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8c"), "raising hands", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbb"),
        "raising hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbc"),
        "raising hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbd"),
        "raising hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbe"),
        "raising hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbf"),
        "raising hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x90"), "open hands", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x90\xf0\x9f\x8f\xbb"),
        "open hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x90\xf0\x9f\x8f\xbc"),
        "open hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x90\xf0\x9f\x8f\xbd"),
        "open hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x90\xf0\x9f\x8f\xbe"),
        "open hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x90\xf0\x9f\x8f\xbf"),
        "open hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb2"), "palms up together", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbb"),
        "palms up together: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbc"),
        "palms up together: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbd"),
        "palms up together: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbe"),
        "palms up together: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbf"),
        "palms up together: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\x9d"), "handshake", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8f"), "folded hands", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbb"),
        "folded hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbc"),
        "folded hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbd"),
        "folded hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbe"),
        "folded hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbf"),
        "folded hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8d"), "writing hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8d\xf0\x9f\x8f\xbb"),
        "writing hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8d\xf0\x9f\x8f\xbc"),
        "writing hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8d\xf0\x9f\x8f\xbd"),
        "writing hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8d\xf0\x9f\x8f\xbe"),
        "writing hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9c\x8d\xf0\x9f\x8f\xbf"),
        "writing hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x85"), "nail polish", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x85\xf0\x9f\x8f\xbb"),
        "nail polish: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x85\xf0\x9f\x8f\xbc"),
        "nail polish: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x85\xf0\x9f\x8f\xbd"),
        "nail polish: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x85\xf0\x9f\x8f\xbe"),
        "nail polish: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x85\xf0\x9f\x8f\xbf"),
        "nail polish: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb3"), "selfie", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbb"),
        "selfie: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbc"),
        "selfie: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbd"),
        "selfie: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbe"),
        "selfie: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbf"),
        "selfie: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xaa"), "flexed biceps", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbb"),
        "flexed biceps: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbc"),
        "flexed biceps: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbd"),
        "flexed biceps: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbe"),
        "flexed biceps: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbf"),
        "flexed biceps: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbe"), "mechanical arm", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbf"), "mechanical leg", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb5"), "leg", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb5\xf0\x9f\x8f\xbb"),
        "leg: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb5\xf0\x9f\x8f\xbc"),
        "leg: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb5\xf0\x9f\x8f\xbd"),
        "leg: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb5\xf0\x9f\x8f\xbe"),
        "leg: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb5\xf0\x9f\x8f\xbf"),
        "leg: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb6"), "foot", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb6\xf0\x9f\x8f\xbb"),
        "foot: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb6\xf0\x9f\x8f\xbc"),
        "foot: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb6\xf0\x9f\x8f\xbd"),
        "foot: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb6\xf0\x9f\x8f\xbe"),
        "foot: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb6\xf0\x9f\x8f\xbf"),
        "foot: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x82"), "ear", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x82\xf0\x9f\x8f\xbb"),
        "ear: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x82\xf0\x9f\x8f\xbc"),
        "ear: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x82\xf0\x9f\x8f\xbd"),
        "ear: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x82\xf0\x9f\x8f\xbe"),
        "ear: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x82\xf0\x9f\x8f\xbf"),
        "ear: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbb"),
        "ear with hearing aid",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbb\xf0\x9f\x8f\xbb"),
        "ear with hearing aid: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbb\xf0\x9f\x8f\xbc"),
        "ear with hearing aid: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbb\xf0\x9f\x8f\xbd"),
        "ear with hearing aid: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbb\xf0\x9f\x8f\xbe"),
        "ear with hearing aid: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbb\xf0\x9f\x8f\xbf"),
        "ear with hearing aid: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x83"), "nose", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x83\xf0\x9f\x8f\xbb"),
        "nose: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x83\xf0\x9f\x8f\xbc"),
        "nose: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x83\xf0\x9f\x8f\xbd"),
        "nose: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x83\xf0\x9f\x8f\xbe"),
        "nose: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x83\xf0\x9f\x8f\xbf"),
        "nose: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa0"), "brain", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x80"), "anatomical heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x81"), "lungs", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb7"), "tooth", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb4"), "bone", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x80"), "eyes", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x81"), "eye", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x85"), "tongue", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x84"), "mouth", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb6"), "baby", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbb"),
        "baby: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbc"),
        "baby: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbd"),
        "baby: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbe"),
        "baby: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbf"),
        "baby: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x92"), "child", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbb"),
        "child: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbc"),
        "child: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbd"),
        "child: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbe"),
        "child: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbf"),
        "child: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa6"), "boy", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbb"),
        "boy: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbc"),
        "boy: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbd"),
        "boy: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbe"),
        "boy: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbf"),
        "boy: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa7"), "girl", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbb"),
        "girl: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbc"),
        "girl: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbd"),
        "girl: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbe"),
        "girl: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbf"),
        "girl: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91"), "person", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb"),
        "person: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc"),
        "person: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd"),
        "person: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe"),
        "person: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf"),
        "person: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1"), "person: blond hair", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb"),
        "person: light skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc"),
        "person: medium-light skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd"),
        "person: medium skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe"),
        "person: medium-dark skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf"),
        "person: dark skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8"), "man", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "man: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "man: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "man: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "man: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "man: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x94"), "man: beard", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbb"),
        "man: light skin tone, beard",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbc"),
        "man: medium-light skin tone, beard",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbd"),
        "man: medium skin tone, beard",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbe"),
        "man: medium-dark skin tone, beard",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbf"),
        "man: dark skin tone, beard",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "man: red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "man: light skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "man: medium-light skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "man: medium skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "man: medium-dark skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "man: dark skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "man: curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "man: light skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "man: medium-light skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "man: medium skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "man: medium-dark skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "man: dark skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "man: white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "man: light skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "man: medium-light skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "man: medium skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "man: medium-dark skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "man: dark skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "man: bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "man: light skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "man: medium-light skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "man: medium skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "man: medium-dark skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "man: dark skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9"), "woman", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb"),
        "woman: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc"),
        "woman: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd"),
        "woman: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe"),
        "woman: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf"),
        "woman: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "woman: red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "woman: light skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "woman: medium-light skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "woman: medium skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "woman: medium-dark skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "woman: dark skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "person: red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "person: light skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "person: medium-light skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "person: medium skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "person: medium-dark skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb0"),
        "person: dark skin tone, red hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "woman: curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "woman: light skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "woman: medium-light skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "woman: medium skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "woman: medium-dark skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "woman: dark skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "person: curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "person: light skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "person: medium-light skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "person: medium skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "person: medium-dark skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb1"),
        "person: dark skin tone, curly hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "woman: white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "woman: light skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "woman: medium-light skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "woman: medium skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "woman: medium-dark skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "woman: dark skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "person: white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "person: light skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "person: medium-light skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "person: medium skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "person: medium-dark skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb3"),
        "person: dark skin tone, white hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "woman: bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "woman: light skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "woman: medium-light skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "woman: medium skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "woman: medium-dark skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "woman: dark skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "person: bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "person: light skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "person: medium-light skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "person: medium skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "person: medium-dark skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xb2"),
        "person: dark skin tone, bald",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x80"),
        "woman: blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman: light skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman: medium-light skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman: medium skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman: medium-dark skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman: dark skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x82"),
        "man: blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man: light skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man: medium-light skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man: medium skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man: medium-dark skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man: dark skin tone, blond hair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x93"), "older person", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbb"),
        "older person: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbc"),
        "older person: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbd"),
        "older person: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbe"),
        "older person: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbf"),
        "older person: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb4"), "old man", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbb"),
        "old man: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbc"),
        "old man: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbd"),
        "old man: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbe"),
        "old man: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbf"),
        "old man: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb5"), "old woman", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbb"),
        "old woman: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbc"),
        "old woman: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbd"),
        "old woman: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbe"),
        "old woman: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbf"),
        "old woman: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d"), "person frowning", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb"),
        "person frowning: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc"),
        "person frowning: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd"),
        "person frowning: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe"),
        "person frowning: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf"),
        "person frowning: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xe2\x80\x8d\xe2\x99\x82"),
        "man frowning",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man frowning: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man frowning: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man frowning: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man frowning: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man frowning: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xe2\x80\x8d\xe2\x99\x80"),
        "woman frowning",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman frowning: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman frowning: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman frowning: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman frowning: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman frowning: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e"), "person pouting", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb"),
        "person pouting: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc"),
        "person pouting: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd"),
        "person pouting: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe"),
        "person pouting: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf"),
        "person pouting: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xe2\x80\x8d\xe2\x99\x82"),
        "man pouting",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man pouting: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man pouting: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man pouting: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man pouting: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man pouting: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xe2\x80\x8d\xe2\x99\x80"),
        "woman pouting",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman pouting: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman pouting: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman pouting: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman pouting: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman pouting: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85"), "person gesturing NO", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb"),
        "person gesturing NO: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc"),
        "person gesturing NO: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd"),
        "person gesturing NO: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe"),
        "person gesturing NO: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf"),
        "person gesturing NO: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing NO",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing NO: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing NO: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing NO: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing NO: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing NO: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing NO",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing NO: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing NO: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing NO: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing NO: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing NO: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86"), "person gesturing OK", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb"),
        "person gesturing OK: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc"),
        "person gesturing OK: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd"),
        "person gesturing OK: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe"),
        "person gesturing OK: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf"),
        "person gesturing OK: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing OK",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing OK: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing OK: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing OK: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing OK: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man gesturing OK: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing OK",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing OK: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing OK: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing OK: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing OK: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman gesturing OK: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81"), "person tipping hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb"),
        "person tipping hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc"),
        "person tipping hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd"),
        "person tipping hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe"),
        "person tipping hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf"),
        "person tipping hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x82"),
        "man tipping hand",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man tipping hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man tipping hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man tipping hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man tipping hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man tipping hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x80"),
        "woman tipping hand",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman tipping hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman tipping hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman tipping hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman tipping hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman tipping hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b"), "person raising hand", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb"),
        "person raising hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc"),
        "person raising hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd"),
        "person raising hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe"),
        "person raising hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf"),
        "person raising hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xe2\x80\x8d\xe2\x99\x82"),
        "man raising hand",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man raising hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man raising hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man raising hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man raising hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man raising hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xe2\x80\x8d\xe2\x99\x80"),
        "woman raising hand",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman raising hand: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman raising hand: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman raising hand: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman raising hand: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman raising hand: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f"), "deaf person", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbb"),
        "deaf person: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbc"),
        "deaf person: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbd"),
        "deaf person: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbe"),
        "deaf person: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbf"),
        "deaf person: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xe2\x80\x8d\xe2\x99\x82"),
        "deaf man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "deaf man: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "deaf man: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "deaf man: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "deaf man: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "deaf man: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xe2\x80\x8d\xe2\x99\x80"),
        "deaf woman",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "deaf woman: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "deaf woman: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "deaf woman: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "deaf woman: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8f\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "deaf woman: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87"), "person bowing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb"),
        "person bowing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc"),
        "person bowing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd"),
        "person bowing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe"),
        "person bowing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf"),
        "person bowing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xe2\x80\x8d\xe2\x99\x82"),
        "man bowing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man bowing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man bowing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man bowing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man bowing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man bowing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xe2\x80\x8d\xe2\x99\x80"),
        "woman bowing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman bowing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman bowing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman bowing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman bowing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman bowing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6"), "person facepalming", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb"),
        "person facepalming: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc"),
        "person facepalming: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd"),
        "person facepalming: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe"),
        "person facepalming: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf"),
        "person facepalming: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xe2\x80\x8d\xe2\x99\x82"),
        "man facepalming",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man facepalming: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man facepalming: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man facepalming: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man facepalming: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man facepalming: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xe2\x80\x8d\xe2\x99\x80"),
        "woman facepalming",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman facepalming: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman facepalming: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman facepalming: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman facepalming: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman facepalming: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7"), "person shrugging", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb"),
        "person shrugging: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc"),
        "person shrugging: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd"),
        "person shrugging: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe"),
        "person shrugging: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf"),
        "person shrugging: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xe2\x80\x8d\xe2\x99\x82"),
        "man shrugging",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man shrugging: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man shrugging: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man shrugging: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man shrugging: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man shrugging: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xe2\x80\x8d\xe2\x99\x80"),
        "woman shrugging",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman shrugging: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman shrugging: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman shrugging: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman shrugging: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman shrugging: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xe2\x9a\x95"),
        "health worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x95"),
        "health worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x95"),
        "health worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x95"),
        "health worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x95"),
        "health worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x95"),
        "health worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9a\x95"),
        "man health worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x95"),
        "man health worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x95"),
        "man health worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x95"),
        "man health worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x95"),
        "man health worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x95"),
        "man health worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9a\x95"),
        "woman health worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x95"),
        "woman health worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x95"),
        "woman health worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x95"),
        "woman health worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x95"),
        "woman health worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x95"),
        "woman health worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "student",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "student: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "student: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "student: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "student: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "student: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "man student",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "man student: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "man student: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "man student: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "man student: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "man student: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "woman student",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "woman student: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "woman student: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "woman student: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "woman student: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\x93"),
        "woman student: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "teacher",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "teacher: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "teacher: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "teacher: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "teacher: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "teacher: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "man teacher",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "man teacher: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "man teacher: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "man teacher: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "man teacher: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "man teacher: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "woman teacher",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "woman teacher: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "woman teacher: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "woman teacher: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "woman teacher: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xab"),
        "woman teacher: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xe2\x9a\x96"),
        "judge",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x96"),
        "judge: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x96"),
        "judge: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x96"),
        "judge: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x96"),
        "judge: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x96"),
        "judge: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9a\x96"),
        "man judge",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x96"),
        "man judge: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x96"),
        "man judge: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x96"),
        "man judge: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x96"),
        "man judge: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x96"),
        "man judge: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9a\x96"),
        "woman judge",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x96"),
        "woman judge: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x96"),
        "woman judge: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x96"),
        "woman judge: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x96"),
        "woman judge: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x96"),
        "woman judge: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "farmer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "farmer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "farmer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "farmer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "farmer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "farmer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "man farmer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "man farmer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "man farmer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "man farmer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "man farmer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "man farmer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "woman farmer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "woman farmer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "woman farmer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "woman farmer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "woman farmer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8c\xbe"),
        "woman farmer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "cook",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "cook: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "cook: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "cook: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "cook: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "cook: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "man cook",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "man cook: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "man cook: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "man cook: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "man cook: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "man cook: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "woman cook",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "woman cook: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "woman cook: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "woman cook: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "woman cook: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xb3"),
        "woman cook: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "mechanic",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "mechanic: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "mechanic: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "mechanic: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "mechanic: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "mechanic: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "man mechanic",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "man mechanic: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "man mechanic: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "man mechanic: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "man mechanic: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "man mechanic: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "woman mechanic",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "woman mechanic: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "woman mechanic: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "woman mechanic: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "woman mechanic: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xa7"),
        "woman mechanic: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "factory worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "factory worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "factory worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "factory worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "factory worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "factory worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "man factory worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "man factory worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "man factory worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "man factory worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "man factory worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "man factory worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "woman factory worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "woman factory worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "woman factory worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "woman factory worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "woman factory worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xad"),
        "woman factory worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "office worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "office worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "office worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "office worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "office worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "office worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "man office worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "man office worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "man office worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "man office worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "man office worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "man office worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "woman office worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "woman office worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "woman office worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "woman office worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "woman office worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbc"),
        "woman office worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "scientist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "scientist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "scientist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "scientist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "scientist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "scientist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "man scientist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "man scientist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "man scientist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "man scientist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "man scientist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "man scientist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "woman scientist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "woman scientist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "woman scientist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "woman scientist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "woman scientist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xac"),
        "woman scientist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "technologist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "technologist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "technologist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "technologist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "technologist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "technologist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "man technologist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "man technologist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "man technologist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "man technologist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "man technologist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "man technologist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "woman technologist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "woman technologist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "woman technologist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "woman technologist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "woman technologist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbb"),
        "woman technologist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "singer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "singer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "singer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "singer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "singer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "singer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "man singer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "man singer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "man singer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "man singer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "man singer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "man singer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "woman singer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "woman singer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "woman singer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "woman singer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "woman singer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa4"),
        "woman singer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "artist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "artist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "artist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "artist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "artist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "artist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "man artist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "man artist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "man artist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "man artist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "man artist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "man artist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "woman artist",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "woman artist: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "woman artist: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "woman artist: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "woman artist: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa8"),
        "woman artist: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xe2\x9c\x88"),
        "pilot",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9c\x88"),
        "pilot: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9c\x88"),
        "pilot: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9c\x88"),
        "pilot: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9c\x88"),
        "pilot: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9c\x88"),
        "pilot: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9c\x88"),
        "man pilot",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9c\x88"),
        "man pilot: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9c\x88"),
        "man pilot: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9c\x88"),
        "man pilot: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9c\x88"),
        "man pilot: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9c\x88"),
        "man pilot: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9c\x88"),
        "woman pilot",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9c\x88"),
        "woman pilot: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9c\x88"),
        "woman pilot: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9c\x88"),
        "woman pilot: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9c\x88"),
        "woman pilot: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9c\x88"),
        "woman pilot: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "astronaut",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "astronaut: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "astronaut: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "astronaut: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "astronaut: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "astronaut: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "man astronaut",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "man astronaut: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "man astronaut: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "man astronaut: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "man astronaut: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "man astronaut: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "woman astronaut",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "woman astronaut: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "woman astronaut: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "woman astronaut: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "woman astronaut: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x80"),
        "woman astronaut: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "firefighter",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "firefighter: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "firefighter: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "firefighter: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "firefighter: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "firefighter: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "man firefighter",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "man firefighter: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "man firefighter: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "man firefighter: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "man firefighter: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "man firefighter: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "woman firefighter",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "woman firefighter: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "woman firefighter: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "woman firefighter: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "woman firefighter: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x92"),
        "woman firefighter: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae"), "police officer", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb"),
        "police officer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc"),
        "police officer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd"),
        "police officer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe"),
        "police officer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf"),
        "police officer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xe2\x80\x8d\xe2\x99\x82"),
        "man police officer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man police officer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man police officer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man police officer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man police officer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man police officer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xe2\x80\x8d\xe2\x99\x80"),
        "woman police officer",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman police officer: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman police officer: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman police officer: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman police officer: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman police officer: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5"), "detective", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb"),
        "detective: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc"),
        "detective: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd"),
        "detective: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe"),
        "detective: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf"),
        "detective: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82"),
        "man detective",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xe2\x80\x8d\xe2\x99\x82"),
        "man detective",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man detective: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man detective: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man detective: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man detective: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man detective: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80"),
        "woman detective",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xe2\x80\x8d\xe2\x99\x80"),
        "woman detective",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman detective: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman detective: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman detective: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman detective: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman detective: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82"), "guard", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb"),
        "guard: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc"),
        "guard: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd"),
        "guard: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe"),
        "guard: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf"),
        "guard: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xe2\x80\x8d\xe2\x99\x82"),
        "man guard",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man guard: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man guard: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man guard: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man guard: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man guard: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xe2\x80\x8d\xe2\x99\x80"),
        "woman guard",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman guard: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman guard: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman guard: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman guard: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman guard: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7"), "construction worker", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb"),
        "construction worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc"),
        "construction worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd"),
        "construction worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe"),
        "construction worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf"),
        "construction worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xe2\x80\x8d\xe2\x99\x82"),
        "man construction worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man construction worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man construction worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man construction worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man construction worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man construction worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xe2\x80\x8d\xe2\x99\x80"),
        "woman construction worker",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman construction worker: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman construction worker: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman construction worker: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman construction worker: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman construction worker: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb4"), "prince", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbb"),
        "prince: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbc"),
        "prince: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbd"),
        "prince: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbe"),
        "prince: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbf"),
        "prince: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb8"), "princess", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbb"),
        "princess: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbc"),
        "princess: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbd"),
        "princess: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbe"),
        "princess: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbf"),
        "princess: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3"),
        "person wearing turban",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb"),
        "person wearing turban: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc"),
        "person wearing turban: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd"),
        "person wearing turban: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe"),
        "person wearing turban: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf"),
        "person wearing turban: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xe2\x80\x8d\xe2\x99\x82"),
        "man wearing turban",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man wearing turban: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man wearing turban: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man wearing turban: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man wearing turban: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man wearing turban: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xe2\x80\x8d\xe2\x99\x80"),
        "woman wearing turban",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman wearing turban: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman wearing turban: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman wearing turban: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman wearing turban: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman wearing turban: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb2"), "man with skullcap", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbb"),
        "man with skullcap: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbc"),
        "man with skullcap: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbd"),
        "man with skullcap: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbe"),
        "man with skullcap: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbf"),
        "man with skullcap: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x95"),
        "woman with headscarf",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbb"),
        "woman with headscarf: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbc"),
        "woman with headscarf: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbd"),
        "woman with headscarf: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbe"),
        "woman with headscarf: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbf"),
        "woman with headscarf: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5"), "man in tuxedo", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbb"),
        "man in tuxedo: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbc"),
        "man in tuxedo: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbd"),
        "man in tuxedo: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbe"),
        "man in tuxedo: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbf"),
        "man in tuxedo: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xe2\x80\x8d\xe2\x99\x82"),
        "man in tuxedo",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man in tuxedo: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man in tuxedo: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man in tuxedo: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man in tuxedo: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man in tuxedo: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xe2\x80\x8d\xe2\x99\x80"),
        "woman in tuxedo",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman in tuxedo: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman in tuxedo: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman in tuxedo: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman in tuxedo: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman in tuxedo: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0"), "bride with veil", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbb"),
        "bride with veil: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbc"),
        "bride with veil: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbd"),
        "bride with veil: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbe"),
        "bride with veil: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbf"),
        "bride with veil: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xe2\x80\x8d\xe2\x99\x82"),
        "man with veil",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man with veil: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man with veil: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man with veil: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man with veil: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man with veil: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xe2\x80\x8d\xe2\x99\x80"),
        "woman with veil",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman with veil: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman with veil: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman with veil: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman with veil: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman with veil: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb0"), "pregnant woman", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbb"),
        "pregnant woman: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbc"),
        "pregnant woman: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbd"),
        "pregnant woman: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbe"),
        "pregnant woman: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbf"),
        "pregnant woman: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb1"), "breast-feeding", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbb"),
        "breast-feeding: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbc"),
        "breast-feeding: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbd"),
        "breast-feeding: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbe"),
        "breast-feeding: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbf"),
        "breast-feeding: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "woman feeding baby",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "woman feeding baby: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "woman feeding baby: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "woman feeding baby: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "woman feeding baby: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "woman feeding baby: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "man feeding baby",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "man feeding baby: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "man feeding baby: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "man feeding baby: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "man feeding baby: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "man feeding baby: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "person feeding baby",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "person feeding baby: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "person feeding baby: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "person feeding baby: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "person feeding baby: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xbc"),
        "person feeding baby: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbc"), "baby angel", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbb"),
        "baby angel: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbc"),
        "baby angel: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbd"),
        "baby angel: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbe"),
        "baby angel: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbf"),
        "baby angel: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x85"), "Santa Claus", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbb"),
        "Santa Claus: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbc"),
        "Santa Claus: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbd"),
        "Santa Claus: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbe"),
        "Santa Claus: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbf"),
        "Santa Claus: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb6"), "Mrs. Claus", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbb"),
        "Mrs. Claus: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbc"),
        "Mrs. Claus: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbd"),
        "Mrs. Claus: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbe"),
        "Mrs. Claus: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbf"),
        "Mrs. Claus: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\x84"),
        "mx claus",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\x84"),
        "mx claus: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\x84"),
        "mx claus: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\x84"),
        "mx claus: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\x84"),
        "mx claus: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\x84"),
        "mx claus: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8"), "superhero", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbb"),
        "superhero: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbc"),
        "superhero: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbd"),
        "superhero: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbe"),
        "superhero: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbf"),
        "superhero: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xe2\x80\x8d\xe2\x99\x82"),
        "man superhero",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man superhero: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man superhero: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man superhero: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man superhero: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man superhero: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xe2\x80\x8d\xe2\x99\x80"),
        "woman superhero",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman superhero: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman superhero: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman superhero: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman superhero: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman superhero: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9"), "supervillain", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbb"),
        "supervillain: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbc"),
        "supervillain: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbd"),
        "supervillain: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbe"),
        "supervillain: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbf"),
        "supervillain: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xe2\x80\x8d\xe2\x99\x82"),
        "man supervillain",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man supervillain: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man supervillain: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man supervillain: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man supervillain: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man supervillain: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xe2\x80\x8d\xe2\x99\x80"),
        "woman supervillain",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman supervillain: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman supervillain: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman supervillain: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman supervillain: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman supervillain: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99"), "mage", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbb"),
        "mage: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbc"),
        "mage: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbd"),
        "mage: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbe"),
        "mage: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf"),
        "mage: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xe2\x80\x8d\xe2\x99\x82"),
        "man mage",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man mage: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man mage: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man mage: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man mage: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man mage: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xe2\x80\x8d\xe2\x99\x80"),
        "woman mage",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman mage: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman mage: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman mage: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman mage: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman mage: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a"), "fairy", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbb"),
        "fairy: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbc"),
        "fairy: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbd"),
        "fairy: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbe"),
        "fairy: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf"),
        "fairy: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xe2\x80\x8d\xe2\x99\x82"),
        "man fairy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man fairy: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man fairy: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man fairy: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man fairy: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man fairy: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xe2\x80\x8d\xe2\x99\x80"),
        "woman fairy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman fairy: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman fairy: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman fairy: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman fairy: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman fairy: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b"), "vampire", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbb"),
        "vampire: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbc"),
        "vampire: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbd"),
        "vampire: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbe"),
        "vampire: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf"),
        "vampire: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xe2\x80\x8d\xe2\x99\x82"),
        "man vampire",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man vampire: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man vampire: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man vampire: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man vampire: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man vampire: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xe2\x80\x8d\xe2\x99\x80"),
        "woman vampire",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman vampire: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman vampire: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman vampire: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman vampire: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman vampire: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c"), "merperson", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbb"),
        "merperson: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbc"),
        "merperson: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbd"),
        "merperson: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbe"),
        "merperson: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf"),
        "merperson: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xe2\x80\x8d\xe2\x99\x82"),
        "merman",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "merman: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "merman: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "merman: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "merman: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "merman: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xe2\x80\x8d\xe2\x99\x80"),
        "mermaid",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "mermaid: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "mermaid: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "mermaid: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "mermaid: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "mermaid: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d"), "elf", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbb"),
        "elf: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbc"),
        "elf: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbd"),
        "elf: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbe"),
        "elf: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf"),
        "elf: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xe2\x80\x8d\xe2\x99\x82"),
        "man elf",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man elf: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man elf: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man elf: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man elf: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man elf: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xe2\x80\x8d\xe2\x99\x80"),
        "woman elf",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman elf: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman elf: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman elf: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman elf: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman elf: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9e"), "genie", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9e\xe2\x80\x8d\xe2\x99\x82"),
        "man genie",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9e\xe2\x80\x8d\xe2\x99\x80"),
        "woman genie",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9f"), "zombie", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9f\xe2\x80\x8d\xe2\x99\x82"),
        "man zombie",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x9f\xe2\x80\x8d\xe2\x99\x80"),
        "woman zombie",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86"),
        "person getting massage",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb"),
        "person getting massage: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc"),
        "person getting massage: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd"),
        "person getting massage: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe"),
        "person getting massage: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf"),
        "person getting massage: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xe2\x80\x8d\xe2\x99\x82"),
        "man getting massage",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man getting massage: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man getting massage: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man getting massage: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man getting massage: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man getting massage: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting massage",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting massage: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting massage: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting massage: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting massage: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting massage: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87"),
        "person getting haircut",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb"),
        "person getting haircut: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc"),
        "person getting haircut: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd"),
        "person getting haircut: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe"),
        "person getting haircut: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf"),
        "person getting haircut: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xe2\x80\x8d\xe2\x99\x82"),
        "man getting haircut",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man getting haircut: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man getting haircut: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man getting haircut: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man getting haircut: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man getting haircut: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting haircut",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting haircut: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting haircut: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting haircut: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting haircut: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman getting haircut: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6"), "person walking", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb"),
        "person walking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc"),
        "person walking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd"),
        "person walking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe"),
        "person walking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf"),
        "person walking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xe2\x80\x8d\xe2\x99\x82"),
        "man walking",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man walking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man walking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man walking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man walking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man walking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xe2\x80\x8d\xe2\x99\x80"),
        "woman walking",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman walking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman walking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman walking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman walking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman walking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d"), "person standing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbb"),
        "person standing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbc"),
        "person standing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbd"),
        "person standing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbe"),
        "person standing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbf"),
        "person standing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xe2\x80\x8d\xe2\x99\x82"),
        "man standing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man standing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man standing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man standing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man standing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man standing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xe2\x80\x8d\xe2\x99\x80"),
        "woman standing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman standing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman standing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman standing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman standing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman standing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e"), "person kneeling", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbb"),
        "person kneeling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbc"),
        "person kneeling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbd"),
        "person kneeling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbe"),
        "person kneeling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbf"),
        "person kneeling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xe2\x80\x8d\xe2\x99\x82"),
        "man kneeling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man kneeling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man kneeling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man kneeling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man kneeling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man kneeling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xe2\x80\x8d\xe2\x99\x80"),
        "woman kneeling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman kneeling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman kneeling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman kneeling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman kneeling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8e\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman kneeling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "person with probing cane",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "person with probing cane: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "person with probing cane: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "person with probing cane: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "person with probing cane: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "person with probing cane: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "man with probing cane",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "man with probing cane: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "man with probing cane: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "man with probing cane: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "man with probing cane: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "man with probing cane: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "woman with probing cane",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "woman with probing cane: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "woman with probing cane: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "woman with probing cane: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "woman with probing cane: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xaf"),
        "woman with probing cane: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "person in motorized wheelchair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "person in motorized wheelchair: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "person in motorized wheelchair: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "person in motorized wheelchair: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "person in motorized wheelchair: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "person in motorized wheelchair: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "man in motorized wheelchair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "man in motorized wheelchair: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "man in motorized wheelchair: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "man in motorized wheelchair: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "man in motorized wheelchair: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "man in motorized wheelchair: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "woman in motorized wheelchair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "woman in motorized wheelchair: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "woman in motorized wheelchair: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "woman in motorized wheelchair: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "woman in motorized wheelchair: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xbc"),
        "woman in motorized wheelchair: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "person in manual wheelchair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "person in manual wheelchair: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "person in manual wheelchair: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "person in manual wheelchair: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "person in manual wheelchair: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "person in manual wheelchair: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "man in manual wheelchair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "man in manual wheelchair: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "man in manual wheelchair: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "man in manual wheelchair: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "man in manual wheelchair: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "man in manual wheelchair: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "woman in manual wheelchair",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "woman in manual wheelchair: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "woman in manual wheelchair: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "woman in manual wheelchair: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "woman in manual wheelchair: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa6\xbd"),
        "woman in manual wheelchair: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83"), "person running", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb"),
        "person running: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc"),
        "person running: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd"),
        "person running: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe"),
        "person running: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf"),
        "person running: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xe2\x80\x8d\xe2\x99\x82"),
        "man running",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man running: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man running: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man running: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man running: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man running: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xe2\x80\x8d\xe2\x99\x80"),
        "woman running",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman running: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman running: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman running: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman running: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman running: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x83"), "woman dancing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x83\xf0\x9f\x8f\xbb"),
        "woman dancing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x83\xf0\x9f\x8f\xbc"),
        "woman dancing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x83\xf0\x9f\x8f\xbd"),
        "woman dancing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x83\xf0\x9f\x8f\xbe"),
        "woman dancing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x83\xf0\x9f\x8f\xbf"),
        "woman dancing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xba"), "man dancing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xba\xf0\x9f\x8f\xbb"),
        "man dancing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xba\xf0\x9f\x8f\xbc"),
        "man dancing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xba\xf0\x9f\x8f\xbd"),
        "man dancing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xba\xf0\x9f\x8f\xbe"),
        "man dancing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xba\xf0\x9f\x8f\xbf"),
        "man dancing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb4"),
        "man in suit levitating",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbb"),
        "man in suit levitating: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbc"),
        "man in suit levitating: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbd"),
        "man in suit levitating: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbe"),
        "man in suit levitating: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbf"),
        "man in suit levitating: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xaf"),
        "people with bunny ears",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xaf\xe2\x80\x8d\xe2\x99\x82"),
        "men with bunny ears",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xaf\xe2\x80\x8d\xe2\x99\x80"),
        "women with bunny ears",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96"),
        "person in steamy room",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbb"),
        "person in steamy room: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbc"),
        "person in steamy room: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbd"),
        "person in steamy room: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbe"),
        "person in steamy room: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf"),
        "person in steamy room: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xe2\x80\x8d\xe2\x99\x82"),
        "man in steamy room",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man in steamy room: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man in steamy room: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man in steamy room: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man in steamy room: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man in steamy room: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xe2\x80\x8d\xe2\x99\x80"),
        "woman in steamy room",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman in steamy room: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman in steamy room: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman in steamy room: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman in steamy room: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman in steamy room: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97"), "person climbing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbb"),
        "person climbing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbc"),
        "person climbing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbd"),
        "person climbing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbe"),
        "person climbing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf"),
        "person climbing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xe2\x80\x8d\xe2\x99\x82"),
        "man climbing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man climbing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man climbing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man climbing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man climbing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man climbing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xe2\x80\x8d\xe2\x99\x80"),
        "woman climbing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman climbing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman climbing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman climbing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman climbing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman climbing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xb7"), "ninja", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xba"), "person fencing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x87"), "horse racing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbb"),
        "horse racing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbc"),
        "horse racing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbd"),
        "horse racing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbe"),
        "horse racing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbf"),
        "horse racing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb7"), "skier", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x82"), "snowboarder", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbb"),
        "snowboarder: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbc"),
        "snowboarder: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbd"),
        "snowboarder: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbe"),
        "snowboarder: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbf"),
        "snowboarder: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c"), "person golfing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbb"),
        "person golfing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbc"),
        "person golfing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbd"),
        "person golfing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbe"),
        "person golfing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf"),
        "person golfing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82"),
        "man golfing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xe2\x80\x8d\xe2\x99\x82"),
        "man golfing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man golfing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man golfing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man golfing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man golfing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man golfing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80"),
        "woman golfing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xe2\x80\x8d\xe2\x99\x80"),
        "woman golfing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman golfing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman golfing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman golfing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman golfing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman golfing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84"), "person surfing", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb"),
        "person surfing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc"),
        "person surfing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd"),
        "person surfing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe"),
        "person surfing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf"),
        "person surfing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xe2\x80\x8d\xe2\x99\x82"),
        "man surfing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man surfing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man surfing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man surfing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man surfing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man surfing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xe2\x80\x8d\xe2\x99\x80"),
        "woman surfing",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman surfing: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman surfing: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman surfing: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman surfing: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman surfing: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3"), "person rowing boat", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb"),
        "person rowing boat: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc"),
        "person rowing boat: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd"),
        "person rowing boat: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe"),
        "person rowing boat: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf"),
        "person rowing boat: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xe2\x80\x8d\xe2\x99\x82"),
        "man rowing boat",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man rowing boat: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man rowing boat: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man rowing boat: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man rowing boat: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man rowing boat: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xe2\x80\x8d\xe2\x99\x80"),
        "woman rowing boat",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman rowing boat: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman rowing boat: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman rowing boat: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman rowing boat: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman rowing boat: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a"), "person swimming", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb"),
        "person swimming: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc"),
        "person swimming: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd"),
        "person swimming: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe"),
        "person swimming: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf"),
        "person swimming: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xe2\x80\x8d\xe2\x99\x82"),
        "man swimming",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man swimming: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man swimming: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man swimming: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man swimming: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man swimming: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xe2\x80\x8d\xe2\x99\x80"),
        "woman swimming",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman swimming: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman swimming: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman swimming: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman swimming: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman swimming: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9"), "person bouncing ball", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbb"),
        "person bouncing ball: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbc"),
        "person bouncing ball: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbd"),
        "person bouncing ball: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbe"),
        "person bouncing ball: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbf"),
        "person bouncing ball: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82"),
        "man bouncing ball",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xe2\x80\x8d\xe2\x99\x82"),
        "man bouncing ball",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man bouncing ball: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man bouncing ball: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man bouncing ball: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man bouncing ball: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man bouncing ball: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80"),
        "woman bouncing ball",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xe2\x80\x8d\xe2\x99\x80"),
        "woman bouncing ball",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman bouncing ball: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman bouncing ball: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman bouncing ball: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman bouncing ball: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xe2\x9b\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman bouncing ball: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b"),
        "person lifting weights",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb"),
        "person lifting weights: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc"),
        "person lifting weights: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd"),
        "person lifting weights: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe"),
        "person lifting weights: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf"),
        "person lifting weights: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82"),
        "man lifting weights",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xe2\x80\x8d\xe2\x99\x82"),
        "man lifting weights",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man lifting weights: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man lifting weights: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man lifting weights: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man lifting weights: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man lifting weights: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80"),
        "woman lifting weights",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xe2\x80\x8d\xe2\x99\x80"),
        "woman lifting weights",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman lifting weights: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman lifting weights: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman lifting weights: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman lifting weights: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman lifting weights: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4"), "person biking", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb"),
        "person biking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc"),
        "person biking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd"),
        "person biking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe"),
        "person biking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf"),
        "person biking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xe2\x80\x8d\xe2\x99\x82"),
        "man biking",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man biking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man biking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man biking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man biking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man biking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xe2\x80\x8d\xe2\x99\x80"),
        "woman biking",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman biking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman biking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman biking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman biking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman biking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5"),
        "person mountain biking",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb"),
        "person mountain biking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc"),
        "person mountain biking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd"),
        "person mountain biking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe"),
        "person mountain biking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf"),
        "person mountain biking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xe2\x80\x8d\xe2\x99\x82"),
        "man mountain biking",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man mountain biking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man mountain biking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man mountain biking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man mountain biking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man mountain biking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xe2\x80\x8d\xe2\x99\x80"),
        "woman mountain biking",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman mountain biking: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman mountain biking: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman mountain biking: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman mountain biking: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman mountain biking: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8"), "person cartwheeling", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb"),
        "person cartwheeling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc"),
        "person cartwheeling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd"),
        "person cartwheeling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe"),
        "person cartwheeling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf"),
        "person cartwheeling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xe2\x80\x8d\xe2\x99\x82"),
        "man cartwheeling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man cartwheeling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man cartwheeling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man cartwheeling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man cartwheeling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man cartwheeling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xe2\x80\x8d\xe2\x99\x80"),
        "woman cartwheeling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman cartwheeling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman cartwheeling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman cartwheeling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman cartwheeling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman cartwheeling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbc"), "people wrestling", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "men wrestling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "women wrestling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd"),
        "person playing water polo",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb"),
        "person playing water polo: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc"),
        "person playing water polo: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd"),
        "person playing water polo: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe"),
        "person playing water polo: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf"),
        "person playing water polo: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man playing water polo",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man playing water polo: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man playing water polo: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man playing water polo: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man playing water polo: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man playing water polo: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing water polo",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing water polo: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing water polo: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing water polo: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing water polo: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing water polo: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe"),
        "person playing handball",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb"),
        "person playing handball: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc"),
        "person playing handball: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd"),
        "person playing handball: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe"),
        "person playing handball: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf"),
        "person playing handball: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man playing handball",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man playing handball: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man playing handball: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man playing handball: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man playing handball: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man playing handball: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing handball",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing handball: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing handball: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing handball: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing handball: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman playing handball: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9"), "person juggling", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb"),
        "person juggling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc"),
        "person juggling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd"),
        "person juggling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe"),
        "person juggling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf"),
        "person juggling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xe2\x80\x8d\xe2\x99\x82"),
        "man juggling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man juggling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man juggling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man juggling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man juggling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man juggling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xe2\x80\x8d\xe2\x99\x80"),
        "woman juggling",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman juggling: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman juggling: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman juggling: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman juggling: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman juggling: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98"),
        "person in lotus position",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbb"),
        "person in lotus position: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbc"),
        "person in lotus position: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbd"),
        "person in lotus position: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbe"),
        "person in lotus position: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf"),
        "person in lotus position: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xe2\x80\x8d\xe2\x99\x82"),
        "man in lotus position",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82"),
        "man in lotus position: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82"),
        "man in lotus position: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82"),
        "man in lotus position: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82"),
        "man in lotus position: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82"),
        "man in lotus position: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xe2\x80\x8d\xe2\x99\x80"),
        "woman in lotus position",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80"),
        "woman in lotus position: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80"),
        "woman in lotus position: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80"),
        "woman in lotus position: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80"),
        "woman in lotus position: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80"),
        "woman in lotus position: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x80"), "person taking bath", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbb"),
        "person taking bath: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbc"),
        "person taking bath: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbd"),
        "person taking bath: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbe"),
        "person taking bath: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbf"),
        "person taking bath: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8c"), "person in bed", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbb"),
        "person in bed: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbc"),
        "person in bed: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbd"),
        "person in bed: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbe"),
        "person in bed: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbf"),
        "person in bed: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d\xf0\x9f\xa7\x91"),
    "people holding hands",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb"),
        "people holding hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc"),
        "people holding hands: light skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd"),
        "people holding hands: light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe"),
        "people holding hands: light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf"),
        "people holding hands: light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb"),
        "people holding hands: medium-light skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc"),
        "people holding hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd"),
        "people holding hands: medium-light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe"),
        "people holding hands: medium-light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf"),
        "people holding hands: medium-light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb"),
        "people holding hands: medium skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc"),
        "people holding hands: medium skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd"),
        "people holding hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe"),
        "people holding hands: medium skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf"),
        "people holding hands: medium skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb"),
        "people holding hands: medium-dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc"),
        "people holding hands: medium-dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd"),
        "people holding hands: medium-dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe"),
        "people holding hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf"),
        "people holding hands: medium-dark skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb"),
        "people holding hands: dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc"),
        "people holding hands: dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd"),
        "people holding hands: dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe"),
        "people holding hands: dark skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf"),
        "people holding hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xad"), "women holding hands", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xad\xf0\x9f\x8f\xbb"),
        "women holding hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc"),
        "women holding hands: light skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd"),
        "women holding hands: light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe"),
        "women holding hands: light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf"),
        "women holding hands: light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb"),
        "women holding hands: medium-light skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xad\xf0\x9f\x8f\xbc"),
        "women holding hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd"),
        "women holding hands: medium-light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe"),
        "women holding hands: medium-light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf"),
        "women holding hands: medium-light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb"),
        "women holding hands: medium skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc"),
        "women holding hands: medium skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xad\xf0\x9f\x8f\xbd"),
        "women holding hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe"),
        "women holding hands: medium skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf"),
        "women holding hands: medium skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb"),
        "women holding hands: medium-dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc"),
        "women holding hands: medium-dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd"),
        "women holding hands: medium-dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xad\xf0\x9f\x8f\xbe"),
        "women holding hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf"),
        "women holding hands: medium-dark skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb"),
        "women holding hands: dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc"),
        "women holding hands: dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd"),
        "women holding hands: dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe"),
        "women holding hands: dark skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xad\xf0\x9f\x8f\xbf"),
        "women holding hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xab"),
        "woman and man holding hands",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xab\xf0\x9f\x8f\xbb"),
        "woman and man holding hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "woman and man holding hands: light skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "woman and man holding hands: light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "woman and man holding hands: light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "woman and man holding hands: light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "woman and man holding hands: medium-light skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xab\xf0\x9f\x8f\xbc"),
        "woman and man holding hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "woman and man holding hands: medium-light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "woman and man holding hands: medium-light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "woman and man holding hands: medium-light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "woman and man holding hands: medium skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "woman and man holding hands: medium skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xab\xf0\x9f\x8f\xbd"),
        "woman and man holding hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "woman and man holding hands: medium skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "woman and man holding hands: medium skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "woman and man holding hands: medium-dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "woman and man holding hands: medium-dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "woman and man holding hands: medium-dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xab\xf0\x9f\x8f\xbe"),
        "woman and man holding hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "woman and man holding hands: medium-dark skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "woman and man holding hands: dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "woman and man holding hands: dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "woman and man holding hands: dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "woman and man holding hands: dark skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xab\xf0\x9f\x8f\xbf"),
        "woman and man holding hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xac"), "men holding hands", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xac\xf0\x9f\x8f\xbb"),
        "men holding hands: light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "men holding hands: light skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "men holding hands: light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "men holding hands: light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "men holding hands: light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "men holding hands: medium-light skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xac\xf0\x9f\x8f\xbc"),
        "men holding hands: medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "men holding hands: medium-light skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "men holding hands: medium-light skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "men holding hands: medium-light skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "men holding hands: medium skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "men holding hands: medium skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xac\xf0\x9f\x8f\xbd"),
        "men holding hands: medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "men holding hands: medium skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "men holding hands: medium skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "men holding hands: medium-dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "men holding hands: medium-dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "men holding hands: medium-dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xac\xf0\x9f\x8f\xbe"),
        "men holding hands: medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"),
        "men holding hands: medium-dark skin tone, dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"),
        "men holding hands: dark skin tone, light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"),
        "men holding hands: dark skin tone, medium-light skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"),
        "men holding hands: dark skin tone, medium skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d"
                          "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"),
        "men holding hands: dark skin tone, medium-dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xac\xf0\x9f\x8f\xbf"),
        "men holding hands: dark skin tone",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x8f"), "kiss", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f"
                          "\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa8"),
        "kiss: woman, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2"
                          "\x80\x8d\xf0\x9f\x91\xa8"),
        "kiss: woman, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f"
                          "\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa8"),
        "kiss: man, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2"
                          "\x80\x8d\xf0\x9f\x91\xa8"),
        "kiss: man, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f"
                          "\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa9"),
        "kiss: woman, woman",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2"
                          "\x80\x8d\xf0\x9f\x91\xa9"),
        "kiss: woman, woman",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x91"), "couple with heart", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8(
          "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa8"),
        "couple with heart: woman, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xe2\x80\x8d\xf0\x9f\x91\xa8"),
        "couple with heart: woman, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8(
          "\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa8"),
        "couple with heart: man, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xe2\x80\x8d\xf0\x9f\x91\xa8"),
        "couple with heart: man, man",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8(
          "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa9"),
        "couple with heart: woman, woman",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xe2\x80\x8d\xf0\x9f\x91\xa9"),
        "couple with heart: woman, woman",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xaa"), "family", emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"),
    "family: man, woman, boy",
    emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"),
    "family: man, woman, girl",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: man, woman, girl, boy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: man, woman, boy, boy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa7"),
        "family: man, woman, girl, girl",
        emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6"),
    "family: man, man, boy",
    emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7"),
    "family: man, man, girl",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: man, man, girl, boy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: man, man, boy, boy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa7"),
        "family: man, man, girl, girl",
        emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"),
    "family: woman, woman, boy",
    emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"),
    "family: woman, woman, girl",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: woman, woman, girl, boy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: woman, woman, boy, boy",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"
                          "\xe2\x80\x8d\xf0\x9f\x91\xa7"),
        "family: woman, woman, girl, girl",
        emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: man, boy",
        emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6"),
    "family: man, boy, boy",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7"),
        "family: man, girl",
        emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6"),
    "family: man, girl, boy",
    emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7"),
    "family: man, girl, girl",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"),
        "family: woman, boy",
        emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6"),
    "family: woman, boy, boy",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"),
        "family: woman, girl",
        emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6"),
    "family: woman, girl, boy",
    emoji::EmojiCategory::People},
  Emoji{
    QString::fromUtf8("\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7"),
    "family: woman, girl, girl",
    emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xa3"), "speaking head", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa4"), "bust in silhouette", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa5"), "busts in silhouette", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x82"), "people hugging", emoji::EmojiCategory::People},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa3"), "footprints", emoji::EmojiCategory::People},
};

const std::vector<Emoji> emoji::Provider::nature = {
  // Nature
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb5"), "monkey face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x92"), "monkey", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x8d"), "gorilla", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa7"), "orangutan", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb6"), "dog face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x95"), "dog", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xae"), "guide dog", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x95\xe2\x80\x8d\xf0\x9f\xa6\xba"),
        "service dog",
        emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa9"), "poodle", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xba"), "wolf", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x8a"), "fox", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x9d"), "raccoon", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb1"), "cat face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x88"), "cat", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x88\xe2\x80\x8d\xe2\xac\x9b"),
        "black cat",
        emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x81"), "lion", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xaf"), "tiger face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x85"), "tiger", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x86"), "leopard", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb4"), "horse face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x8e"), "horse", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x84"), "unicorn", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x93"), "zebra", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x8c"), "deer", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xac"), "bison", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xae"), "cow face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x82"), "ox", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x83"), "water buffalo", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x84"), "cow", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb7"), "pig face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x96"), "pig", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x97"), "boar", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xbd"), "pig nose", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x8f"), "ram", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x91"), "ewe", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x90"), "goat", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xaa"), "camel", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xab"), "two-hump camel", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x99"), "llama", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x92"), "giraffe", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x98"), "elephant", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa3"), "mammoth", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x8f"), "rhinoceros", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x9b"), "hippopotamus", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xad"), "mouse face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x81"), "mouse", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x80"), "rat", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb9"), "hamster", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb0"), "rabbit face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x87"), "rabbit", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xbf"), "chipmunk", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xab"), "beaver", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x94"), "hedgehog", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x87"), "bat", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xbb"), "bear", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xbb\xe2\x80\x8d\xe2\x9d\x84"),
        "polar bear",
        emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa8"), "koala", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xbc"), "panda", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa5"), "sloth", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa6"), "otter", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa8"), "skunk", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x98"), "kangaroo", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa1"), "badger", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xbe"), "paw prints", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x83"), "turkey", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x94"), "chicken", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x93"), "rooster", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa3"), "hatching chick", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa4"), "baby chick", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa5"),
        "front-facing baby chick",
        emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa6"), "bird", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa7"), "penguin", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x8a"), "dove", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x85"), "eagle", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x86"), "duck", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa2"), "swan", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x89"), "owl", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa4"), "dodo", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xb6"), "feather", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa9"), "flamingo", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x9a"), "peacock", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x9c"), "parrot", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb8"), "frog", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x8a"), "crocodile", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa2"), "turtle", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x8e"), "lizard", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x8d"), "snake", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb2"), "dragon face", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x89"), "dragon", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x95"), "sauropod", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x96"), "T-Rex", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xb3"), "spouting whale", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x8b"), "whale", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xac"), "dolphin", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xad"), "seal", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x9f"), "fish", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa0"), "tropical fish", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\xa1"), "blowfish", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x88"), "shark", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x99"), "octopus", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x9a"), "spiral shell", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x8c"), "snail", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x8b"), "butterfly", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x9b"), "bug", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x9c"), "ant", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x9d"), "honeybee", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xb2"), "beetle", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x90\x9e"), "lady beetle", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x97"), "cricket", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xb3"), "cockroach", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb7"), "spider", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb8"), "spider web", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x82"), "scorpion", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x9f"), "mosquito", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xb0"), "fly", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xb1"), "worm", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xa0"), "microbe", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x90"), "bouquet", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb8"), "cherry blossom", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xae"), "white flower", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb5"), "rosette", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb9"), "rose", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x80"), "wilted flower", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xba"), "hibiscus", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xbb"), "sunflower", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xbc"), "blossom", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb7"), "tulip", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb1"), "seedling", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xb4"), "potted plant", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb2"), "evergreen tree", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb3"), "deciduous tree", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb4"), "palm tree", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb5"), "cactus", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xbe"), "sheaf of rice", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xbf"), "herb", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xe2\x98\x98"), "shamrock", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x80"), "four leaf clover", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x81"), "maple leaf", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x82"), "fallen leaf", emoji::EmojiCategory::Nature},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x83"),
        "leaf fluttering in wind",
        emoji::EmojiCategory::Nature},
};

const std::vector<Emoji> emoji::Provider::food = {
  // Food
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x87"), "grapes", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x88"), "melon", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x89"), "watermelon", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x8a"), "tangerine", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x8b"), "lemon", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x8c"), "banana", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x8d"), "pineapple", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xad"), "mango", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x8e"), "red apple", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x8f"), "green apple", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x90"), "pear", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x91"), "peach", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x92"), "cherries", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x93"), "strawberry", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x90"), "blueberries", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x9d"), "kiwi fruit", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x85"), "tomato", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x92"), "olive", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa5"), "coconut", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x91"), "avocado", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x86"), "eggplant", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x94"), "potato", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x95"), "carrot", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xbd"), "ear of corn", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb6"), "hot pepper", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x91"), "bell pepper", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x92"), "cucumber", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xac"), "leafy green", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa6"), "broccoli", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x84"), "garlic", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x85"), "onion", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x84"), "mushroom", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x9c"), "peanuts", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xb0"), "chestnut", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x9e"), "bread", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x90"), "croissant", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x96"), "baguette bread", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x93"), "flatbread", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa8"), "pretzel", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xaf"), "bagel", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x9e"), "pancakes", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x87"), "waffle", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x80"), "cheese wedge", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x96"), "meat on bone", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x97"), "poultry leg", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa9"), "cut of meat", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x93"), "bacon", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x94"), "hamburger", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x9f"), "french fries", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x95"), "pizza", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xad"), "hot dog", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xaa"), "sandwich", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xae"), "taco", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xaf"), "burrito", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x94"), "tamale", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x99"), "stuffed flatbread", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x86"), "falafel", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x9a"), "egg", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb3"), "cooking", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x98"), "shallow pan of food", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb2"), "pot of food", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x95"), "fondue", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa3"), "bowl with spoon", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x97"), "green salad", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xbf"), "popcorn", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x88"), "butter", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x82"), "salt", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xab"), "canned food", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb1"), "bento box", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x98"), "rice cracker", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x99"), "rice ball", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x9a"), "cooked rice", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x9b"), "curry rice", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x9c"), "steaming bowl", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\x9d"), "spaghetti", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa0"), "roasted sweet potato", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa2"), "oden", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa3"), "sushi", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa4"), "fried shrimp", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa5"), "fish cake with swirl", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xae"), "moon cake", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa1"), "dango", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x9f"), "dumpling", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa0"), "fortune cookie", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa1"), "takeout box", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x80"), "crab", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x9e"), "lobster", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x90"), "shrimp", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\x91"), "squid", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xaa"), "oyster", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa6"), "soft ice cream", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa7"), "shaved ice", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa8"), "ice cream", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xa9"), "doughnut", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xaa"), "cookie", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x82"), "birthday cake", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb0"), "shortcake", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x81"), "cupcake", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa7"), "pie", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xab"), "chocolate bar", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xac"), "candy", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xad"), "lollipop", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xae"), "custard", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xaf"), "honey pot", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xbc"), "baby bottle", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x9b"), "glass of milk", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xe2\x98\x95"), "hot beverage", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xab\x96"), "teapot", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb5"), "teacup without handle", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb6"), "sake", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xbe"),
        "bottle with popping cork",
        emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb7"), "wine glass", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb8"), "cocktail glass", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb9"), "tropical drink", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xba"), "beer mug", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xbb"), "clinking beer mugs", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x82"), "clinking glasses", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x83"), "tumbler glass", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa4"), "cup with straw", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8b"), "bubble tea", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x83"), "beverage box", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x89"), "mate", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\x8a"), "ice", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xa2"), "chopsticks", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xbd"),
        "fork and knife with plate",
        emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8d\xb4"), "fork and knife", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x84"), "spoon", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xaa"), "kitchen knife", emoji::EmojiCategory::Food},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xba"), "amphora", emoji::EmojiCategory::Food},
};

const std::vector<Emoji> emoji::Provider::activity = {
  // Activity
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x83"), "jack-o-lantern", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x84"), "Christmas tree", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x86"), "fireworks", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x87"), "sparkler", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa8"), "firecracker", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x9c\xa8"), "sparkles", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x88"), "balloon", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x89"), "party popper", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x8a"), "confetti ball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x8b"), "tanabata tree", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x8d"), "pine decoration", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x8e"), "Japanese dolls", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x8f"), "carp streamer", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x90"), "wind chime", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x91"),
        "moon viewing ceremony",
        emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa7"), "red envelope", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x80"), "ribbon", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x81"), "wrapped gift", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x97"), "reminder ribbon", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x9f"), "admission tickets", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xab"), "ticket", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x96"), "military medal", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x86"), "trophy", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x85"), "sports medal", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x87"), "1st place medal", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x88"), "2nd place medal", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x89"), "3rd place medal", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x9a\xbd"), "soccer ball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x9a\xbe"), "baseball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x8e"), "softball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x80"), "basketball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x90"), "volleyball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x88"), "american football", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x89"), "rugby football", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xbe"), "tennis", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x8f"), "flying disc", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb3"), "bowling", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8f"), "cricket game", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x91"), "field hockey", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x92"), "ice hockey", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x8d"), "lacrosse", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x93"), "ping pong", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb8"), "badminton", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x8a"), "boxing glove", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x8b"),
        "martial arts uniform",
        emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x85"), "goal net", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x9b\xb3"), "flag in hole", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x9b\xb8"), "ice skate", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa3"), "fishing pole", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa4\xbf"), "diving mask", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xbd"), "running shirt", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xbf"), "skis", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb7"), "sled", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x8c"), "curling stone", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xaf"), "direct hit", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x80"), "yo-yo", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x81"), "kite", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb1"), "pool 8 ball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xae"), "crystal ball", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x84"), "magic wand", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xbf"), "nazar amulet", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xae"), "video game", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb9"), "joystick", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb0"), "slot machine", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb2"), "game die", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa9"), "puzzle piece", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb8"), "teddy bear", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x85"), "piñata", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x86"), "nesting dolls", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x99\xa0"), "spade suit", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x99\xa5"), "heart suit", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x99\xa6"), "diamond suit", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x99\xa3"), "club suit", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xe2\x99\x9f"), "chess pawn", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x83\x8f"), "joker", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x80\x84"),
        "mahjong red dragon",
        emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb4"),
        "flower playing cards",
        emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xad"), "performing arts", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\xbc"), "framed picture", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa8"), "artist palette", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb5"), "thread", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa1"), "sewing needle", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb6"), "yarn", emoji::EmojiCategory::Activity},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa2"), "knot", emoji::EmojiCategory::Activity},
};

const std::vector<Emoji> emoji::Provider::travel = {
  // Travel
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x8d"),
        "globe showing Europe-Africa",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x8e"),
        "globe showing Americas",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x8f"),
        "globe showing Asia-Australia",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x90"),
        "globe with meridians",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xba"), "world map", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xbe"), "map of Japan", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xad"), "compass", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x94"),
        "snow-capped mountain",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xb0"), "mountain", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x8b"), "volcano", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xbb"), "mount fuji", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x95"), "camping", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x96"), "beach with umbrella", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x9c"), "desert", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x9d"), "desert island", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x9e"), "national park", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x9f"), "stadium", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x9b"), "classical building", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x97"),
        "building construction",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb1"), "brick", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa8"), "rock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xb5"), "wood", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x96"), "hut", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x98"), "houses", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x9a"), "derelict house", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa0"), "house", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa1"), "house with garden", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa2"), "office building", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa3"),
        "Japanese post office",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa4"), "post office", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa5"), "hospital", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa6"), "bank", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa8"), "hotel", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa9"), "love hotel", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xaa"), "convenience store", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xab"), "school", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xac"), "department store", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xad"), "factory", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xaf"), "Japanese castle", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb0"), "castle", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x92"), "wedding", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xbc"), "Tokyo tower", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xbd"), "Statue of Liberty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xaa"), "church", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x8c"), "mosque", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x95"), "hindu temple", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x8d"), "synagogue", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xa9"), "shinto shrine", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x8b"), "kaaba", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xb2"), "fountain", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xba"), "tent", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x81"), "foggy", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x83"), "night with stars", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x99"), "cityscape", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x84"),
        "sunrise over mountains",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x85"), "sunrise", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x86"), "cityscape at dusk", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x87"), "sunset", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x89"), "bridge at night", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x99\xa8"), "hot springs", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa0"), "carousel horse", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa1"), "ferris wheel", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa2"), "roller coaster", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x88"), "barber pole", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xaa"), "circus tent", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x82"), "locomotive", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x83"), "railway car", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x84"), "high-speed train", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x85"), "bullet train", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x86"), "train", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x87"), "metro", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x88"), "light rail", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x89"), "station", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x8a"), "tram", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x9d"), "monorail", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x9e"), "mountain railway", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x8b"), "tram car", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x8c"), "bus", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x8d"), "oncoming bus", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x8e"), "trolleybus", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x90"), "minibus", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x91"), "ambulance", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x92"), "fire engine", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x93"), "police car", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x94"), "oncoming police car", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x95"), "taxi", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x96"), "oncoming taxi", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x97"), "automobile", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x98"), "oncoming automobile", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x99"),
        "sport utility vehicle",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xbb"), "pickup truck", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x9a"), "delivery truck", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x9b"), "articulated lorry", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x9c"), "tractor", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8e"), "racing car", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x8d"), "motorcycle", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb5"), "motor scooter", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbd"), "manual wheelchair", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xbc"),
        "motorized wheelchair",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xba"), "auto rickshaw", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb2"), "bicycle", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb4"), "kick scooter", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb9"), "skateboard", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xbc"), "roller skate", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x8f"), "bus stop", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xa3"), "motorway", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xa4"), "railway track", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xa2"), "oil drum", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xbd"), "fuel pump", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa8"), "police car light", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa5"),
        "horizontal traffic light",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa6"),
        "vertical traffic light",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x91"), "stop sign", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa7"), "construction", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9a\x93"), "anchor", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xb5"), "sailboat", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb6"), "canoe", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa4"), "speedboat", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb3"), "passenger ship", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xb4"), "ferry", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xa5"), "motor boat", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa2"), "ship", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9c\x88"), "airplane", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xa9"), "small airplane", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xab"), "airplane departure", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xac"), "airplane arrival", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x82"), "parachute", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xba"), "seat", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x81"), "helicopter", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x9f"), "suspension railway", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa0"), "mountain cableway", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa1"), "aerial tramway", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb0"), "satellite", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\x80"), "rocket", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xb8"), "flying saucer", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8e"), "bellhop bell", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb3"), "luggage", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x8c\x9b"), "hourglass done", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x8f\xb3"), "hourglass not done", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x8c\x9a"), "watch", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x8f\xb0"), "alarm clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x8f\xb1"), "stopwatch", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x8f\xb2"), "timer clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb0"), "mantelpiece clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x9b"), "twelve o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa7"), "twelve-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x90"), "one o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x9c"), "one-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x91"), "two o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x9d"), "two-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x92"), "three o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x9e"), "three-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x93"), "four o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x9f"), "four-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x94"), "five o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa0"), "five-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x95"), "six o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa1"), "six-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x96"), "seven o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa2"), "seven-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x97"), "eight o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa3"), "eight-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x98"), "nine o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa4"), "nine-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x99"), "ten o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa5"), "ten-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x9a"), "eleven o’clock", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xa6"), "eleven-thirty", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x91"), "new moon", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x92"),
        "waxing crescent moon",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x93"), "first quarter moon", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x94"), "waxing gibbous moon", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x95"), "full moon", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x96"), "waning gibbous moon", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x97"), "last quarter moon", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x98"),
        "waning crescent moon",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x99"), "crescent moon", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x9a"), "new moon face", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x9b"),
        "first quarter moon face",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x9c"),
        "last quarter moon face",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa1"), "thermometer", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x98\x80"), "sun", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x9d"), "full moon face", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x9e"), "sun with face", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x90"), "ringed planet", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\xad\x90"), "star", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x9f"), "glowing star", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa0"), "shooting star", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x8c"), "milky way", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x98\x81"), "cloud", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\x85"), "sun behind cloud", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\x88"),
        "cloud with lightning and rain",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa4"),
        "sun behind small cloud",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa5"),
        "sun behind large cloud",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa6"),
        "sun behind rain cloud",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa7"), "cloud with rain", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa8"), "cloud with snow", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xa9"),
        "cloud with lightning",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xaa"), "tornado", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xab"), "fog", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\xac"), "wind face", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x80"), "cyclone", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x88"), "rainbow", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x82"), "closed umbrella", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x98\x82"), "umbrella", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x98\x94"),
        "umbrella with rain drops",
        emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\xb1"), "umbrella on ground", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9a\xa1"), "high voltage", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9d\x84"), "snowflake", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x98\x83"), "snowman", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x9b\x84"), "snowman without snow", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xe2\x98\x84"), "comet", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa5"), "fire", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa7"), "droplet", emoji::EmojiCategory::Travel},
  Emoji{QString::fromUtf8("\xf0\x9f\x8c\x8a"), "water wave", emoji::EmojiCategory::Travel},
};

const std::vector<Emoji> emoji::Provider::objects = {
  // Objects
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x93"), "glasses", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xb6"), "sunglasses", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xbd"), "goggles", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xbc"), "lab coat", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xba"), "safety vest", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x94"), "necktie", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x95"), "t-shirt", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x96"), "jeans", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa3"), "scarf", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa4"), "gloves", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa5"), "coat", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa6"), "socks", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x97"), "dress", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x98"), "kimono", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xbb"), "sari", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xb1"), "one-piece swimsuit", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xb2"), "briefs", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xb3"), "shorts", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x99"), "bikini", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x9a"), "woman’s clothes", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x9b"), "purse", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x9c"), "handbag", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x9d"), "clutch bag", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8d"), "shopping bags", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x92"), "backpack", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xb4"), "thong sandal", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x9e"), "man’s shoe", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x9f"), "running shoe", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xbe"), "hiking boot", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\xbf"), "flat shoe", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa0"), "high-heeled shoe", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa1"), "woman’s sandal", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xb0"), "ballet shoes", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\xa2"), "woman’s boot", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x91"), "crown", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x91\x92"), "woman’s hat", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa9"), "top hat", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x93"), "graduation cap", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xa2"), "billed cap", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x96"), "military helmet", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9b\x91"), "rescue worker’s helmet", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xbf"), "prayer beads", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x84"), "lipstick", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x8d"), "ring", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x8e"), "gem stone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x87"), "muted speaker", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x88"), "speaker low volume", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x89"),
        "speaker medium volume",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x8a"),
        "speaker high volume",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa2"), "loudspeaker", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa3"), "megaphone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xaf"), "postal horn", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x94"), "bell", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x95"), "bell with slash", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xbc"), "musical score", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb5"), "musical note", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb6"), "musical notes", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x99"), "studio microphone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x9a"), "level slider", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x9b"), "control knobs", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa4"), "microphone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa7"), "headphone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xbb"), "radio", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb7"), "saxophone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x97"), "accordion", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb8"), "guitar", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xb9"), "musical keyboard", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xba"), "trumpet", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xbb"), "violin", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x95"), "banjo", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa5\x81"), "drum", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x98"), "long drum", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb1"), "mobile phone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb2"),
        "mobile phone with arrow",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x98\x8e"), "telephone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x9e"), "telephone receiver", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x9f"), "pager", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa0"), "fax machine", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x8b"), "battery", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x8c"), "electric plug", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xbb"), "laptop", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\xa5"), "desktop computer", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\xa8"), "printer", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x8c\xa8"), "keyboard", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\xb1"), "computer mouse", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\xb2"), "trackball", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xbd"), "computer disk", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xbe"), "floppy disk", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xbf"), "optical disk", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x80"), "dvd", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xae"), "abacus", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa5"), "movie camera", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x9e"), "film frames", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xbd"), "film projector", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xac"), "clapper board", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xba"), "television", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb7"), "camera", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb8"), "camera with flash", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb9"), "video camera", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xbc"), "videocassette", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x8d"),
        "magnifying glass tilted left",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x8e"),
        "magnifying glass tilted right",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\xaf"), "candle", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa1"), "light bulb", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa6"), "flashlight", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xae"), "red paper lantern", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x94"), "diya lamp", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x94"),
        "notebook with decorative cover",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x95"), "closed book", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x96"), "open book", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x97"), "green book", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x98"), "blue book", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x99"), "orange book", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x9a"), "books", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x93"), "notebook", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x92"), "ledger", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x83"), "page with curl", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x9c"), "scroll", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x84"), "page facing up", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb0"), "newspaper", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x9e"),
        "rolled-up newspaper",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x91"), "bookmark tabs", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x96"), "bookmark", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb7"), "label", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb0"), "money bag", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x99"), "coin", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb4"), "yen banknote", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb5"), "dollar banknote", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb6"), "euro banknote", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb7"), "pound banknote", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb8"), "money with wings", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb3"), "credit card", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xbe"), "receipt", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb9"),
        "chart increasing with yen",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb1"), "currency exchange", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xb2"), "heavy dollar sign", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9c\x89"), "envelope", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa7"), "e-mail", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa8"), "incoming envelope", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa9"),
        "envelope with arrow",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa4"), "outbox tray", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa5"), "inbox tray", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa6"), "package", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xab"),
        "closed mailbox with raised flag",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xaa"),
        "closed mailbox with lowered flag",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xac"),
        "open mailbox with raised flag",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xad"),
        "open mailbox with lowered flag",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xae"), "postbox", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xb3"),
        "ballot box with ballot",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9c\x8f"), "pencil", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9c\x92"), "black nib", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x8b"), "fountain pen", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x8a"), "pen", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x8c"), "paintbrush", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x8d"), "crayon", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x9d"), "memo", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xbc"), "briefcase", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x81"), "file folder", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x82"), "open file folder", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x82"),
        "card index dividers",
        emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x85"), "calendar", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x86"), "tear-off calendar", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x92"), "spiral notepad", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x93"), "spiral calendar", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x87"), "card index", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x88"), "chart increasing", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x89"), "chart decreasing", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x8a"), "bar chart", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x8b"), "clipboard", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x8c"), "pushpin", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x8d"), "round pushpin", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x8e"), "paperclip", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x96\x87"), "linked paperclips", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x8f"), "straight ruler", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x90"), "triangular ruler", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9c\x82"), "scissors", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x83"), "card file box", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x84"), "file cabinet", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x91"), "wastebasket", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x92"), "locked", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x93"), "unlocked", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x8f"), "locked with pen", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x90"), "locked with key", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x91"), "key", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x9d"), "old key", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa8"), "hammer", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x93"), "axe", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9b\x8f"), "pick", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9a\x92"), "hammer and pick", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xa0"), "hammer and wrench", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xa1"), "dagger", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9a\x94"), "crossed swords", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xab"), "pistol", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x83"), "boomerang", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb9"), "bow and arrow", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\xa1"), "shield", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x9a"), "carpentry saw", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa7"), "wrench", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x9b"), "screwdriver", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa9"), "nut and bolt", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9a\x99"), "gear", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\x9c"), "clamp", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9a\x96"), "balance scale", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa6\xaf"), "probing cane", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x97"), "link", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9b\x93"), "chains", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x9d"), "hook", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb0"), "toolbox", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb2"), "magnet", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x9c"), "ladder", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9a\x97"), "alembic", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xaa"), "test tube", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xab"), "petri dish", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xac"), "dna", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xac"), "microscope", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xad"), "telescope", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xa1"), "satellite antenna", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x89"), "syringe", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xb8"), "drop of blood", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\x8a"), "pill", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xb9"), "adhesive bandage", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa9\xba"), "stethoscope", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xaa"), "door", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x97"), "elevator", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x9e"), "mirror", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x9f"), "window", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8f"), "bed", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x8b"), "couch and lamp", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x91"), "chair", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xbd"), "toilet", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa0"), "plunger", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xbf"), "shower", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x81"), "bathtub", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa4"), "mouse trap", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\x92"), "razor", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb4"), "lotion bottle", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb7"), "safety pin", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xb9"), "broom", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xba"), "basket", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xbb"), "roll of paper", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa3"), "bucket", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xbc"), "soap", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa5"), "toothbrush", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xbd"), "sponge", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xa7\xaf"), "fire extinguisher", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x92"), "shopping cart", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xac"), "cigarette", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9a\xb0"), "coffin", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa6"), "headstone", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xe2\x9a\xb1"), "funeral urn", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\x97\xbf"), "moai", emoji::EmojiCategory::Objects},
  Emoji{QString::fromUtf8("\xf0\x9f\xaa\xa7"), "placard", emoji::EmojiCategory::Objects},
};

const std::vector<Emoji> emoji::Provider::symbols = {
  // Symbols
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xa7"), "ATM sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xae"), "litter in bin sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb0"), "potable water", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\xbf"), "wheelchair symbol", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb9"), "men’s room", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xba"), "women’s room", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xbb"), "restroom", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xbc"), "baby symbol", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xbe"), "water closet", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x82"), "passport control", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x83"), "customs", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x84"), "baggage claim", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x85"), "left luggage", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9a\xa0"), "warning", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb8"), "children crossing", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9b\x94"), "no entry", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xab"), "prohibited", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb3"), "no bicycles", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xad"), "no smoking", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xaf"), "no littering", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb1"), "non-potable water", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xb7"), "no pedestrians", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb5"), "no mobile phones", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x9e"),
        "no one under eighteen",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\xa2"), "radioactive", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\xa3"), "biohazard", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xac\x86"), "up arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\x97"), "up-right arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9e\xa1"), "right arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\x98"), "down-right arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xac\x87"), "down arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\x99"), "down-left arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xac\x85"), "left arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\x96"), "up-left arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\x95"), "up-down arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\x94"), "left-right arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\xa9"),
        "right arrow curving left",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x86\xaa"),
        "left arrow curving right",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xa4\xb4"), "right arrow curving up", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xa4\xb5"),
        "right arrow curving down",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x83"),
        "clockwise vertical arrows",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x84"),
        "counterclockwise arrows button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x99"), "BACK arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x9a"), "END arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x9b"), "ON! arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x9c"), "SOON arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x9d"), "TOP arrow", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9b\x90"), "place of worship", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9a\x9b"), "atom symbol", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x89"), "om", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9c\xa1"), "star of David", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\xb8"), "wheel of dharma", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\xaf"), "yin yang", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9c\x9d"), "latin cross", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\xa6"), "orthodox cross", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\xaa"), "star and crescent", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\xae"), "peace symbol", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x95\x8e"), "menorah", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xaf"),
        "dotted six-pointed star",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x88"), "Aries", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x89"), "Taurus", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x8a"), "Gemini", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x8b"), "Cancer", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x8c"), "Leo", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x8d"), "Virgo", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x8e"), "Libra", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x8f"), "Scorpio", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x90"), "Sagittarius", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x91"), "Capricorn", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x92"), "Aquarius", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x93"), "Pisces", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9b\x8e"), "Ophiuchus", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x80"),
        "shuffle tracks button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x81"), "repeat button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x82"),
        "repeat single button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x96\xb6"), "play button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xa9"), "fast-forward button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xad"), "next track button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xaf"), "play or pause button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x97\x80"), "reverse button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xaa"), "fast reverse button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xae"), "last track button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xbc"), "upwards button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xab"), "fast up button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xbd"), "downwards button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xac"), "fast down button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xb8"), "pause button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xb9"), "stop button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\xba"), "record button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x8f\x8f"), "eject button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\xa6"), "cinema", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x85"), "dim button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x86"), "bright button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb6"), "antenna bars", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb3"), "vibration mode", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\xb4"), "mobile phone off", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x80"), "female sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\x82"), "male sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9a\xa7"), "transgender symbol", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9a\x95"), "medical symbol", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\xbe"), "infinity", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x99\xbb"), "recycling symbol", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9a\x9c"), "fleur-de-lis", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb1"), "trident emblem", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x93\x9b"), "name badge", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb0"),
        "Japanese symbol for beginner",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xad\x95"), "hollow red circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9c\x85"), "check mark button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x98\x91"), "check box with check", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9c\x94"), "check mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9c\x96"), "multiplication sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9d\x8c"), "cross mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9d\x8e"), "cross mark button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9e\x95"), "plus sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9e\x96"), "minus sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9e\x97"), "division sign", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9e\xb0"), "curly loop", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9e\xbf"), "double curly loop", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe3\x80\xbd"), "part alternation mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9c\xb3"), "eight-spoked asterisk", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9c\xb4"), "eight-pointed star", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9d\x87"), "sparkle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x80\xbc"),
        "double exclamation mark",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x81\x89"),
        "exclamation question mark",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9d\x93"), "question mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9d\x94"), "white question mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9d\x95"), "white exclamation mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9d\x97"), "exclamation mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe3\x80\xb0"), "wavy dash", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xc2\xa9"), "copyright", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xc2\xae"), "registered", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x84\xa2"), "trade mark", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("#\xef\xb8\x8f\xe2\x83\xa3"), "keycap: #", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("#\xe2\x83\xa3"), "keycap: #", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("*\xef\xb8\x8f\xe2\x83\xa3"), "keycap: *", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("*\xe2\x83\xa3"), "keycap: *", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("0\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 0", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("0\xe2\x83\xa3"), "keycap: 0", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("1\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 1", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("1\xe2\x83\xa3"), "keycap: 1", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("2\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 2", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("2\xe2\x83\xa3"), "keycap: 2", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("3\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 3", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("3\xe2\x83\xa3"), "keycap: 3", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("4\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 4", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("4\xe2\x83\xa3"), "keycap: 4", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("5\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 5", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("5\xe2\x83\xa3"), "keycap: 5", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("6\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 6", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("6\xe2\x83\xa3"), "keycap: 6", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("7\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 7", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("7\xe2\x83\xa3"), "keycap: 7", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("8\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 8", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("8\xe2\x83\xa3"), "keycap: 8", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("9\xef\xb8\x8f\xe2\x83\xa3"), "keycap: 9", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("9\xe2\x83\xa3"), "keycap: 9", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x9f"), "keycap: 10", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa0"),
        "input latin uppercase",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa1"),
        "input latin lowercase",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa2"), "input numbers", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa3"), "input symbols", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xa4"),
        "input latin letters",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x85\xb0"),
        "A button (blood type)",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x8e"),
        "AB button (blood type)",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x85\xb1"),
        "B button (blood type)",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x91"), "CL button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x92"), "COOL button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x93"), "FREE button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x84\xb9"), "information", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x94"), "ID button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x93\x82"), "circled M", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x95"), "NEW button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x96"), "NG button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x85\xbe"),
        "O button (blood type)",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x97"), "OK button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x85\xbf"), "P button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x98"), "SOS button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x99"), "UP! button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x86\x9a"), "VS button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\x81"),
        "Japanese “here” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\x82"),
        "Japanese “service charge” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb7"),
        "Japanese “monthly amount” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb6"),
        "Japanese “not free of charge” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xaf"),
        "Japanese “reserved” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x89\x90"),
        "Japanese “bargain” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb9"),
        "Japanese “discount” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\x9a"),
        "Japanese “free of charge” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb2"),
        "Japanese “prohibited” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x89\x91"),
        "Japanese “acceptable” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb8"),
        "Japanese “application” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb4"),
        "Japanese “passing grade” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb3"),
        "Japanese “vacancy” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe3\x8a\x97"),
        "Japanese “congratulations” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe3\x8a\x99"),
        "Japanese “secret” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xba"),
        "Japanese “open for business” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x88\xb5"),
        "Japanese “no vacancy” button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb4"), "red circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa0"), "orange circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa1"), "yellow circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa2"), "green circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb5"), "blue circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa3"), "purple circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa4"), "brown circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9a\xab"), "black circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x9a\xaa"), "white circle", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa5"), "red square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa7"), "orange square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa8"), "yellow square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa9"), "green square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xa6"), "blue square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xaa"), "purple square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x9f\xab"), "brown square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xac\x9b"), "black large square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\xac\x9c"), "white large square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x97\xbc"), "black medium square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x97\xbb"), "white medium square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x97\xbe"),
        "black medium-small square",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x97\xbd"),
        "white medium-small square",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x96\xaa"), "black small square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xe2\x96\xab"), "white small square", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb6"),
        "large orange diamond",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb7"), "large blue diamond", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb8"),
        "small orange diamond",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb9"), "small blue diamond", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xba"),
        "red triangle pointed up",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xbb"),
        "red triangle pointed down",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x92\xa0"), "diamond with a dot", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\x98"), "radio button", emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb3"),
        "white square button",
        emoji::EmojiCategory::Symbols},
  Emoji{QString::fromUtf8("\xf0\x9f\x94\xb2"),
        "black square button",
        emoji::EmojiCategory::Symbols},
};

const std::vector<Emoji> emoji::Provider::flags = {
  // Flags
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\x81"), "chequered flag", emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x9a\xa9"), "triangular flag", emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8e\x8c"), "crossed flags", emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb4"), "black flag", emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb3"), "white flag", emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb3\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x8c\x88"),
        "rainbow flag",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb3\xe2\x80\x8d\xf0\x9f\x8c\x88"),
        "rainbow flag",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb3\xef\xb8\x8f\xe2\x80\x8d\xe2\x9a\xa7"),
        "transgender flag",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb3\xe2\x80\x8d\xe2\x9a\xa7"),
        "transgender flag",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb4\xe2\x80\x8d\xe2\x98\xa0"),
        "pirate flag",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xa8"),
        "flag: Ascension Island",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xa9"),
        "flag: Andorra",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xaa"),
        "flag: United Arab Emirates",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xab"),
        "flag: Afghanistan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xac"),
        "flag: Antigua & Barbuda",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xae"),
        "flag: Anguilla",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xb1"),
        "flag: Albania",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xb2"),
        "flag: Armenia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xb4"),
        "flag: Angola",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xb6"),
        "flag: Antarctica",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xb7"),
        "flag: Argentina",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xb8"),
        "flag: American Samoa",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xb9"),
        "flag: Austria",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xba"),
        "flag: Australia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xbc"),
        "flag: Aruba",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xbd"),
        "flag: Åland Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa6\xf0\x9f\x87\xbf"),
        "flag: Azerbaijan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xa6"),
        "flag: Bosnia & Herzegovina",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xa7"),
        "flag: Barbados",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xa9"),
        "flag: Bangladesh",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xaa"),
        "flag: Belgium",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xab"),
        "flag: Burkina Faso",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xac"),
        "flag: Bulgaria",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xad"),
        "flag: Bahrain",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xae"),
        "flag: Burundi",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xaf"),
        "flag: Benin",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb1"),
        "flag: St. Barthélemy",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb2"),
        "flag: Bermuda",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb3"),
        "flag: Brunei",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb4"),
        "flag: Bolivia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb6"),
        "flag: Caribbean Netherlands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb7"),
        "flag: Brazil",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb8"),
        "flag: Bahamas",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xb9"),
        "flag: Bhutan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xbb"),
        "flag: Bouvet Island",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xbc"),
        "flag: Botswana",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xbe"),
        "flag: Belarus",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa7\xf0\x9f\x87\xbf"),
        "flag: Belize",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xa6"),
        "flag: Canada",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xa8"),
        "flag: Cocos (Keeling) Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xa9"),
        "flag: Congo - Kinshasa",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xab"),
        "flag: Central African Republic",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xac"),
        "flag: Congo - Brazzaville",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xad"),
        "flag: Switzerland",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xae"),
        "flag: Côte d’Ivoire",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xb0"),
        "flag: Cook Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xb1"),
        "flag: Chile",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xb2"),
        "flag: Cameroon",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xb3"),
        "flag: China",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xb4"),
        "flag: Colombia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xb5"),
        "flag: Clipperton Island",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xb7"),
        "flag: Costa Rica",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xba"),
        "flag: Cuba",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xbb"),
        "flag: Cape Verde",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xbc"),
        "flag: Curaçao",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xbd"),
        "flag: Christmas Island",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xbe"),
        "flag: Cyprus",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa8\xf0\x9f\x87\xbf"),
        "flag: Czechia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa9\xf0\x9f\x87\xaa"),
        "flag: Germany",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa9\xf0\x9f\x87\xac"),
        "flag: Diego Garcia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa9\xf0\x9f\x87\xaf"),
        "flag: Djibouti",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa9\xf0\x9f\x87\xb0"),
        "flag: Denmark",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa9\xf0\x9f\x87\xb2"),
        "flag: Dominica",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa9\xf0\x9f\x87\xb4"),
        "flag: Dominican Republic",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xa9\xf0\x9f\x87\xbf"),
        "flag: Algeria",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xa6"),
        "flag: Ceuta & Melilla",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xa8"),
        "flag: Ecuador",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xaa"),
        "flag: Estonia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xac"),
        "flag: Egypt",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xad"),
        "flag: Western Sahara",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xb7"),
        "flag: Eritrea",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xb8"),
        "flag: Spain",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xb9"),
        "flag: Ethiopia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaa\xf0\x9f\x87\xba"),
        "flag: European Union",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xab\xf0\x9f\x87\xae"),
        "flag: Finland",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xab\xf0\x9f\x87\xaf"),
        "flag: Fiji",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xab\xf0\x9f\x87\xb0"),
        "flag: Falkland Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xab\xf0\x9f\x87\xb2"),
        "flag: Micronesia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xab\xf0\x9f\x87\xb4"),
        "flag: Faroe Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xab\xf0\x9f\x87\xb7"),
        "flag: France",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xa6"),
        "flag: Gabon",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xa7"),
        "flag: United Kingdom",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xa9"),
        "flag: Grenada",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xaa"),
        "flag: Georgia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xab"),
        "flag: French Guiana",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xac"),
        "flag: Guernsey",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xad"),
        "flag: Ghana",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xae"),
        "flag: Gibraltar",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb1"),
        "flag: Greenland",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb2"),
        "flag: Gambia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb3"),
        "flag: Guinea",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb5"),
        "flag: Guadeloupe",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb6"),
        "flag: Equatorial Guinea",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb7"),
        "flag: Greece",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb8"),
        "flag: South Georgia & South Sandwich Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xb9"),
        "flag: Guatemala",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xba"),
        "flag: Guam",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xbc"),
        "flag: Guinea-Bissau",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xac\xf0\x9f\x87\xbe"),
        "flag: Guyana",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xad\xf0\x9f\x87\xb0"),
        "flag: Hong Kong SAR China",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xad\xf0\x9f\x87\xb2"),
        "flag: Heard & McDonald Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xad\xf0\x9f\x87\xb3"),
        "flag: Honduras",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xad\xf0\x9f\x87\xb7"),
        "flag: Croatia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xad\xf0\x9f\x87\xb9"),
        "flag: Haiti",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xad\xf0\x9f\x87\xba"),
        "flag: Hungary",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xa8"),
        "flag: Canary Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xa9"),
        "flag: Indonesia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xaa"),
        "flag: Ireland",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb1"),
        "flag: Israel",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb2"),
        "flag: Isle of Man",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb3"),
        "flag: India",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb4"),
        "flag: British Indian Ocean Territory",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb6"),
        "flag: Iraq",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb7"),
        "flag: Iran",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb8"),
        "flag: Iceland",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xae\xf0\x9f\x87\xb9"),
        "flag: Italy",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaf\xf0\x9f\x87\xaa"),
        "flag: Jersey",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaf\xf0\x9f\x87\xb2"),
        "flag: Jamaica",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaf\xf0\x9f\x87\xb4"),
        "flag: Jordan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xaf\xf0\x9f\x87\xb5"),
        "flag: Japan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xaa"),
        "flag: Kenya",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xac"),
        "flag: Kyrgyzstan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xad"),
        "flag: Cambodia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xae"),
        "flag: Kiribati",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xb2"),
        "flag: Comoros",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xb3"),
        "flag: St. Kitts & Nevis",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xb5"),
        "flag: North Korea",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xb7"),
        "flag: South Korea",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xbc"),
        "flag: Kuwait",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xbe"),
        "flag: Cayman Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb0\xf0\x9f\x87\xbf"),
        "flag: Kazakhstan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xa6"),
        "flag: Laos",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xa7"),
        "flag: Lebanon",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xa8"),
        "flag: St. Lucia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xae"),
        "flag: Liechtenstein",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xb0"),
        "flag: Sri Lanka",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xb7"),
        "flag: Liberia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xb8"),
        "flag: Lesotho",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xb9"),
        "flag: Lithuania",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xba"),
        "flag: Luxembourg",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xbb"),
        "flag: Latvia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb1\xf0\x9f\x87\xbe"),
        "flag: Libya",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xa6"),
        "flag: Morocco",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xa8"),
        "flag: Monaco",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xa9"),
        "flag: Moldova",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xaa"),
        "flag: Montenegro",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xab"),
        "flag: St. Martin",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xac"),
        "flag: Madagascar",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xad"),
        "flag: Marshall Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb0"),
        "flag: North Macedonia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb1"),
        "flag: Mali",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb2"),
        "flag: Myanmar (Burma)",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb3"),
        "flag: Mongolia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb4"),
        "flag: Macao SAR China",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb5"),
        "flag: Northern Mariana Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb6"),
        "flag: Martinique",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb7"),
        "flag: Mauritania",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb8"),
        "flag: Montserrat",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xb9"),
        "flag: Malta",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xba"),
        "flag: Mauritius",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xbb"),
        "flag: Maldives",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xbc"),
        "flag: Malawi",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xbd"),
        "flag: Mexico",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xbe"),
        "flag: Malaysia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb2\xf0\x9f\x87\xbf"),
        "flag: Mozambique",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xa6"),
        "flag: Namibia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xa8"),
        "flag: New Caledonia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xaa"),
        "flag: Niger",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xab"),
        "flag: Norfolk Island",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xac"),
        "flag: Nigeria",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xae"),
        "flag: Nicaragua",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xb1"),
        "flag: Netherlands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xb4"),
        "flag: Norway",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xb5"),
        "flag: Nepal",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xb7"),
        "flag: Nauru",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xba"),
        "flag: Niue",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb3\xf0\x9f\x87\xbf"),
        "flag: New Zealand",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb4\xf0\x9f\x87\xb2"),
        "flag: Oman",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xa6"),
        "flag: Panama",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xaa"),
        "flag: Peru",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xab"),
        "flag: French Polynesia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xac"),
        "flag: Papua New Guinea",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xad"),
        "flag: Philippines",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xb0"),
        "flag: Pakistan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xb1"),
        "flag: Poland",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xb2"),
        "flag: St. Pierre & Miquelon",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xb3"),
        "flag: Pitcairn Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xb7"),
        "flag: Puerto Rico",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xb8"),
        "flag: Palestinian Territories",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xb9"),
        "flag: Portugal",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xbc"),
        "flag: Palau",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb5\xf0\x9f\x87\xbe"),
        "flag: Paraguay",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb6\xf0\x9f\x87\xa6"),
        "flag: Qatar",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb7\xf0\x9f\x87\xaa"),
        "flag: Réunion",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb7\xf0\x9f\x87\xb4"),
        "flag: Romania",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb7\xf0\x9f\x87\xb8"),
        "flag: Serbia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb7\xf0\x9f\x87\xba"),
        "flag: Russia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb7\xf0\x9f\x87\xbc"),
        "flag: Rwanda",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xa6"),
        "flag: Saudi Arabia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xa7"),
        "flag: Solomon Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xa8"),
        "flag: Seychelles",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xa9"),
        "flag: Sudan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xaa"),
        "flag: Sweden",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xac"),
        "flag: Singapore",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xad"),
        "flag: St. Helena",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xae"),
        "flag: Slovenia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xaf"),
        "flag: Svalbard & Jan Mayen",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb0"),
        "flag: Slovakia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb1"),
        "flag: Sierra Leone",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb2"),
        "flag: San Marino",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb3"),
        "flag: Senegal",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb4"),
        "flag: Somalia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb7"),
        "flag: Suriname",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb8"),
        "flag: South Sudan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xb9"),
        "flag: São Tomé & Príncipe",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xbb"),
        "flag: El Salvador",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xbd"),
        "flag: Sint Maarten",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xbe"),
        "flag: Syria",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb8\xf0\x9f\x87\xbf"),
        "flag: Eswatini",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xa6"),
        "flag: Tristan da Cunha",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xa8"),
        "flag: Turks & Caicos Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xa9"),
        "flag: Chad",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xab"),
        "flag: French Southern Territories",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xac"),
        "flag: Togo",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xad"),
        "flag: Thailand",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xaf"),
        "flag: Tajikistan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xb0"),
        "flag: Tokelau",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xb1"),
        "flag: Timor-Leste",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xb2"),
        "flag: Turkmenistan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xb3"),
        "flag: Tunisia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xb4"),
        "flag: Tonga",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xb7"),
        "flag: Turkey",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xb9"),
        "flag: Trinidad & Tobago",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xbb"),
        "flag: Tuvalu",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xbc"),
        "flag: Taiwan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xb9\xf0\x9f\x87\xbf"),
        "flag: Tanzania",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xba\xf0\x9f\x87\xa6"),
        "flag: Ukraine",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xba\xf0\x9f\x87\xac"),
        "flag: Uganda",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xba\xf0\x9f\x87\xb2"),
        "flag: U.S. Outlying Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xba\xf0\x9f\x87\xb3"),
        "flag: United Nations",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xba\xf0\x9f\x87\xb8"),
        "flag: United States",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xba\xf0\x9f\x87\xbe"),
        "flag: Uruguay",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xba\xf0\x9f\x87\xbf"),
        "flag: Uzbekistan",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbb\xf0\x9f\x87\xa6"),
        "flag: Vatican City",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbb\xf0\x9f\x87\xa8"),
        "flag: St. Vincent & Grenadines",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbb\xf0\x9f\x87\xaa"),
        "flag: Venezuela",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbb\xf0\x9f\x87\xac"),
        "flag: British Virgin Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbb\xf0\x9f\x87\xae"),
        "flag: U.S. Virgin Islands",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbb\xf0\x9f\x87\xb3"),
        "flag: Vietnam",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbb\xf0\x9f\x87\xba"),
        "flag: Vanuatu",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbc\xf0\x9f\x87\xab"),
        "flag: Wallis & Futuna",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbc\xf0\x9f\x87\xb8"),
        "flag: Samoa",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbd\xf0\x9f\x87\xb0"),
        "flag: Kosovo",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbe\xf0\x9f\x87\xaa"),
        "flag: Yemen",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbe\xf0\x9f\x87\xb9"),
        "flag: Mayotte",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbf\xf0\x9f\x87\xa6"),
        "flag: South Africa",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbf\xf0\x9f\x87\xb2"),
        "flag: Zambia",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x87\xbf\xf0\x9f\x87\xbc"),
        "flag: Zimbabwe",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xa5\xf3\xa0"
                          "\x81\xae\xf3\xa0\x81\xa7\xf3\xa0\x81\xbf"),
        "flag: England",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xb3\xf3\xa0"
                          "\x81\xa3\xf3\xa0\x81\xb4\xf3\xa0\x81\xbf"),
        "flag: Scotland",
        emoji::EmojiCategory::Flags},
  Emoji{QString::fromUtf8("\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xb7\xf3\xa0"
                          "\x81\xac\xf3\xa0\x81\xb3\xf3\xa0\x81\xbf"),
        "flag: Wales",
        emoji::EmojiCategory::Flags},
};
