-- the polynomial is the 3x3x3 degree 4 Strassen Invariant
xx = 5
aa = 2
bb = 2
cc = 2

Ra = QQ[a_(0,0)..a_(aa,xx)] -- ring on  A times CC^d
Rb = QQ[b_(0,0)..b_(bb,xx)] -- ring on  B times CC^d
Rc = QQ[c_(0,0)..c_(cc,xx)] -- ring on  C times CC^d
Rx = QQ[x_(0,0,0)..x_(aa,bb,cc)] -- ring on A \otimes B\otimes C
R = Ra**Rb**Rc**Rx  -- big ring


-- the following matrices should have their column indices be determined by the
--  columns of some triple of tableaux, and ideally there should be a function that makes
--  them dynamically
A1= matrix apply(3,i -> apply({0,1,2}, j-> a_(i,j) ))
A2= matrix apply(3,i -> apply({3,4,5}, j-> a_(i,j) ))


B1= matrix apply(3,i -> apply({0,2,4}, j-> b_(i,j) ))
B2= matrix apply(3,i -> apply({1,3,5}, j-> b_(i,j) ))

C1= matrix apply(3,i -> apply({0,1,3}, j-> c_(i,j) ))
C2= matrix apply(3,i -> apply({2,4,5}, j-> c_(i,j) ))

-- this should be held as a product and not expanded for larger problems
time T = det(A1)*det(A2)*det(B1)*det(B2)*det(C1)*det(C2);
F=T;
size T
time for d from 0 to xx do( print(size F); F= sum(cc+1,k-> sum(bb+1, j-> sum(cc+1,i->x_(i,j,k)*diff(a_(i,d)*b_(j,d)*c_(k,d),F))));)
size F
toString F

-6*x_(0,2,2)^2*x_(1,1,1)^2*x_(2,0,0)^2+12*x_(0,2,1)*x_(0,2,2)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)^2-6*x_(0,2,1)^2*x_(1,1,2)^2*x_(2,0,0)^2+12*x_(0,1,2)*x_(0,2,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)^2+12*x_(0,1,2)*x_(0,2,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)^2-24*x_(0,1,1)*x_(0,2,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)^2-6*x_(0,1,2)^2*x_(1,2,1)^2*x_(2,0,0)^2-24*x_(0,1,2)*x_(0,2,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)^2+12*x_(0,1,1)*x_(0,2,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)^2+12*x_(0,1,1)*x_(0,2,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)^2+12*x_(0,1,1)*x_(0,1,2)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)^2-6*x_(0,1,1)^2*x_(1,2,2)^2*x_(2,0,0)^2+12*x_(0,2,2)^2*x_(1,1,0)*x_(1,1,1)*x_(2,0,0)*x_(2,0,1)-12*x_(0,2,1)*x_(0,2,2)*x_(1,1,0)*x_(1,1,2)*x_(2,0,0)*x_(2,0,1)-12*x_(0,2,0)*x_(0,2,2)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,0,1)+12*x_(0,2,0)*x_(0,2,1)*x_(1,1,2)^2*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,2)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,2)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,0,1)+24*x_(0,1,1)*x_(0,2,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,2)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,2)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,0,1)+24*x_(0,1,0)*x_(0,2,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,0,1)+12*x_(0,1,2)^2*x_(1,2,0)*x_(1,2,1)*x_(2,0,0)*x_(2,0,1)+24*x_(0,1,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)+24*x_(0,1,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,1)*x_(0,1,2)*x_(1,2,0)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)-12*x_(0,1,0)*x_(0,1,2)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,0,1)+12*x_(0,1,0)*x_(0,1,1)*x_(1,2,2)^2*x_(2,0,0)*x_(2,0,1)-6*x_(0,2,2)^2*x_(1,1,0)^2*x_(2,0,1)^2+12*x_(0,2,0)*x_(0,2,2)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)^2-6*x_(0,2,0)^2*x_(1,1,2)^2*x_(2,0,1)^2+12*x_(0,1,2)*x_(0,2,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)^2+12*x_(0,1,2)*x_(0,2,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)^2-24*x_(0,1,0)*x_(0,2,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)^2-6*x_(0,1,2)^2*x_(1,2,0)^2*x_(2,0,1)^2-24*x_(0,1,2)*x_(0,2,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)^2+12*x_(0,1,0)*x_(0,2,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)^2+12*x_(0,1,0)*x_(0,2,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,1)^2+12*x_(0,1,0)*x_(0,1,2)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)^2-6*x_(0,1,0)^2*x_(1,2,2)^2*x_(2,0,1)^2-12*x_(0,2,1)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,0)*x_(2,0,2)+12*x_(0,2,0)*x_(0,2,2)*x_(1,1,1)^2*x_(2,0,0)*x_(2,0,2)+12*x_(0,2,1)^2*x_(1,1,0)*x_(1,1,2)*x_(2,0,0)*x_(2,0,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,0,2)+24*x_(0,1,2)*x_(0,2,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,1)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,1)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,0,2)+24*x_(0,1,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,0,2)+24*x_(0,1,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,1)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,0)*x_(2,0,2)+12*x_(0,1,0)*x_(0,1,2)*x_(1,2,1)^2*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,1)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,1)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,0,2)+24*x_(0,1,0)*x_(0,2,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,0,2)+12*x_(0,1,1)^2*x_(1,2,0)*x_(1,2,2)*x_(2,0,0)*x_(2,0,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,0,2)+12*x_(0,2,1)*x_(0,2,2)*x_(1,1,0)^2*x_(2,0,1)*x_(2,0,2)-12*x_(0,2,0)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,1)*x_(2,0,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)*x_(2,0,2)+12*x_(0,2,0)^2*x_(1,1,1)*x_(1,1,2)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,0,2)+24*x_(0,1,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,0,2)+24*x_(0,1,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,0,2)+12*x_(0,1,1)*x_(0,1,2)*x_(1,2,0)^2*x_(2,0,1)*x_(2,0,2)+24*x_(0,1,2)*x_(0,2,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,0)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,0)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,0)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,1)*x_(2,0,2)+24*x_(0,1,1)*x_(0,2,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,0)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,0)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,1)*x_(2,0,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)*x_(2,0,2)+12*x_(0,1,0)^2*x_(1,2,1)*x_(1,2,2)*x_(2,0,1)*x_(2,0,2)-6*x_(0,2,1)^2*x_(1,1,0)^2*x_(2,0,2)^2+12*x_(0,2,0)*x_(0,2,1)*x_(1,1,0)*x_(1,1,1)*x_(2,0,2)^2-6*x_(0,2,0)^2*x_(1,1,1)^2*x_(2,0,2)^2+12*x_(0,1,1)*x_(0,2,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,2)^2+12*x_(0,1,1)*x_(0,2,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)^2-24*x_(0,1,0)*x_(0,2,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)^2-6*x_(0,1,1)^2*x_(1,2,0)^2*x_(2,0,2)^2-24*x_(0,1,1)*x_(0,2,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)^2+12*x_(0,1,0)*x_(0,2,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)^2+12*x_(0,1,0)*x_(0,2,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,2)^2+12*x_(0,1,0)*x_(0,1,1)*x_(1,2,0)*x_(1,2,1)*x_(2,0,2)^2-6*x_(0,1,0)^2*x_(1,2,1)^2*x_(2,0,2)^2+12*x_(0,2,2)^2*x_(1,0,1)*x_(1,1,1)*x_(2,0,0)*x_(2,1,0)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,1,0)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,1,0)+12*x_(0,2,1)^2*x_(1,0,2)*x_(1,1,2)*x_(2,0,0)*x_(2,1,0)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,1)*x_(1,2,1)*x_(2,0,0)*x_(2,1,0)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,0)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,0)-12*x_(0,0,2)*x_(0,2,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,1,0)-12*x_(0,0,2)*x_(0,2,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,0)+24*x_(0,0,1)*x_(0,2,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,0)+12*x_(0,0,2)*x_(0,1,2)*x_(1,2,1)^2*x_(2,0,0)*x_(2,1,0)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,2)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)+24*x_(0,0,2)*x_(0,2,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)-12*x_(0,0,1)*x_(0,2,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)-12*x_(0,0,1)*x_(0,2,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)-12*x_(0,0,2)*x_(0,1,1)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)-12*x_(0,0,1)*x_(0,1,2)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,0)+12*x_(0,0,1)*x_(0,1,1)*x_(1,2,2)^2*x_(2,0,0)*x_(2,1,0)+12*x_(0,2,2)^2*x_(1,0,1)*x_(1,1,0)*x_(2,0,1)*x_(2,1,0)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,1,0)-24*x_(0,2,2)^2*x_(1,0,0)*x_(1,1,1)*x_(2,0,1)*x_(2,1,0)+24*x_(0,2,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,0,1)*x_(2,1,0)+24*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,1)*x_(2,1,0)+60*x_(0,1,2)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,0)-48*x_(0,1,1)*x_(0,2,2)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,0)+24*x_(0,0,2)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,1,0)-48*x_(0,0,2)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,0)+24*x_(0,0,1)*x_(0,2,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,0)+24*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,0)-48*x_(0,1,2)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,0,1)*x_(2,1,0)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,2)*x_(1,2,1)*x_(2,0,1)*x_(2,1,0)-12*x_(0,0,2)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,0)+60*x_(0,0,2)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,1)*x_(2,1,0)-48*x_(0,0,0)*x_(0,2,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,1)*x_(2,1,0)-12*x_(0,0,2)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,0)-48*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)-48*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,0,2)*x_(0,1,1)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,0,1)*x_(0,1,2)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)-12*x_(0,0,2)*x_(0,1,0)*x_(1,2,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+24*x_(0,0,0)*x_(0,1,2)*x_(1,2,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,0)+12*x_(0,0,1)*x_(0,1,0)*x_(1,2,2)^2*x_(2,0,1)*x_(2,1,0)-24*x_(0,0,0)*x_(0,1,1)*x_(1,2,2)^2*x_(2,0,1)*x_(2,1,0)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,1,0)+12*x_(0,2,1)^2*x_(1,0,2)*x_(1,1,0)*x_(2,0,2)*x_(2,1,0)+24*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,1,0)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,0,2)*x_(2,1,0)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,0,2)*x_(2,1,0)-24*x_(0,2,1)^2*x_(1,0,0)*x_(1,1,2)*x_(2,0,2)*x_(2,1,0)+24*x_(0,2,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,0,2)*x_(2,1,0)-48*x_(0,1,2)*x_(0,2,1)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,0)+60*x_(0,1,1)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,0)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,2)*x_(2,1,0)+24*x_(0,0,2)*x_(0,2,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,0)-48*x_(0,0,1)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,0)+24*x_(0,0,1)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,2)*x_(2,1,0)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)-48*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)-12*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)+24*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)-12*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)+24*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)-48*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)+24*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)-12*x_(0,0,2)*x_(0,1,1)*x_(1,2,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)+24*x_(0,0,1)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,0)+12*x_(0,0,2)*x_(0,1,0)*x_(1,2,1)^2*x_(2,0,2)*x_(2,1,0)-24*x_(0,0,0)*x_(0,1,2)*x_(1,2,1)^2*x_(2,0,2)*x_(2,1,0)+24*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)-48*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)-12*x_(0,0,1)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)+60*x_(0,0,1)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)-48*x_(0,0,0)*x_(0,2,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)-12*x_(0,0,1)*x_(0,1,1)*x_(1,2,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)-12*x_(0,0,1)*x_(0,1,0)*x_(1,2,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)+24*x_(0,0,0)*x_(0,1,1)*x_(1,2,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,0)-6*x_(0,2,2)^2*x_(1,0,1)^2*x_(2,1,0)^2+12*x_(0,2,1)*x_(0,2,2)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)^2-6*x_(0,2,1)^2*x_(1,0,2)^2*x_(2,1,0)^2+12*x_(0,0,2)*x_(0,2,2)*x_(1,0,1)*x_(1,2,1)*x_(2,1,0)^2+12*x_(0,0,2)*x_(0,2,1)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)^2-24*x_(0,0,1)*x_(0,2,2)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)^2-6*x_(0,0,2)^2*x_(1,2,1)^2*x_(2,1,0)^2-24*x_(0,0,2)*x_(0,2,1)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)^2+12*x_(0,0,1)*x_(0,2,2)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)^2+12*x_(0,0,1)*x_(0,2,1)*x_(1,0,2)*x_(1,2,2)*x_(2,1,0)^2+12*x_(0,0,1)*x_(0,0,2)*x_(1,2,1)*x_(1,2,2)*x_(2,1,0)^2-6*x_(0,0,1)^2*x_(1,2,2)^2*x_(2,1,0)^2-24*x_(0,2,2)^2*x_(1,0,1)*x_(1,1,0)*x_(2,0,0)*x_(2,1,1)+24*x_(0,2,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,0,0)*x_(2,1,1)+12*x_(0,2,2)^2*x_(1,0,0)*x_(1,1,1)*x_(2,0,0)*x_(2,1,1)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,1,1)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,1,1)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,1,2)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,0)*x_(2,1,1)-48*x_(0,1,2)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,0)*x_(2,1,1)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,2)*x_(1,2,0)*x_(2,0,0)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,1,1)+60*x_(0,0,2)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,1,1)-48*x_(0,0,1)*x_(0,2,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,1,1)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,1)+60*x_(0,1,2)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,1)-48*x_(0,1,0)*x_(0,2,2)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,1)+24*x_(0,0,2)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,1)-48*x_(0,0,2)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,1)+24*x_(0,0,0)*x_(0,2,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,1)-12*x_(0,0,2)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,1)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-48*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-48*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-12*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-12*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-12*x_(0,0,2)*x_(0,1,1)*x_(1,2,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,0,1)*x_(0,1,2)*x_(1,2,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-12*x_(0,0,0)*x_(0,1,2)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,1)-24*x_(0,0,1)*x_(0,1,0)*x_(1,2,2)^2*x_(2,0,0)*x_(2,1,1)+12*x_(0,0,0)*x_(0,1,1)*x_(1,2,2)^2*x_(2,0,0)*x_(2,1,1)+12*x_(0,2,2)^2*x_(1,0,0)*x_(1,1,0)*x_(2,0,1)*x_(2,1,1)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,1,1)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,1,1)+12*x_(0,2,0)^2*x_(1,0,2)*x_(1,1,2)*x_(2,0,1)*x_(2,1,1)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,2,0)*x_(2,0,1)*x_(2,1,1)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,1)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,1)+24*x_(0,0,0)*x_(0,2,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,1)+12*x_(0,0,2)*x_(0,1,2)*x_(1,2,0)^2*x_(2,0,1)*x_(2,1,1)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,2)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)+24*x_(0,0,2)*x_(0,2,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)-12*x_(0,0,0)*x_(0,2,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)-12*x_(0,0,0)*x_(0,2,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)-12*x_(0,0,2)*x_(0,1,0)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)-12*x_(0,0,0)*x_(0,1,2)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,1)+12*x_(0,0,0)*x_(0,1,0)*x_(1,2,2)^2*x_(2,0,1)*x_(2,1,1)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,0,2)*x_(2,1,1)+24*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,1,1)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,2)*x_(2,1,1)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,1,1)+12*x_(0,2,0)^2*x_(1,0,2)*x_(1,1,1)*x_(2,0,2)*x_(2,1,1)+24*x_(0,2,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,2)*x_(2,1,1)-24*x_(0,2,0)^2*x_(1,0,1)*x_(1,1,2)*x_(2,0,2)*x_(2,1,1)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)-48*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)+24*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)+24*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)+24*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)-48*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,2)*x_(2,1,1)+12*x_(0,0,2)*x_(0,1,1)*x_(1,2,0)^2*x_(2,0,2)*x_(2,1,1)-24*x_(0,0,1)*x_(0,1,2)*x_(1,2,0)^2*x_(2,0,2)*x_(2,1,1)-48*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)+60*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)+24*x_(0,0,2)*x_(0,2,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)-48*x_(0,0,0)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)+24*x_(0,0,0)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)-12*x_(0,0,2)*x_(0,1,0)*x_(1,2,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,1)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)-48*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)+24*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)-48*x_(0,0,1)*x_(0,2,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)+60*x_(0,0,0)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)-12*x_(0,0,0)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)+24*x_(0,0,1)*x_(0,1,0)*x_(1,2,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)-12*x_(0,0,0)*x_(0,1,1)*x_(1,2,0)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)-12*x_(0,0,0)*x_(0,1,0)*x_(1,2,1)*x_(1,2,2)*x_(2,0,2)*x_(2,1,1)+12*x_(0,2,2)^2*x_(1,0,0)*x_(1,0,1)*x_(2,1,0)*x_(2,1,1)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,0,2)*x_(2,1,0)*x_(2,1,1)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,1,1)+12*x_(0,2,0)*x_(0,2,1)*x_(1,0,2)^2*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,0)*x_(2,1,1)+24*x_(0,0,1)*x_(0,2,2)*x_(1,0,2)*x_(1,2,0)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,2)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,1,1)+24*x_(0,0,0)*x_(0,2,2)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,1,1)+12*x_(0,0,2)^2*x_(1,2,0)*x_(1,2,1)*x_(2,1,0)*x_(2,1,1)+24*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)+24*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,1)*x_(0,0,2)*x_(1,2,0)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)-12*x_(0,0,0)*x_(0,0,2)*x_(1,2,1)*x_(1,2,2)*x_(2,1,0)*x_(2,1,1)+12*x_(0,0,0)*x_(0,0,1)*x_(1,2,2)^2*x_(2,1,0)*x_(2,1,1)-6*x_(0,2,2)^2*x_(1,0,0)^2*x_(2,1,1)^2+12*x_(0,2,0)*x_(0,2,2)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)^2-6*x_(0,2,0)^2*x_(1,0,2)^2*x_(2,1,1)^2+12*x_(0,0,2)*x_(0,2,2)*x_(1,0,0)*x_(1,2,0)*x_(2,1,1)^2+12*x_(0,0,2)*x_(0,2,0)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)^2-24*x_(0,0,0)*x_(0,2,2)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)^2-6*x_(0,0,2)^2*x_(1,2,0)^2*x_(2,1,1)^2-24*x_(0,0,2)*x_(0,2,0)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)^2+12*x_(0,0,0)*x_(0,2,2)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)^2+12*x_(0,0,0)*x_(0,2,0)*x_(1,0,2)*x_(1,2,2)*x_(2,1,1)^2+12*x_(0,0,0)*x_(0,0,2)*x_(1,2,0)*x_(1,2,2)*x_(2,1,1)^2-6*x_(0,0,0)^2*x_(1,2,2)^2*x_(2,1,1)^2+24*x_(0,2,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,0)*x_(2,1,2)-24*x_(0,2,1)^2*x_(1,0,2)*x_(1,1,0)*x_(2,0,0)*x_(2,1,2)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,0)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,2,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,1,2)+12*x_(0,2,1)^2*x_(1,0,0)*x_(1,1,2)*x_(2,0,0)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,1,2)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,1)*x_(1,2,0)*x_(2,0,0)*x_(2,1,2)-48*x_(0,1,1)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,0)*x_(2,1,2)+24*x_(0,1,1)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,0)*x_(2,1,2)-48*x_(0,0,2)*x_(0,2,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,1,2)+60*x_(0,0,1)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,1,2)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)-48*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)-48*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)+24*x_(0,0,2)*x_(0,1,1)*x_(1,2,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,0)*x_(2,1,2)-24*x_(0,0,2)*x_(0,1,0)*x_(1,2,1)^2*x_(2,0,0)*x_(2,1,2)+12*x_(0,0,0)*x_(0,1,2)*x_(1,2,1)^2*x_(2,0,0)*x_(2,1,2)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)+60*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)-48*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)+24*x_(0,0,1)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)-48*x_(0,0,1)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,1,1)*x_(1,2,0)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,2,1)*x_(1,2,2)*x_(2,0,0)*x_(2,1,2)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,0,1)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,2,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,2,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,1)*x_(2,1,2)-24*x_(0,2,0)^2*x_(1,0,2)*x_(1,1,1)*x_(2,0,1)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,1,2)+12*x_(0,2,0)^2*x_(1,0,1)*x_(1,1,2)*x_(2,0,1)*x_(2,1,2)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)-48*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)-48*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,1,2)-24*x_(0,0,2)*x_(0,1,1)*x_(1,2,0)^2*x_(2,0,1)*x_(2,1,2)+12*x_(0,0,1)*x_(0,1,2)*x_(1,2,0)^2*x_(2,0,1)*x_(2,1,2)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)-48*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)+24*x_(0,1,0)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)-48*x_(0,0,2)*x_(0,2,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)+60*x_(0,0,0)*x_(0,2,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)+24*x_(0,0,2)*x_(0,1,0)*x_(1,2,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,1,2)*x_(1,2,0)*x_(1,2,1)*x_(2,0,1)*x_(2,1,2)-48*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)+60*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)-48*x_(0,0,0)*x_(0,2,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)+24*x_(0,0,0)*x_(0,2,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,2,0)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,1,0)*x_(1,2,1)*x_(1,2,2)*x_(2,0,1)*x_(2,1,2)+12*x_(0,2,1)^2*x_(1,0,0)*x_(1,1,0)*x_(2,0,2)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,1,2)+12*x_(0,2,0)^2*x_(1,0,1)*x_(1,1,1)*x_(2,0,2)*x_(2,1,2)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,2,0)*x_(2,0,2)*x_(2,1,2)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,2)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,2)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,1,2)+12*x_(0,0,1)*x_(0,1,1)*x_(1,2,0)^2*x_(2,0,2)*x_(2,1,2)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,2,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,2,0)*x_(1,2,1)*x_(2,0,2)*x_(2,1,2)+12*x_(0,0,0)*x_(0,1,0)*x_(1,2,1)^2*x_(2,0,2)*x_(2,1,2)-12*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,0)*x_(2,1,2)+12*x_(0,2,0)*x_(0,2,2)*x_(1,0,1)^2*x_(2,1,0)*x_(2,1,2)+12*x_(0,2,1)^2*x_(1,0,0)*x_(1,0,2)*x_(2,1,0)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,1,2)+24*x_(0,0,2)*x_(0,2,1)*x_(1,0,1)*x_(1,2,0)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,1)*x_(2,1,0)*x_(2,1,2)+24*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,1)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,1)*x_(2,1,0)*x_(2,1,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,0,2)*x_(1,2,0)*x_(1,2,1)*x_(2,1,0)*x_(2,1,2)+12*x_(0,0,0)*x_(0,0,2)*x_(1,2,1)^2*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,1,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,1,2)+12*x_(0,0,1)^2*x_(1,2,0)*x_(1,2,2)*x_(2,1,0)*x_(2,1,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,2,1)*x_(1,2,2)*x_(2,1,0)*x_(2,1,2)+12*x_(0,2,1)*x_(0,2,2)*x_(1,0,0)^2*x_(2,1,1)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,1)*x_(2,1,2)-12*x_(0,2,0)*x_(0,2,1)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)*x_(2,1,2)+12*x_(0,2,0)^2*x_(1,0,1)*x_(1,0,2)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,2,0)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,2,0)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,2,0)*x_(2,1,1)*x_(2,1,2)+24*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,1,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,1,2)+12*x_(0,0,1)*x_(0,0,2)*x_(1,2,0)^2*x_(2,1,1)*x_(2,1,2)+24*x_(0,0,2)*x_(0,2,0)*x_(1,0,0)*x_(1,2,1)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,0,2)*x_(1,2,0)*x_(1,2,1)*x_(2,1,1)*x_(2,1,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,2,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,1)*x_(2,1,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,2,0)*x_(1,2,2)*x_(2,1,1)*x_(2,1,2)+12*x_(0,0,0)^2*x_(1,2,1)*x_(1,2,2)*x_(2,1,1)*x_(2,1,2)-6*x_(0,2,1)^2*x_(1,0,0)^2*x_(2,1,2)^2+12*x_(0,2,0)*x_(0,2,1)*x_(1,0,0)*x_(1,0,1)*x_(2,1,2)^2-6*x_(0,2,0)^2*x_(1,0,1)^2*x_(2,1,2)^2+12*x_(0,0,1)*x_(0,2,1)*x_(1,0,0)*x_(1,2,0)*x_(2,1,2)^2+12*x_(0,0,1)*x_(0,2,0)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)^2-24*x_(0,0,0)*x_(0,2,1)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)^2-6*x_(0,0,1)^2*x_(1,2,0)^2*x_(2,1,2)^2-24*x_(0,0,1)*x_(0,2,0)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)^2+12*x_(0,0,0)*x_(0,2,1)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)^2+12*x_(0,0,0)*x_(0,2,0)*x_(1,0,1)*x_(1,2,1)*x_(2,1,2)^2+12*x_(0,0,0)*x_(0,0,1)*x_(1,2,0)*x_(1,2,1)*x_(2,1,2)^2-6*x_(0,0,0)^2*x_(1,2,1)^2*x_(2,1,2)^2-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,0,0)*x_(2,2,0)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,2,0)+12*x_(0,0,2)*x_(0,2,2)*x_(1,1,1)^2*x_(2,0,0)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,0)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,0,0)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,1)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,2)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,0)+12*x_(0,0,1)*x_(0,2,1)*x_(1,1,2)^2*x_(2,0,0)*x_(2,2,0)+12*x_(0,1,2)^2*x_(1,0,1)*x_(1,2,1)*x_(2,0,0)*x_(2,2,0)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,0)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,0)+12*x_(0,1,1)^2*x_(1,0,2)*x_(1,2,2)*x_(2,0,0)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,1)*x_(2,2,0)-48*x_(0,1,2)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,2,0)+60*x_(0,1,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,2,0)+24*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,1)*x_(2,2,0)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,0,1)*x_(2,2,0)-48*x_(0,1,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,0,1)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,1)*x_(2,2,0)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)-48*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)+24*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,1,2)*x_(2,0,1)*x_(2,2,0)+12*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)^2*x_(2,0,1)*x_(2,2,0)-24*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)^2*x_(2,0,1)*x_(2,2,0)+12*x_(0,1,2)^2*x_(1,0,1)*x_(1,2,0)*x_(2,0,1)*x_(2,2,0)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,0)-24*x_(0,1,2)^2*x_(1,0,0)*x_(1,2,1)*x_(2,0,1)*x_(2,2,0)+24*x_(0,1,0)*x_(0,1,2)*x_(1,0,2)*x_(1,2,1)*x_(2,0,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,2,0)-48*x_(0,0,2)*x_(0,1,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,1)*x_(2,2,0)+24*x_(0,0,0)*x_(0,1,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,1)*x_(2,2,0)+24*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)-48*x_(0,0,2)*x_(0,1,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)+60*x_(0,0,2)*x_(0,1,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)-48*x_(0,0,0)*x_(0,1,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)+24*x_(0,0,0)*x_(0,1,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,1)*x_(2,2,0)+60*x_(0,1,2)*x_(0,2,1)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,2,0)-48*x_(0,1,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,2)*x_(2,2,0)-48*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,0)+12*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)^2*x_(2,0,2)*x_(2,2,0)-24*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)^2*x_(2,0,2)*x_(2,2,0)+24*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,2)*x_(2,2,0)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,0,2)*x_(2,2,0)-48*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,0,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,1)*x_(1,1,0)*x_(1,1,2)*x_(2,0,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,0)*x_(1,1,1)*x_(1,1,2)*x_(2,0,2)*x_(2,2,0)+24*x_(0,0,0)*x_(0,2,1)*x_(1,1,1)*x_(1,1,2)*x_(2,0,2)*x_(2,2,0)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,0)+12*x_(0,1,1)^2*x_(1,0,2)*x_(1,2,0)*x_(2,0,2)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,2)*x_(2,2,0)+24*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)-48*x_(0,0,1)*x_(0,1,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)+24*x_(0,0,0)*x_(0,1,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)+60*x_(0,0,1)*x_(0,1,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)-48*x_(0,0,0)*x_(0,1,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,2)*x_(2,2,0)-24*x_(0,1,1)^2*x_(1,0,0)*x_(1,2,2)*x_(2,0,2)*x_(2,2,0)+24*x_(0,1,0)*x_(0,1,1)*x_(1,0,1)*x_(1,2,2)*x_(2,0,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,2)*x_(2,2,0)-48*x_(0,0,1)*x_(0,1,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,2)*x_(2,2,0)+24*x_(0,0,0)*x_(0,1,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,2)*x_(2,2,0)+12*x_(0,1,2)*x_(0,2,2)*x_(1,0,1)^2*x_(2,1,0)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,2,0)+12*x_(0,1,1)*x_(0,2,1)*x_(1,0,2)^2*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,1,0)*x_(2,2,0)+24*x_(0,0,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,1,0)*x_(2,2,0)+24*x_(0,0,2)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,2)*x_(1,0,1)*x_(1,2,1)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,1)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,2)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,0)+12*x_(0,0,2)^2*x_(1,1,1)*x_(1,2,1)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,1)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,2)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,1)*x_(1,0,2)*x_(1,2,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,0)+12*x_(0,0,1)^2*x_(1,1,2)*x_(1,2,2)*x_(2,1,0)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,1)*x_(2,2,0)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,0,2)*x_(2,1,1)*x_(2,2,0)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,0,2)*x_(2,1,1)*x_(2,2,0)+12*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)^2*x_(2,1,1)*x_(2,2,0)-24*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)^2*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,1,1)*x_(2,2,0)-48*x_(0,0,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,1,1)*x_(2,2,0)-48*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,1,1)*x_(2,2,0)+60*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,1,1)*x_(2,2,0)-48*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,2)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,2)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,2)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,0)+12*x_(0,0,2)^2*x_(1,1,1)*x_(1,2,0)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,1)*x_(2,2,0)-48*x_(0,0,0)*x_(0,1,2)*x_(1,0,2)*x_(1,2,1)*x_(2,1,1)*x_(2,2,0)-24*x_(0,0,2)^2*x_(1,1,0)*x_(1,2,1)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,0)*x_(0,0,2)*x_(1,1,2)*x_(1,2,1)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)-48*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)-48*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)+60*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)+24*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,2)*x_(1,2,2)*x_(2,1,1)*x_(2,2,0)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,0,1)*x_(2,1,2)*x_(2,2,0)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,2)*x_(2,2,0)+12*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)^2*x_(2,1,2)*x_(2,2,0)-24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)^2*x_(2,1,2)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,0,2)*x_(2,1,2)*x_(2,2,0)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,0,2)*x_(2,1,2)*x_(2,2,0)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,0,2)*x_(2,1,2)*x_(2,2,0)-48*x_(0,0,2)*x_(0,2,1)*x_(1,0,1)*x_(1,1,0)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,1,2)*x_(2,2,0)+60*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,1)*x_(2,1,2)*x_(2,2,0)-48*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,1)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,1,2)*x_(2,2,0)-48*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,1)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,0)+12*x_(0,0,1)^2*x_(1,1,2)*x_(1,2,0)*x_(2,1,2)*x_(2,2,0)-48*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)-48*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)+60*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,2)*x_(1,2,1)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,1)*x_(0,1,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,2)*x_(2,2,0)-48*x_(0,0,0)*x_(0,1,1)*x_(1,0,1)*x_(1,2,2)*x_(2,1,2)*x_(2,2,0)-24*x_(0,0,1)^2*x_(1,1,0)*x_(1,2,2)*x_(2,1,2)*x_(2,2,0)+24*x_(0,0,0)*x_(0,0,1)*x_(1,1,1)*x_(1,2,2)*x_(2,1,2)*x_(2,2,0)-6*x_(0,1,2)^2*x_(1,0,1)^2*x_(2,2,0)^2+12*x_(0,1,1)*x_(0,1,2)*x_(1,0,1)*x_(1,0,2)*x_(2,2,0)^2-6*x_(0,1,1)^2*x_(1,0,2)^2*x_(2,2,0)^2+12*x_(0,0,2)*x_(0,1,2)*x_(1,0,1)*x_(1,1,1)*x_(2,2,0)^2+12*x_(0,0,2)*x_(0,1,1)*x_(1,0,2)*x_(1,1,1)*x_(2,2,0)^2-24*x_(0,0,1)*x_(0,1,2)*x_(1,0,2)*x_(1,1,1)*x_(2,2,0)^2-6*x_(0,0,2)^2*x_(1,1,1)^2*x_(2,2,0)^2-24*x_(0,0,2)*x_(0,1,1)*x_(1,0,1)*x_(1,1,2)*x_(2,2,0)^2+12*x_(0,0,1)*x_(0,1,2)*x_(1,0,1)*x_(1,1,2)*x_(2,2,0)^2+12*x_(0,0,1)*x_(0,1,1)*x_(1,0,2)*x_(1,1,2)*x_(2,2,0)^2+12*x_(0,0,1)*x_(0,0,2)*x_(1,1,1)*x_(1,1,2)*x_(2,2,0)^2-6*x_(0,0,1)^2*x_(1,1,2)^2*x_(2,2,0)^2+24*x_(0,1,2)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,0)*x_(2,2,1)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,0)*x_(2,2,1)-48*x_(0,1,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,0,0)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,0)*x_(2,2,1)-48*x_(0,1,2)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,2,1)+60*x_(0,1,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,0)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)-48*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,1)-24*x_(0,0,1)*x_(0,2,0)*x_(1,1,2)^2*x_(2,0,0)*x_(2,2,1)+12*x_(0,0,0)*x_(0,2,1)*x_(1,1,2)^2*x_(2,0,0)*x_(2,2,1)-24*x_(0,1,2)^2*x_(1,0,1)*x_(1,2,0)*x_(2,0,0)*x_(2,2,1)+24*x_(0,1,1)*x_(0,1,2)*x_(1,0,2)*x_(1,2,0)*x_(2,0,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,2,1)-48*x_(0,0,2)*x_(0,1,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,2,1)+24*x_(0,0,1)*x_(0,1,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,2,1)+12*x_(0,1,2)^2*x_(1,0,0)*x_(1,2,1)*x_(2,0,0)*x_(2,2,1)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,2)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,1)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)+60*x_(0,0,2)*x_(0,1,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)-48*x_(0,0,1)*x_(0,1,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)-48*x_(0,0,2)*x_(0,1,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)+24*x_(0,0,1)*x_(0,1,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,1)*x_(1,1,2)*x_(1,2,2)*x_(2,0,0)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,0,1)*x_(2,2,1)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,2,1)+12*x_(0,0,2)*x_(0,2,2)*x_(1,1,0)^2*x_(2,0,1)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,1)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,2)*x_(1,1,2)*x_(2,0,1)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,0)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,2)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,1)+12*x_(0,0,0)*x_(0,2,0)*x_(1,1,2)^2*x_(2,0,1)*x_(2,2,1)+12*x_(0,1,2)^2*x_(1,0,0)*x_(1,2,0)*x_(2,0,1)*x_(2,2,1)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,2)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,1)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,1)+12*x_(0,1,0)^2*x_(1,0,2)*x_(1,2,2)*x_(2,0,1)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,0)*x_(1,1,2)*x_(1,2,2)*x_(2,0,1)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,0)*x_(2,0,2)*x_(2,2,1)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,0,2)*x_(2,2,1)-48*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,2,1)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,2,1)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,0)*x_(2,0,2)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,2)*x_(2,2,1)+12*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)^2*x_(2,0,2)*x_(2,2,1)-24*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)^2*x_(2,0,2)*x_(2,2,1)+60*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,1)-48*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,0,2)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,0)*x_(1,1,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,1)-48*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,1,2)*x_(2,0,2)*x_(2,2,1)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,2)*x_(2,2,1)+24*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,0,2)*x_(2,2,1)+24*x_(0,0,1)*x_(0,2,0)*x_(1,1,0)*x_(1,1,2)*x_(2,0,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,1)*x_(1,1,0)*x_(1,1,2)*x_(2,0,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,0)*x_(1,1,1)*x_(1,1,2)*x_(2,0,2)*x_(2,2,1)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)+24*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)+24*x_(0,0,1)*x_(0,1,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)-48*x_(0,0,0)*x_(0,1,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)-48*x_(0,0,1)*x_(0,1,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)+60*x_(0,0,0)*x_(0,1,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,2)*x_(2,2,1)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,1)+12*x_(0,1,0)^2*x_(1,0,2)*x_(1,2,1)*x_(2,0,2)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,2)*x_(2,2,1)+24*x_(0,1,0)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,2)*x_(2,2,1)-24*x_(0,1,0)^2*x_(1,0,1)*x_(1,2,2)*x_(2,0,2)*x_(2,2,1)+24*x_(0,0,1)*x_(0,1,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,2)*x_(2,2,1)-48*x_(0,0,0)*x_(0,1,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,2)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,0)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,0,2)*x_(2,1,0)*x_(2,2,1)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,0,2)*x_(2,1,0)*x_(2,2,1)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,2,1)-24*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)^2*x_(2,1,0)*x_(2,2,1)+12*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)^2*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,1)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,1,0)*x_(2,2,1)-48*x_(0,0,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,1)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,1,0)*x_(2,2,1)-48*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,1,0)*x_(2,2,1)-48*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,1,0)*x_(2,2,1)+60*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,2)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,2)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,2)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,0)*x_(2,2,1)-48*x_(0,0,1)*x_(0,1,2)*x_(1,0,2)*x_(1,2,0)*x_(2,1,0)*x_(2,2,1)-24*x_(0,0,2)^2*x_(1,1,1)*x_(1,2,0)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,1)*x_(0,0,2)*x_(1,1,2)*x_(1,2,0)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,1)+12*x_(0,0,2)^2*x_(1,1,0)*x_(1,2,1)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,1)-48*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)+60*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)-48*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)+24*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,2)*x_(1,2,2)*x_(2,1,0)*x_(2,2,1)+12*x_(0,1,2)*x_(0,2,2)*x_(1,0,0)^2*x_(2,1,1)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)*x_(2,2,1)+12*x_(0,1,0)*x_(0,2,0)*x_(1,0,2)^2*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,0)*x_(1,0,2)*x_(1,1,0)*x_(2,1,1)*x_(2,2,1)+24*x_(0,0,0)*x_(0,2,2)*x_(1,0,2)*x_(1,1,0)*x_(2,1,1)*x_(2,2,1)+24*x_(0,0,2)*x_(0,2,0)*x_(1,0,0)*x_(1,1,2)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,2)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,0)*x_(1,0,2)*x_(1,1,2)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,2)*x_(1,0,0)*x_(1,2,0)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,0)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,1)+12*x_(0,0,2)^2*x_(1,1,0)*x_(1,2,0)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,2)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,0)*x_(1,0,2)*x_(1,2,2)*x_(2,1,1)*x_(2,2,1)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,1)+12*x_(0,0,0)^2*x_(1,1,2)*x_(1,2,2)*x_(2,1,1)*x_(2,2,1)+12*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)^2*x_(2,1,2)*x_(2,2,1)-24*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)^2*x_(2,1,2)*x_(2,2,1)-12*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,0,1)*x_(2,1,2)*x_(2,2,1)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,2)*x_(2,2,1)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,0,2)*x_(2,1,2)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,0,2)*x_(2,1,2)*x_(2,2,1)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,0,2)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,0)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,1,2)*x_(2,2,1)+60*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,0)*x_(2,1,2)*x_(2,2,1)-48*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,1,2)*x_(2,2,1)-48*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,0)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,1,2)*x_(2,2,1)-48*x_(0,0,2)*x_(0,2,0)*x_(1,0,0)*x_(1,1,1)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,1)*x_(0,2,0)*x_(1,0,0)*x_(1,1,2)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)-48*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)+60*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)-48*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,2)*x_(1,2,0)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,2)*x_(2,2,1)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,1)+12*x_(0,0,0)^2*x_(1,1,2)*x_(1,2,1)*x_(2,1,2)*x_(2,2,1)-48*x_(0,0,1)*x_(0,1,0)*x_(1,0,0)*x_(1,2,2)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,2)*x_(2,2,1)+24*x_(0,0,0)*x_(0,0,1)*x_(1,1,0)*x_(1,2,2)*x_(2,1,2)*x_(2,2,1)-24*x_(0,0,0)^2*x_(1,1,1)*x_(1,2,2)*x_(2,1,2)*x_(2,2,1)+12*x_(0,1,2)^2*x_(1,0,0)*x_(1,0,1)*x_(2,2,0)*x_(2,2,1)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,0,2)*x_(2,2,0)*x_(2,2,1)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)*x_(1,0,2)*x_(2,2,0)*x_(2,2,1)+12*x_(0,1,0)*x_(0,1,1)*x_(1,0,2)^2*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,2)*x_(1,0,1)*x_(1,1,0)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,1)*x_(1,0,2)*x_(1,1,0)*x_(2,2,0)*x_(2,2,1)+24*x_(0,0,1)*x_(0,1,2)*x_(1,0,2)*x_(1,1,0)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,2)*x_(1,0,0)*x_(1,1,1)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,2)*x_(0,1,0)*x_(1,0,2)*x_(1,1,1)*x_(2,2,0)*x_(2,2,1)+24*x_(0,0,0)*x_(0,1,2)*x_(1,0,2)*x_(1,1,1)*x_(2,2,0)*x_(2,2,1)+12*x_(0,0,2)^2*x_(1,1,0)*x_(1,1,1)*x_(2,2,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)+24*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)*x_(1,1,2)*x_(2,2,0)*x_(2,2,1)+12*x_(0,0,0)*x_(0,0,1)*x_(1,1,2)^2*x_(2,2,0)*x_(2,2,1)-6*x_(0,1,2)^2*x_(1,0,0)^2*x_(2,2,1)^2+12*x_(0,1,0)*x_(0,1,2)*x_(1,0,0)*x_(1,0,2)*x_(2,2,1)^2-6*x_(0,1,0)^2*x_(1,0,2)^2*x_(2,2,1)^2+12*x_(0,0,2)*x_(0,1,2)*x_(1,0,0)*x_(1,1,0)*x_(2,2,1)^2+12*x_(0,0,2)*x_(0,1,0)*x_(1,0,2)*x_(1,1,0)*x_(2,2,1)^2-24*x_(0,0,0)*x_(0,1,2)*x_(1,0,2)*x_(1,1,0)*x_(2,2,1)^2-6*x_(0,0,2)^2*x_(1,1,0)^2*x_(2,2,1)^2-24*x_(0,0,2)*x_(0,1,0)*x_(1,0,0)*x_(1,1,2)*x_(2,2,1)^2+12*x_(0,0,0)*x_(0,1,2)*x_(1,0,0)*x_(1,1,2)*x_(2,2,1)^2+12*x_(0,0,0)*x_(0,1,0)*x_(1,0,2)*x_(1,1,2)*x_(2,2,1)^2+12*x_(0,0,0)*x_(0,0,2)*x_(1,1,0)*x_(1,1,2)*x_(2,2,1)^2-6*x_(0,0,0)^2*x_(1,1,2)^2*x_(2,2,1)^2-48*x_(0,1,2)*x_(0,2,1)*x_(1,0,1)*x_(1,1,0)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,1)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)-48*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)+24*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,0)*x_(2,2,2)-24*x_(0,0,2)*x_(0,2,0)*x_(1,1,1)^2*x_(2,0,0)*x_(2,2,2)+12*x_(0,0,0)*x_(0,2,2)*x_(1,1,1)^2*x_(2,0,0)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,0)*x_(2,2,2)-48*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,2)+60*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,1)*x_(1,1,0)*x_(1,1,2)*x_(2,0,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,1)*x_(1,1,1)*x_(1,1,2)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,1)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,0)*x_(2,2,2)-24*x_(0,1,1)^2*x_(1,0,2)*x_(1,2,0)*x_(2,0,0)*x_(2,2,2)+24*x_(0,0,2)*x_(0,1,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,2,2)-48*x_(0,0,1)*x_(0,1,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,0)*x_(2,2,2)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)-48*x_(0,0,2)*x_(0,1,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)+60*x_(0,0,1)*x_(0,1,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)+24*x_(0,0,2)*x_(0,1,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,2)*x_(1,1,1)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)-48*x_(0,0,1)*x_(0,1,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,1,2)*x_(1,2,1)*x_(2,0,0)*x_(2,2,2)+12*x_(0,1,1)^2*x_(1,0,0)*x_(1,2,2)*x_(2,0,0)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,1,1)*x_(1,2,2)*x_(2,0,0)*x_(2,2,2)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,0)*x_(2,0,1)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,0,1)*x_(2,2,2)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,0)*x_(2,0,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,0,1)*x_(2,2,2)-48*x_(0,1,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,2,2)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,0,1)*x_(2,2,2)-24*x_(0,0,2)*x_(0,2,1)*x_(1,1,0)^2*x_(2,0,1)*x_(2,2,2)+12*x_(0,0,1)*x_(0,2,2)*x_(1,1,0)^2*x_(2,0,1)*x_(2,2,2)-48*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,1,1)*x_(2,0,1)*x_(2,2,2)+24*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,0,1)*x_(2,2,2)+24*x_(0,1,0)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,0,1)*x_(2,2,2)+24*x_(0,0,2)*x_(0,2,0)*x_(1,1,0)*x_(1,1,1)*x_(2,0,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,2)*x_(1,1,0)*x_(1,1,1)*x_(2,0,1)*x_(2,2,2)+60*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,2)-48*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,0,1)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,0)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,1,0)*x_(1,1,2)*x_(2,0,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,0)*x_(1,1,1)*x_(1,1,2)*x_(2,0,1)*x_(2,2,2)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)+24*x_(0,1,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)+24*x_(0,0,2)*x_(0,1,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,2)*x_(1,1,0)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)-48*x_(0,0,2)*x_(0,1,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)+60*x_(0,0,0)*x_(0,1,2)*x_(1,1,1)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)-48*x_(0,0,0)*x_(0,1,1)*x_(1,1,2)*x_(1,2,0)*x_(2,0,1)*x_(2,2,2)+24*x_(0,1,0)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,0,1)*x_(2,2,2)-24*x_(0,1,0)^2*x_(1,0,2)*x_(1,2,1)*x_(2,0,1)*x_(2,2,2)+24*x_(0,0,2)*x_(0,1,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,2,2)-48*x_(0,0,0)*x_(0,1,2)*x_(1,1,0)*x_(1,2,1)*x_(2,0,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,0)*x_(1,1,2)*x_(1,2,1)*x_(2,0,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,2)+12*x_(0,1,0)^2*x_(1,0,1)*x_(1,2,2)*x_(2,0,1)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,1,0)*x_(1,2,2)*x_(2,0,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,0)*x_(1,1,1)*x_(1,2,2)*x_(2,0,1)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,1,0)*x_(2,0,2)*x_(2,2,2)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,0)*x_(2,0,2)*x_(2,2,2)+12*x_(0,0,1)*x_(0,2,1)*x_(1,1,0)^2*x_(2,0,2)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,2)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,1,1)*x_(2,0,2)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,0)*x_(1,1,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,1)*x_(1,1,0)*x_(1,1,1)*x_(2,0,2)*x_(2,2,2)+12*x_(0,0,0)*x_(0,2,0)*x_(1,1,1)^2*x_(2,0,2)*x_(2,2,2)+12*x_(0,1,1)^2*x_(1,0,0)*x_(1,2,0)*x_(2,0,2)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,1)*x_(1,1,0)*x_(1,2,0)*x_(2,0,2)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,1,1)*x_(1,2,0)*x_(2,0,2)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,2)+12*x_(0,1,0)^2*x_(1,0,1)*x_(1,2,1)*x_(2,0,2)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,1,0)*x_(1,2,1)*x_(2,0,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,0)*x_(1,1,1)*x_(1,2,1)*x_(2,0,2)*x_(2,2,2)+24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)*x_(1,0,1)*x_(2,1,0)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,0)*x_(2,2,2)-24*x_(0,1,2)*x_(0,2,0)*x_(1,0,1)^2*x_(2,1,0)*x_(2,2,2)+12*x_(0,1,0)*x_(0,2,2)*x_(1,0,1)^2*x_(2,1,0)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)*x_(1,0,2)*x_(2,1,0)*x_(2,2,2)+24*x_(0,1,1)*x_(0,2,0)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,1)*x_(1,0,2)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,2)*x_(0,2,1)*x_(1,0,1)*x_(1,1,0)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,1,0)*x_(2,2,2)-48*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,1)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,1)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,1)*x_(2,1,0)*x_(2,2,2)-48*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,1,0)*x_(2,2,2)+60*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,1)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,1,0)*x_(2,2,2)-48*x_(0,0,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,2)*x_(2,1,0)*x_(2,2,2)-48*x_(0,0,2)*x_(0,1,1)*x_(1,0,1)*x_(1,2,0)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,0,2)*x_(1,1,1)*x_(1,2,0)*x_(2,1,0)*x_(2,2,2)-24*x_(0,0,1)^2*x_(1,1,2)*x_(1,2,0)*x_(2,1,0)*x_(2,2,2)+60*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)-48*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)-48*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,0)*x_(0,0,1)*x_(1,1,2)*x_(1,2,1)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,0,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,2)+12*x_(0,0,1)^2*x_(1,1,0)*x_(1,2,2)*x_(2,1,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,1)*x_(1,2,2)*x_(2,1,0)*x_(2,2,2)-24*x_(0,1,2)*x_(0,2,1)*x_(1,0,0)^2*x_(2,1,1)*x_(2,2,2)+12*x_(0,1,1)*x_(0,2,2)*x_(1,0,0)^2*x_(2,1,1)*x_(2,2,2)+24*x_(0,1,2)*x_(0,2,0)*x_(1,0,0)*x_(1,0,1)*x_(2,1,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,2)*x_(1,0,0)*x_(1,0,1)*x_(2,1,1)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)*x_(2,2,2)+24*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,0,2)*x_(2,1,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)*x_(1,0,2)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,2)*x_(0,2,1)*x_(1,0,0)*x_(1,1,0)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,2)*x_(1,0,0)*x_(1,1,0)*x_(2,1,1)*x_(2,2,2)-48*x_(0,0,2)*x_(0,2,0)*x_(1,0,1)*x_(1,1,0)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,2,2)*x_(1,0,1)*x_(1,1,0)*x_(2,1,1)*x_(2,2,2)+60*x_(0,0,1)*x_(0,2,0)*x_(1,0,2)*x_(1,1,0)*x_(2,1,1)*x_(2,2,2)-48*x_(0,0,0)*x_(0,2,1)*x_(1,0,2)*x_(1,1,0)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,2)*x_(0,2,0)*x_(1,0,0)*x_(1,1,1)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,2)*x_(1,0,0)*x_(1,1,1)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,0)*x_(1,0,2)*x_(1,1,1)*x_(2,1,1)*x_(2,2,2)-48*x_(0,0,1)*x_(0,2,0)*x_(1,0,0)*x_(1,1,2)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,2)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,2,0)*x_(1,0,1)*x_(1,1,2)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)+60*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)-48*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)-48*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,0,1)*x_(1,1,2)*x_(1,2,0)*x_(2,1,1)*x_(2,2,2)-48*x_(0,0,2)*x_(0,1,0)*x_(1,0,0)*x_(1,2,1)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,2)*x_(1,0,0)*x_(1,2,1)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,0)*x_(1,0,2)*x_(1,2,1)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,0,2)*x_(1,1,0)*x_(1,2,1)*x_(2,1,1)*x_(2,2,2)-24*x_(0,0,0)^2*x_(1,1,2)*x_(1,2,1)*x_(2,1,1)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,0,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,0)*x_(1,0,1)*x_(1,2,2)*x_(2,1,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,0)*x_(1,2,2)*x_(2,1,1)*x_(2,2,2)+12*x_(0,0,0)^2*x_(1,1,1)*x_(1,2,2)*x_(2,1,1)*x_(2,2,2)+12*x_(0,1,1)*x_(0,2,1)*x_(1,0,0)^2*x_(2,1,2)*x_(2,2,2)-12*x_(0,1,1)*x_(0,2,0)*x_(1,0,0)*x_(1,0,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,1,0)*x_(0,2,1)*x_(1,0,0)*x_(1,0,1)*x_(2,1,2)*x_(2,2,2)+12*x_(0,1,0)*x_(0,2,0)*x_(1,0,1)^2*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,1)*x_(1,0,0)*x_(1,1,0)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,1)*x_(0,2,0)*x_(1,0,1)*x_(1,1,0)*x_(2,1,2)*x_(2,2,2)+24*x_(0,0,0)*x_(0,2,1)*x_(1,0,1)*x_(1,1,0)*x_(2,1,2)*x_(2,2,2)+24*x_(0,0,1)*x_(0,2,0)*x_(1,0,0)*x_(1,1,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,1)*x_(1,0,0)*x_(1,1,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,2,0)*x_(1,0,1)*x_(1,1,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,1)*x_(1,0,0)*x_(1,2,0)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,0,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,2)+12*x_(0,0,1)^2*x_(1,1,0)*x_(1,2,0)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,1)*x_(1,2,0)*x_(2,1,2)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,0,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,0)*x_(1,0,1)*x_(1,2,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,0)*x_(1,2,1)*x_(2,1,2)*x_(2,2,2)+12*x_(0,0,0)^2*x_(1,1,1)*x_(1,2,1)*x_(2,1,2)*x_(2,2,2)-12*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)*x_(1,0,1)*x_(2,2,0)*x_(2,2,2)+12*x_(0,1,0)*x_(0,1,2)*x_(1,0,1)^2*x_(2,2,0)*x_(2,2,2)+12*x_(0,1,1)^2*x_(1,0,0)*x_(1,0,2)*x_(2,2,0)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,1)*x_(1,0,2)*x_(2,2,0)*x_(2,2,2)+24*x_(0,0,2)*x_(0,1,1)*x_(1,0,1)*x_(1,1,0)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,2)*x_(1,0,1)*x_(1,1,0)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,1)*x_(1,0,2)*x_(1,1,0)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,1,1)*x_(2,2,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,1,1)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,1,1)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,1,1)*x_(2,2,0)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,1,1)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,1,1)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)*x_(1,1,1)*x_(2,2,0)*x_(2,2,2)+12*x_(0,0,0)*x_(0,0,2)*x_(1,1,1)^2*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,1)*x_(1,0,0)*x_(1,1,2)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,0,1)*x_(1,1,2)*x_(2,2,0)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,0,1)*x_(1,1,2)*x_(2,2,0)*x_(2,2,2)+12*x_(0,0,1)^2*x_(1,1,0)*x_(1,1,2)*x_(2,2,0)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,1)*x_(1,1,2)*x_(2,2,0)*x_(2,2,2)+12*x_(0,1,1)*x_(0,1,2)*x_(1,0,0)^2*x_(2,2,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,2)*x_(1,0,0)*x_(1,0,1)*x_(2,2,1)*x_(2,2,2)-12*x_(0,1,0)*x_(0,1,1)*x_(1,0,0)*x_(1,0,2)*x_(2,2,1)*x_(2,2,2)+12*x_(0,1,0)^2*x_(1,0,1)*x_(1,0,2)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,2)*x_(0,1,1)*x_(1,0,0)*x_(1,1,0)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,2)*x_(1,0,0)*x_(1,1,0)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,2)*x_(0,1,0)*x_(1,0,1)*x_(1,1,0)*x_(2,2,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,2)*x_(1,0,1)*x_(1,1,0)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,1)*x_(0,1,0)*x_(1,0,2)*x_(1,1,0)*x_(2,2,1)*x_(2,2,2)+24*x_(0,0,0)*x_(0,1,1)*x_(1,0,2)*x_(1,1,0)*x_(2,2,1)*x_(2,2,2)+12*x_(0,0,1)*x_(0,0,2)*x_(1,1,0)^2*x_(2,2,1)*x_(2,2,2)+24*x_(0,0,2)*x_(0,1,0)*x_(1,0,0)*x_(1,1,1)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,2)*x_(1,0,0)*x_(1,1,1)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,0)*x_(1,0,2)*x_(1,1,1)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,2)*x_(1,1,0)*x_(1,1,1)*x_(2,2,1)*x_(2,2,2)+24*x_(0,0,1)*x_(0,1,0)*x_(1,0,0)*x_(1,1,2)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,1)*x_(1,0,0)*x_(1,1,2)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,1,0)*x_(1,0,1)*x_(1,1,2)*x_(2,2,1)*x_(2,2,2)-12*x_(0,0,0)*x_(0,0,1)*x_(1,1,0)*x_(1,1,2)*x_(2,2,1)*x_(2,2,2)+12*x_(0,0,0)^2*x_(1,1,1)*x_(1,1,2)*x_(2,2,1)*x_(2,2,2)-6*x_(0,1,1)^2*x_(1,0,0)^2*x_(2,2,2)^2+12*x_(0,1,0)*x_(0,1,1)*x_(1,0,0)*x_(1,0,1)*x_(2,2,2)^2-6*x_(0,1,0)^2*x_(1,0,1)^2*x_(2,2,2)^2+12*x_(0,0,1)*x_(0,1,1)*x_(1,0,0)*x_(1,1,0)*x_(2,2,2)^2+12*x_(0,0,1)*x_(0,1,0)*x_(1,0,1)*x_(1,1,0)*x_(2,2,2)^2-24*x_(0,0,0)*x_(0,1,1)*x_(1,0,1)*x_(1,1,0)*x_(2,2,2)^2-6*x_(0,0,1)^2*x_(1,1,0)^2*x_(2,2,2)^2-24*x_(0,0,1)*x_(0,1,0)*x_(1,0,0)*x_(1,1,1)*x_(2,2,2)^2+12*x_(0,0,0)*x_(0,1,1)*x_(1,0,0)*x_(1,1,1)*x_(2,2,2)^2+12*x_(0,0,0)*x_(0,1,0)*x_(1,0,1)*x_(1,1,1)*x_(2,2,2)^2+12*x_(0,0,0)*x_(0,0,1)*x_(1,1,0)*x_(1,1,1)*x_(2,2,2)^2-6*x_(0,0,0)^2*x_(1,1,1)^2*x_(2,2,2)^2




