# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181416;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"434212", "Sankt\ Veit\ an\ der\ Glan",
"432815", "Großschönau",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"432822", "Zwettl\-Niederösterreich",
"437566", "Rosenau\ am\ Hengstpaß",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"4312", "Wien",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"437956", "Unterweißenbach",
"436565", "Neukirchen\ am\ Großvenediger",
"4316", "Wien",
"432233", "Preßbaum",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"4315", "Wien",
"432847", "Groß\-Siegharts",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"433575", "Sankt\ Johann\ am\ Tauern",
"433864", "Sankt\ Marein\ im\ Mürztal",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"436414", "Großarl",
"432617", "Draßmarkt",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"434264", "Klein\ Sankt\ Paul",
"436277", "Sankt\ Pantaleon",
"433632", "Sankt\ Gallen",
"434358", "Sankt\ Andrä",
"433386", "Großsteinbach",
"4317", "Wien",
"435352", "Sankt\ Johann\ in\ Tirol",
"436227", "Sankt\ Gilgen",
"434286", "Weißbriach",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"437477", "Sankt\ Peter\ in\ der\ Au",
"437254", "Großraming",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"433469", "Sankt\ Oswald\ im\ Freiland",
"4318", "Wien",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"437717", "Sankt\ Aegidi",
"432647", "Krumbach\,\ Niederösterreich",
"433119", "Sankt\ Marein\ bei\ Graz",
"4313", "Wien",
"436241", "Sankt\ Koloman",
"434825", "Großkirchheim",
"432857", "Bad\ Großpertholz",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"432268", "Großmugl",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"434877", "Prägraten\ am\ Großvenediger",
"433158", "Sankt\ Anna\ am\ Aigen",
"432629", "Warth\,\ Niederösterreich",
"433327", "Sankt\ Michael\ im\ Burgenland",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"434785", "Außerfragant",
"433585", "Sankt\ Lambrecht",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"437224", "Sankt\ Florian",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"435449", "Fließ",
"437565", "Sankt\ Pankraz",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"432955", "Großweikersdorf",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"433464", "Groß\ Sankt\ Florian",
"434226", "Sankt\ Margareten\ im\ Rosental",
"432823", "Großglobnitz",
"433684", "Sankt\ Martin\ am\ Grimming",
"435678", "Weißenbach\ am\ Lech",
"437435", "Sankt\ Valentin",
"434876", "Kals\ am\ Großglockner",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"434253", "Sankt\ Jakob\ im\ Rosental",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"432742", "Sankt\ Pölten",
"437954", "Sankt\ Georgen\ am\ Walde",
"437219", "Vorderweißenbach",
"435245", "Hinterriß",
"434266", "Straßburg",
"432618", "Markt\ Sankt\ Martin",
"432756", "Sankt\ Leonhard\ am\ Forst",
"435279", "Sankt\ Jodok\ am\ Brenner",
"434843", "Außervillgraten",
"437218", "Großtraberg",
"435557", "Sankt\ Gallenkirch",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"433834", "Wald\ am\ Schoberpaß",
"432249", "Groß\-Enzersdorf",
"436247", "Großgmain",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"434783", "Reißeck",
"432642", "Aspangberg\-Sankt\ Peter",
"432719", "Droß",
"432263", "Großrußbach",
"433868", "Tragöß",
"437751", "Sankt\ Martin\ im\ Innkreis",
"436276", "Nußdorf\ am\ Haunsberg",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"432812", "Groß\ Gerungs",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432686", "Draßburg",
"432556", "Großkrut",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"4314", "Wien",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"433537", "Sankt\ Georgen\ ob\ Murau",
"434879", "Sankt\ Veit\ in\ Defereggen",
"436215", "Straßwalchen",
"4319", "Wien",
"436412", "Sankt\ Johann\ im\ Pongau",
"435446", "Sankt\ Anton\ am\ Arlberg",
"432242", "Sankt\ Andrä\-Wördern",
"436477", "Sankt\ Michael\ im\ Lungau",
"433362", "Großpetersdorf",
"432674", "Weißenbach\ an\ der\ Triesting",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",};
$areanames{en} = {"432231", "Purkersdorf",
"433387", "Söchau",
"432573", "Wilfersdorf",
"432767", "Hohenberg",
"437582", "Kirchdorf\ an\ der\ Krems",
"433357", "Pinkafeld",
"432164", "Rohrau",
"432619", "Lackendorf",
"433147", "Salla",
"437682", "Vöcklamarkt",
"432742", "St\.\ Pölten",
"432689", "Hornstein",
"434822", "Winklern",
"437612", "Gmunden",
"432673", "Altenmarkt\ an\ der\ Triesting",
"433866", "Breitenau\ am\ Hochlantsch",
"432538", "Velm\-Götzendorf",
"432230", "Schwadorf",
"43316", "Graz",
"434257", "Fürnitz",
"436226", "Fuschl\ am\ See",
"432947", "Theras",
"437264", "Windhaag\ bei\ Perg",
"435441", "See",
"432277", "Zwentendorf",
"432638", "Winzendorf\-Muthmannsdorf",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432736", "Paudorf",
"432664", "Semmering",
"435376", "Thiersee",
"434762", "Spittal\ an\ der\ Drau",
"434354", "Preitenegg",
"432875", "Grafenschlag",
"436244", "Golling\ an\ der\ Salzach",
"437238", "Mauthausen",
"435245", "Hinterriss",
"434855", "Assling",
"436213", "Oberhofen\ am\ Irrsee",
"437763", "Kopfing\ im\ Innkreis",
"436467", "Mühlbach\ am\ Hochkönig",
"432173", "Gols",
"432827", "Schönbach",
"437943", "Windhaag\ bei\ Freistadt",
"432282", "Gänserndorf",
"437219", "Vorderweissenbach",
"437259", "Sierning",
"432252", "Baden",
"437273", "Aschach\ an\ der\ Donau",
"432212", "Orth\ an\ der\ Donau",
"435278", "Navis",
"433452", "Leibnitz",
"437289", "Rohrbach\ in\ Oberösterreich",
"437954", "St\.\ Georgen\ am\ Walde",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"434272", "Pörtschach\ am\ Wörther\ See",
"437748", "Eggelsberg",
"432688", "Steinbrunn",
"435226", "Neustift\ im\ Stubaital",
"432786", "Oberwölbling",
"437265", "Pabneukirchen",
"433366", "Kohfidisch",
"433576", "Bretstein",
"432618", "Markt\ St\.\ Martin",
"435672", "Reutte",
"436137", "Strobl",
"432716", "Gföhl",
"432756", "St\.\ Leonhard\ am\ Forst",
"435572", "Dornbirn",
"434237", "Miklauzhof",
"434761", "Stockenboi",
"437727", "Ach",
"434266", "Strassburg",
"432639", "Bad\ Fischau",
"434271", "Steuerberg",
"432863", "Eggern",
"433857", "Neuberg\ an\ der\ Mürz",
"432165", "Hainburg\ a\.d\.\ Donau",
"433337", "Vorau",
"435557", "St\.\ Gallenkirch",
"435517", "Riezlern",
"436278", "Ostermiething",
"437955", "Königswiesen",
"432741", "Flinsbach",
"437239", "Lichtenberg",
"432232", "Fischamend",
"433176", "Stubenberg",
"436416", "Lend",
"436456", "Obertauern",
"436233", "Oberwang",
"432849", "Schwarzenau",
"435244", "Jenbach",
"436566", "Bramberg\ am\ Wildkogel",
"437476", "Aschbach\-Markt",
"435442", "Landeck",
"432246", "Gerasdorf\ bei\ Wien",
"432723", "Rabenstein\ an\ der\ Pielach",
"435283", "Kaltenbach",
"432665", "Prein\ an\ der\ Rax",
"432874", "Martinsberg",
"435279", "St\.\ Jodok\ am\ Brenner",
"434355", "Gemmersdorf",
"437288", "Ulrichsberg",
"435213", "Scharnitz",
"436245", "Hallein",
"434843", "Ausservillgraten",
"435253", "Längenfeld",
"437218", "Grosstraberg",
"437258", "Bad\ Hall",
"437250", "Maria\ Neustift",
"437224", "St\.\ Florian",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"435553", "Raggal",
"435513", "Hittisau",
"435579", "Alberschwende",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"437588", "Ried\ im\ Traunkreis",
"435583", "Lech",
"432265", "Hausleiten",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"432748", "Kilb",
"433465", "Pölfing\-Brunn",
"437716", "Münzkirchen",
"437618", "Neukirchen\,\ Altmünster",
"437211", "Reichenau\ im\ Mühlkreis",
"433585", "St\.\ Lambrecht",
"432532", "Zistersdorf",
"437251", "Schiedlberg",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"437281", "Aigen\ im\ Mühlkreis",
"433534", "Stadl\ an\ der\ Mur",
"433615", "Trieben",
"433634", "Hieflau",
"435287", "Tux",
"434785", "Ausserfragant",
"432632", "Pernitz",
"433685", "Gröbming",
"434715", "Kötschach\-Mauthen",
"434847", "Obertilliach",
"434734", "Rennweg",
"432239", "Breitenfurt\ bei\ Wien",
"434245", "Feistritz\ an\ der\ Drau",
"437434", "Haag",
"437415", "Altenmarkt\,\ Yspertal",
"434768", "Kleblach\-Lind",
"436133", "Ebensee",
"437485", "Gaming",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"435335", "Hopfgarten\ im\ Brixental",
"432985", "Gars\ am\ Kamp",
"435354", "Fieberbrunn",
"434233", "Griffen",
"432146", "Nickelsdorf",
"432955", "Grossweikersdorf",
"432915", "Drosendorf\-Zissersdorf",
"435474", "Pfunds",
"432288", "Auersthal",
"433883", "Terz",
"437665", "Unterach\ am\ Attersee",
"437723", "Altheim",
"437246", "Gunskirchen",
"432524", "Kautendorf",
"433853", "Spital\ am\ Semmering",
"432258", "Alland",
"435272", "Steinach\ am\ Brenner",
"433185", "Preding",
"433844", "Kammern\ im\ Liesingtal",
"432610", "Horitschon",
"432624", "Ebenfurth",
"435449", "Fliess",
"433115", "Studenzen",
"432842", "Waidhofen\ an\ der\ Thaya",
"437565", "St\.\ Pankraz",
"436475", "Ramingstein",
"435526", "Laterns",
"433155", "Fehring",
"433134", "Heiligenkreuz\ am\ Waasen",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"433333", "Sebersdorf",
"434278", "Gnesau",
"433622", "Bad\ Aussee",
"432682", "Eisenstadt",
"433635", "Radmer",
"433614", "Rottenmann",
"437742", "Mattighofen",
"437619", "Kirchham",
"434784", "Mallnitz",
"432612", "Oberpullendorf",
"433684", "St\.\ Martin\ am\ Grimming",
"437673", "Schwanenstadt",
"434735", "Kremsbrücke",
"432749", "Prinzersdorf",
"434714", "Dellach\ im\ Drautal",
"435678", "Weissenbach\ am\ Lech",
"435578", "Höchst",
"432177", "Podersdorf\ am\ See",
"437231", "Herzogsdorf",
"434226", "St\.\ Margareten\ im\ Rosental",
"437767", "Eggerding",
"436217", "Mattsee",
"432552", "Poysdorf",
"433584", "Neumarkt\ in\ Steiermark",
"436463", "Annaberg\-Lungötz",
"432774", "Innermanzing",
"433535", "Krakaudorf",
"432823", "Grossglobnitz",
"433514", "Seckau",
"432264", "Rückersdorf\,\ Harmannsdorf",
"432841", "Vitis",
"436583", "Leogang",
"433464", "Gross\ St\.\ Florian",
"437947", "Kefermarkt",
"437736", "Pram",
"435633", "Hägerau",
"437277", "Waizenkirchen",
"433326", "Stegersbach",
"437225", "Hargelsberg",
"435266", "Ötztal\-Bahnhof",
"437230", "Altenberg\ bei\ Linz",
"436544", "Rauris",
"433845", "Mautern\ in\ Steiermark",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432630", "Ternitz",
"436272", "Oberndorf\ bei\ Salzburg",
"433383", "Burgau",
"432577", "Asparn\ an\ der\ Zaya",
"432625", "Bad\ Sauerbrunn",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"433135", "Kalsdorf\ bei\ Graz",
"437564", "Hinterstoder",
"436474", "Tamsweg",
"433114", "Markt\ Hartmannsdorf",
"433353", "Oberschützen",
"433143", "Krottendorf",
"4346", "Klagenfurt",
"435475", "Feichten",
"437664", "Weyregg\ am\ Attersee",
"432238", "Kaltenleutgeben",
"433833", "Traboch",
"432525", "Gnadendorf",
"434769", "Möllbrücke",
"432856", "Weitra",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432631", "Pöttsching",
"432816", "Karlstift",
"432984", "Eggenburg",
"435334", "Westendorf",
"435355", "Jochberg",
"434279", "Sirnitz",
"434213", "Launsdorf",
"437443", "Ybbsitz",
"434253", "St\.\ Jakob\ im\ Rosental",
"432914", "Japons",
"435448", "Pettneu\ am\ Arlberg",
"432954", "Göllersdorf",
"437414", "Weins\-Isperdorf",
"437435", "St\.\ Valentin",
"434244", "Bad\ Bleiberg",
"432259", "Münchendorf",
"434876", "Kals\ am\ Grossglockner",
"437282", "Neufelden",
"432943", "Obritz",
"432289", "Matzen",
"433473", "Straden",
"437484", "Göstling\ an\ der\ Ybbs",
"432273", "Tulbing",
"437252", "Steyr",
"437212", "Zwettl\ an\ der\ Rodl",
"435214", "Leutasch",
"432859", "Brand\-Nagelberg",
"435254", "Sölden",
"434276", "Feldkirchen\ in\ Kärnten",
"435284", "Gerlos",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432873", "Kottes",
"433637", "Gams\ bei\ Hieflau",
"435412", "Imst",
"432256", "Leobersdorf",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"433537", "St\.\ Georgen\ ob\ Murau",
"434879", "St\.\ Veit\ in\ Defereggen",
"436432", "Bad\ Hofgastein",
"433456", "Fresing",
"436215", "Strasswalchen",
"437765", "Lambrechten",
"434853", "Ainet",
"436234", "Zell\ am\ Moos",
"435243", "Maurach",
"432286", "Obersiebenbrunn",
"432175", "Apetlon",
"437248", "Grieskirchen",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"433571", "Möderbrugg",
"432711", "Dürnstein",
"435372", "Kufstein",
"434766", "Millstatt",
"437227", "Neuhofen\ an\ der\ Krems",
"437471", "Neustadtl\ an\ der\ Donau",
"432732", "Krems\ an\ der\ Donau",
"433137", "Söding",
"432627", "Pitten",
"432575", "Ladendorf",
"4319", "Vienna",
"433847", "Trofaiach",
"432864", "Kautzen",
"433329", "Jennersdorf",
"432527", "Wulzeshofen",
"433170", "Fischbach",
"433862", "Bruck\ an\ der\ Mur",
"435477", "Tösens",
"437758", "Obernberg\ am\ Inn",
"437718", "Waldkirchen\ am\ Wesen",
"434826", "Mörtschach",
"437616", "Grünau\ im\ Almtal",
"432648", "Hochneukirchen",
"435357", "Kirchberg\ in\ Tirol",
"432746", "Wilhelmsburg",
"437586", "Pettenbach",
"434229", "Krumpendorf\ am\ Wörther\ See",
"433171", "Gasen",
"433861", "Aflenz",
"437953", "Liebenau",
"437249", "Bad\ Schallerbach",
"432242", "St\.\ Andrä\-Wördern",
"436547", "Kaprun",
"436221", "Koppl",
"437274", "Alkoven",
"435446", "St\.\ Anton\ am\ Arlberg",
"433467", "Schwanberg",
"437944", "Sandl",
"432858", "Moorbad\ Harbach",
"432267", "Sierndorf",
"437472", "Amstetten",
"436562", "Mittersill",
"432731", "Idolsberg",
"432236", "Mödling",
"433172", "Weiz",
"436412", "St\.\ Johann\ im\ Pongau",
"436452", "Radstadt",
"436235", "Thalgau",
"437764", "Riedau",
"436214", "Henndorf\ am\ Wallersee",
"433587", "Schönberg\-Lachtal",
"432174", "Wallern\ im\ Burgenland",
"435234", "Axams",
"435255", "Umhausen",
"436243", "Abtenau",
"434717", "Steinfeld",
"433687", "Schladming",
"432663", "Schottwien",
"435285", "Mayrhofen",
"432725", "Frankenfels",
"433617", "Gaishorn\ am\ See",
"434353", "Prebl",
"437487", "Gresten",
"433328", "Kukmirn",
"437263", "Bad\ Zell",
"434247", "Afritz",
"432957", "Hohenwarth",
"435337", "Brixlegg",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"434262", "Treibach",
"432865", "Litschau",
"432674", "Weissenbach\ an\ der\ Triesting",
"435576", "Hohenems",
"437667", "St\.\ Georgen\ im\ Attergau",
"434228", "Feistritz\ im\ Rosental",
"433572", "Judenburg",
"432649", "Mönichkirchen",
"432163", "Petronell\-Carnuntum",
"433157", "Kapfenstein",
"435676", "Jungholz",
"432712", "Aggsbach",
"436477", "St\.\ Michael\ im\ Lungau",
"432752", "Melk",
"433117", "Eggersdorf\ bei\ Graz",
"437759", "Antiesenhofen",
"432574", "Gaweinstal",
"437719", "Taufkirchen\ an\ der\ Pram",
"432782", "Herzogenburg",
"433362", "Grosspetersdorf",
"432846", "Raabs\ an\ der\ Thaya",
"433474", "Deutsch\ Goritz",
"437483", "Oberndorf\ an\ der\ Melk",
"436135", "Bad\ Goisern",
"435522", "Feldkirch",
"432274", "Sieghartskirchen",
"437479", "Ardagger",
"437267", "Mönchdorf",
"437413", "Marbach\ an\ der\ Donau",
"434243", "Bodensdorf",
"435418", "Schönwies",
"432944", "Haugsdorf",
"434220", "Köttmannsdorf",
"434214", "Brückl",
"437444", "Opponitz",
"434254", "Faak\ am\ See",
"434235", "Bleiburg",
"432249", "Gross\-Enzersdorf",
"432913", "Hötzelsdorf",
"435276", "Gschnitz",
"432953", "Nappersdorf",
"434284", "Kirchbach",
"435333", "Söll",
"432983", "Sigmundsherberg",
"437242", "Wels",
"433834", "Wald\ am\ Schoberpass",
"433855", "Krieglach",
"432142", "Gattendorf",
"433144", "Köflach",
"433885", "Greith",
"437663", "Steinbach\ am\ Attersee",
"433153", "Riegersburg",
"437563", "Spital\ am\ Pyhrn",
"436473", "Mariapfarr",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"433335", "Pöllau",
"437236", "Pregarten",
"434221", "Gallizien",
"433354", "Bernstein",
"432167", "Neusiedl\ am\ See",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"433179", "Passail",
"432764", "Hainfeld",
"434269", "Flattnitz",
"432636", "Puchberg\ am\ Schneeberg",
"435585", "Dalaas",
"432738", "Fels\ am\ Wagram",
"435515", "Au",
"433126", "Frohnleiten",
"436543", "Taxenbach",
"435634", "Elbigenalp",
"436228", "Faistenau",
"433868", "Tragöss",
"432263", "Grossrussbach",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"433463", "Stainz",
"432536", "Drösing",
"437712", "Schärding",
"432773", "Eichgraben",
"437752", "Ried\ im\ Innkreis",
"432824", "Allentsteig",
"433513", "Bischoffeld",
"433579", "Pöls",
"432642", "Aspangberg\-St\.\ Peter",
"432719", "Dross",
"433583", "Unzmarkt",
"437674", "Attnang\-Puchheim",
"433683", "Donnersbach",
"436247", "Grossgmain",
"434713", "Techendorf",
"433613", "Admont",
"434357", "St\.\ Paul\ im\ Lavanttal",
"43512", "Innsbruck",
"432667", "Schwarzau\ im\ Gebirge",
"434783", "Reisseck",
"433133", "Nestelbach",
"437256", "Ternberg",
"433334", "Kaindorf",
"433355", "Stadtschlaining",
"437216", "Helfenberg",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"432248", "Markgrafneusiedl",
"432765", "Kaumberg",
"432623", "Pottendorf",
"434872", "Huben",
"437286", "Lembach\ im\ Mühlkreis",
"433385", "Ilz",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"433854", "Langenwang",
"435473", "Nauders",
"432852", "Gmünd",
"43662", "Salzburg",
"433884", "Wegscheid",
"432812", "Gross\ Gerungs",
"433145", "Edelschrott",
"437478", "Oed\-Oehling",
"437724", "Mauerkirchen",
"437750", "Andrichsfurt",
"437445", "Hollenstein\ an\ der\ Ybbs",
"434234", "Ruden",
"434255", "Arnoldstein",
"434215", "Liebenfels",
"436458", "Hüttau",
"436418", "Kleinarl",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"434285", "Tröpolach",
"435353", "Waidring",
"436134", "Hallstatt",
"432641", "Kirchberg\ am\ Wechsel",
"433475", "Hürth",
"432275", "Atzenbrugg",
"437751", "St\.\ Martin\ im\ Innkreis",
"437433", "Wallsee",
"437711", "Suben",
"432945", "Zellerndorf",
"436276", "Nussdorf\ am\ Haunsberg",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"437675", "Ampflwang\ im\ Hausruckwald",
"4314", "Vienna",
"434733", "Malta",
"437241", "Steinerkirchen\ an\ der\ Traun",
"432877", "Grainbrunn",
"433322", "Güssing",
"433633", "Landl",
"435262", "Telfs",
"436229", "Hof\ bei\ Salzburg",
"437732", "Haag\ am\ Hausruck",
"432825", "Göpfritz\ an\ der\ Wild",
"433533", "Turrach",
"434268", "Friesach",
"432739", "Tiefenfucha",
"435635", "Elmen",
"437240", "Sipbachzell",
"432556", "Grosskrut",
"432616", "Lockenhaus",
"433578", "Obdach",
"432758", "Pöggstall",
"432718", "Lichtenau\ im\ Waldviertel",
"432686", "Drassburg",
"437746", "Friedburg",
"437223", "Enns",
"435554", "Sonntag",
"435514", "Bezau",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"434356", "Lavamünd",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432666", "Reichenau",
"432245", "Wolkersdorf\ im\ Weinviertel",
"435374", "Walchsee",
"4315", "Vienna",
"433358", "Litzelsdorf",
"436246", "Grödig",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"436565", "Neukirchen\ am\ Grossvenediger",
"4316", "Vienna",
"433148", "Kainach\ bei\ Voitsberg",
"432233", "Pressbaum",
"433339", "Friedberg",
"436232", "Mondsee",
"437355", "Weyer",
"435443", "Galtür",
"436455", "Untertauern",
"436434", "Bad\ Gastein",
"436415", "Schwarzach\ im\ Pongau",
"433175", "Anger",
"434258", "Gummern",
"437448", "Kematen\ an\ der\ Ybbs",
"432948", "Weitersfeld",
"435414", "Wenns",
"435282", "Zell\ am\ Ziller",
"432722", "Kirchberg\ an\ der\ Pielach",
"433859", "Mürzsteg",
"433127", "Peggau",
"432637", "Grünbach\ am\ Schneeberg",
"437729", "Neukirchen\ an\ der\ Enknach",
"432278", "Absdorf",
"435212", "Seefeld\ in\ Tirol",
"437956", "Unterweissenbach",
"434842", "Sillian",
"435252", "Oetz",
"43732", "Linz",
"435673", "Ehrwald",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432166", "Parndorf",
"436468", "Werfen",
"434265", "Weitensfeld\ im\ Gurktal",
"435573", "Hörbranz",
"432828", "Rappottenstein",
"435519", "Schröcken",
"435559", "Brand",
"436588", "Lofer",
"433864", "St\.\ Marein\ im\ Mürztal",
"436224", "Hintersee",
"432862", "Heidenreichstein",
"433365", "Deutsch\ Schützen\-Eisenberg",
"437266", "Bad\ Kreuzen",
"435230", "Sellrain",
"435225", "Fulpmes",
"432847", "Gross\-Siegharts",
"432734", "Langenlois",
"432755", "Mank",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"437941", "Neumarkt\ im\ Mühlkreis",
"433575", "St\.\ Johann\ am\ Tauern",
"432687", "Siegendorf",
"437747", "Kirchberg\ bei\ Mattighofen",
"432617", "Drassmarkt",
"435232", "Kematen\ in\ Tirol",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"433149", "Geistthal",
"436484", "Lessach",
"433359", "Loipersdorf\-Kitzladen",
"432172", "Frauenkirchen",
"437762", "Raab",
"432557", "Bernhardsthal",
"436212", "Seekirchen\ am\ Wallersee",
"433174", "Birkfeld",
"432769", "Türnitz",
"436414", "Grossarl",
"436454", "Mandling",
"434238", "Eisenkappel\-Vellach",
"437474", "Euratsfeld",
"437728", "Schwand\ im\ Innkreis",
"436564", "Krimml",
"432279", "Kirchberg\ am\ Wagram",
"437942", "Freistadt",
"432283", "Angern\ an\ der\ March",
"435246", "Achenkirch",
"432949", "Niederfladnitz",
"433453", "Ehrenhausen",
"432253", "Oberwaltersdorf",
"437272", "Eferding",
"433858", "Mitterdorf\ im\ Mürztal",
"432213", "Lassee",
"432876", "Els",
"435375", "Kössen",
"432244", "Langenzersdorf",
"434273", "Reifnitz",
"433338", "Lafnitz",
"435518", "Mellau",
"432829", "Schweiggers",
"435224", "Wattens",
"432784", "Perschling",
"435558", "Gaschurn",
"433364", "Hannersdorf",
"436277", "St\.\ Pantaleon",
"432572", "Mistelbach",
"435280", "Hochfügen",
"432714", "Rossatz",
"432754", "Loosdorf",
"432735", "Hadersdorf\ am\ Kamp",
"437583", "Kremsmünster",
"433574", "Pusterwald",
"437683", "Frankenburg\ am\ Hausruck",
"432743", "Böheimkirchen",
"433865", "Kindberg",
"436225", "Eugendorf",
"434823", "Tresdorf\,\ Rangersdorf",
"437613", "Laakirchen",
"432672", "Berndorf",
"434264", "Klein\ St\.\ Paul",
"437287", "Peilstein\ im\ Mühlviertel",
"436589", "Unken",
"437257", "Grünburg",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"434875", "Matrei\ in\ Osttirol",
"433382", "Fürstenfeld",
"432762", "Lilienfeld",
"437587", "Wartberg\ an\ der\ Krems",
"433352", "Oberwart",
"436219", "Obertrum\ am\ See",
"435356", "Kitzbühel",
"432815", "Grossschönau",
"433142", "Voitsberg",
"432747", "Ober\-Grafendorf",
"435239", "Kühtai",
"432855", "Waldenstein",
"437617", "Traunkirchen",
"433832", "Kraubath\ an\ der\ Mur",
"432144", "Deutsch\ Jahrndorf",
"437244", "Sattledt",
"435476", "Serfaus",
"434282", "Hermagor",
"432526", "Stronsdorf",
"434212", "St\.\ Veit\ an\ der\ Glan",
"434252", "Wernberg",
"437442", "Waidhofen\ an\ der\ Ybbs",
"432626", "Mattersburg",
"437283", "Sarleinsbach",
"432942", "Retz",
"433846", "Kalwang",
"437279", "Haibach\ ob\ der\ Donau",
"432728", "Wienerbruck",
"435288", "Fügen",
"432272", "Tulln\ an\ der\ Donau",
"437253", "Wolfern",
"437213", "Bad\ Leonfelden",
"434848", "Kartitsch",
"437949", "Rainbach\ im\ Mühlkreis",
"435550", "Thüringen",
"433472", "Mureck",
"435510", "Damüls",
"433136", "Dobl",
"435524", "Satteins",
"432683", "Purbach\ am\ Neusiedler\ See",
"434767", "Rothenthurn",
"435265", "Nassereith",
"437743", "Maria\ Schmolln",
"437226", "Wilhering",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"434231", "Mittertrixen",
"432613", "Deutschkreutz",
"437672", "Vöcklabruck",
"436462", "Bischofshofen",
"436131", "Obertraun",
"432644", "Grimmenstein",
"432822", "Zwettl\,\ Lower\ Austria",
"437714", "Esternberg",
"437754", "Waldzell",
"437735", "Gaspoltshofen",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"434230", "Globasnitz",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"434225", "Grafenstein",
"432287", "Strasshof\ an\ der\ Nordbahn",
"432257", "Klausen\-Leopoldsdorf",
"433536", "St\.\ Peter\ am\ Kammersberg",
"433457", "Gleinstätten",
"435632", "Stanzach",
"433636", "Wildalpen",
"434736", "Innerkrems",
"434277", "Glanegg",
"436461", "Dienten\ am\ Hochkönig",
"437233", "Feldkirchen\ an\ der\ Donau",
"435525", "Nenzing",
"436132", "Bad\ Ischl",
"435677", "Vils",
"437566", "Rosenau\ am\ Hengstpass",
"436476", "St\.\ Margarethen\ im\ Lungau",
"433116", "Kirchbach\ in\ Steiermark",
"435238", "Zirl",
"435577", "Lustenau",
"437245", "Lambach",
"437666", "Attersee",
"434232", "Völkermarkt",
"435336", "Alpbach",
"432986", "Irnfritz",
"437722", "Braunau\ am\ Inn",
"432854", "Kirchberg\ am\ Walde",
"433882", "Mariazell",
"437948", "Hirschbach\ im\ Mühlkreis",
"432814", "Langschlag",
"432916", "Riegersburg\,\ Hardegg",
"432956", "Ziersdorf",
"435273", "Matrei\ am\ Brenner",
"432145", "Prellenkirchen",
"437278", "Neukirchen\ am\ Walde",
"433852", "Mürzzuschlag",
"435289", "Häusling",
"434874", "Virgen",
"437416", "Wieselburg",
"434246", "Radenthein",
"433332", "Hartberg",
"433623", "Bad\ Mitterndorf",
"432843", "Dobersberg",
"437486", "Lunz\ am\ See",
"435552", "Bludenz",
"435512", "Egg",
"433616", "Selzthal",
"435582", "Klösterle",
"434716", "Lesachtal",
"433686", "Haus",
"433141", "Hirschegg",
"434224", "Pischeldorf",
"433586", "Mühlen",
"433516", "Kleinlobming",
"432237", "Gaaden",
"433466", "Eibiswald",
"432533", "Neusiedl\ an\ der\ Zaya",
"432271", "Ried\ am\ Riederberg",
"432645", "Wiesmath",
"432266", "Stockerau",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"437755", "Mettmach",
"435447", "Flirsch",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"433324", "Strem",
"435264", "Mieming",
"4312", "Vienna",
"432633", "Markt\ Piesting",
"433469", "St\.\ Oswald\ im\ Freiland",
"435675", "Tannheim",
"432269", "Niederfellabrunn",
"4318", "Vienna",
"437262", "Perg",
"433638", "Palfau",
"436549", "Piesendorf",
"437247", "Kematen\ am\ Innbach",
"435575", "Langen\ bei\ Bregenz",
"434263", "Hüttenberg",
"434824", "Heiligenblut",
"437614", "Vorchdorf",
"432147", "Zurndorf",
"433619", "Oppenberg",
"437684", "Frankenmarkt",
"432744", "Kasten\ bei\ Böheimkirchen",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"432713", "Spitz",
"432753", "Gansbach",
"433573", "Fohnsdorf",
"437584", "Molln",
"432162", "Bruck\ an\ der\ Leitha",
"435223", "Hall\ in\ Tirol",
"432783", "Traismauer",
"433363", "Rechnitz",
"437228", "Kematen\ an\ der\ Krems",
"434274", "Velden\ am\ Wörther\ See",
"435339", "Wildschönau",
"432989", "Brunn\ an\ der\ Wild",
"437952", "Weitersfelden",
"434846", "Abfaltersbach",
"435256", "Untergurgl",
"432959", "Sitzendorf\ an\ der\ Schmida",
"432628", "Felixdorf",
"435286", "Ginzling",
"432243", "Klosterneuburg",
"432726", "Puchenstuben",
"433848", "Eisenerz",
"433454", "Leutschach",
"432254", "Ebreichsdorf",
"432235", "Maria\-Lanzendorf",
"432214", "Kopfstetten",
"437473", "Blindenmarkt",
"436563", "Uttendorf",
"437489", "Purgstall\ an\ der\ Erlauf",
"432284", "Oberweiden",
"433173", "Ratten",
"437717", "St\.\ Aegidi",
"436413", "Wagrain",
"436453", "Filzmoos",
"437757", "Gurten",
"435445", "Kappl",
"435358", "Ellmau",
"436483", "Göriach",
"432647", "Krumbach\,\ Lower\ Austria",
"433119", "St\.\ Marein\ bei\ Graz",
"437353", "Gaflenz",
"436479", "Muhr",
"433159", "Bad\ Gleichenberg",
"436242", "Russbach\ am\ Pass\ Gschütt",
"434352", "Wolfsberg",
"432662", "Gloggnitz",
"432733", "Schönberg\ am\ Kamp",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"436548", "Niedernsill",
"436240", "Krispl",
"434877", "Prägraten\ am\ Grossvenediger",
"437615", "Scharnstein",
"436223", "Anthering",
"434825", "Grosskirchheim",
"432857", "Bad\ Grosspertholz",
"432745", "Pyhra",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"432268", "Grossmugl",
"433863", "Turnau",
"4313", "Vienna",
"437229", "Traun",
"433588", "Katsch\ an\ der\ Mur",
"435574", "Bregenz",
"436241", "St\.\ Koloman",
"434718", "Dellach",
"435674", "Bichlbach",
"433688", "Tauplitz",
"433618", "Hohentauern",
"432576", "Ernstbrunn",
"437488", "Steinakirchen\ am\ Forst",
"433327", "St\.\ Michael\ im\ Burgenland",
"432872", "Ottenschlag",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"432160", "Jois",
"434248", "Treffen",
"432958", "Maissau",
"435444", "Ischgl",
"436433", "Dorfgastein",
"432629", "Warth\,\ Lower\ Austria",
"437261", "Schönau\ im\ Mühlkreis",
"437276", "Peuerbach",
"433849", "Vordernberg",
"435338", "Kundl",
"432988", "Neupölla",
"434852", "Lienz",
"437946", "Gutau",
"435242", "Schwaz",
"433455", "Arnfels",
"432215", "Probstdorf",
"432255", "Deutsch\ Brodersdorf",
"432234", "Gramatneusiedl",
"432176", "Tadten",
"434227", "Ferlach",
"432285", "Marchegg",
"436216", "Neumarkt\ am\ Wallersee",
"437766", "Andorf",
"435359", "Hochfilzen",
"434275", "Ebene\ Reichenau",
"437260", "Waldhausen",
"435236", "Gries\ im\ Sellrain",
"433118", "Sinabelkirchen",
"436478", "Zederhaus",
"433158", "St\.\ Anna\ am\ Aigen",
"435373", "Ebbs",
"435331", "Brandenberg",
"434732", "Gmünd\ in\ Kärnten",
"432634", "Gutenstein",
"432615", "Lutzmannsburg",
"433150", "Paldau",
"432951", "Guntersdorf",
"436470", "Atzmannsdorf",
"433124", "Gratkorn",
"437268", "Grein",
"433323", "Eberau",
"437745", "Lochen",
"433632", "St\.\ Gallen",
"435263", "Silz",
"435417", "Roppen",
"432685", "Rust",
"433532", "Murau",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432534", "Niedersulz",
"432555", "Herrnbaumgarten",
"432826", "Rastenfeld",
"434223", "Maria\ Saal",
"436466", "Werfenweng",
"436471", "Tweng",
"433151", "Gnas",
"434240", "Bad\ Kleinkirchheim",
"432168", "Mannersdorf\ am\ Leithagebirge",
"437676", "Ottnang\ am\ Hausruck",
"437480", "Langau\,\ Gaming",
"432276", "Reidling",
"433461", "Trahütten",
"433624", "Pichl\-Kainisch",
"432844", "Karlstein\ an\ der\ Thaya",
"433476", "Bad\ Radkersburg",
"433132", "Kumberg",
"432622", "Wiener\ Neustadt",
"433680", "Donnersbachwald",
"434873", "St\.\ Jakob\ in\ Defereggen",
"432946", "Pulkau",
"433842", "Leoben",
"434710", "Oberdrauburg",
"436541", "Saalbach",
"435274", "Gries\ am\ Brenner",
"432522", "Laa\ an\ der\ Thaya",
"434256", "Nötsch\ im\ Gailtal",
"436227", "St\.\ Gilgen",
"433867", "Pernegg\ an\ der\ Mur",
"432853", "Schrems",
"435472", "Prutz",
"434286", "Weissbriach",
"432813", "Arbesbach",
"433611", "Johnsbach",
"433460", "Soboth",
"4317", "Vienna",
"435352", "St\.\ Johann\ in\ Tirol",
"433146", "Modriach",
"437215", "Hellmonsödt",
"433581", "Oberwölz",
"437255", "Losenstein",
"437234", "Ottensheim",
"433356", "Markt\ Allhau",
"433386", "Grosssteinbach",
"437285", "Hofkirchen\ im\ Mühlkreis",
"434358", "St\.\ Andrä",
"432766", "Kleinzell",
"437432", "Strengberg",
"432247", "Deutsch\-Wagram",
"436542", "Zell\ am\ See",
"432621", "Sieggraben",
"437269", "Baumgartenberg",
"433462", "Deutschlandsberg",
"432262", "Korneuburg",
"437477", "St\.\ Peter\ in\ der\ Au",
"433512", "Knittelfeld",
"433177", "Puch\ bei\ Weiz",
"437713", "Schardenberg",
"436417", "Hüttschlag",
"432772", "Neulengbach",
"436457", "Flachau",
"437753", "Eberschwang",
"437357", "Kleinreifling",
"432554", "Stützenhofen",
"432535", "Hohenau\ an\ der\ March",
"433582", "Scheifling",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"432643", "Lichtenegg",
"434712", "Greifenburg",
"432614", "Kleinwarasdorf",
"432620", "Willendorf",
"433682", "Stainach",
"432635", "Neunkirchen",
"435556", "Schruns",
"433125", "Übelbach",
"435516", "Doren",
"434782", "Obervellach",
"432684", "Schützen\ am\ Gebirge",
"433612", "Liezen",
"437744", "Munderfing",
"437235", "Gallneukirchen",
"437254", "Grossraming",
"433336", "Waldbach",
"437214", "Reichenthal",
"437482", "Scheibbs",
"435523", "Götzis",
"437284", "Oberkappel",
"432878", "Traunstein",
"437412", "Ybbs\ an\ der\ Donau",
"434242", "Villach",
"432912", "Geras",
"432952", "Hollabrunn",
"433631", "Unterlaussa",
"433856", "Veitsch",
"435332", "Wörgl",
"432982", "Horn",
"437243", "Marchtrenk",
"434267", "Metnitz",
"435248", "Steinberg\ am\ Rofan",
"434858", "Nikolsdorf",
"433886", "Weichselboden",
"435275", "Trins",
"434359", "Reichenfels",
"434236", "Eberndorf",
"437221", "Hörsching",
"432143", "Kittsee",
"437662", "Seewalchen\ am\ Attersee",
"433577", "Zeltweg",
"433152", "Feldbach",
"436136", "Gosau",
"432717", "Unter\-Meisling",
"437562", "Windischgarsten",
"436472", "Mauterndorf",
"432757", "Pöchlarn",
"432845", "Weikertschlag\ an\ der\ Thaya",
"433112", "Gleisdorf",
"436274", "Lamprechtshausen",
"433182", "Wildon",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;