; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define i8 @scmp_lt() {
; CHECK-LABEL: define i8 @scmp_lt() {
; CHECK-NEXT:    ret i8 -1
;
  %1 = call i8 @llvm.scmp(i32 -7, i32 3)
  ret i8 %1
}

define i8 @scmp_eq() {
; CHECK-LABEL: define i8 @scmp_eq() {
; CHECK-NEXT:    ret i8 0
;
  %1 = call i8 @llvm.scmp(i32 2, i32 2)
  ret i8 %1
}

define i8 @scmp_gt() {
; CHECK-LABEL: define i8 @scmp_gt() {
; CHECK-NEXT:    ret i8 1
;
  %1 = call i8 @llvm.scmp(i32 2, i32 -7)
  ret i8 %1
}

define i8 @ucmp_lt() {
; CHECK-LABEL: define i8 @ucmp_lt() {
; CHECK-NEXT:    ret i8 -1
;
  %1 = call i8 @llvm.ucmp(i32 7, i32 12)
  ret i8 %1
}

define i2 @ucmp_eq() {
; CHECK-LABEL: define i2 @ucmp_eq() {
; CHECK-NEXT:    ret i2 0
;
  %1 = call i2 @llvm.ucmp(i32 12, i32 12)
  ret i2 %1
}

define i100 @ucmp_gt() {
; CHECK-LABEL: define i100 @ucmp_gt() {
; CHECK-NEXT:    ret i100 1
;
  %1 = call i100 @llvm.ucmp(i32 7, i32 3)
  ret i100 %1
}

define i8 @ucmp_poison() {
; CHECK-LABEL: define i8 @ucmp_poison() {
; CHECK-NEXT:    ret i8 poison
;
  %1 = call i8 @llvm.ucmp(i32 poison, i32 5)
  ret i8 %1
}

define i8 @scmp_poison() {
; CHECK-LABEL: define i8 @scmp_poison() {
; CHECK-NEXT:    ret i8 poison
;
  %1 = call i8 @llvm.scmp(i32 0, i32 poison)
  ret i8 %1
}

define i8 @scmp_undef() {
; CHECK-LABEL: define i8 @scmp_undef() {
; CHECK-NEXT:    ret i8 0
;
  %1 = call i8 @llvm.scmp(i32 undef, i32 -12)
  ret i8 %1
}

define i8 @ucmp_undef() {
; CHECK-LABEL: define i8 @ucmp_undef() {
; CHECK-NEXT:    ret i8 0
;
  %1 = call i8 @llvm.ucmp(i32 2, i32 undef)
  ret i8 %1
}

define <4 x i8> @ucmp_lt_splat() {
; CHECK-LABEL: define <4 x i8> @ucmp_lt_splat() {
; CHECK-NEXT:    ret <4 x i8> <i8 -1, i8 -1, i8 -1, i8 -1>
;
  %1 = call <4 x i8> @llvm.ucmp(<4 x i32> splat(i32 1), <4 x i32> splat(i32 3))
  ret <4 x i8> %1
}

define <4 x i8> @scmp_nonsplat() {
; CHECK-LABEL: define <4 x i8> @scmp_nonsplat() {
; CHECK-NEXT:    ret <4 x i8> <i8 1, i8 0, i8 1, i8 -1>
;
  %1 = call <4 x i8> @llvm.scmp(<4 x i32> <i32 0, i32 1, i32 2, i32 3>, <4 x i32> <i32 -1, i32 1, i32 -2, i32 4>)
  ret <4 x i8> %1
}

define i8 @scmp_with_itself(i32 %x) {
; CHECK-LABEL: define i8 @scmp_with_itself(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    ret i8 0
;
  %1 = call i8 @llvm.scmp(i32 %x, i32 %x)
  ret i8 %1
}

define <4 x i8> @ucmp_vec_with_itself(<4 x i32> %x) {
; CHECK-LABEL: define <4 x i8> @ucmp_vec_with_itself(
; CHECK-SAME: <4 x i32> [[X:%.*]]) {
; CHECK-NEXT:    ret <4 x i8> zeroinitializer
;
  %1 = call <4 x i8> @llvm.scmp(<4 x i32> %x, <4 x i32> %x)
  ret <4 x i8> %1
}

define i8 @scmp_known_gt(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @scmp_known_gt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret i8 1
;
  %1 = icmp sgt i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @scmp_known_eq(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @scmp_known_eq(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret i8 0
;
  %1 = icmp eq i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @scmp_known_lt(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @scmp_known_lt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret i8 -1
;
  %1 = icmp slt i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @ucmp_known_gt(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @ucmp_known_gt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ugt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret i8 1
;
  %1 = icmp ugt i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @ucmp_known_eq(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @ucmp_known_eq(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret i8 0
;
  %1 = icmp eq i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @ucmp_known_lt(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @ucmp_known_lt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret i8 -1
;
  %1 = icmp ult i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @ucmp_with_addition(i32 %x) {
; CHECK-LABEL: define i8 @ucmp_with_addition(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    ret i8 -1
;
  %1 = add nuw i32 %x, 1
  %2 = call i8 @llvm.ucmp(i32 %x, i32 %1)
  ret i8 %2
}

define i8 @ucmp_with_addition2(i32 %x) {
; CHECK-LABEL: define i8 @ucmp_with_addition2(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    ret i8 1
;
  %1 = add nuw i32 %x, 1
  %2 = call i8 @llvm.ucmp(i32 %1, i32 %x)
  ret i8 %2
}

define <4 x i8> @ucmp_with_addition_vec(<4 x i32> %x) {
; CHECK-LABEL: define <4 x i8> @ucmp_with_addition_vec(
; CHECK-SAME: <4 x i32> [[X:%.*]]) {
; CHECK-NEXT:    ret <4 x i8> <i8 -1, i8 -1, i8 -1, i8 -1>
;
  %1 = add nuw <4 x i32> %x, splat(i32 1)
  %2 = call <4 x i8> @llvm.ucmp(<4 x i32> %x, <4 x i32> %1)
  ret <4 x i8> %2
}

define i1 @scmp_eq_4(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @scmp_eq_4(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %1 = call i8 @llvm.scmp(i32 %x, i32 %y)
  %2 = icmp eq i8 %1, 4
  ret i1 %2
}

define i1 @ucmp_ne_negative_2(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @ucmp_ne_negative_2(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %1 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  %2 = icmp ne i8 %1, -2
  ret i1 %2
}

; Negative case: mismatched signedness of predicates
define i8 @scmp_known_ugt(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @scmp_known_ugt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ugt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i8 @llvm.scmp.i8.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    ret i8 [[TMP2]]
;
  %1 = icmp ugt i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @scmp_known_ult(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @scmp_known_ult(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i8 @llvm.scmp.i8.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    ret i8 [[TMP2]]
;
  %1 = icmp ult i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @ucmp_known_sgt(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @ucmp_known_sgt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i8 @llvm.ucmp.i8.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    ret i8 [[TMP2]]
;
  %1 = icmp sgt i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %2
}

define i8 @ucmp_known_slt(i32 %x, i32 %y) {
; CHECK-LABEL: define i8 @ucmp_known_slt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = call i8 @llvm.ucmp.i8.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    ret i8 [[TMP2]]
;
  %1 = icmp slt i32 %x, %y
  call void @llvm.assume(i1 %1)

  %2 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %2
}

; Negative case: no nuw flag
define i8 @ucmp_with_addition_no_nuw(i32 %x) {
; CHECK-LABEL: define i8 @ucmp_with_addition_no_nuw(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[X]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = call i8 @llvm.ucmp.i8.i32(i32 [[X]], i32 [[TMP1]])
; CHECK-NEXT:    ret i8 [[TMP2]]
;
  %1 = add i32 %x, 1
  %2 = call i8 @llvm.ucmp(i32 %x, i32 %1)
  ret i8 %2
}
