/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandIf: public LWCommandSegment {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 1, NULL);
	g_return_val_if_fail (context->instrPtr->next != NULL, NULL);
	
	if (0 == args[0]->toInt()) {
		
		//if there is "else" for that "if"
		if (TRUE == isAlreadyMatched())
			context->instrPtr = context->instrPtr->next->next->next;
		else
			context->instrPtr = context->instrPtr->next->next;
		
	}
	
	return NULL;
}

const gchar *getName (void)
{
	return "if";
}	

gchar *getHint ()
{
	return _("If");
}

void checkArgument (guint n, LWValue *value)
{
	(void) n;
	
	if (FALSE == value->isVariable() && FALSE == value->checkRange())
			throw new LWMessage (LW_ERROR_NumberOutOfRange);
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

gboolean matchNextCondition (LWCommand *cmd)
{
//	return (!g_ascii_strcasecmp (cmd->getName(), "else")); ||
//				!g_ascii_strcasecmp (cmd->getName(), "end")) ? TRUE : FALSE;
	return !g_ascii_strcasecmp (cmd->getName(), "else"); 
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd != NULL) {
		g_return_val_if_fail (!g_ascii_strcasecmp (cmd->getName(), "else"), FALSE);
		match();
		return TRUE;
	}

	return FALSE;
}

gboolean requiresLogicBlock ()
{
	return TRUE;
}

};

LWSymbol *new_LWCommandIf()
{
	return new LWCommandIf();
}
