/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.checkers.javac;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class JavacFieldResolutionTestGenerated extends AbstractJavacFieldResolutionTest {
    @TestMetadata("compiler/testData/javac/fieldsResolution/tests")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Tests extends AbstractJavacFieldResolutionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTests() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/javac/fieldsResolution/tests"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AsteriskStaticImportsAmbiguity.kt")
        public void testAsteriskStaticImportsAmbiguity() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/AsteriskStaticImportsAmbiguity.kt");
        }

        @TestMetadata("BinaryInitializers.kt")
        public void testBinaryInitializers() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/BinaryInitializers.kt");
        }

        @TestMetadata("ConstantByFqName.kt")
        public void testConstantByFqName() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ConstantByFqName.kt");
        }

        @TestMetadata("ConstantValues.kt")
        public void testConstantValues() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ConstantValues.kt");
        }

        @TestMetadata("ConstantValuesFromKtFile.kt")
        public void testConstantValuesFromKtFile() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ConstantValuesFromKtFile.kt");
        }

        @TestMetadata("FieldFromOuterClass.kt")
        public void testFieldFromOuterClass() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/FieldFromOuterClass.kt");
        }

        @TestMetadata("InheritedField.kt")
        public void testInheritedField() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/InheritedField.kt");
        }

        @TestMetadata("MultipleOuters.kt")
        public void testMultipleOuters() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/MultipleOuters.kt");
        }

        @TestMetadata("ResolutionPriority.kt")
        public void testResolutionPriority() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ResolutionPriority.kt");
        }

        @TestMetadata("SameFieldInSupertypes.kt")
        public void testSameFieldInSupertypes() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/SameFieldInSupertypes.kt");
        }

        @TestMetadata("StaticImport.kt")
        public void testStaticImport() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/StaticImport.kt");
        }

        @TestMetadata("StaticImportsAmbiguity.kt")
        public void testStaticImportsAmbiguity() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/StaticImportsAmbiguity.kt");
        }
    }

    @TestMetadata("compiler/testData/javac/fieldsResolution/tests")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TestsWithoutJavac extends AbstractJavacFieldResolutionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestWithoutJavacWrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTestsWithoutJavac() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/javac/fieldsResolution/tests"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AsteriskStaticImportsAmbiguity.kt")
        public void testAsteriskStaticImportsAmbiguity() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/AsteriskStaticImportsAmbiguity.kt");
        }

        @TestMetadata("BinaryInitializers.kt")
        public void testBinaryInitializers() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/BinaryInitializers.kt");
        }

        @TestMetadata("ConstantByFqName.kt")
        public void testConstantByFqName() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ConstantByFqName.kt");
        }

        @TestMetadata("ConstantValues.kt")
        public void testConstantValues() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ConstantValues.kt");
        }

        @TestMetadata("ConstantValuesFromKtFile.kt")
        public void testConstantValuesFromKtFile() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ConstantValuesFromKtFile.kt");
        }

        @TestMetadata("FieldFromOuterClass.kt")
        public void testFieldFromOuterClass() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/FieldFromOuterClass.kt");
        }

        @TestMetadata("InheritedField.kt")
        public void testInheritedField() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/InheritedField.kt");
        }

        @TestMetadata("MultipleOuters.kt")
        public void testMultipleOuters() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/MultipleOuters.kt");
        }

        @TestMetadata("ResolutionPriority.kt")
        public void testResolutionPriority() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/ResolutionPriority.kt");
        }

        @TestMetadata("SameFieldInSupertypes.kt")
        public void testSameFieldInSupertypes() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/SameFieldInSupertypes.kt");
        }

        @TestMetadata("StaticImport.kt")
        public void testStaticImport() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/StaticImport.kt");
        }

        @TestMetadata("StaticImportsAmbiguity.kt")
        public void testStaticImportsAmbiguity() throws Exception {
            runTest("compiler/testData/javac/fieldsResolution/tests/StaticImportsAmbiguity.kt");
        }
    }
}
