/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.util.Range;
import org.jetbrains.annotations.NotNull;

import java.util.Iterator;

class InvertedDiffIterableWrapper implements DiffIterable {
  @NotNull private final DiffIterable myIterable;

  InvertedDiffIterableWrapper(@NotNull DiffIterable iterable) {
    myIterable = iterable;
  }

  @Override
  public int getLength1() {
    return myIterable.getLength1();
  }

  @Override
  public int getLength2() {
    return myIterable.getLength2();
  }

  @Override
  @NotNull
  public Iterator<Range> changes() {
    return myIterable.unchanged();
  }

  @Override
  @NotNull
  public Iterator<Range> unchanged() {
    return myIterable.changes();
  }
}
