/*******************************************************************************
  Copyright (c) 2023-2024, Intel Corporation

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

      * Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
      * Neither the name of Intel Corporation nor the names of its contributors
        may be used to endorse or promote products derived from this software
        without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/* ZUC-EIA3 128  */
#include "mac_test.h"

/**
 *  Note: ZUC IV params stored in vector IV field
 *  uin32_t count = iv[0-3]
 *  uint8_t bearer = iv[4]
 *  uint8_t direction = iv[5]
 */
const struct mac_test zuc_eia3_128_test_json[] = {
        { 128, 32, 1, "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00", "\xc8\xa9\x59\x5e", 1, 1, "\x00\x00\x00\x00\x00\x00", 48 },
        { 128, 32, 2, "\x47\x05\x41\x25\x56\x1e\xb2\xdd\xa9\x40\x59\xda\x05\x09\x78\x50",
          "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "\x67\x19\xa0\x88", 1, 90,
          "\xdd\xb2\x1e\x56\x14\x00", 48 },
        { 128, 32, 3, "\xc9\xe6\xce\xc4\x60\x7c\x72\xdb\x00\x0a\xef\xa8\x83\x85\xab\x0a",
          "\x98\x3b\x41\xd4\x7d\x78\x0c\x9e\x1a\xd1\x1d\x7e\xb7\x03\x91\xb1\xde\x0b\x35\xda\x2d\xc6"
          "\x2f\x83\xe7\xb7\x8d\x63\x06\xca\x0e\xa0\x7e\x94\x1b\x7b\xe9\x13\x48\xf9\xfc\xb1\x70\xe2"
          "\x21\x7f\xec\xd9\x7f\x9f\x68\xad\xb1\x6e\x5d\x7d\x21\xe5\x69\xd2\x80\xed\x77\x5c\xeb\xde"
          "\x3f\x40\x93\xc5\x38\x81\x00\x00\x00\x00",
          "\xfa\xe8\xff\x0b", 1, 577, "\xda\x59\x40\xa9\x0a\x01", 48 },
        { 128, 32, 4, "\xc8\xa4\x82\x62\xd0\xc2\xe2\xba\xc4\xb9\x6e\xf7\x7e\x80\xca\x59",
          "\xb5\x46\x43\x0b\xf8\x7b\x4f\x1e\xe8\x34\x70\x4c\xd6\x95\x1c\x36\xe2\x6f\x10\x8c\xf7\x31"
          "\x78\x8f\x48\xdc\x34\xf1\x67\x8c\x05\x22\x1c\x8f\xa7\xff\x2f\x39\xf4\x77\xe7\xe4\x9e\xf6"
          "\x0a\x4e\xc2\xc3\xde\x24\x31\x2a\x96\xaa\x26\xe1\xcf\xba\x57\x56\x38\x38\xb2\x97\xf4\x7e"
          "\x85\x10\xc7\x79\xfd\x66\x54\xb1\x43\x38\x6f\xa6\x39\xd3\x1e\xdb\xd6\xc0\x6e\x47\xd1\x59"
          "\xd9\x43\x62\xf2\x6a\xee\xed\xee\x0e\x4f\x49\xd9\xbf\x84\x12\x99\x54\x15\xbf\xad\x56\xee"
          "\x82\xd1\xca\x74\x63\xab\xf0\x85\xb0\x82\xb0\x99\x04\xd6\xd9\x90\xd4\x3c\xf2\xe0\x62\xf4"
          "\x08\x39\xd9\x32\x48\xb1\xeb\x92\xcd\xfe\xd5\x30\x0b\xc1\x48\x28\x04\x30\xb6\xd0\xca\xa0"
          "\x94\xb6\xec\x89\x11\xab\x7d\xc3\x68\x24\xb8\x24\xdc\x0a\xf6\x68\x2b\x09\x35\xfd\xe7\xb4"
          "\x92\xa1\x4d\xc2\xf4\x36\x48\x03\x8d\xa2\xcf\x79\x17\x0d\x2d\x50\x13\x3f\xd4\x94\x16\xcb"
          "\x6e\x33\xbe\xa9\x0b\x8b\xf4\x55\x9b\x03\x73\x2a\x01\xea\x29\x0e\x6d\x07\x4f\x79\xbb\x83"
          "\xc1\x0e\x58\x00\x15\xcc\x1a\x85\xb3\x6b\x55\x01\x04\x6e\x9c\x4b\xdc\xae\x51\x35\x69\x0b"
          "\x86\x66\xbd\x54\xb7\xa7\x03\xea\x7b\x6f\x22\x0a\x54\x69\xa5\x68\x02\x7e",
          "\x00\x4a\xc4\xd6", 1, 2079, "\x50\x78\x09\x05\x10\x01", 48 },
        { 128, 32, 5, "\x6b\x8b\x08\xee\x79\xe0\xb5\x98\x2d\x6d\x12\x8e\xa9\xf2\x20\xcb",
          "\x5b\xad\x72\x47\x10\xba\x1c\x56\xd5\xa3\x15\xf8\xd4\x0f\x6e\x09\x37\x80\xbe\x8e\x8d\xe0"
          "\x7b\x69\x92\x43\x20\x18\xe0\x8e\xd9\x6a\x57\x34\xaf\x8b\xad\x8a\x57\x5d\x3a\x1f\x16\x2f"
          "\x85\x04\x5c\xc7\x70\x92\x55\x71\xd9\xf5\xb9\x4e\x45\x4a\x77\xc1\x6e\x72\x93\x6b\xf0\x16"
          "\xae\x15\x74\x99\xf0\x54\x3b\x5d\x52\xca\xa6\xdb\xea\xb6\x97\xd2\xbb\x73\xe4\x1b\x80\x75"
          "\xdc\xe7\x9b\x4b\x86\x04\x4f\x66\x1d\x44\x85\xa5\x43\xdd\x78\x60\x6e\x04\x19\xe8\x05\x98"
          "\x59\xd3\xcb\x2b\x67\xce\x09\x77\x60\x3f\x81\xff\x83\x9e\x33\x18\x59\x54\x4c\xfb\xc8\xd0"
          "\x0f\xef\x1a\x4c\x85\x10\xfb\x54\x7d\x6b\x06\xc6\x11\xef\x44\xf1\xbc\xe1\x07\xcf\xa4\x5a"
          "\x06\xaa\xb3\x60\x15\x2b\x28\xdc\x1e\xbe\x6f\x7f\xe0\x9b\x05\x16\xf9\xa5\xb0\x2a\x1b\xd8"
          "\x4b\xb0\x18\x1e\x2e\x89\xe1\x9b\xd8\x12\x59\x30\xd1\x78\x68\x2f\x38\x62\xdc\x51\xb6\x36"
          "\xf0\x4e\x72\x0c\x47\xc3\xce\x51\xad\x70\xd9\x4b\x9b\x22\x55\xfb\xae\x90\x65\x49\xf4\x99"
          "\xf8\xc6\xd3\x99\x47\xed\x5e\x5d\xf8\xe2\xde\xf1\x13\x25\x3e\x7b\x08\xd0\xa7\x6b\x6b\xfc"
          "\x68\xc8\x12\xf3\x75\xc7\x9b\x8f\xe5\xfd\x85\x97\x6a\xa6\xd4\x6b\x4a\x23\x39\xd8\xae\x51"
          "\x47\xf6\x80\xfb\xe7\x0f\x97\x8b\x38\xef\xfd\x7b\x2f\x78\x66\xa2\x25\x54\xe1\x93\xa9\x4e"
          "\x98\xa6\x8b\x74\xbd\x25\xbb\x2b\x3f\x5f\xb0\xa5\xfd\x59\x88\x7f\x9a\xb6\x81\x59\xb7\x17"
          "\x8d\x5b\x7b\x67\x7c\xb5\x46\xbf\x41\xea\xdc\xa2\x16\xfc\x10\x85\x01\x28\xf8\xbd\xef\x5c"
          "\x8d\x89\xf9\x6a\xfa\x4f\xa8\xb5\x48\x85\x56\x5e\xd8\x38\xa9\x50\xfe\xe5\xf1\xc3\xb0\xa4"
          "\xf6\xfb\x71\xe5\x4d\xfd\x16\x9e\x82\xce\xcc\x72\x66\xc8\x50\xe6\x7c\x5e\xf0\xba\x96\x0f"
          "\x52\x14\x06\x0e\x71\xeb\x17\x2a\x75\xfc\x14\x86\x83\x5c\xbe\xa6\x53\x44\x65\xb0\x55\xc9"
          "\x6a\x72\xe4\x10\x52\x24\x18\x23\x25\xd8\x30\x41\x4b\x40\x21\x4d\xaa\x80\x91\xd2\xe0\xfb"
          "\x01\x0a\xe1\x5c\x6d\xe9\x08\x50\x97\x3b\xdf\x1e\x42\x3b\xe1\x48\xa2\x37\xb8\x7a\x0c\x9f"
          "\x34\xd4\xb4\x76\x05\xb8\x03\xd7\x43\xa8\x6a\x90\x39\x9a\x4a\xf3\x96\xd3\xa1\x20\x0a\x62"
          "\xf3\xd9\x50\x79\x62\xe8\xe5\xbe\xe6\xd3\xda\x2b\xb3\xf7\x23\x76\x64\xac\x7a\x29\x28\x23"
          "\x90\x0b\xc6\x35\x03\xb2\x9e\x80\xd6\x3f\x60\x67\xbf\x8e\x17\x16\xac\x25\xbe\xba\x35\x0d"
          "\xeb\x62\xa9\x9f\xe0\x31\x85\xeb\x4f\x69\x93\x7e\xcd\x38\x79\x41\xfd\xa5\x44\xba\x67\xdb"
          "\x09\x11\x77\x49\x38\xb0\x18\x27\xbc\xc6\x9c\x92\xb3\xf7\x72\xa9\xd2\x85\x9e\xf0\x03\x39"
          "\x8b\x1f\x6b\xba\xd7\xb5\x74\xf7\x98\x9a\x1d\x10\xb2\xdf\x79\x8e\x0d\xbf\x30\xd6\x58\x74"
          "\x64\xd2\x48\x78\xcd\x00\xc0\xea\xee\x8a\x1a\x0c\xc7\x53\xa2\x79\x79\xe1\x1b\x41\xdb\x1d"
          "\xe3\xd5\x03\x8a\xfa\xf4\x9f\x5c\x68\x2c\x37\x48\xd8\xa3\xa9\xec\x54\xe6\xa3\x71\x27\x5f"
          "\x16\x83\x51\x0f\x8e\x4f\x90\x93\x8f\x9a\xb6\xe1\x34\xc2\xcf\xdf\x48\x41\xcb\xa8\x8e\x0c"
          "\xff\x2b\x0b\xcc\x8e\x6a\xdc\xb7\x11\x09\xb5\x19\x8f\xec\xf1\xbb\x7e\x5c\x53\x1a\xca\x50"
          "\xa5\x6a\x8a\x3b\x6d\xe5\x98\x62\xd4\x1f\xa1\x13\xd9\xcd\x95\x78\x08\xf0\x85\x71\xd9\xa4"
          "\xbb\x79\x2a\xf2\x71\xf6\xcc\x6d\xbb\x8d\xc7\xec\x36\xe3\x6b\xe1\xed\x30\x81\x64\xc3\x1c"
          "\x7c\x0a\xfc\x54\x1c",
          "\x0c\xa1\x27\x92", 1, 5670, "\xdd\xb2\x1e\x56\x1c\x00", 48 },
        { 128, 32, 6, "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x5b\xad\x72\x47\x10\xba\x1c\x56", "\x84\x9a\xca\xdb", 1, 63, "\x67\x45\x23\x01\x0a\x00",
          48 },
        { 128, 32, 7, "\xc9\xe6\xce\xc4\x60\x7c\x72\xdb\x00\x0a\xef\xa8\x83\x85\xab\x0a",
          "\x98\x3b\x41\xd4\x7d\x78\x0c\x9e\x1a\xd1\x1d\x7e\xb7\x03\x91\xb1", "\x81\x17\x55\x81", 1,
          62, "\xda\x59\x40\xa9\x0a\x01", 48 },
        { 128, 32, 8, "\xc9\xe6\xce\xc4\x60\x7c\x72\xdb\x00\x0a\xef\xa8\x83\x85\xab\x0a",
          "\x98\x3b\x41\xd4\x7d\x78\x0c\x9e\x1a\xd1\x1d\x7e\xb7\x03\x91\xb1\xde\x0b\x35\xda\x2d\xc6"
          "\x2f\x83\xe7\xb7\x8d\x63\x06\xca\x0e\xa0\x7e\x94\x1b\x7b\xe9\x13\x48\xf9\xfc\xb1\x70\xe2"
          "\x21\x7f\xec\xd9\x7f\x9f\x68\xad\xb1\x6e\x5d\x7d\x21\xe5\x69\xd2\x80\xed\x77\x5c",
          "\xbb\xaf\x2f\xc3", 1, 512, "\xda\x59\x40\xa9\x0a\x00", 48 },
        { 128, 32, 9, "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x5b\xad\x72\x47\x10\xba\x1c\x56", "\x1b\x3d\x0f\x74", 1, 64, "\x67\x45\x23\x01\x0a\x00",
          48 },
        { 128, 32, 10, "\xc9\xe6\xce\xc4\x60\x7c\x72\xdb\x00\x0a\xef\xa8\x83\x85\xab\x0a",
          "\x98\x3b\x41\xd4\x7d\x78\x0c\x9e\x1a\xd1\x1d\x7e\xb7\x03\x91\xb1\xde\x0b\x35\xda\x2d\xc6"
          "\x2f\x83\xe7\xb7\x8d\x63\x06\xca\x0e\xa0\x7e\x94\x1b\x7b\xe9\x13\x48\xf9\xfc\xb1\x70\xe2"
          "\x21\x7f\xec\xd9\x7f\x9f\x68\xad\xb1\x6e\x5d\x7d\x21\xe5\x69\xd2\x80\xed\x77\x5c",
          "\x39\x5c\x11\x92", 1, 480, "\xda\x59\x40\xa9\x0a\x01", 48 },
        { 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0 }
};
