//
// Copyright (c) 2015-2022 MinIO, Inc.
//
// This file is part of MinIO Object Storage stack
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

// Code generated by "stringer -type=checksumType -trimprefix=checksumType"; DO NOT EDIT.

package estream

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[checksumTypeNone-0]
	_ = x[checksumTypeXxhash-1]
	_ = x[checksumTypeUnknown-2]
}

const _checksumType_name = "NoneXxhashUnknown"

var _checksumType_index = [...]uint8{0, 4, 10, 17}

func (i checksumType) String() string {
	if i >= checksumType(len(_checksumType_index)-1) {
		return "checksumType(" + strconv.FormatInt(int64(i), 10) + ")"
	}
	return _checksumType_name[_checksumType_index[i]:_checksumType_index[i+1]]
}
