//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: ClientDatanodeProtocol.proto

package hadoop_hdfs

import (
	hadoop_common "github.com/colinmarc/hdfs/v2/internal/protocol/hadoop_common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

//*
// block - block for which visible length is requested
type GetReplicaVisibleLengthRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block *ExtendedBlockProto `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
}

func (x *GetReplicaVisibleLengthRequestProto) Reset() {
	*x = GetReplicaVisibleLengthRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReplicaVisibleLengthRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReplicaVisibleLengthRequestProto) ProtoMessage() {}

func (x *GetReplicaVisibleLengthRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReplicaVisibleLengthRequestProto.ProtoReflect.Descriptor instead.
func (*GetReplicaVisibleLengthRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{0}
}

func (x *GetReplicaVisibleLengthRequestProto) GetBlock() *ExtendedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

//*
// length - visible length of the block
type GetReplicaVisibleLengthResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Length *uint64 `protobuf:"varint,1,req,name=length" json:"length,omitempty"`
}

func (x *GetReplicaVisibleLengthResponseProto) Reset() {
	*x = GetReplicaVisibleLengthResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReplicaVisibleLengthResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReplicaVisibleLengthResponseProto) ProtoMessage() {}

func (x *GetReplicaVisibleLengthResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReplicaVisibleLengthResponseProto.ProtoReflect.Descriptor instead.
func (*GetReplicaVisibleLengthResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{1}
}

func (x *GetReplicaVisibleLengthResponseProto) GetLength() uint64 {
	if x != nil && x.Length != nil {
		return *x.Length
	}
	return 0
}

//*
// void request
type RefreshNamenodesRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RefreshNamenodesRequestProto) Reset() {
	*x = RefreshNamenodesRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshNamenodesRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshNamenodesRequestProto) ProtoMessage() {}

func (x *RefreshNamenodesRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshNamenodesRequestProto.ProtoReflect.Descriptor instead.
func (*RefreshNamenodesRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{2}
}

//*
// void response
type RefreshNamenodesResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RefreshNamenodesResponseProto) Reset() {
	*x = RefreshNamenodesResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshNamenodesResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshNamenodesResponseProto) ProtoMessage() {}

func (x *RefreshNamenodesResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshNamenodesResponseProto.ProtoReflect.Descriptor instead.
func (*RefreshNamenodesResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{3}
}

//*
// blockPool - block pool to be deleted
// force - if false, delete the block pool only if it is empty.
//         if true, delete the block pool even if it has blocks.
type DeleteBlockPoolRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BlockPool *string `protobuf:"bytes,1,req,name=blockPool" json:"blockPool,omitempty"`
	Force     *bool   `protobuf:"varint,2,req,name=force" json:"force,omitempty"`
}

func (x *DeleteBlockPoolRequestProto) Reset() {
	*x = DeleteBlockPoolRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBlockPoolRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBlockPoolRequestProto) ProtoMessage() {}

func (x *DeleteBlockPoolRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBlockPoolRequestProto.ProtoReflect.Descriptor instead.
func (*DeleteBlockPoolRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteBlockPoolRequestProto) GetBlockPool() string {
	if x != nil && x.BlockPool != nil {
		return *x.BlockPool
	}
	return ""
}

func (x *DeleteBlockPoolRequestProto) GetForce() bool {
	if x != nil && x.Force != nil {
		return *x.Force
	}
	return false
}

//*
// void response
type DeleteBlockPoolResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteBlockPoolResponseProto) Reset() {
	*x = DeleteBlockPoolResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBlockPoolResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBlockPoolResponseProto) ProtoMessage() {}

func (x *DeleteBlockPoolResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBlockPoolResponseProto.ProtoReflect.Descriptor instead.
func (*DeleteBlockPoolResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{5}
}

//*
// Gets the file information where block and its metadata is stored
// block - block for which path information is being requested
// token - block token
//
// This message is deprecated in favor of file descriptor passing.
type GetBlockLocalPathInfoRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block *ExtendedBlockProto       `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
	Token *hadoop_common.TokenProto `protobuf:"bytes,2,req,name=token" json:"token,omitempty"`
}

func (x *GetBlockLocalPathInfoRequestProto) Reset() {
	*x = GetBlockLocalPathInfoRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBlockLocalPathInfoRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBlockLocalPathInfoRequestProto) ProtoMessage() {}

func (x *GetBlockLocalPathInfoRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBlockLocalPathInfoRequestProto.ProtoReflect.Descriptor instead.
func (*GetBlockLocalPathInfoRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{6}
}

func (x *GetBlockLocalPathInfoRequestProto) GetBlock() *ExtendedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *GetBlockLocalPathInfoRequestProto) GetToken() *hadoop_common.TokenProto {
	if x != nil {
		return x.Token
	}
	return nil
}

//*
// block - block for which file path information is being returned
// localPath - file path where the block data is stored
// localMetaPath - file path where the block meta data is stored
//
// This message is deprecated in favor of file descriptor passing.
type GetBlockLocalPathInfoResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block         *ExtendedBlockProto `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
	LocalPath     *string             `protobuf:"bytes,2,req,name=localPath" json:"localPath,omitempty"`
	LocalMetaPath *string             `protobuf:"bytes,3,req,name=localMetaPath" json:"localMetaPath,omitempty"`
}

func (x *GetBlockLocalPathInfoResponseProto) Reset() {
	*x = GetBlockLocalPathInfoResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBlockLocalPathInfoResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBlockLocalPathInfoResponseProto) ProtoMessage() {}

func (x *GetBlockLocalPathInfoResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBlockLocalPathInfoResponseProto.ProtoReflect.Descriptor instead.
func (*GetBlockLocalPathInfoResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{7}
}

func (x *GetBlockLocalPathInfoResponseProto) GetBlock() *ExtendedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *GetBlockLocalPathInfoResponseProto) GetLocalPath() string {
	if x != nil && x.LocalPath != nil {
		return *x.LocalPath
	}
	return ""
}

func (x *GetBlockLocalPathInfoResponseProto) GetLocalMetaPath() string {
	if x != nil && x.LocalMetaPath != nil {
		return *x.LocalMetaPath
	}
	return ""
}

//*
// forUpgrade - if true, clients are advised to wait for restart and quick
//              upgrade restart is instrumented. Otherwise, datanode does
//              the regular shutdown.
type ShutdownDatanodeRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ForUpgrade *bool `protobuf:"varint,1,req,name=forUpgrade" json:"forUpgrade,omitempty"`
}

func (x *ShutdownDatanodeRequestProto) Reset() {
	*x = ShutdownDatanodeRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShutdownDatanodeRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShutdownDatanodeRequestProto) ProtoMessage() {}

func (x *ShutdownDatanodeRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShutdownDatanodeRequestProto.ProtoReflect.Descriptor instead.
func (*ShutdownDatanodeRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{8}
}

func (x *ShutdownDatanodeRequestProto) GetForUpgrade() bool {
	if x != nil && x.ForUpgrade != nil {
		return *x.ForUpgrade
	}
	return false
}

type ShutdownDatanodeResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ShutdownDatanodeResponseProto) Reset() {
	*x = ShutdownDatanodeResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShutdownDatanodeResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShutdownDatanodeResponseProto) ProtoMessage() {}

func (x *ShutdownDatanodeResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShutdownDatanodeResponseProto.ProtoReflect.Descriptor instead.
func (*ShutdownDatanodeResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{9}
}

//* Tell datanode to evict active clients that are writing
type EvictWritersRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EvictWritersRequestProto) Reset() {
	*x = EvictWritersRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvictWritersRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvictWritersRequestProto) ProtoMessage() {}

func (x *EvictWritersRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvictWritersRequestProto.ProtoReflect.Descriptor instead.
func (*EvictWritersRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{10}
}

type EvictWritersResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EvictWritersResponseProto) Reset() {
	*x = EvictWritersResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvictWritersResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvictWritersResponseProto) ProtoMessage() {}

func (x *EvictWritersResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvictWritersResponseProto.ProtoReflect.Descriptor instead.
func (*EvictWritersResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{11}
}

//*
// Ping datanode for liveness and quick info
type GetDatanodeInfoRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetDatanodeInfoRequestProto) Reset() {
	*x = GetDatanodeInfoRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatanodeInfoRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatanodeInfoRequestProto) ProtoMessage() {}

func (x *GetDatanodeInfoRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatanodeInfoRequestProto.ProtoReflect.Descriptor instead.
func (*GetDatanodeInfoRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{12}
}

type GetDatanodeInfoResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LocalInfo *DatanodeLocalInfoProto `protobuf:"bytes,1,req,name=localInfo" json:"localInfo,omitempty"`
}

func (x *GetDatanodeInfoResponseProto) Reset() {
	*x = GetDatanodeInfoResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatanodeInfoResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatanodeInfoResponseProto) ProtoMessage() {}

func (x *GetDatanodeInfoResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatanodeInfoResponseProto.ProtoReflect.Descriptor instead.
func (*GetDatanodeInfoResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{13}
}

func (x *GetDatanodeInfoResponseProto) GetLocalInfo() *DatanodeLocalInfoProto {
	if x != nil {
		return x.LocalInfo
	}
	return nil
}

type GetVolumeReportRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetVolumeReportRequestProto) Reset() {
	*x = GetVolumeReportRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVolumeReportRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeReportRequestProto) ProtoMessage() {}

func (x *GetVolumeReportRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeReportRequestProto.ProtoReflect.Descriptor instead.
func (*GetVolumeReportRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{14}
}

type GetVolumeReportResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VolumeInfo []*DatanodeVolumeInfoProto `protobuf:"bytes,1,rep,name=volumeInfo" json:"volumeInfo,omitempty"`
}

func (x *GetVolumeReportResponseProto) Reset() {
	*x = GetVolumeReportResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVolumeReportResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeReportResponseProto) ProtoMessage() {}

func (x *GetVolumeReportResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeReportResponseProto.ProtoReflect.Descriptor instead.
func (*GetVolumeReportResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{15}
}

func (x *GetVolumeReportResponseProto) GetVolumeInfo() []*DatanodeVolumeInfoProto {
	if x != nil {
		return x.VolumeInfo
	}
	return nil
}

type TriggerBlockReportRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Incremental *bool   `protobuf:"varint,1,req,name=incremental" json:"incremental,omitempty"`
	NnAddress   *string `protobuf:"bytes,2,opt,name=nnAddress" json:"nnAddress,omitempty"`
}

func (x *TriggerBlockReportRequestProto) Reset() {
	*x = TriggerBlockReportRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TriggerBlockReportRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriggerBlockReportRequestProto) ProtoMessage() {}

func (x *TriggerBlockReportRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriggerBlockReportRequestProto.ProtoReflect.Descriptor instead.
func (*TriggerBlockReportRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{16}
}

func (x *TriggerBlockReportRequestProto) GetIncremental() bool {
	if x != nil && x.Incremental != nil {
		return *x.Incremental
	}
	return false
}

func (x *TriggerBlockReportRequestProto) GetNnAddress() string {
	if x != nil && x.NnAddress != nil {
		return *x.NnAddress
	}
	return ""
}

type TriggerBlockReportResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TriggerBlockReportResponseProto) Reset() {
	*x = TriggerBlockReportResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TriggerBlockReportResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriggerBlockReportResponseProto) ProtoMessage() {}

func (x *TriggerBlockReportResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriggerBlockReportResponseProto.ProtoReflect.Descriptor instead.
func (*TriggerBlockReportResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{17}
}

type GetBalancerBandwidthRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetBalancerBandwidthRequestProto) Reset() {
	*x = GetBalancerBandwidthRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBalancerBandwidthRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBalancerBandwidthRequestProto) ProtoMessage() {}

func (x *GetBalancerBandwidthRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBalancerBandwidthRequestProto.ProtoReflect.Descriptor instead.
func (*GetBalancerBandwidthRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{18}
}

//*
// bandwidth - balancer bandwidth value of the datanode.
type GetBalancerBandwidthResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Bandwidth *uint64 `protobuf:"varint,1,req,name=bandwidth" json:"bandwidth,omitempty"`
}

func (x *GetBalancerBandwidthResponseProto) Reset() {
	*x = GetBalancerBandwidthResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBalancerBandwidthResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBalancerBandwidthResponseProto) ProtoMessage() {}

func (x *GetBalancerBandwidthResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBalancerBandwidthResponseProto.ProtoReflect.Descriptor instead.
func (*GetBalancerBandwidthResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{19}
}

func (x *GetBalancerBandwidthResponseProto) GetBandwidth() uint64 {
	if x != nil && x.Bandwidth != nil {
		return *x.Bandwidth
	}
	return 0
}

//*
// This message allows a client to submit a disk
// balancer plan to a data node.
type SubmitDiskBalancerPlanRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PlanID          *string `protobuf:"bytes,1,req,name=planID" json:"planID,omitempty"`                    // A hash of the plan like SHA-1
	Plan            *string `protobuf:"bytes,2,req,name=plan" json:"plan,omitempty"`                        // Plan file data in Json format
	PlanVersion     *uint64 `protobuf:"varint,3,opt,name=planVersion" json:"planVersion,omitempty"`         // Plan version number
	IgnoreDateCheck *bool   `protobuf:"varint,4,opt,name=ignoreDateCheck" json:"ignoreDateCheck,omitempty"` // Ignore date checks on this plan.
	PlanFile        *string `protobuf:"bytes,5,req,name=planFile" json:"planFile,omitempty"`                // Plan file path
}

func (x *SubmitDiskBalancerPlanRequestProto) Reset() {
	*x = SubmitDiskBalancerPlanRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubmitDiskBalancerPlanRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitDiskBalancerPlanRequestProto) ProtoMessage() {}

func (x *SubmitDiskBalancerPlanRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitDiskBalancerPlanRequestProto.ProtoReflect.Descriptor instead.
func (*SubmitDiskBalancerPlanRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{20}
}

func (x *SubmitDiskBalancerPlanRequestProto) GetPlanID() string {
	if x != nil && x.PlanID != nil {
		return *x.PlanID
	}
	return ""
}

func (x *SubmitDiskBalancerPlanRequestProto) GetPlan() string {
	if x != nil && x.Plan != nil {
		return *x.Plan
	}
	return ""
}

func (x *SubmitDiskBalancerPlanRequestProto) GetPlanVersion() uint64 {
	if x != nil && x.PlanVersion != nil {
		return *x.PlanVersion
	}
	return 0
}

func (x *SubmitDiskBalancerPlanRequestProto) GetIgnoreDateCheck() bool {
	if x != nil && x.IgnoreDateCheck != nil {
		return *x.IgnoreDateCheck
	}
	return false
}

func (x *SubmitDiskBalancerPlanRequestProto) GetPlanFile() string {
	if x != nil && x.PlanFile != nil {
		return *x.PlanFile
	}
	return ""
}

//*
// Response from the DataNode on Plan Submit request
type SubmitDiskBalancerPlanResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SubmitDiskBalancerPlanResponseProto) Reset() {
	*x = SubmitDiskBalancerPlanResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubmitDiskBalancerPlanResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitDiskBalancerPlanResponseProto) ProtoMessage() {}

func (x *SubmitDiskBalancerPlanResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitDiskBalancerPlanResponseProto.ProtoReflect.Descriptor instead.
func (*SubmitDiskBalancerPlanResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{21}
}

//*
// This message describes a request to cancel an
// outstanding disk balancer plan
type CancelPlanRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PlanID *string `protobuf:"bytes,1,req,name=planID" json:"planID,omitempty"`
}

func (x *CancelPlanRequestProto) Reset() {
	*x = CancelPlanRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelPlanRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelPlanRequestProto) ProtoMessage() {}

func (x *CancelPlanRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelPlanRequestProto.ProtoReflect.Descriptor instead.
func (*CancelPlanRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{22}
}

func (x *CancelPlanRequestProto) GetPlanID() string {
	if x != nil && x.PlanID != nil {
		return *x.PlanID
	}
	return ""
}

//*
// This is the response for the cancellation request
type CancelPlanResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelPlanResponseProto) Reset() {
	*x = CancelPlanResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelPlanResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelPlanResponseProto) ProtoMessage() {}

func (x *CancelPlanResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelPlanResponseProto.ProtoReflect.Descriptor instead.
func (*CancelPlanResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{23}
}

//*
// This message allows a client to query data node to see
// if a disk balancer plan is executing and if so what is
// the status.
type QueryPlanStatusRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *QueryPlanStatusRequestProto) Reset() {
	*x = QueryPlanStatusRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryPlanStatusRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryPlanStatusRequestProto) ProtoMessage() {}

func (x *QueryPlanStatusRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryPlanStatusRequestProto.ProtoReflect.Descriptor instead.
func (*QueryPlanStatusRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{24}
}

//*
// This message describes a plan if it is in progress
type QueryPlanStatusResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result        *uint32 `protobuf:"varint,1,opt,name=result" json:"result,omitempty"`
	PlanID        *string `protobuf:"bytes,2,opt,name=planID" json:"planID,omitempty"`
	CurrentStatus *string `protobuf:"bytes,3,opt,name=currentStatus" json:"currentStatus,omitempty"`
	PlanFile      *string `protobuf:"bytes,4,opt,name=planFile" json:"planFile,omitempty"`
}

func (x *QueryPlanStatusResponseProto) Reset() {
	*x = QueryPlanStatusResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryPlanStatusResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryPlanStatusResponseProto) ProtoMessage() {}

func (x *QueryPlanStatusResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryPlanStatusResponseProto.ProtoReflect.Descriptor instead.
func (*QueryPlanStatusResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{25}
}

func (x *QueryPlanStatusResponseProto) GetResult() uint32 {
	if x != nil && x.Result != nil {
		return *x.Result
	}
	return 0
}

func (x *QueryPlanStatusResponseProto) GetPlanID() string {
	if x != nil && x.PlanID != nil {
		return *x.PlanID
	}
	return ""
}

func (x *QueryPlanStatusResponseProto) GetCurrentStatus() string {
	if x != nil && x.CurrentStatus != nil {
		return *x.CurrentStatus
	}
	return ""
}

func (x *QueryPlanStatusResponseProto) GetPlanFile() string {
	if x != nil && x.PlanFile != nil {
		return *x.PlanFile
	}
	return ""
}

//*
// This message sends a request to data node get a specific setting
// that is used by disk balancer.
type DiskBalancerSettingRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
}

func (x *DiskBalancerSettingRequestProto) Reset() {
	*x = DiskBalancerSettingRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskBalancerSettingRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskBalancerSettingRequestProto) ProtoMessage() {}

func (x *DiskBalancerSettingRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskBalancerSettingRequestProto.ProtoReflect.Descriptor instead.
func (*DiskBalancerSettingRequestProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{26}
}

func (x *DiskBalancerSettingRequestProto) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

//*
// Response that describes the value of requested disk balancer setting.
type DiskBalancerSettingResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
}

func (x *DiskBalancerSettingResponseProto) Reset() {
	*x = DiskBalancerSettingResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ClientDatanodeProtocol_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskBalancerSettingResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskBalancerSettingResponseProto) ProtoMessage() {}

func (x *DiskBalancerSettingResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_ClientDatanodeProtocol_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskBalancerSettingResponseProto.ProtoReflect.Descriptor instead.
func (*DiskBalancerSettingResponseProto) Descriptor() ([]byte, []int) {
	return file_ClientDatanodeProtocol_proto_rawDescGZIP(), []int{27}
}

func (x *DiskBalancerSettingResponseProto) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

var File_ClientDatanodeProtocol_proto protoreflect.FileDescriptor

var file_ClientDatanodeProtocol_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x1a, 0x0e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0a, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5c, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x35, 0x0a,
	0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x3e, 0x0a, 0x24, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x06, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x22, 0x1e, 0x0a, 0x1c, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x4e,
	0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1f, 0x0a, 0x1d, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x4e,
	0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x51, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f,
	0x6c, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x1e, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8b, 0x01, 0x0a, 0x21, 0x47, 0x65, 0x74,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x35,
	0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2f, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9f, 0x01, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x35, 0x0a,
	0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x24, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x50,
	0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x4d, 0x65, 0x74, 0x61, 0x50, 0x61, 0x74, 0x68, 0x22, 0x3e, 0x0a, 0x1c, 0x53, 0x68, 0x75, 0x74,
	0x64, 0x6f, 0x77, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x6f, 0x72, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0a, 0x66, 0x6f,
	0x72, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x22, 0x1f, 0x0a, 0x1d, 0x53, 0x68, 0x75, 0x74,
	0x64, 0x6f, 0x77, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1a, 0x0a, 0x18, 0x45, 0x76, 0x69,
	0x63, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1b, 0x0a, 0x19, 0x45, 0x76, 0x69, 0x63, 0x74, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x1d, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x61, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x41, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x22, 0x1d, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x64, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x44, 0x0a, 0x0a, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x60, 0x0a, 0x1e, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x69,
	0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08,
	0x52, 0x0b, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x12, 0x1c, 0x0a,
	0x09, 0x6e, 0x6e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6e, 0x6e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x21, 0x0a, 0x1f, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x22,
	0x0a, 0x20, 0x47, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x6e,
	0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x41, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x62, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x22, 0xb8, 0x01, 0x0a, 0x22, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74,
	0x44, 0x69, 0x73, 0x6b, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x6c, 0x61, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6c,
	0x61, 0x6e, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x6c, 0x61, 0x6e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x70,
	0x6c, 0x61, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0f, 0x69, 0x67,
	0x6e, 0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x44, 0x61, 0x74, 0x65, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x6e, 0x46, 0x69, 0x6c, 0x65,
	0x18, 0x05, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x6e, 0x46, 0x69, 0x6c, 0x65,
	0x22, 0x25, 0x0a, 0x23, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x30, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x6c, 0x61, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x6c, 0x61, 0x6e, 0x49, 0x44, 0x22, 0x19, 0x0a, 0x17, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1d, 0x0a, 0x1b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x90, 0x01, 0x0a, 0x1c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x6c, 0x61, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6c,
	0x61, 0x6e, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6c,
	0x61, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c,
	0x61, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x22, 0x33, 0x0a, 0x1f, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x38, 0x0a, 0x20, 0x44,
	0x69, 0x73, 0x6b, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x32, 0xc0, 0x0f, 0x0a, 0x1d, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x7e, 0x0a, 0x17, 0x67, 0x65, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x12, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x56, 0x69, 0x73, 0x69, 0x62,
	0x6c, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x56, 0x69, 0x73,
	0x69, 0x62, 0x6c, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x69, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x29, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x4e, 0x61, 0x6d, 0x65,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x66, 0x0a, 0x0f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x78, 0x0a, 0x15, 0x67, 0x65,
	0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50,
	0x61, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50,
	0x61, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x69, 0x0a, 0x10, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x12, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f,
	0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x5d, 0x0a, 0x0c, 0x65, 0x76, 0x69, 0x63, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x76,
	0x69, 0x63, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x76, 0x69, 0x63, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x66,
	0x0a, 0x0f, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x66, 0x0a, 0x0f, 0x67, 0x65, 0x74, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x28, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x81,
	0x01, 0x0a, 0x18, 0x67, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x31, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x75, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x8d, 0x01, 0x0a, 0x1c, 0x6c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x36, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x6f, 0x0a, 0x12, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x75, 0x0a, 0x14, 0x67, 0x65,
	0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x12, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x7b, 0x0a, 0x16, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2f, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74,
	0x44, 0x69, 0x73, 0x6b, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x63,
	0x0a, 0x16, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x6c, 0x0a, 0x15, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x73, 0x6b,
	0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x28, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x75, 0x0a, 0x16, 0x67, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x2c, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x87, 0x01, 0x0a, 0x25, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x42, 0x1c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f,
	0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6c,
	0x69, 0x6e, 0x6d, 0x61, 0x72, 0x63, 0x2f, 0x68, 0x64, 0x66, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2f, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x5f, 0x68, 0x64, 0x66, 0x73, 0x88, 0x01, 0x01, 0xa0,
	0x01, 0x01,
}

var (
	file_ClientDatanodeProtocol_proto_rawDescOnce sync.Once
	file_ClientDatanodeProtocol_proto_rawDescData = file_ClientDatanodeProtocol_proto_rawDesc
)

func file_ClientDatanodeProtocol_proto_rawDescGZIP() []byte {
	file_ClientDatanodeProtocol_proto_rawDescOnce.Do(func() {
		file_ClientDatanodeProtocol_proto_rawDescData = protoimpl.X.CompressGZIP(file_ClientDatanodeProtocol_proto_rawDescData)
	})
	return file_ClientDatanodeProtocol_proto_rawDescData
}

var file_ClientDatanodeProtocol_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_ClientDatanodeProtocol_proto_goTypes = []interface{}{
	(*GetReplicaVisibleLengthRequestProto)(nil),       // 0: hadoop.hdfs.GetReplicaVisibleLengthRequestProto
	(*GetReplicaVisibleLengthResponseProto)(nil),      // 1: hadoop.hdfs.GetReplicaVisibleLengthResponseProto
	(*RefreshNamenodesRequestProto)(nil),              // 2: hadoop.hdfs.RefreshNamenodesRequestProto
	(*RefreshNamenodesResponseProto)(nil),             // 3: hadoop.hdfs.RefreshNamenodesResponseProto
	(*DeleteBlockPoolRequestProto)(nil),               // 4: hadoop.hdfs.DeleteBlockPoolRequestProto
	(*DeleteBlockPoolResponseProto)(nil),              // 5: hadoop.hdfs.DeleteBlockPoolResponseProto
	(*GetBlockLocalPathInfoRequestProto)(nil),         // 6: hadoop.hdfs.GetBlockLocalPathInfoRequestProto
	(*GetBlockLocalPathInfoResponseProto)(nil),        // 7: hadoop.hdfs.GetBlockLocalPathInfoResponseProto
	(*ShutdownDatanodeRequestProto)(nil),              // 8: hadoop.hdfs.ShutdownDatanodeRequestProto
	(*ShutdownDatanodeResponseProto)(nil),             // 9: hadoop.hdfs.ShutdownDatanodeResponseProto
	(*EvictWritersRequestProto)(nil),                  // 10: hadoop.hdfs.EvictWritersRequestProto
	(*EvictWritersResponseProto)(nil),                 // 11: hadoop.hdfs.EvictWritersResponseProto
	(*GetDatanodeInfoRequestProto)(nil),               // 12: hadoop.hdfs.GetDatanodeInfoRequestProto
	(*GetDatanodeInfoResponseProto)(nil),              // 13: hadoop.hdfs.GetDatanodeInfoResponseProto
	(*GetVolumeReportRequestProto)(nil),               // 14: hadoop.hdfs.GetVolumeReportRequestProto
	(*GetVolumeReportResponseProto)(nil),              // 15: hadoop.hdfs.GetVolumeReportResponseProto
	(*TriggerBlockReportRequestProto)(nil),            // 16: hadoop.hdfs.TriggerBlockReportRequestProto
	(*TriggerBlockReportResponseProto)(nil),           // 17: hadoop.hdfs.TriggerBlockReportResponseProto
	(*GetBalancerBandwidthRequestProto)(nil),          // 18: hadoop.hdfs.GetBalancerBandwidthRequestProto
	(*GetBalancerBandwidthResponseProto)(nil),         // 19: hadoop.hdfs.GetBalancerBandwidthResponseProto
	(*SubmitDiskBalancerPlanRequestProto)(nil),        // 20: hadoop.hdfs.SubmitDiskBalancerPlanRequestProto
	(*SubmitDiskBalancerPlanResponseProto)(nil),       // 21: hadoop.hdfs.SubmitDiskBalancerPlanResponseProto
	(*CancelPlanRequestProto)(nil),                    // 22: hadoop.hdfs.CancelPlanRequestProto
	(*CancelPlanResponseProto)(nil),                   // 23: hadoop.hdfs.CancelPlanResponseProto
	(*QueryPlanStatusRequestProto)(nil),               // 24: hadoop.hdfs.QueryPlanStatusRequestProto
	(*QueryPlanStatusResponseProto)(nil),              // 25: hadoop.hdfs.QueryPlanStatusResponseProto
	(*DiskBalancerSettingRequestProto)(nil),           // 26: hadoop.hdfs.DiskBalancerSettingRequestProto
	(*DiskBalancerSettingResponseProto)(nil),          // 27: hadoop.hdfs.DiskBalancerSettingResponseProto
	(*ExtendedBlockProto)(nil),                        // 28: hadoop.hdfs.ExtendedBlockProto
	(*hadoop_common.TokenProto)(nil),                  // 29: hadoop.common.TokenProto
	(*DatanodeLocalInfoProto)(nil),                    // 30: hadoop.hdfs.DatanodeLocalInfoProto
	(*DatanodeVolumeInfoProto)(nil),                   // 31: hadoop.hdfs.DatanodeVolumeInfoProto
	(*GetReconfigurationStatusRequestProto)(nil),      // 32: hadoop.hdfs.GetReconfigurationStatusRequestProto
	(*StartReconfigurationRequestProto)(nil),          // 33: hadoop.hdfs.StartReconfigurationRequestProto
	(*ListReconfigurablePropertiesRequestProto)(nil),  // 34: hadoop.hdfs.ListReconfigurablePropertiesRequestProto
	(*GetReconfigurationStatusResponseProto)(nil),     // 35: hadoop.hdfs.GetReconfigurationStatusResponseProto
	(*StartReconfigurationResponseProto)(nil),         // 36: hadoop.hdfs.StartReconfigurationResponseProto
	(*ListReconfigurablePropertiesResponseProto)(nil), // 37: hadoop.hdfs.ListReconfigurablePropertiesResponseProto
}
var file_ClientDatanodeProtocol_proto_depIdxs = []int32{
	28, // 0: hadoop.hdfs.GetReplicaVisibleLengthRequestProto.block:type_name -> hadoop.hdfs.ExtendedBlockProto
	28, // 1: hadoop.hdfs.GetBlockLocalPathInfoRequestProto.block:type_name -> hadoop.hdfs.ExtendedBlockProto
	29, // 2: hadoop.hdfs.GetBlockLocalPathInfoRequestProto.token:type_name -> hadoop.common.TokenProto
	28, // 3: hadoop.hdfs.GetBlockLocalPathInfoResponseProto.block:type_name -> hadoop.hdfs.ExtendedBlockProto
	30, // 4: hadoop.hdfs.GetDatanodeInfoResponseProto.localInfo:type_name -> hadoop.hdfs.DatanodeLocalInfoProto
	31, // 5: hadoop.hdfs.GetVolumeReportResponseProto.volumeInfo:type_name -> hadoop.hdfs.DatanodeVolumeInfoProto
	0,  // 6: hadoop.hdfs.ClientDatanodeProtocolService.getReplicaVisibleLength:input_type -> hadoop.hdfs.GetReplicaVisibleLengthRequestProto
	2,  // 7: hadoop.hdfs.ClientDatanodeProtocolService.refreshNamenodes:input_type -> hadoop.hdfs.RefreshNamenodesRequestProto
	4,  // 8: hadoop.hdfs.ClientDatanodeProtocolService.deleteBlockPool:input_type -> hadoop.hdfs.DeleteBlockPoolRequestProto
	6,  // 9: hadoop.hdfs.ClientDatanodeProtocolService.getBlockLocalPathInfo:input_type -> hadoop.hdfs.GetBlockLocalPathInfoRequestProto
	8,  // 10: hadoop.hdfs.ClientDatanodeProtocolService.shutdownDatanode:input_type -> hadoop.hdfs.ShutdownDatanodeRequestProto
	10, // 11: hadoop.hdfs.ClientDatanodeProtocolService.evictWriters:input_type -> hadoop.hdfs.EvictWritersRequestProto
	12, // 12: hadoop.hdfs.ClientDatanodeProtocolService.getDatanodeInfo:input_type -> hadoop.hdfs.GetDatanodeInfoRequestProto
	14, // 13: hadoop.hdfs.ClientDatanodeProtocolService.getVolumeReport:input_type -> hadoop.hdfs.GetVolumeReportRequestProto
	32, // 14: hadoop.hdfs.ClientDatanodeProtocolService.getReconfigurationStatus:input_type -> hadoop.hdfs.GetReconfigurationStatusRequestProto
	33, // 15: hadoop.hdfs.ClientDatanodeProtocolService.startReconfiguration:input_type -> hadoop.hdfs.StartReconfigurationRequestProto
	34, // 16: hadoop.hdfs.ClientDatanodeProtocolService.listReconfigurableProperties:input_type -> hadoop.hdfs.ListReconfigurablePropertiesRequestProto
	16, // 17: hadoop.hdfs.ClientDatanodeProtocolService.triggerBlockReport:input_type -> hadoop.hdfs.TriggerBlockReportRequestProto
	18, // 18: hadoop.hdfs.ClientDatanodeProtocolService.getBalancerBandwidth:input_type -> hadoop.hdfs.GetBalancerBandwidthRequestProto
	20, // 19: hadoop.hdfs.ClientDatanodeProtocolService.submitDiskBalancerPlan:input_type -> hadoop.hdfs.SubmitDiskBalancerPlanRequestProto
	22, // 20: hadoop.hdfs.ClientDatanodeProtocolService.cancelDiskBalancerPlan:input_type -> hadoop.hdfs.CancelPlanRequestProto
	24, // 21: hadoop.hdfs.ClientDatanodeProtocolService.queryDiskBalancerPlan:input_type -> hadoop.hdfs.QueryPlanStatusRequestProto
	26, // 22: hadoop.hdfs.ClientDatanodeProtocolService.getDiskBalancerSetting:input_type -> hadoop.hdfs.DiskBalancerSettingRequestProto
	1,  // 23: hadoop.hdfs.ClientDatanodeProtocolService.getReplicaVisibleLength:output_type -> hadoop.hdfs.GetReplicaVisibleLengthResponseProto
	3,  // 24: hadoop.hdfs.ClientDatanodeProtocolService.refreshNamenodes:output_type -> hadoop.hdfs.RefreshNamenodesResponseProto
	5,  // 25: hadoop.hdfs.ClientDatanodeProtocolService.deleteBlockPool:output_type -> hadoop.hdfs.DeleteBlockPoolResponseProto
	7,  // 26: hadoop.hdfs.ClientDatanodeProtocolService.getBlockLocalPathInfo:output_type -> hadoop.hdfs.GetBlockLocalPathInfoResponseProto
	9,  // 27: hadoop.hdfs.ClientDatanodeProtocolService.shutdownDatanode:output_type -> hadoop.hdfs.ShutdownDatanodeResponseProto
	11, // 28: hadoop.hdfs.ClientDatanodeProtocolService.evictWriters:output_type -> hadoop.hdfs.EvictWritersResponseProto
	13, // 29: hadoop.hdfs.ClientDatanodeProtocolService.getDatanodeInfo:output_type -> hadoop.hdfs.GetDatanodeInfoResponseProto
	15, // 30: hadoop.hdfs.ClientDatanodeProtocolService.getVolumeReport:output_type -> hadoop.hdfs.GetVolumeReportResponseProto
	35, // 31: hadoop.hdfs.ClientDatanodeProtocolService.getReconfigurationStatus:output_type -> hadoop.hdfs.GetReconfigurationStatusResponseProto
	36, // 32: hadoop.hdfs.ClientDatanodeProtocolService.startReconfiguration:output_type -> hadoop.hdfs.StartReconfigurationResponseProto
	37, // 33: hadoop.hdfs.ClientDatanodeProtocolService.listReconfigurableProperties:output_type -> hadoop.hdfs.ListReconfigurablePropertiesResponseProto
	17, // 34: hadoop.hdfs.ClientDatanodeProtocolService.triggerBlockReport:output_type -> hadoop.hdfs.TriggerBlockReportResponseProto
	19, // 35: hadoop.hdfs.ClientDatanodeProtocolService.getBalancerBandwidth:output_type -> hadoop.hdfs.GetBalancerBandwidthResponseProto
	21, // 36: hadoop.hdfs.ClientDatanodeProtocolService.submitDiskBalancerPlan:output_type -> hadoop.hdfs.SubmitDiskBalancerPlanResponseProto
	23, // 37: hadoop.hdfs.ClientDatanodeProtocolService.cancelDiskBalancerPlan:output_type -> hadoop.hdfs.CancelPlanResponseProto
	25, // 38: hadoop.hdfs.ClientDatanodeProtocolService.queryDiskBalancerPlan:output_type -> hadoop.hdfs.QueryPlanStatusResponseProto
	27, // 39: hadoop.hdfs.ClientDatanodeProtocolService.getDiskBalancerSetting:output_type -> hadoop.hdfs.DiskBalancerSettingResponseProto
	23, // [23:40] is the sub-list for method output_type
	6,  // [6:23] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_ClientDatanodeProtocol_proto_init() }
func file_ClientDatanodeProtocol_proto_init() {
	if File_ClientDatanodeProtocol_proto != nil {
		return
	}
	file_hdfs_proto_init()
	file_ReconfigurationProtocol_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_ClientDatanodeProtocol_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReplicaVisibleLengthRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReplicaVisibleLengthResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshNamenodesRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshNamenodesResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBlockPoolRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBlockPoolResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBlockLocalPathInfoRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBlockLocalPathInfoResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShutdownDatanodeRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShutdownDatanodeResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvictWritersRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvictWritersResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatanodeInfoRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatanodeInfoResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVolumeReportRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVolumeReportResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TriggerBlockReportRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TriggerBlockReportResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBalancerBandwidthRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBalancerBandwidthResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubmitDiskBalancerPlanRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubmitDiskBalancerPlanResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelPlanRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelPlanResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryPlanStatusRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryPlanStatusResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskBalancerSettingRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ClientDatanodeProtocol_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskBalancerSettingResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ClientDatanodeProtocol_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_ClientDatanodeProtocol_proto_goTypes,
		DependencyIndexes: file_ClientDatanodeProtocol_proto_depIdxs,
		MessageInfos:      file_ClientDatanodeProtocol_proto_msgTypes,
	}.Build()
	File_ClientDatanodeProtocol_proto = out.File
	file_ClientDatanodeProtocol_proto_rawDesc = nil
	file_ClientDatanodeProtocol_proto_goTypes = nil
	file_ClientDatanodeProtocol_proto_depIdxs = nil
}
