package storsimple8000series

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.1.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AlertEmailNotificationStatus enumerates the values for alert email
// notification status.
type AlertEmailNotificationStatus string

const (
	// Disabled specifies the disabled state for alert email notification
	// status.
	Disabled AlertEmailNotificationStatus = "Disabled"
	// Enabled specifies the enabled state for alert email notification status.
	Enabled AlertEmailNotificationStatus = "Enabled"
)

// AlertScope enumerates the values for alert scope.
type AlertScope string

const (
	// AlertScopeDevice specifies the alert scope device state for alert scope.
	AlertScopeDevice AlertScope = "Device"
	// AlertScopeResource specifies the alert scope resource state for alert
	// scope.
	AlertScopeResource AlertScope = "Resource"
)

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// Critical specifies the critical state for alert severity.
	Critical AlertSeverity = "Critical"
	// Informational specifies the informational state for alert severity.
	Informational AlertSeverity = "Informational"
	// Warning specifies the warning state for alert severity.
	Warning AlertSeverity = "Warning"
)

// AlertSourceType enumerates the values for alert source type.
type AlertSourceType string

const (
	// AlertSourceTypeDevice specifies the alert source type device state for
	// alert source type.
	AlertSourceTypeDevice AlertSourceType = "Device"
	// AlertSourceTypeResource specifies the alert source type resource state
	// for alert source type.
	AlertSourceTypeResource AlertSourceType = "Resource"
)

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// Active specifies the active state for alert status.
	Active AlertStatus = "Active"
	// Cleared specifies the cleared state for alert status.
	Cleared AlertStatus = "Cleared"
)

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// Basic specifies the basic state for authentication type.
	Basic AuthenticationType = "Basic"
	// Invalid specifies the invalid state for authentication type.
	Invalid AuthenticationType = "Invalid"
	// None specifies the none state for authentication type.
	None AuthenticationType = "None"
	// NTLM specifies the ntlm state for authentication type.
	NTLM AuthenticationType = "NTLM"
)

// AuthorizationEligibility enumerates the values for authorization
// eligibility.
type AuthorizationEligibility string

const (
	// Eligible specifies the eligible state for authorization eligibility.
	Eligible AuthorizationEligibility = "Eligible"
	// InEligible specifies the in eligible state for authorization
	// eligibility.
	InEligible AuthorizationEligibility = "InEligible"
)

// AuthorizationStatus enumerates the values for authorization status.
type AuthorizationStatus string

const (
	// AuthorizationStatusDisabled specifies the authorization status disabled
	// state for authorization status.
	AuthorizationStatusDisabled AuthorizationStatus = "Disabled"
	// AuthorizationStatusEnabled specifies the authorization status enabled
	// state for authorization status.
	AuthorizationStatusEnabled AuthorizationStatus = "Enabled"
)

// BackupJobCreationType enumerates the values for backup job creation type.
type BackupJobCreationType string

const (
	// Adhoc specifies the adhoc state for backup job creation type.
	Adhoc BackupJobCreationType = "Adhoc"
	// BySchedule specifies the by schedule state for backup job creation type.
	BySchedule BackupJobCreationType = "BySchedule"
	// BySSM specifies the by ssm state for backup job creation type.
	BySSM BackupJobCreationType = "BySSM"
)

// BackupPolicyCreationType enumerates the values for backup policy creation
// type.
type BackupPolicyCreationType string

const (
	// BackupPolicyCreationTypeBySaaS specifies the backup policy creation type
	// by saa s state for backup policy creation type.
	BackupPolicyCreationTypeBySaaS BackupPolicyCreationType = "BySaaS"
	// BackupPolicyCreationTypeBySSM specifies the backup policy creation type
	// by ssm state for backup policy creation type.
	BackupPolicyCreationTypeBySSM BackupPolicyCreationType = "BySSM"
)

// BackupStatus enumerates the values for backup status.
type BackupStatus string

const (
	// BackupStatusDisabled specifies the backup status disabled state for
	// backup status.
	BackupStatusDisabled BackupStatus = "Disabled"
	// BackupStatusEnabled specifies the backup status enabled state for backup
	// status.
	BackupStatusEnabled BackupStatus = "Enabled"
)

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// CloudSnapshot specifies the cloud snapshot state for backup type.
	CloudSnapshot BackupType = "CloudSnapshot"
	// LocalSnapshot specifies the local snapshot state for backup type.
	LocalSnapshot BackupType = "LocalSnapshot"
)

// ControllerID enumerates the values for controller id.
type ControllerID string

const (
	// ControllerIDController0 specifies the controller id controller 0 state
	// for controller id.
	ControllerIDController0 ControllerID = "Controller0"
	// ControllerIDController1 specifies the controller id controller 1 state
	// for controller id.
	ControllerIDController1 ControllerID = "Controller1"
	// ControllerIDNone specifies the controller id none state for controller
	// id.
	ControllerIDNone ControllerID = "None"
	// ControllerIDUnknown specifies the controller id unknown state for
	// controller id.
	ControllerIDUnknown ControllerID = "Unknown"
)

// ControllerPowerStateAction enumerates the values for controller power state
// action.
type ControllerPowerStateAction string

const (
	// Restart specifies the restart state for controller power state action.
	Restart ControllerPowerStateAction = "Restart"
	// Shutdown specifies the shutdown state for controller power state action.
	Shutdown ControllerPowerStateAction = "Shutdown"
	// Start specifies the start state for controller power state action.
	Start ControllerPowerStateAction = "Start"
)

// ControllerStatus enumerates the values for controller status.
type ControllerStatus string

const (
	// ControllerStatusFailure specifies the controller status failure state
	// for controller status.
	ControllerStatusFailure ControllerStatus = "Failure"
	// ControllerStatusNotPresent specifies the controller status not present
	// state for controller status.
	ControllerStatusNotPresent ControllerStatus = "NotPresent"
	// ControllerStatusOk specifies the controller status ok state for
	// controller status.
	ControllerStatusOk ControllerStatus = "Ok"
	// ControllerStatusPoweredOff specifies the controller status powered off
	// state for controller status.
	ControllerStatusPoweredOff ControllerStatus = "PoweredOff"
	// ControllerStatusRecovering specifies the controller status recovering
	// state for controller status.
	ControllerStatusRecovering ControllerStatus = "Recovering"
	// ControllerStatusWarning specifies the controller status warning state
	// for controller status.
	ControllerStatusWarning ControllerStatus = "Warning"
)

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday specifies the friday state for day of week.
	Friday DayOfWeek = "Friday"
	// Monday specifies the monday state for day of week.
	Monday DayOfWeek = "Monday"
	// Saturday specifies the saturday state for day of week.
	Saturday DayOfWeek = "Saturday"
	// Sunday specifies the sunday state for day of week.
	Sunday DayOfWeek = "Sunday"
	// Thursday specifies the thursday state for day of week.
	Thursday DayOfWeek = "Thursday"
	// Tuesday specifies the tuesday state for day of week.
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday specifies the wednesday state for day of week.
	Wednesday DayOfWeek = "Wednesday"
)

// DeviceConfigurationStatus enumerates the values for device configuration
// status.
type DeviceConfigurationStatus string

const (
	// Complete specifies the complete state for device configuration status.
	Complete DeviceConfigurationStatus = "Complete"
	// Pending specifies the pending state for device configuration status.
	Pending DeviceConfigurationStatus = "Pending"
)

// DeviceStatus enumerates the values for device status.
type DeviceStatus string

const (
	// Creating specifies the creating state for device status.
	Creating DeviceStatus = "Creating"
	// Deactivated specifies the deactivated state for device status.
	Deactivated DeviceStatus = "Deactivated"
	// Deactivating specifies the deactivating state for device status.
	Deactivating DeviceStatus = "Deactivating"
	// Deleted specifies the deleted state for device status.
	Deleted DeviceStatus = "Deleted"
	// MaintenanceMode specifies the maintenance mode state for device status.
	MaintenanceMode DeviceStatus = "MaintenanceMode"
	// Offline specifies the offline state for device status.
	Offline DeviceStatus = "Offline"
	// Online specifies the online state for device status.
	Online DeviceStatus = "Online"
	// Provisioning specifies the provisioning state for device status.
	Provisioning DeviceStatus = "Provisioning"
	// ReadyToSetup specifies the ready to setup state for device status.
	ReadyToSetup DeviceStatus = "ReadyToSetup"
	// RequiresAttention specifies the requires attention state for device
	// status.
	RequiresAttention DeviceStatus = "RequiresAttention"
	// Unknown specifies the unknown state for device status.
	Unknown DeviceStatus = "Unknown"
)

// DeviceType enumerates the values for device type.
type DeviceType string

const (
	// DeviceTypeInvalid specifies the device type invalid state for device
	// type.
	DeviceTypeInvalid DeviceType = "Invalid"
	// DeviceTypeSeries8000PhysicalAppliance specifies the device type series
	// 8000 physical appliance state for device type.
	DeviceTypeSeries8000PhysicalAppliance DeviceType = "Series8000PhysicalAppliance"
	// DeviceTypeSeries8000VirtualAppliance specifies the device type series
	// 8000 virtual appliance state for device type.
	DeviceTypeSeries8000VirtualAppliance DeviceType = "Series8000VirtualAppliance"
)

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES256 specifies the encryption algorithm aes256
	// state for encryption algorithm.
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmNone specifies the encryption algorithm none state
	// for encryption algorithm.
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmRSAESPKCS1V15 specifies the encryption algorithm
	// rsaespkcs1v15 state for encryption algorithm.
	EncryptionAlgorithmRSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// EncryptionStatus enumerates the values for encryption status.
type EncryptionStatus string

const (
	// EncryptionStatusDisabled specifies the encryption status disabled state
	// for encryption status.
	EncryptionStatusDisabled EncryptionStatus = "Disabled"
	// EncryptionStatusEnabled specifies the encryption status enabled state
	// for encryption status.
	EncryptionStatusEnabled EncryptionStatus = "Enabled"
)

// FeatureSupportStatus enumerates the values for feature support status.
type FeatureSupportStatus string

const (
	// NotAvailable specifies the not available state for feature support
	// status.
	NotAvailable FeatureSupportStatus = "NotAvailable"
	// Supported specifies the supported state for feature support status.
	Supported FeatureSupportStatus = "Supported"
	// UnsupportedDeviceVersion specifies the unsupported device version state
	// for feature support status.
	UnsupportedDeviceVersion FeatureSupportStatus = "UnsupportedDeviceVersion"
)

// HardwareComponentStatus enumerates the values for hardware component status.
type HardwareComponentStatus string

const (
	// HardwareComponentStatusFailure specifies the hardware component status
	// failure state for hardware component status.
	HardwareComponentStatusFailure HardwareComponentStatus = "Failure"
	// HardwareComponentStatusNotPresent specifies the hardware component
	// status not present state for hardware component status.
	HardwareComponentStatusNotPresent HardwareComponentStatus = "NotPresent"
	// HardwareComponentStatusOk specifies the hardware component status ok
	// state for hardware component status.
	HardwareComponentStatusOk HardwareComponentStatus = "Ok"
	// HardwareComponentStatusPoweredOff specifies the hardware component
	// status powered off state for hardware component status.
	HardwareComponentStatusPoweredOff HardwareComponentStatus = "PoweredOff"
	// HardwareComponentStatusRecovering specifies the hardware component
	// status recovering state for hardware component status.
	HardwareComponentStatusRecovering HardwareComponentStatus = "Recovering"
	// HardwareComponentStatusUnknown specifies the hardware component status
	// unknown state for hardware component status.
	HardwareComponentStatusUnknown HardwareComponentStatus = "Unknown"
	// HardwareComponentStatusWarning specifies the hardware component status
	// warning state for hardware component status.
	HardwareComponentStatusWarning HardwareComponentStatus = "Warning"
)

// InEligibilityCategory enumerates the values for in eligibility category.
type InEligibilityCategory string

const (
	// DeviceNotOnline specifies the device not online state for in eligibility
	// category.
	DeviceNotOnline InEligibilityCategory = "DeviceNotOnline"
	// NotSupportedAppliance specifies the not supported appliance state for in
	// eligibility category.
	NotSupportedAppliance InEligibilityCategory = "NotSupportedAppliance"
	// RolloverPending specifies the rollover pending state for in eligibility
	// category.
	RolloverPending InEligibilityCategory = "RolloverPending"
)

// ISCSIAndCloudStatus enumerates the values for iscsi and cloud status.
type ISCSIAndCloudStatus string

const (
	// ISCSIAndCloudStatusCloudEnabled specifies the iscsi and cloud status
	// cloud enabled state for iscsi and cloud status.
	ISCSIAndCloudStatusCloudEnabled ISCSIAndCloudStatus = "CloudEnabled"
	// ISCSIAndCloudStatusDisabled specifies the iscsi and cloud status
	// disabled state for iscsi and cloud status.
	ISCSIAndCloudStatusDisabled ISCSIAndCloudStatus = "Disabled"
	// ISCSIAndCloudStatusIscsiAndCloudEnabled specifies the iscsi and cloud
	// status iscsi and cloud enabled state for iscsi and cloud status.
	ISCSIAndCloudStatusIscsiAndCloudEnabled ISCSIAndCloudStatus = "IscsiAndCloudEnabled"
	// ISCSIAndCloudStatusIscsiEnabled specifies the iscsi and cloud status
	// iscsi enabled state for iscsi and cloud status.
	ISCSIAndCloudStatusIscsiEnabled ISCSIAndCloudStatus = "IscsiEnabled"
)

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// Canceled specifies the canceled state for job status.
	Canceled JobStatus = "Canceled"
	// Failed specifies the failed state for job status.
	Failed JobStatus = "Failed"
	// Running specifies the running state for job status.
	Running JobStatus = "Running"
	// Succeeded specifies the succeeded state for job status.
	Succeeded JobStatus = "Succeeded"
)

// JobType enumerates the values for job type.
type JobType string

const (
	// CloneVolume specifies the clone volume state for job type.
	CloneVolume JobType = "CloneVolume"
	// CreateCloudAppliance specifies the create cloud appliance state for job
	// type.
	CreateCloudAppliance JobType = "CreateCloudAppliance"
	// CreateLocallyPinnedVolume specifies the create locally pinned volume
	// state for job type.
	CreateLocallyPinnedVolume JobType = "CreateLocallyPinnedVolume"
	// FailoverVolumeContainers specifies the failover volume containers state
	// for job type.
	FailoverVolumeContainers JobType = "FailoverVolumeContainers"
	// InstallUpdates specifies the install updates state for job type.
	InstallUpdates JobType = "InstallUpdates"
	// ManualBackup specifies the manual backup state for job type.
	ManualBackup JobType = "ManualBackup"
	// ModifyVolume specifies the modify volume state for job type.
	ModifyVolume JobType = "ModifyVolume"
	// RestoreBackup specifies the restore backup state for job type.
	RestoreBackup JobType = "RestoreBackup"
	// ScheduledBackup specifies the scheduled backup state for job type.
	ScheduledBackup JobType = "ScheduledBackup"
	// SupportPackageLogs specifies the support package logs state for job
	// type.
	SupportPackageLogs JobType = "SupportPackageLogs"
)

// KeyRolloverStatus enumerates the values for key rollover status.
type KeyRolloverStatus string

const (
	// NotRequired specifies the not required state for key rollover status.
	NotRequired KeyRolloverStatus = "NotRequired"
	// Required specifies the required state for key rollover status.
	Required KeyRolloverStatus = "Required"
)

// Kind enumerates the values for kind.
type Kind string

const (
	// Series8000 specifies the series 8000 state for kind.
	Series8000 Kind = "Series8000"
)

// ManagerType enumerates the values for manager type.
type ManagerType string

const (
	// GardaV1 specifies the garda v1 state for manager type.
	GardaV1 ManagerType = "GardaV1"
	// HelsinkiV1 specifies the helsinki v1 state for manager type.
	HelsinkiV1 ManagerType = "HelsinkiV1"
)

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage specifies the metric aggregation type
	// average state for metric aggregation type.
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeLast specifies the metric aggregation type last
	// state for metric aggregation type.
	MetricAggregationTypeLast MetricAggregationType = "Last"
	// MetricAggregationTypeMaximum specifies the metric aggregation type
	// maximum state for metric aggregation type.
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	// MetricAggregationTypeMinimum specifies the metric aggregation type
	// minimum state for metric aggregation type.
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	// MetricAggregationTypeNone specifies the metric aggregation type none
	// state for metric aggregation type.
	MetricAggregationTypeNone MetricAggregationType = "None"
	// MetricAggregationTypeTotal specifies the metric aggregation type total
	// state for metric aggregation type.
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// Bytes specifies the bytes state for metric unit.
	Bytes MetricUnit = "Bytes"
	// BytesPerSecond specifies the bytes per second state for metric unit.
	BytesPerSecond MetricUnit = "BytesPerSecond"
	// Count specifies the count state for metric unit.
	Count MetricUnit = "Count"
	// CountPerSecond specifies the count per second state for metric unit.
	CountPerSecond MetricUnit = "CountPerSecond"
	// Percent specifies the percent state for metric unit.
	Percent MetricUnit = "Percent"
	// Seconds specifies the seconds state for metric unit.
	Seconds MetricUnit = "Seconds"
)

// MonitoringStatus enumerates the values for monitoring status.
type MonitoringStatus string

const (
	// MonitoringStatusDisabled specifies the monitoring status disabled state
	// for monitoring status.
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	// MonitoringStatusEnabled specifies the monitoring status enabled state
	// for monitoring status.
	MonitoringStatusEnabled MonitoringStatus = "Enabled"
)

// NetInterfaceID enumerates the values for net interface id.
type NetInterfaceID string

const (
	// NetInterfaceIDData0 specifies the net interface id data 0 state for net
	// interface id.
	NetInterfaceIDData0 NetInterfaceID = "Data0"
	// NetInterfaceIDData1 specifies the net interface id data 1 state for net
	// interface id.
	NetInterfaceIDData1 NetInterfaceID = "Data1"
	// NetInterfaceIDData2 specifies the net interface id data 2 state for net
	// interface id.
	NetInterfaceIDData2 NetInterfaceID = "Data2"
	// NetInterfaceIDData3 specifies the net interface id data 3 state for net
	// interface id.
	NetInterfaceIDData3 NetInterfaceID = "Data3"
	// NetInterfaceIDData4 specifies the net interface id data 4 state for net
	// interface id.
	NetInterfaceIDData4 NetInterfaceID = "Data4"
	// NetInterfaceIDData5 specifies the net interface id data 5 state for net
	// interface id.
	NetInterfaceIDData5 NetInterfaceID = "Data5"
	// NetInterfaceIDInvalid specifies the net interface id invalid state for
	// net interface id.
	NetInterfaceIDInvalid NetInterfaceID = "Invalid"
)

// NetInterfaceStatus enumerates the values for net interface status.
type NetInterfaceStatus string

const (
	// NetInterfaceStatusDisabled specifies the net interface status disabled
	// state for net interface status.
	NetInterfaceStatusDisabled NetInterfaceStatus = "Disabled"
	// NetInterfaceStatusEnabled specifies the net interface status enabled
	// state for net interface status.
	NetInterfaceStatusEnabled NetInterfaceStatus = "Enabled"
)

// NetworkMode enumerates the values for network mode.
type NetworkMode string

const (
	// NetworkModeBOTH specifies the network mode both state for network mode.
	NetworkModeBOTH NetworkMode = "BOTH"
	// NetworkModeInvalid specifies the network mode invalid state for network
	// mode.
	NetworkModeInvalid NetworkMode = "Invalid"
	// NetworkModeIPV4 specifies the network mode ipv4 state for network mode.
	NetworkModeIPV4 NetworkMode = "IPV4"
	// NetworkModeIPV6 specifies the network mode ipv6 state for network mode.
	NetworkModeIPV6 NetworkMode = "IPV6"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusDeleting specifies the operation status deleting state
	// for operation status.
	OperationStatusDeleting OperationStatus = "Deleting"
	// OperationStatusNone specifies the operation status none state for
	// operation status.
	OperationStatusNone OperationStatus = "None"
	// OperationStatusRestoring specifies the operation status restoring state
	// for operation status.
	OperationStatusRestoring OperationStatus = "Restoring"
	// OperationStatusUpdating specifies the operation status updating state
	// for operation status.
	OperationStatusUpdating OperationStatus = "Updating"
)

// OwnerShipStatus enumerates the values for owner ship status.
type OwnerShipStatus string

const (
	// NotOwned specifies the not owned state for owner ship status.
	NotOwned OwnerShipStatus = "NotOwned"
	// Owned specifies the owned state for owner ship status.
	Owned OwnerShipStatus = "Owned"
)

// RecurrenceType enumerates the values for recurrence type.
type RecurrenceType string

const (
	// Daily specifies the daily state for recurrence type.
	Daily RecurrenceType = "Daily"
	// Hourly specifies the hourly state for recurrence type.
	Hourly RecurrenceType = "Hourly"
	// Minutes specifies the minutes state for recurrence type.
	Minutes RecurrenceType = "Minutes"
	// Weekly specifies the weekly state for recurrence type.
	Weekly RecurrenceType = "Weekly"
)

// RemoteManagementModeConfiguration enumerates the values for remote
// management mode configuration.
type RemoteManagementModeConfiguration string

const (
	// RemoteManagementModeConfigurationDisabled specifies the remote
	// management mode configuration disabled state for remote management mode
	// configuration.
	RemoteManagementModeConfigurationDisabled RemoteManagementModeConfiguration = "Disabled"
	// RemoteManagementModeConfigurationHTTPSAndHTTPEnabled specifies the
	// remote management mode configuration https and http enabled state for
	// remote management mode configuration.
	RemoteManagementModeConfigurationHTTPSAndHTTPEnabled RemoteManagementModeConfiguration = "HttpsAndHttpEnabled"
	// RemoteManagementModeConfigurationHTTPSEnabled specifies the remote
	// management mode configuration https enabled state for remote management
	// mode configuration.
	RemoteManagementModeConfigurationHTTPSEnabled RemoteManagementModeConfiguration = "HttpsEnabled"
	// RemoteManagementModeConfigurationUnknown specifies the remote management
	// mode configuration unknown state for remote management mode
	// configuration.
	RemoteManagementModeConfigurationUnknown RemoteManagementModeConfiguration = "Unknown"
)

// ScheduledBackupStatus enumerates the values for scheduled backup status.
type ScheduledBackupStatus string

const (
	// ScheduledBackupStatusDisabled specifies the scheduled backup status
	// disabled state for scheduled backup status.
	ScheduledBackupStatusDisabled ScheduledBackupStatus = "Disabled"
	// ScheduledBackupStatusEnabled specifies the scheduled backup status
	// enabled state for scheduled backup status.
	ScheduledBackupStatusEnabled ScheduledBackupStatus = "Enabled"
)

// ScheduleStatus enumerates the values for schedule status.
type ScheduleStatus string

const (
	// ScheduleStatusDisabled specifies the schedule status disabled state for
	// schedule status.
	ScheduleStatusDisabled ScheduleStatus = "Disabled"
	// ScheduleStatusEnabled specifies the schedule status enabled state for
	// schedule status.
	ScheduleStatusEnabled ScheduleStatus = "Enabled"
)

// SslStatus enumerates the values for ssl status.
type SslStatus string

const (
	// SslStatusDisabled specifies the ssl status disabled state for ssl
	// status.
	SslStatusDisabled SslStatus = "Disabled"
	// SslStatusEnabled specifies the ssl status enabled state for ssl status.
	SslStatusEnabled SslStatus = "Enabled"
)

// TargetEligibilityResultCode enumerates the values for target eligibility
// result code.
type TargetEligibilityResultCode string

const (
	// LocalToTieredVolumesConversionWarning specifies the local to tiered
	// volumes conversion warning state for target eligibility result code.
	LocalToTieredVolumesConversionWarning TargetEligibilityResultCode = "LocalToTieredVolumesConversionWarning"
	// TargetAndSourceCannotBeSameError specifies the target and source cannot
	// be same error state for target eligibility result code.
	TargetAndSourceCannotBeSameError TargetEligibilityResultCode = "TargetAndSourceCannotBeSameError"
	// TargetInsufficientCapacityError specifies the target insufficient
	// capacity error state for target eligibility result code.
	TargetInsufficientCapacityError TargetEligibilityResultCode = "TargetInsufficientCapacityError"
	// TargetInsufficientLocalVolumeMemoryError specifies the target
	// insufficient local volume memory error state for target eligibility
	// result code.
	TargetInsufficientLocalVolumeMemoryError TargetEligibilityResultCode = "TargetInsufficientLocalVolumeMemoryError"
	// TargetInsufficientTieredVolumeMemoryError specifies the target
	// insufficient tiered volume memory error state for target eligibility
	// result code.
	TargetInsufficientTieredVolumeMemoryError TargetEligibilityResultCode = "TargetInsufficientTieredVolumeMemoryError"
	// TargetIsNotOnlineError specifies the target is not online error state
	// for target eligibility result code.
	TargetIsNotOnlineError TargetEligibilityResultCode = "TargetIsNotOnlineError"
	// TargetSourceIncompatibleVersionError specifies the target source
	// incompatible version error state for target eligibility result code.
	TargetSourceIncompatibleVersionError TargetEligibilityResultCode = "TargetSourceIncompatibleVersionError"
)

// TargetEligibilityStatus enumerates the values for target eligibility status.
type TargetEligibilityStatus string

const (
	// TargetEligibilityStatusEligible specifies the target eligibility status
	// eligible state for target eligibility status.
	TargetEligibilityStatusEligible TargetEligibilityStatus = "Eligible"
	// TargetEligibilityStatusNotEligible specifies the target eligibility
	// status not eligible state for target eligibility status.
	TargetEligibilityStatusNotEligible TargetEligibilityStatus = "NotEligible"
)

// VirtualMachineAPIType enumerates the values for virtual machine api type.
type VirtualMachineAPIType string

const (
	// Arm specifies the arm state for virtual machine api type.
	Arm VirtualMachineAPIType = "Arm"
	// Classic specifies the classic state for virtual machine api type.
	Classic VirtualMachineAPIType = "Classic"
)

// VolumeStatus enumerates the values for volume status.
type VolumeStatus string

const (
	// VolumeStatusOffline specifies the volume status offline state for volume
	// status.
	VolumeStatusOffline VolumeStatus = "Offline"
	// VolumeStatusOnline specifies the volume status online state for volume
	// status.
	VolumeStatusOnline VolumeStatus = "Online"
)

// VolumeType enumerates the values for volume type.
type VolumeType string

const (
	// Archival specifies the archival state for volume type.
	Archival VolumeType = "Archival"
	// LocallyPinned specifies the locally pinned state for volume type.
	LocallyPinned VolumeType = "LocallyPinned"
	// Tiered specifies the tiered state for volume type.
	Tiered VolumeType = "Tiered"
)

// AccessControlRecord is the access control record.
type AccessControlRecord struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	Kind                           Kind    `json:"kind,omitempty"`
	*AccessControlRecordProperties `json:"properties,omitempty"`
}

// AccessControlRecordList is the collection of access control records.
type AccessControlRecordList struct {
	autorest.Response `json:"-"`
	Value             *[]AccessControlRecord `json:"value,omitempty"`
}

// AccessControlRecordProperties is the properties of access control record.
type AccessControlRecordProperties struct {
	InitiatorName *string `json:"initiatorName,omitempty"`
	VolumeCount   *int32  `json:"volumeCount,omitempty"`
}

// AcsConfiguration is the ACS configuration.
type AcsConfiguration struct {
	Namespace  *string `json:"namespace,omitempty"`
	Realm      *string `json:"realm,omitempty"`
	ServiceURL *string `json:"serviceUrl,omitempty"`
}

// Alert is the alert.
type Alert struct {
	ID               *string `json:"id,omitempty"`
	Name             *string `json:"name,omitempty"`
	Type             *string `json:"type,omitempty"`
	Kind             Kind    `json:"kind,omitempty"`
	*AlertProperties `json:"properties,omitempty"`
}

// AlertErrorDetails is the details of the error for which the alert was raised
type AlertErrorDetails struct {
	ErrorCode    *string `json:"errorCode,omitempty"`
	ErrorMessage *string `json:"errorMessage,omitempty"`
	Occurences   *int32  `json:"occurences,omitempty"`
}

// AlertFilter is the OData filters to be used for Alert
type AlertFilter struct {
	Status         AlertStatus     `json:"status,omitempty"`
	Severity       AlertSeverity   `json:"severity,omitempty"`
	SourceType     AlertSourceType `json:"sourceType,omitempty"`
	SourceName     *string         `json:"sourceName,omitempty"`
	AppearedOnTime *date.Time      `json:"appearedOnTime,omitempty"`
}

// AlertList is the collection of alerts.
type AlertList struct {
	autorest.Response `json:"-"`
	Value             *[]Alert `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// AlertListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AlertList) AlertListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AlertNotificationProperties is the properties of the alert notification
// settings.
type AlertNotificationProperties struct {
	EmailNotification            AlertEmailNotificationStatus `json:"emailNotification,omitempty"`
	AlertNotificationCulture     *string                      `json:"alertNotificationCulture,omitempty"`
	NotificationToServiceOwners  AlertEmailNotificationStatus `json:"notificationToServiceOwners,omitempty"`
	AdditionalRecipientEmailList *[]string                    `json:"additionalRecipientEmailList,omitempty"`
}

// AlertProperties is the properties of alert
type AlertProperties struct {
	Title                *string             `json:"title,omitempty"`
	Scope                AlertScope          `json:"scope,omitempty"`
	AlertType            *string             `json:"alertType,omitempty"`
	AppearedAtTime       *date.Time          `json:"appearedAtTime,omitempty"`
	AppearedAtSourceTime *date.Time          `json:"appearedAtSourceTime,omitempty"`
	ClearedAtTime        *date.Time          `json:"clearedAtTime,omitempty"`
	ClearedAtSourceTime  *date.Time          `json:"clearedAtSourceTime,omitempty"`
	Source               *AlertSource        `json:"source,omitempty"`
	Recommendation       *string             `json:"recommendation,omitempty"`
	ResolutionReason     *string             `json:"resolutionReason,omitempty"`
	Severity             AlertSeverity       `json:"severity,omitempty"`
	Status               AlertStatus         `json:"status,omitempty"`
	ErrorDetails         *AlertErrorDetails  `json:"errorDetails,omitempty"`
	DetailedInformation  *map[string]*string `json:"detailedInformation,omitempty"`
}

// AlertSettings is the alert settings.
type AlertSettings struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	Kind                         Kind    `json:"kind,omitempty"`
	*AlertNotificationProperties `json:"properties,omitempty"`
}

// AlertSource is the source details at which the alert was raised
type AlertSource struct {
	Name            *string         `json:"name,omitempty"`
	TimeZone        *string         `json:"timeZone,omitempty"`
	AlertSourceType AlertSourceType `json:"alertSourceType,omitempty"`
}

// AsymmetricEncryptedSecret is represent the secrets intended for encryption
// with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	Value                    *string             `json:"value,omitempty"`
	EncryptionCertThumbprint *string             `json:"encryptionCertThumbprint,omitempty"`
	EncryptionAlgorithm      EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// AvailableProviderOperation is represents available provider operation.
type AvailableProviderOperation struct {
	Name       *string                            `json:"name,omitempty"`
	Display    *AvailableProviderOperationDisplay `json:"display,omitempty"`
	Origin     *string                            `json:"origin,omitempty"`
	Properties *map[string]interface{}            `json:"properties,omitempty"`
}

// AvailableProviderOperationDisplay is contains the localized display
// information for this particular operation/action. These value will be used
// by several clients for (a) custom role definitions for RBAC, (b) complex
// query filters for the event service and (c) audit history/records for
// management operations.
type AvailableProviderOperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// AvailableProviderOperationList is list of available provider operations.
type AvailableProviderOperationList struct {
	autorest.Response `json:"-"`
	Value             *[]AvailableProviderOperation `json:"value,omitempty"`
	NextLink          *string                       `json:"nextLink,omitempty"`
}

// AvailableProviderOperationListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AvailableProviderOperationList) AvailableProviderOperationListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Backup is the backup.
type Backup struct {
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	Kind              Kind    `json:"kind,omitempty"`
	*BackupProperties `json:"properties,omitempty"`
}

// BackupElement is the backup element.
type BackupElement struct {
	ElementID         *string    `json:"elementId,omitempty"`
	ElementName       *string    `json:"elementName,omitempty"`
	ElementType       *string    `json:"elementType,omitempty"`
	SizeInBytes       *int64     `json:"sizeInBytes,omitempty"`
	VolumeName        *string    `json:"volumeName,omitempty"`
	VolumeContainerID *string    `json:"volumeContainerId,omitempty"`
	VolumeType        VolumeType `json:"volumeType,omitempty"`
}

// BackupFilter is the OData filters to be used for backups.
type BackupFilter struct {
	BackupPolicyID *string    `json:"backupPolicyId,omitempty"`
	VolumeID       *string    `json:"volumeId,omitempty"`
	CreatedTime    *date.Time `json:"createdTime,omitempty"`
}

// BackupList is the collection of backups.
type BackupList struct {
	autorest.Response `json:"-"`
	Value             *[]Backup `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// BackupListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client BackupList) BackupListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// BackupPolicy is the backup policy.
type BackupPolicy struct {
	autorest.Response       `json:"-"`
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Type                    *string `json:"type,omitempty"`
	Kind                    Kind    `json:"kind,omitempty"`
	*BackupPolicyProperties `json:"properties,omitempty"`
}

// BackupPolicyList is the collection of backup policies.
type BackupPolicyList struct {
	autorest.Response `json:"-"`
	Value             *[]BackupPolicy `json:"value,omitempty"`
}

// BackupPolicyProperties is the properties of the backup policy.
type BackupPolicyProperties struct {
	VolumeIds                *[]string                `json:"volumeIds,omitempty"`
	NextBackupTime           *date.Time               `json:"nextBackupTime,omitempty"`
	LastBackupTime           *date.Time               `json:"lastBackupTime,omitempty"`
	SchedulesCount           *int64                   `json:"schedulesCount,omitempty"`
	ScheduledBackupStatus    ScheduledBackupStatus    `json:"scheduledBackupStatus,omitempty"`
	BackupPolicyCreationType BackupPolicyCreationType `json:"backupPolicyCreationType,omitempty"`
	SsmHostName              *string                  `json:"ssmHostName,omitempty"`
}

// BackupProperties is the properties of the backup.
type BackupProperties struct {
	CreatedOn             *date.Time            `json:"createdOn,omitempty"`
	SizeInBytes           *int64                `json:"sizeInBytes,omitempty"`
	BackupType            BackupType            `json:"backupType,omitempty"`
	BackupJobCreationType BackupJobCreationType `json:"backupJobCreationType,omitempty"`
	BackupPolicyID        *string               `json:"backupPolicyId,omitempty"`
	SsmHostName           *string               `json:"ssmHostName,omitempty"`
	Elements              *[]BackupElement      `json:"elements,omitempty"`
}

// BackupSchedule is the backup schedule.
type BackupSchedule struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Type                      *string `json:"type,omitempty"`
	Kind                      Kind    `json:"kind,omitempty"`
	*BackupScheduleProperties `json:"properties,omitempty"`
}

// BackupScheduleList is the backup schedule list.
type BackupScheduleList struct {
	autorest.Response `json:"-"`
	Value             *[]BackupSchedule `json:"value,omitempty"`
}

// BackupScheduleProperties is the properties of the backup schedule.
type BackupScheduleProperties struct {
	ScheduleRecurrence *ScheduleRecurrence `json:"scheduleRecurrence,omitempty"`
	BackupType         BackupType          `json:"backupType,omitempty"`
	RetentionCount     *int64              `json:"retentionCount,omitempty"`
	StartTime          *date.Time          `json:"startTime,omitempty"`
	ScheduleStatus     ScheduleStatus      `json:"scheduleStatus,omitempty"`
	LastSuccessfulRun  *date.Time          `json:"lastSuccessfulRun,omitempty"`
}

// BandwidthRateSettingProperties is the properties of the bandwidth setting.
type BandwidthRateSettingProperties struct {
	Schedules   *[]BandwidthSchedule `json:"schedules,omitempty"`
	VolumeCount *int32               `json:"volumeCount,omitempty"`
}

// BandwidthSchedule is the schedule for bandwidth setting.
type BandwidthSchedule struct {
	Start      *Time        `json:"start,omitempty"`
	Stop       *Time        `json:"stop,omitempty"`
	RateInMbps *int32       `json:"rateInMbps,omitempty"`
	Days       *[]DayOfWeek `json:"days,omitempty"`
}

// BandwidthSetting is the bandwidth setting.
type BandwidthSetting struct {
	autorest.Response               `json:"-"`
	ID                              *string `json:"id,omitempty"`
	Name                            *string `json:"name,omitempty"`
	Type                            *string `json:"type,omitempty"`
	Kind                            Kind    `json:"kind,omitempty"`
	*BandwidthRateSettingProperties `json:"properties,omitempty"`
}

// BandwidthSettingList is the collection of bandwidth setting entities.
type BandwidthSettingList struct {
	autorest.Response `json:"-"`
	Value             *[]BandwidthSetting `json:"value,omitempty"`
}

// BaseModel is represents the base class for all other ARM object models
type BaseModel struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
	Kind Kind    `json:"kind,omitempty"`
}

// ChapSettings is the Challenge-Handshake Authentication Protocol (CHAP)
// settings.
type ChapSettings struct {
	InitiatorUser   *string                    `json:"initiatorUser,omitempty"`
	InitiatorSecret *AsymmetricEncryptedSecret `json:"initiatorSecret,omitempty"`
	TargetUser      *string                    `json:"targetUser,omitempty"`
	TargetSecret    *AsymmetricEncryptedSecret `json:"targetSecret,omitempty"`
}

// ClearAlertRequest is the request for clearing the alert
type ClearAlertRequest struct {
	ResolutionMessage *string   `json:"resolutionMessage,omitempty"`
	Alerts            *[]string `json:"alerts,omitempty"`
}

// CloneRequest is the clone job request.
type CloneRequest struct {
	TargetDeviceID               *string        `json:"targetDeviceId,omitempty"`
	TargetVolumeName             *string        `json:"targetVolumeName,omitempty"`
	TargetAccessControlRecordIds *[]string      `json:"targetAccessControlRecordIds,omitempty"`
	BackupElement                *BackupElement `json:"backupElement,omitempty"`
}

// CloudAppliance is the cloud appliance.
type CloudAppliance struct {
	Name                    *string `json:"name,omitempty"`
	VnetName                *string `json:"vnetName,omitempty"`
	VnetRegion              *string `json:"vnetRegion,omitempty"`
	IsVnetDNSConfigured     *bool   `json:"isVnetDnsConfigured,omitempty"`
	IsVnetExpressConfigured *bool   `json:"isVnetExpressConfigured,omitempty"`
	SubnetName              *string `json:"subnetName,omitempty"`
	StorageAccountName      *string `json:"storageAccountName,omitempty"`
	StorageAccountType      *string `json:"storageAccountType,omitempty"`
	VMType                  *string `json:"vmType,omitempty"`
	VMImageName             *string `json:"vmImageName,omitempty"`
	ModelNumber             *string `json:"modelNumber,omitempty"`
}

// CloudApplianceConfiguration is the cloud appliance configuration
type CloudApplianceConfiguration struct {
	ID                                     *string `json:"id,omitempty"`
	Name                                   *string `json:"name,omitempty"`
	Type                                   *string `json:"type,omitempty"`
	Kind                                   Kind    `json:"kind,omitempty"`
	*CloudApplianceConfigurationProperties `json:"properties,omitempty"`
}

// CloudApplianceConfigurationList is the cloud appliance configuration list
type CloudApplianceConfigurationList struct {
	autorest.Response `json:"-"`
	Value             *[]CloudApplianceConfiguration `json:"value,omitempty"`
}

// CloudApplianceConfigurationProperties is the properties of cloud appliance
// configuration.
type CloudApplianceConfigurationProperties struct {
	ModelNumber                  *string           `json:"modelNumber,omitempty"`
	CloudPlatform                *string           `json:"cloudPlatform,omitempty"`
	AcsConfiguration             *AcsConfiguration `json:"acsConfiguration,omitempty"`
	SupportedStorageAccountTypes *[]string         `json:"supportedStorageAccountTypes,omitempty"`
	SupportedRegions             *[]string         `json:"supportedRegions,omitempty"`
	SupportedVMTypes             *[]string         `json:"supportedVmTypes,omitempty"`
	SupportedVMImages            *[]VMImage        `json:"supportedVmImages,omitempty"`
}

// CloudApplianceSettings is the cloud appliance settings.
type CloudApplianceSettings struct {
	ServiceDataEncryptionKey *AsymmetricEncryptedSecret `json:"serviceDataEncryptionKey,omitempty"`
	ChannelIntegrityKey      *AsymmetricEncryptedSecret `json:"channelIntegrityKey,omitempty"`
}

// ConfigureDeviceRequest is the mandatory device configuration request.
type ConfigureDeviceRequest struct {
	ID                                *string `json:"id,omitempty"`
	Name                              *string `json:"name,omitempty"`
	Type                              *string `json:"type,omitempty"`
	Kind                              Kind    `json:"kind,omitempty"`
	*ConfigureDeviceRequestProperties `json:"properties,omitempty"`
}

// ConfigureDeviceRequestProperties is the properties of the configure device
// request.
type ConfigureDeviceRequestProperties struct {
	FriendlyName                  *string                        `json:"friendlyName,omitempty"`
	CurrentDeviceName             *string                        `json:"currentDeviceName,omitempty"`
	TimeZone                      *string                        `json:"timeZone,omitempty"`
	DNSSettings                   *SecondaryDNSSettings          `json:"dnsSettings,omitempty"`
	NetworkInterfaceData0Settings *NetworkInterfaceData0Settings `json:"networkInterfaceData0Settings,omitempty"`
}

// ControllerPowerStateChangeRequest is the controller power state change
// request.
type ControllerPowerStateChangeRequest struct {
	ID                                           *string `json:"id,omitempty"`
	Name                                         *string `json:"name,omitempty"`
	Type                                         *string `json:"type,omitempty"`
	Kind                                         Kind    `json:"kind,omitempty"`
	*ControllerPowerStateChangeRequestProperties `json:"properties,omitempty"`
}

// ControllerPowerStateChangeRequestProperties is the properties of the
// controller power state change request.
type ControllerPowerStateChangeRequestProperties struct {
	Action           ControllerPowerStateAction `json:"action,omitempty"`
	ActiveController ControllerID               `json:"activeController,omitempty"`
	Controller0State ControllerStatus           `json:"controller0State,omitempty"`
	Controller1State ControllerStatus           `json:"controller1State,omitempty"`
}

// DataStatistics is the additional details related to the data related
// statistics of a job. Currently applicable only for Backup, Clone and Restore
// jobs.
type DataStatistics struct {
	TotalData     *int64 `json:"totalData,omitempty"`
	ProcessedData *int64 `json:"processedData,omitempty"`
	CloudData     *int64 `json:"cloudData,omitempty"`
	Throughput    *int64 `json:"throughput,omitempty"`
}

// Device is the StorSimple device.
type Device struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	Kind              Kind    `json:"kind,omitempty"`
	*DeviceProperties `json:"properties,omitempty"`
}

// DeviceDetails is the additional device details regarding the end point count
// and volume container count.
type DeviceDetails struct {
	EndpointCount        *int32 `json:"endpointCount,omitempty"`
	VolumeContainerCount *int32 `json:"volumeContainerCount,omitempty"`
}

// DeviceList is the collection of devices.
type DeviceList struct {
	autorest.Response `json:"-"`
	Value             *[]Device `json:"value,omitempty"`
}

// DevicePatch is the device patch.
type DevicePatch struct {
	*DevicePatchProperties `json:"properties,omitempty"`
}

// DevicePatchProperties is the properties of the device patch.
type DevicePatchProperties struct {
	DeviceDescription *string `json:"deviceDescription,omitempty"`
}

// DeviceProperties is the properties of the StorSimple device.
type DeviceProperties struct {
	FriendlyName                    *string                   `json:"friendlyName,omitempty"`
	ActivationTime                  *date.Time                `json:"activationTime,omitempty"`
	Culture                         *string                   `json:"culture,omitempty"`
	DeviceDescription               *string                   `json:"deviceDescription,omitempty"`
	DeviceSoftwareVersion           *string                   `json:"deviceSoftwareVersion,omitempty"`
	FriendlySoftwareName            *string                   `json:"friendlySoftwareName,omitempty"`
	DeviceConfigurationStatus       DeviceConfigurationStatus `json:"deviceConfigurationStatus,omitempty"`
	TargetIqn                       *string                   `json:"targetIqn,omitempty"`
	ModelDescription                *string                   `json:"modelDescription,omitempty"`
	Status                          DeviceStatus              `json:"status,omitempty"`
	SerialNumber                    *string                   `json:"serialNumber,omitempty"`
	DeviceType                      DeviceType                `json:"deviceType,omitempty"`
	ActiveController                ControllerID              `json:"activeController,omitempty"`
	FriendlySoftwareVersion         *string                   `json:"friendlySoftwareVersion,omitempty"`
	AvailableLocalStorageInBytes    *int64                    `json:"availableLocalStorageInBytes,omitempty"`
	AvailableTieredStorageInBytes   *int64                    `json:"availableTieredStorageInBytes,omitempty"`
	ProvisionedTieredStorageInBytes *int64                    `json:"provisionedTieredStorageInBytes,omitempty"`
	ProvisionedLocalStorageInBytes  *int64                    `json:"provisionedLocalStorageInBytes,omitempty"`
	ProvisionedVolumeSizeInBytes    *int64                    `json:"provisionedVolumeSizeInBytes,omitempty"`
	UsingStorageInBytes             *int64                    `json:"usingStorageInBytes,omitempty"`
	TotalTieredStorageInBytes       *int64                    `json:"totalTieredStorageInBytes,omitempty"`
	AgentGroupVersion               *int32                    `json:"agentGroupVersion,omitempty"`
	NetworkInterfaceCardCount       *int32                    `json:"networkInterfaceCardCount,omitempty"`
	DeviceLocation                  *string                   `json:"deviceLocation,omitempty"`
	VirtualMachineAPIType           VirtualMachineAPIType     `json:"virtualMachineApiType,omitempty"`
	Details                         *DeviceDetails            `json:"details,omitempty"`
	RolloverDetails                 *DeviceRolloverDetails    `json:"rolloverDetails,omitempty"`
}

// DeviceRolloverDetails is the additional device details for the service data
// encryption key rollover.
type DeviceRolloverDetails struct {
	AuthorizationEligibility AuthorizationEligibility `json:"authorizationEligibility,omitempty"`
	AuthorizationStatus      AuthorizationStatus      `json:"authorizationStatus,omitempty"`
	InEligibilityReason      InEligibilityCategory    `json:"inEligibilityReason,omitempty"`
}

// DimensionFilter is the dimension filter.
type DimensionFilter struct {
	Name   *string `json:"name,omitempty"`
	Values *string `json:"values,omitempty"`
}

// DNSSettings is the DNS(Domain Name Server) settings of a device.
type DNSSettings struct {
	PrimaryDNSServer        *string   `json:"primaryDnsServer,omitempty"`
	PrimaryIpv6DNSServer    *string   `json:"primaryIpv6DnsServer,omitempty"`
	SecondaryDNSServers     *[]string `json:"secondaryDnsServers,omitempty"`
	SecondaryIpv6DNSServers *[]string `json:"secondaryIpv6DnsServers,omitempty"`
}

// EncryptionSettings is the encryption settings.
type EncryptionSettings struct {
	autorest.Response             `json:"-"`
	ID                            *string `json:"id,omitempty"`
	Name                          *string `json:"name,omitempty"`
	Type                          *string `json:"type,omitempty"`
	Kind                          Kind    `json:"kind,omitempty"`
	*EncryptionSettingsProperties `json:"properties,omitempty"`
}

// EncryptionSettingsProperties is the properties of encryption settings.
type EncryptionSettingsProperties struct {
	EncryptionStatus  EncryptionStatus  `json:"encryptionStatus,omitempty"`
	KeyRolloverStatus KeyRolloverStatus `json:"keyRolloverStatus,omitempty"`
}

// FailoverRequest is the request object for triggering a failover of volume
// containers, from a source device to a target device.
type FailoverRequest struct {
	TargetDeviceID   *string   `json:"targetDeviceId,omitempty"`
	VolumeContainers *[]string `json:"volumeContainers,omitempty"`
}

// FailoverSet is the failover set on a device.
type FailoverSet struct {
	VolumeContainers  *[]VolumeContainerFailoverMetadata `json:"volumeContainers,omitempty"`
	EligibilityResult *FailoverSetEligibilityResult      `json:"eligibilityResult,omitempty"`
}

// FailoverSetEligibilityResult is the eligibility result of failover set, for
// failover.
type FailoverSetEligibilityResult struct {
	IsEligibleForFailover *bool   `json:"isEligibleForFailover,omitempty"`
	ErrorMessage          *string `json:"errorMessage,omitempty"`
}

// FailoverSetsList is the list of failover sets.
type FailoverSetsList struct {
	autorest.Response `json:"-"`
	Value             *[]FailoverSet `json:"value,omitempty"`
}

// FailoverTarget is represents the eligibility of a device as a failover
// target device.
type FailoverTarget struct {
	DeviceID                      *string                  `json:"deviceId,omitempty"`
	DeviceStatus                  DeviceStatus             `json:"deviceStatus,omitempty"`
	ModelDescription              *string                  `json:"modelDescription,omitempty"`
	DeviceSoftwareVersion         *string                  `json:"deviceSoftwareVersion,omitempty"`
	DataContainersCount           *int32                   `json:"dataContainersCount,omitempty"`
	VolumesCount                  *int32                   `json:"volumesCount,omitempty"`
	AvailableLocalStorageInBytes  *int64                   `json:"availableLocalStorageInBytes,omitempty"`
	AvailableTieredStorageInBytes *int64                   `json:"availableTieredStorageInBytes,omitempty"`
	DeviceLocation                *string                  `json:"deviceLocation,omitempty"`
	FriendlyDeviceSoftwareVersion *string                  `json:"friendlyDeviceSoftwareVersion,omitempty"`
	EligibilityResult             *TargetEligibilityResult `json:"eligibilityResult,omitempty"`
}

// FailoverTargetsList is the list of all devices in a resource and their
// eligibility status as a failover target device.
type FailoverTargetsList struct {
	autorest.Response `json:"-"`
	Value             *[]FailoverTarget `json:"value,omitempty"`
}

// Feature is the feature.
type Feature struct {
	Name   *string              `json:"name,omitempty"`
	Status FeatureSupportStatus `json:"status,omitempty"`
}

// FeatureFilter is the OData filter to be used for features.
type FeatureFilter struct {
	DeviceID *string `json:"deviceId,omitempty"`
}

// FeatureList is the collections of features.
type FeatureList struct {
	autorest.Response `json:"-"`
	Value             *[]Feature `json:"value,omitempty"`
}

// HardwareComponent is the hardware component.
type HardwareComponent struct {
	ComponentID       *string                 `json:"componentId,omitempty"`
	DisplayName       *string                 `json:"displayName,omitempty"`
	Status            HardwareComponentStatus `json:"status,omitempty"`
	StatusDisplayName *string                 `json:"statusDisplayName,omitempty"`
}

// HardwareComponentGroup is the hardware component group.
type HardwareComponentGroup struct {
	ID                                *string `json:"id,omitempty"`
	Name                              *string `json:"name,omitempty"`
	Type                              *string `json:"type,omitempty"`
	Kind                              Kind    `json:"kind,omitempty"`
	*HardwareComponentGroupProperties `json:"properties,omitempty"`
}

// HardwareComponentGroupList is the collection of hardware component groups.
type HardwareComponentGroupList struct {
	autorest.Response `json:"-"`
	Value             *[]HardwareComponentGroup `json:"value,omitempty"`
}

// HardwareComponentGroupProperties is the properties of hardware component
// group.
type HardwareComponentGroupProperties struct {
	DisplayName     *string              `json:"displayName,omitempty"`
	LastUpdatedTime *date.Time           `json:"lastUpdatedTime,omitempty"`
	Components      *[]HardwareComponent `json:"components,omitempty"`
}

// Job is the job.
type Job struct {
	autorest.Response `json:"-"`
	ID                *string          `json:"id,omitempty"`
	Name              *string          `json:"name,omitempty"`
	Type              *string          `json:"type,omitempty"`
	Kind              Kind             `json:"kind,omitempty"`
	Status            JobStatus        `json:"status,omitempty"`
	StartTime         *date.Time       `json:"startTime,omitempty"`
	EndTime           *date.Time       `json:"endTime,omitempty"`
	PercentComplete   *int32           `json:"percentComplete,omitempty"`
	Error             *JobErrorDetails `json:"error,omitempty"`
	*JobProperties    `json:"properties,omitempty"`
}

// JobErrorDetails is the job error details. Contains list of job error items.
type JobErrorDetails struct {
	ErrorDetails *[]JobErrorItem `json:"errorDetails,omitempty"`
	Code         *string         `json:"code,omitempty"`
	Message      *string         `json:"message,omitempty"`
}

// JobErrorItem is the job error items.
type JobErrorItem struct {
	Recommendations *[]string `json:"recommendations,omitempty"`
	Code            *string   `json:"code,omitempty"`
	Message         *string   `json:"message,omitempty"`
}

// JobFilter is the OData filter to be used for jobs.
type JobFilter struct {
	Status    *string    `json:"status,omitempty"`
	JobType   *string    `json:"jobType,omitempty"`
	StartTime *date.Time `json:"startTime,omitempty"`
}

// JobList is the collection of jobs.
type JobList struct {
	autorest.Response `json:"-"`
	Value             *[]Job  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// JobListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobList) JobListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobProperties is the properties of the job.
type JobProperties struct {
	JobType           JobType         `json:"jobType,omitempty"`
	DataStats         *DataStatistics `json:"dataStats,omitempty"`
	EntityLabel       *string         `json:"entityLabel,omitempty"`
	EntityType        *string         `json:"entityType,omitempty"`
	JobStages         *[]JobStage     `json:"jobStages,omitempty"`
	DeviceID          *string         `json:"deviceId,omitempty"`
	IsCancellable     *bool           `json:"isCancellable,omitempty"`
	BackupType        BackupType      `json:"backupType,omitempty"`
	SourceDeviceID    *string         `json:"sourceDeviceId,omitempty"`
	BackupPointInTime *date.Time      `json:"backupPointInTime,omitempty"`
}

// JobStage is the details about the specific stage of a job.
type JobStage struct {
	Message     *string   `json:"message,omitempty"`
	StageStatus JobStatus `json:"stageStatus,omitempty"`
	Detail      *string   `json:"detail,omitempty"`
	ErrorCode   *string   `json:"errorCode,omitempty"`
}

// Key is the key.
type Key struct {
	autorest.Response `json:"-"`
	ActivationKey     *string `json:"activationKey,omitempty"`
}

// ListFailoverTargetsRequest is the request object for fetching the list of
// failover targets (eligible devices for failover).
type ListFailoverTargetsRequest struct {
	VolumeContainers *[]string `json:"volumeContainers,omitempty"`
}

// Manager is the StorSimple Manager.
type Manager struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	*ManagerProperties `json:"properties,omitempty"`
	Etag               *string `json:"etag,omitempty"`
}

// ManagerExtendedInfo is the extended info of the manager.
type ManagerExtendedInfo struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	Kind                           Kind    `json:"kind,omitempty"`
	*ManagerExtendedInfoProperties `json:"properties,omitempty"`
	Etag                           *string `json:"etag,omitempty"`
}

// ManagerExtendedInfoProperties is the properties of the manager extended
// info.
type ManagerExtendedInfoProperties struct {
	Version                     *string `json:"version,omitempty"`
	IntegrityKey                *string `json:"integrityKey,omitempty"`
	EncryptionKey               *string `json:"encryptionKey,omitempty"`
	EncryptionKeyThumbprint     *string `json:"encryptionKeyThumbprint,omitempty"`
	PortalCertificateThumbprint *string `json:"portalCertificateThumbprint,omitempty"`
	Algorithm                   *string `json:"algorithm,omitempty"`
}

// ManagerIntrinsicSettings is intrinsic settings which refers to the type of
// the Storsimple Manager.
type ManagerIntrinsicSettings struct {
	Type ManagerType `json:"type,omitempty"`
}

// ManagerList is the list of StorSimple Managers.
type ManagerList struct {
	autorest.Response `json:"-"`
	Value             *[]Manager `json:"value,omitempty"`
}

// ManagerPatch is the StorSimple Manager patch.
type ManagerPatch struct {
	Tags *map[string]*string `json:"tags,omitempty"`
}

// ManagerProperties is the properties of the StorSimple Manager.
type ManagerProperties struct {
	CisIntrinsicSettings *ManagerIntrinsicSettings `json:"cisIntrinsicSettings,omitempty"`
	Sku                  *ManagerSku               `json:"sku,omitempty"`
	ProvisioningState    *string                   `json:"provisioningState,omitempty"`
}

// ManagerSku is the Sku.
type ManagerSku struct {
	Name *string `json:"name,omitempty"`
}

// MetricAvailablity is the metric availability.
type MetricAvailablity struct {
	TimeGrain *string `json:"timeGrain,omitempty"`
	Retention *string `json:"retention,omitempty"`
}

// MetricData is the metric data.
type MetricData struct {
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	Sum       *float64   `json:"sum,omitempty"`
	Count     *int32     `json:"count,omitempty"`
	Average   *float64   `json:"average,omitempty"`
	Minimum   *float64   `json:"minimum,omitempty"`
	Maximum   *float64   `json:"maximum,omitempty"`
}

// MetricDefinition is the monitoring metric definition.
type MetricDefinition struct {
	Name                   *MetricName           `json:"name,omitempty"`
	Unit                   MetricUnit            `json:"unit,omitempty"`
	PrimaryAggregationType MetricAggregationType `json:"primaryAggregationType,omitempty"`
	ResourceID             *string               `json:"resourceId,omitempty"`
	MetricAvailabilities   *[]MetricAvailablity  `json:"metricAvailabilities,omitempty"`
	Dimensions             *[]MetricDimension    `json:"dimensions,omitempty"`
	Category               *string               `json:"category,omitempty"`
	Type                   *string               `json:"type,omitempty"`
}

// MetricDefinitionList is the list of metric definitions.
type MetricDefinitionList struct {
	autorest.Response `json:"-"`
	Value             *[]MetricDefinition `json:"value,omitempty"`
}

// MetricDimension is the metric dimension. It indicates the source of the
// metric.
type MetricDimension struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// MetricFilter is the OData filters to be used for metrics.
type MetricFilter struct {
	Name       *MetricNameFilter `json:"name,omitempty"`
	StartTime  *date.Time        `json:"startTime,omitempty"`
	EndTime    *date.Time        `json:"endTime,omitempty"`
	TimeGrain  *string           `json:"timeGrain,omitempty"`
	Category   *string           `json:"category,omitempty"`
	Dimensions *DimensionFilter  `json:"dimensions,omitempty"`
}

// MetricList is the metric list.
type MetricList struct {
	autorest.Response `json:"-"`
	Value             *[]Metrics `json:"value,omitempty"`
}

// MetricName is the metric name.
type MetricName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricNameFilter is the metric name filter, specifying the name of the
// metric to be filtered on.
type MetricNameFilter struct {
	Value *string `json:"value,omitempty"`
}

// Metrics is the monitoring metric.
type Metrics struct {
	ResourceID         *string               `json:"resourceId,omitempty"`
	StartTime          *date.Time            `json:"startTime,omitempty"`
	EndTime            *date.Time            `json:"endTime,omitempty"`
	TimeGrain          *string               `json:"timeGrain,omitempty"`
	PrimaryAggregation MetricAggregationType `json:"primaryAggregation,omitempty"`
	Name               *MetricName           `json:"name,omitempty"`
	Dimensions         *[]MetricDimension    `json:"dimensions,omitempty"`
	Unit               MetricUnit            `json:"unit,omitempty"`
	Type               *string               `json:"type,omitempty"`
	Values             *[]MetricData         `json:"values,omitempty"`
}

// NetworkAdapterList is the collection of network adapters on the device.
type NetworkAdapterList struct {
	Value *[]NetworkAdapters `json:"value,omitempty"`
}

// NetworkAdapters is represents the network adapter on device.
type NetworkAdapters struct {
	InterfaceID         NetInterfaceID      `json:"interfaceId,omitempty"`
	NetInterfaceStatus  NetInterfaceStatus  `json:"netInterfaceStatus,omitempty"`
	IsDefault           *bool               `json:"isDefault,omitempty"`
	IscsiAndCloudStatus ISCSIAndCloudStatus `json:"iscsiAndCloudStatus,omitempty"`
	Speed               *int64              `json:"speed,omitempty"`
	Mode                NetworkMode         `json:"mode,omitempty"`
	NicIpv4Settings     *NicIPv4            `json:"nicIpv4Settings,omitempty"`
	NicIpv6Settings     *NicIPv6            `json:"nicIpv6Settings,omitempty"`
}

// NetworkInterfaceData0Settings is the 'Data 0' network interface card
// settings.
type NetworkInterfaceData0Settings struct {
	ControllerZeroIP *string `json:"controllerZeroIp,omitempty"`
	ControllerOneIP  *string `json:"controllerOneIp,omitempty"`
}

// NetworkSettings is represents the network settings of a device.
type NetworkSettings struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	Kind                       Kind    `json:"kind,omitempty"`
	*NetworkSettingsProperties `json:"properties,omitempty"`
}

// NetworkSettingsPatch is represents the patch request for the network
// settings of a device.
type NetworkSettingsPatch struct {
	*NetworkSettingsPatchProperties `json:"properties,omitempty"`
}

// NetworkSettingsPatchProperties is the properties of the network settings
// patch.
type NetworkSettingsPatchProperties struct {
	DNSSettings     *DNSSettings        `json:"dnsSettings,omitempty"`
	NetworkAdapters *NetworkAdapterList `json:"networkAdapters,omitempty"`
}

// NetworkSettingsProperties is the properties of the network settings of
// device.
type NetworkSettingsProperties struct {
	DNSSettings      *DNSSettings        `json:"dnsSettings,omitempty"`
	NetworkAdapters  *NetworkAdapterList `json:"networkAdapters,omitempty"`
	WebproxySettings *WebproxySettings   `json:"webproxySettings,omitempty"`
}

// NicIPv4 is details related to the IPv4 address configuration.
type NicIPv4 struct {
	Ipv4Address            *string `json:"ipv4Address,omitempty"`
	Ipv4Netmask            *string `json:"ipv4Netmask,omitempty"`
	Ipv4Gateway            *string `json:"ipv4Gateway,omitempty"`
	Controller0Ipv4Address *string `json:"controller0Ipv4Address,omitempty"`
	Controller1Ipv4Address *string `json:"controller1Ipv4Address,omitempty"`
}

// NicIPv6 is details related to the IPv6 address configuration.
type NicIPv6 struct {
	Ipv6Address            *string `json:"ipv6Address,omitempty"`
	Ipv6Prefix             *string `json:"ipv6Prefix,omitempty"`
	Ipv6Gateway            *string `json:"ipv6Gateway,omitempty"`
	Controller0Ipv6Address *string `json:"controller0Ipv6Address,omitempty"`
	Controller1Ipv6Address *string `json:"controller1Ipv6Address,omitempty"`
}

// PublicKey is the public key.
type PublicKey struct {
	autorest.Response `json:"-"`
	Key               *string `json:"key,omitempty"`
}

// RemoteManagementSettings is the settings for remote management of a device.
type RemoteManagementSettings struct {
	RemoteManagementMode        RemoteManagementModeConfiguration `json:"remoteManagementMode,omitempty"`
	RemoteManagementCertificate *string                           `json:"remoteManagementCertificate,omitempty"`
}

// RemoteManagementSettingsPatch is the settings for updating remote management
// mode of the device.
type RemoteManagementSettingsPatch struct {
	RemoteManagementMode RemoteManagementModeConfiguration `json:"remoteManagementMode,omitempty"`
}

// Resource is the Azure Resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ScheduleRecurrence is the schedule recurrence.
type ScheduleRecurrence struct {
	RecurrenceType  RecurrenceType `json:"recurrenceType,omitempty"`
	RecurrenceValue *int32         `json:"recurrenceValue,omitempty"`
	WeeklyDaysList  *[]DayOfWeek   `json:"weeklyDaysList,omitempty"`
}

// SecondaryDNSSettings is the secondary DNS settings.
type SecondaryDNSSettings struct {
	SecondaryDNSServers *[]string `json:"secondaryDnsServers,omitempty"`
}

// SecuritySettings is the security settings of a device.
type SecuritySettings struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Type                        *string `json:"type,omitempty"`
	Kind                        Kind    `json:"kind,omitempty"`
	*SecuritySettingsProperties `json:"properties,omitempty"`
}

// SecuritySettingsPatch is represents the patch request for the security
// settings of a device.
type SecuritySettingsPatch struct {
	*SecuritySettingsPatchProperties `json:"properties,omitempty"`
}

// SecuritySettingsPatchProperties is the properties of the security settings
// patch.
type SecuritySettingsPatchProperties struct {
	RemoteManagementSettings *RemoteManagementSettingsPatch `json:"remoteManagementSettings,omitempty"`
	DeviceAdminPassword      *AsymmetricEncryptedSecret     `json:"deviceAdminPassword,omitempty"`
	SnapshotPassword         *AsymmetricEncryptedSecret     `json:"snapshotPassword,omitempty"`
	ChapSettings             *ChapSettings                  `json:"chapSettings,omitempty"`
	CloudApplianceSettings   *CloudApplianceSettings        `json:"cloudApplianceSettings,omitempty"`
}

// SecuritySettingsProperties is the properties of security settings of a
// device.
type SecuritySettingsProperties struct {
	RemoteManagementSettings *RemoteManagementSettings `json:"remoteManagementSettings,omitempty"`
	ChapSettings             *ChapSettings             `json:"chapSettings,omitempty"`
}

// SendTestAlertEmailRequest is the request for sending test alert email
type SendTestAlertEmailRequest struct {
	EmailList *[]string `json:"emailList,omitempty"`
}

// StorageAccountCredential is the storage account credential.
type StorageAccountCredential struct {
	autorest.Response                   `json:"-"`
	ID                                  *string `json:"id,omitempty"`
	Name                                *string `json:"name,omitempty"`
	Type                                *string `json:"type,omitempty"`
	Kind                                Kind    `json:"kind,omitempty"`
	*StorageAccountCredentialProperties `json:"properties,omitempty"`
}

// StorageAccountCredentialList is the collection of storage account credential
// entities.
type StorageAccountCredentialList struct {
	autorest.Response `json:"-"`
	Value             *[]StorageAccountCredential `json:"value,omitempty"`
}

// StorageAccountCredentialProperties is the storage account credential
// properties.
type StorageAccountCredentialProperties struct {
	EndPoint     *string                    `json:"endPoint,omitempty"`
	SslStatus    SslStatus                  `json:"sslStatus,omitempty"`
	AccessKey    *AsymmetricEncryptedSecret `json:"accessKey,omitempty"`
	VolumesCount *int32                     `json:"volumesCount,omitempty"`
}

// SymmetricEncryptedSecret is represents the secrets encrypted using Symmetric
// Encryption Key.
type SymmetricEncryptedSecret struct {
	autorest.Response          `json:"-"`
	Value                      *string             `json:"value,omitempty"`
	ValueCertificateThumbprint *string             `json:"valueCertificateThumbprint,omitempty"`
	EncryptionAlgorithm        EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// TargetEligibilityErrorMessage is the error/warning message due to which the
// device is ineligible as a failover target device.
type TargetEligibilityErrorMessage struct {
	Message    *string                     `json:"message,omitempty"`
	Resolution *string                     `json:"resolution,omitempty"`
	ResultCode TargetEligibilityResultCode `json:"resultCode,omitempty"`
}

// TargetEligibilityResult is the eligibility result of device, as a failover
// target device.
type TargetEligibilityResult struct {
	EligibilityStatus TargetEligibilityStatus          `json:"eligibilityStatus,omitempty"`
	Messages          *[]TargetEligibilityErrorMessage `json:"messages,omitempty"`
}

// Time is the time.
type Time struct {
	Hours   *int32 `json:"hours,omitempty"`
	Minutes *int32 `json:"minutes,omitempty"`
	Seconds *int32 `json:"seconds,omitempty"`
}

// TimeSettings is the time settings of a device.
type TimeSettings struct {
	autorest.Response       `json:"-"`
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Type                    *string `json:"type,omitempty"`
	Kind                    Kind    `json:"kind,omitempty"`
	*TimeSettingsProperties `json:"properties,omitempty"`
}

// TimeSettingsProperties is the properties of time settings of a device.
type TimeSettingsProperties struct {
	TimeZone            *string   `json:"timeZone,omitempty"`
	PrimaryTimeServer   *string   `json:"primaryTimeServer,omitempty"`
	SecondaryTimeServer *[]string `json:"secondaryTimeServer,omitempty"`
}

// Updates is the updates profile of a device.
type Updates struct {
	autorest.Response  `json:"-"`
	ID                 *string `json:"id,omitempty"`
	Name               *string `json:"name,omitempty"`
	Type               *string `json:"type,omitempty"`
	Kind               Kind    `json:"kind,omitempty"`
	*UpdatesProperties `json:"properties,omitempty"`
}

// UpdatesProperties is the properties of the updates profile.
type UpdatesProperties struct {
	RegularUpdatesAvailable         *bool      `json:"regularUpdatesAvailable,omitempty"`
	MaintenanceModeUpdatesAvailable *bool      `json:"maintenanceModeUpdatesAvailable,omitempty"`
	IsUpdateInProgress              *bool      `json:"isUpdateInProgress,omitempty"`
	LastUpdatedTime                 *date.Time `json:"lastUpdatedTime,omitempty"`
}

// VMImage is the virtual machine image.
type VMImage struct {
	Name      *string `json:"name,omitempty"`
	Version   *string `json:"version,omitempty"`
	Offer     *string `json:"offer,omitempty"`
	Publisher *string `json:"publisher,omitempty"`
	Sku       *string `json:"sku,omitempty"`
}

// Volume is the volume.
type Volume struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	Kind              Kind    `json:"kind,omitempty"`
	*VolumeProperties `json:"properties,omitempty"`
}

// VolumeContainer is the volume container.
type VolumeContainer struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	Kind                       Kind    `json:"kind,omitempty"`
	*VolumeContainerProperties `json:"properties,omitempty"`
}

// VolumeContainerFailoverMetadata is the metadata of the volume container,
// that is being considered as part of a failover set.
type VolumeContainerFailoverMetadata struct {
	VolumeContainerID *string                   `json:"volumeContainerId,omitempty"`
	Volumes           *[]VolumeFailoverMetadata `json:"volumes,omitempty"`
}

// VolumeContainerList is the collection of volume container entities.
type VolumeContainerList struct {
	autorest.Response `json:"-"`
	Value             *[]VolumeContainer `json:"value,omitempty"`
}

// VolumeContainerProperties is the properties of volume container.
type VolumeContainerProperties struct {
	EncryptionKey                 *AsymmetricEncryptedSecret `json:"encryptionKey,omitempty"`
	EncryptionStatus              EncryptionStatus           `json:"encryptionStatus,omitempty"`
	VolumeCount                   *int32                     `json:"volumeCount,omitempty"`
	StorageAccountCredentialID    *string                    `json:"storageAccountCredentialId,omitempty"`
	OwnerShipStatus               OwnerShipStatus            `json:"ownerShipStatus,omitempty"`
	BandWidthRateInMbps           *int32                     `json:"bandWidthRateInMbps,omitempty"`
	BandwidthSettingID            *string                    `json:"bandwidthSettingId,omitempty"`
	TotalCloudStorageUsageInBytes *int64                     `json:"totalCloudStorageUsageInBytes,omitempty"`
}

// VolumeFailoverMetadata is the metadata of a volume that has valid cloud
// snapshot.
type VolumeFailoverMetadata struct {
	VolumeID          *string    `json:"volumeId,omitempty"`
	VolumeType        VolumeType `json:"volumeType,omitempty"`
	SizeInBytes       *int64     `json:"sizeInBytes,omitempty"`
	BackupCreatedDate *date.Time `json:"backupCreatedDate,omitempty"`
	BackupElementID   *string    `json:"backupElementId,omitempty"`
	BackupID          *string    `json:"backupId,omitempty"`
	BackupPolicyID    *string    `json:"backupPolicyId,omitempty"`
}

// VolumeList is the collection of volumes.
type VolumeList struct {
	autorest.Response `json:"-"`
	Value             *[]Volume `json:"value,omitempty"`
}

// VolumeProperties is the properties of volume.
type VolumeProperties struct {
	SizeInBytes            *int64           `json:"sizeInBytes,omitempty"`
	VolumeType             VolumeType       `json:"volumeType,omitempty"`
	VolumeContainerID      *string          `json:"volumeContainerId,omitempty"`
	AccessControlRecordIds *[]string        `json:"accessControlRecordIds,omitempty"`
	VolumeStatus           VolumeStatus     `json:"volumeStatus,omitempty"`
	OperationStatus        OperationStatus  `json:"operationStatus,omitempty"`
	BackupStatus           BackupStatus     `json:"backupStatus,omitempty"`
	MonitoringStatus       MonitoringStatus `json:"monitoringStatus,omitempty"`
	BackupPolicyIds        *[]string        `json:"backupPolicyIds,omitempty"`
}

// WebproxySettings is the web proxy settings on the device.
type WebproxySettings struct {
	ConnectionURI  *string            `json:"connectionUri,omitempty"`
	Authentication AuthenticationType `json:"authentication,omitempty"`
	Username       *string            `json:"username,omitempty"`
}
