package iothub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// ResourceClient is the use this API to manage the IoT hubs in your
// subscription.
type ResourceClient struct {
	ManagementClient
}

// NewResourceClient creates an instance of the ResourceClient client.
func NewResourceClient(subscriptionID string) ResourceClient {
	return NewResourceClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewResourceClientWithBaseURI creates an instance of the ResourceClient
// client.
func NewResourceClientWithBaseURI(baseURI string, subscriptionID string) ResourceClient {
	return ResourceClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckNameAvailability check if an IoT hub name is available.
//
// operationInputs is set the name parameter in the OperationInputs structure
// to the name of the IoT hub to check.
func (client ResourceClient) CheckNameAvailability(operationInputs OperationInputs) (result NameAvailabilityInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: operationInputs,
			Constraints: []validation.Constraint{{Target: "operationInputs.Name", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "iothub.ResourceClient", "CheckNameAvailability")
	}

	req, err := client.CheckNameAvailabilityPreparer(operationInputs)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CheckNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CheckNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CheckNameAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client ResourceClient) CheckNameAvailabilityPreparer(operationInputs OperationInputs) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability", pathParameters),
		autorest.WithJSON(operationInputs),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client ResourceClient) CheckNameAvailabilityResponder(resp *http.Response) (result NameAvailabilityInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateEventHubConsumerGroup add a consumer group to an Event Hub-compatible
// endpoint in an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. eventHubEndpointName is the
// name of the Event Hub-compatible endpoint in the IoT hub. name is the name
// of the consumer group to add.
func (client ResourceClient) CreateEventHubConsumerGroup(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result EventHubConsumerGroupInfo, err error) {
	req, err := client.CreateEventHubConsumerGroupPreparer(resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CreateEventHubConsumerGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CreateEventHubConsumerGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CreateEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CreateEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// CreateEventHubConsumerGroupPreparer prepares the CreateEventHubConsumerGroup request.
func (client ResourceClient) CreateEventHubConsumerGroupPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateEventHubConsumerGroupSender sends the CreateEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) CreateEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateEventHubConsumerGroupResponder handles the response to the CreateEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client ResourceClient) CreateEventHubConsumerGroupResponder(resp *http.Response) (result EventHubConsumerGroupInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate create or update the metadata of an Iot hub. The usual
// pattern to modify a property is to retrieve the IoT hub metadata and
// security metadata, and then combine them with the modified values in a new
// body to update the IoT hub. This method may poll for completion. Polling can
// be canceled by passing the cancel channel argument. The channel will be used
// to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub to create or update.
// iotHubDescription is the IoT hub metadata and security metadata.
func (client ResourceClient) CreateOrUpdate(resourceGroupName string, resourceName string, iotHubDescription Description, cancel <-chan struct{}) (<-chan Description, <-chan error) {
	resultChan := make(chan Description, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: iotHubDescription,
			Constraints: []validation.Constraint{{Target: "iotHubDescription.Subscriptionid", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "iotHubDescription.Resourcegroup", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "iotHubDescription.Properties", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.MaxDeliveryCount", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.MaxDeliveryCount", Name: validation.InclusiveMaximum, Rule: 100, Chain: nil},
								{Target: "iotHubDescription.Properties.CloudToDevice.MaxDeliveryCount", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
							}},
							{Target: "iotHubDescription.Properties.CloudToDevice.Feedback", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.Feedback.MaxDeliveryCount", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.Feedback.MaxDeliveryCount", Name: validation.InclusiveMaximum, Rule: 100, Chain: nil},
										{Target: "iotHubDescription.Properties.CloudToDevice.Feedback.MaxDeliveryCount", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
									}},
								}},
						}},
					}},
				{Target: "iotHubDescription.Sku", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "iotHubDescription.Sku.Capacity", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "iothub.ResourceClient", "CreateOrUpdate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result Description
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, resourceName, iotHubDescription, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ResourceClient) CreateOrUpdatePreparer(resourceGroupName string, resourceName string, iotHubDescription Description, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithJSON(iotHubDescription),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ResourceClient) CreateOrUpdateResponder(resp *http.Response) (result Description, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusCreated, http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an IoT hub. This method may poll for completion. Polling can
// be canceled by passing the cancel channel argument. The channel will be used
// to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub to delete.
func (client ResourceClient) Delete(resourceGroupName string, resourceName string, cancel <-chan struct{}) (<-chan SetObject, <-chan error) {
	resultChan := make(chan SetObject, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result SetObject
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.DeletePreparer(resourceGroupName, resourceName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "Delete", nil, "Failure preparing request")
			return
		}

		resp, err := client.DeleteSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "Delete", resp, "Failure sending request")
			return
		}

		result, err = client.DeleteResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "Delete", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// DeletePreparer prepares the Delete request.
func (client ResourceClient) DeletePreparer(resourceGroupName string, resourceName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ResourceClient) DeleteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusAccepted, http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEventHubConsumerGroup delete a consumer group from an Event
// Hub-compatible endpoint in an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. eventHubEndpointName is the
// name of the Event Hub-compatible endpoint in the IoT hub. name is the name
// of the consumer group to delete.
func (client ResourceClient) DeleteEventHubConsumerGroup(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result autorest.Response, err error) {
	req, err := client.DeleteEventHubConsumerGroupPreparer(resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "DeleteEventHubConsumerGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "DeleteEventHubConsumerGroup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "DeleteEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// DeleteEventHubConsumerGroupPreparer prepares the DeleteEventHubConsumerGroup request.
func (client ResourceClient) DeleteEventHubConsumerGroupPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteEventHubConsumerGroupSender sends the DeleteEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) DeleteEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteEventHubConsumerGroupResponder handles the response to the DeleteEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client ResourceClient) DeleteEventHubConsumerGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExportDevices exports all the device identities in the IoT hub identity
// registry to an Azure Storage blob container. For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. exportDevicesParameters is the
// parameters that specify the export devices operation.
func (client ResourceClient) ExportDevices(resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest) (result JobResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: exportDevicesParameters,
			Constraints: []validation.Constraint{{Target: "exportDevicesParameters.ExportBlobContainerURI", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "exportDevicesParameters.ExcludeKeys", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "iothub.ResourceClient", "ExportDevices")
	}

	req, err := client.ExportDevicesPreparer(resourceGroupName, resourceName, exportDevicesParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ExportDevices", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExportDevicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ExportDevices", resp, "Failure sending request")
		return
	}

	result, err = client.ExportDevicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ExportDevices", resp, "Failure responding to request")
	}

	return
}

// ExportDevicesPreparer prepares the ExportDevices request.
func (client ResourceClient) ExportDevicesPreparer(resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices", pathParameters),
		autorest.WithJSON(exportDevicesParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ExportDevicesSender sends the ExportDevices request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) ExportDevicesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ExportDevicesResponder handles the response to the ExportDevices request. The method always
// closes the http.Response Body.
func (client ResourceClient) ExportDevicesResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get the non-security related metadata of an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub.
func (client ResourceClient) Get(resourceGroupName string, resourceName string) (result Description, err error) {
	req, err := client.GetPreparer(resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ResourceClient) GetPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ResourceClient) GetResponder(resp *http.Response) (result Description, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEventHubConsumerGroup get a consumer group from the Event Hub-compatible
// device-to-cloud endpoint for an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. eventHubEndpointName is the
// name of the Event Hub-compatible endpoint in the IoT hub. name is the name
// of the consumer group to retrieve.
func (client ResourceClient) GetEventHubConsumerGroup(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result EventHubConsumerGroupInfo, err error) {
	req, err := client.GetEventHubConsumerGroupPreparer(resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetEventHubConsumerGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetEventHubConsumerGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// GetEventHubConsumerGroupPreparer prepares the GetEventHubConsumerGroup request.
func (client ResourceClient) GetEventHubConsumerGroupPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetEventHubConsumerGroupSender sends the GetEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) GetEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetEventHubConsumerGroupResponder handles the response to the GetEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client ResourceClient) GetEventHubConsumerGroupResponder(resp *http.Response) (result EventHubConsumerGroupInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetJob get the details of a job from an IoT hub. For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. jobID is the job identifier.
func (client ResourceClient) GetJob(resourceGroupName string, resourceName string, jobID string) (result JobResponse, err error) {
	req, err := client.GetJobPreparer(resourceGroupName, resourceName, jobID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetJob", resp, "Failure responding to request")
	}

	return
}

// GetJobPreparer prepares the GetJob request.
func (client ResourceClient) GetJobPreparer(resourceGroupName string, resourceName string, jobID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"jobId":             autorest.Encode("path", jobID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetJobSender sends the GetJob request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) GetJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetJobResponder handles the response to the GetJob request. The method always
// closes the http.Response Body.
func (client ResourceClient) GetJobResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetKeysForKeyName get a shared access policy by name from an IoT hub. For
// more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. keyName is the name of the
// shared access policy.
func (client ResourceClient) GetKeysForKeyName(resourceGroupName string, resourceName string, keyName string) (result SharedAccessSignatureAuthorizationRule, err error) {
	req, err := client.GetKeysForKeyNamePreparer(resourceGroupName, resourceName, keyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetKeysForKeyName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetKeysForKeyNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetKeysForKeyName", resp, "Failure sending request")
		return
	}

	result, err = client.GetKeysForKeyNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetKeysForKeyName", resp, "Failure responding to request")
	}

	return
}

// GetKeysForKeyNamePreparer prepares the GetKeysForKeyName request.
func (client ResourceClient) GetKeysForKeyNamePreparer(resourceGroupName string, resourceName string, keyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":           autorest.Encode("path", keyName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetKeysForKeyNameSender sends the GetKeysForKeyName request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) GetKeysForKeyNameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetKeysForKeyNameResponder handles the response to the GetKeysForKeyName request. The method always
// closes the http.Response Body.
func (client ResourceClient) GetKeysForKeyNameResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetQuotaMetrics get the quota metrics for an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub.
func (client ResourceClient) GetQuotaMetrics(resourceGroupName string, resourceName string) (result QuotaMetricInfoListResult, err error) {
	req, err := client.GetQuotaMetricsPreparer(resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetQuotaMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetQuotaMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetQuotaMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetQuotaMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetQuotaMetrics", resp, "Failure responding to request")
	}

	return
}

// GetQuotaMetricsPreparer prepares the GetQuotaMetrics request.
func (client ResourceClient) GetQuotaMetricsPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetQuotaMetricsSender sends the GetQuotaMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) GetQuotaMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetQuotaMetricsResponder handles the response to the GetQuotaMetrics request. The method always
// closes the http.Response Body.
func (client ResourceClient) GetQuotaMetricsResponder(resp *http.Response) (result QuotaMetricInfoListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetQuotaMetricsNextResults retrieves the next set of results, if any.
func (client ResourceClient) GetQuotaMetricsNextResults(lastResults QuotaMetricInfoListResult) (result QuotaMetricInfoListResult, err error) {
	req, err := lastResults.QuotaMetricInfoListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetQuotaMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetQuotaMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetQuotaMetrics", resp, "Failure sending next results request")
	}

	result, err = client.GetQuotaMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetQuotaMetrics", resp, "Failure responding to next results request")
	}

	return
}

// GetStats get the statistics from an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub.
func (client ResourceClient) GetStats(resourceGroupName string, resourceName string) (result RegistryStatistics, err error) {
	req, err := client.GetStatsPreparer(resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetStats", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStatsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetStats", resp, "Failure sending request")
		return
	}

	result, err = client.GetStatsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetStats", resp, "Failure responding to request")
	}

	return
}

// GetStatsPreparer prepares the GetStats request.
func (client ResourceClient) GetStatsPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetStatsSender sends the GetStats request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) GetStatsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetStatsResponder handles the response to the GetStats request. The method always
// closes the http.Response Body.
func (client ResourceClient) GetStatsResponder(resp *http.Response) (result RegistryStatistics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetValidSkus get the list of valid SKUs for an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub.
func (client ResourceClient) GetValidSkus(resourceGroupName string, resourceName string) (result SkuDescriptionListResult, err error) {
	req, err := client.GetValidSkusPreparer(resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetValidSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetValidSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetValidSkus", resp, "Failure sending request")
		return
	}

	result, err = client.GetValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetValidSkus", resp, "Failure responding to request")
	}

	return
}

// GetValidSkusPreparer prepares the GetValidSkus request.
func (client ResourceClient) GetValidSkusPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetValidSkusSender sends the GetValidSkus request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) GetValidSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetValidSkusResponder handles the response to the GetValidSkus request. The method always
// closes the http.Response Body.
func (client ResourceClient) GetValidSkusResponder(resp *http.Response) (result SkuDescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetValidSkusNextResults retrieves the next set of results, if any.
func (client ResourceClient) GetValidSkusNextResults(lastResults SkuDescriptionListResult) (result SkuDescriptionListResult, err error) {
	req, err := lastResults.SkuDescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetValidSkus", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetValidSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetValidSkus", resp, "Failure sending next results request")
	}

	result, err = client.GetValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "GetValidSkus", resp, "Failure responding to next results request")
	}

	return
}

// ImportDevices import, update, or delete device identities in the IoT hub
// identity registry from a blob. For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. importDevicesParameters is the
// parameters that specify the import devices operation.
func (client ResourceClient) ImportDevices(resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest) (result JobResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: importDevicesParameters,
			Constraints: []validation.Constraint{{Target: "importDevicesParameters.InputBlobContainerURI", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "importDevicesParameters.OutputBlobContainerURI", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "iothub.ResourceClient", "ImportDevices")
	}

	req, err := client.ImportDevicesPreparer(resourceGroupName, resourceName, importDevicesParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ImportDevices", nil, "Failure preparing request")
		return
	}

	resp, err := client.ImportDevicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ImportDevices", resp, "Failure sending request")
		return
	}

	result, err = client.ImportDevicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ImportDevices", resp, "Failure responding to request")
	}

	return
}

// ImportDevicesPreparer prepares the ImportDevices request.
func (client ResourceClient) ImportDevicesPreparer(resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices", pathParameters),
		autorest.WithJSON(importDevicesParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ImportDevicesSender sends the ImportDevices request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) ImportDevicesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ImportDevicesResponder handles the response to the ImportDevices request. The method always
// closes the http.Response Body.
func (client ResourceClient) ImportDevicesResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup get all the IoT hubs in a resource group.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hubs.
func (client ResourceClient) ListByResourceGroup(resourceGroupName string) (result DescriptionListResult, err error) {
	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client ResourceClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client ResourceClient) ListByResourceGroupResponder(resp *http.Response) (result DescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client ResourceClient) ListByResourceGroupNextResults(lastResults DescriptionListResult) (result DescriptionListResult, err error) {
	req, err := lastResults.DescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListByResourceGroup", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListByResourceGroup", resp, "Failure sending next results request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListByResourceGroup", resp, "Failure responding to next results request")
	}

	return
}

// ListBySubscription get all the IoT hubs in a subscription.
func (client ResourceClient) ListBySubscription() (result DescriptionListResult, err error) {
	req, err := client.ListBySubscriptionPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListBySubscription", resp, "Failure sending request")
		return
	}

	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListBySubscription", resp, "Failure responding to request")
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client ResourceClient) ListBySubscriptionPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client ResourceClient) ListBySubscriptionResponder(resp *http.Response) (result DescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySubscriptionNextResults retrieves the next set of results, if any.
func (client ResourceClient) ListBySubscriptionNextResults(lastResults DescriptionListResult) (result DescriptionListResult, err error) {
	req, err := lastResults.DescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListBySubscription", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListBySubscription", resp, "Failure sending next results request")
	}

	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListBySubscription", resp, "Failure responding to next results request")
	}

	return
}

// ListEventHubConsumerGroups get a list of the consumer groups in the Event
// Hub-compatible device-to-cloud endpoint in an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub. eventHubEndpointName is the
// name of the Event Hub-compatible endpoint.
func (client ResourceClient) ListEventHubConsumerGroups(resourceGroupName string, resourceName string, eventHubEndpointName string) (result EventHubConsumerGroupsListResult, err error) {
	req, err := client.ListEventHubConsumerGroupsPreparer(resourceGroupName, resourceName, eventHubEndpointName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListEventHubConsumerGroups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEventHubConsumerGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListEventHubConsumerGroups", resp, "Failure sending request")
		return
	}

	result, err = client.ListEventHubConsumerGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListEventHubConsumerGroups", resp, "Failure responding to request")
	}

	return
}

// ListEventHubConsumerGroupsPreparer prepares the ListEventHubConsumerGroups request.
func (client ResourceClient) ListEventHubConsumerGroupsPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListEventHubConsumerGroupsSender sends the ListEventHubConsumerGroups request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) ListEventHubConsumerGroupsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListEventHubConsumerGroupsResponder handles the response to the ListEventHubConsumerGroups request. The method always
// closes the http.Response Body.
func (client ResourceClient) ListEventHubConsumerGroupsResponder(resp *http.Response) (result EventHubConsumerGroupsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEventHubConsumerGroupsNextResults retrieves the next set of results, if any.
func (client ResourceClient) ListEventHubConsumerGroupsNextResults(lastResults EventHubConsumerGroupsListResult) (result EventHubConsumerGroupsListResult, err error) {
	req, err := lastResults.EventHubConsumerGroupsListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListEventHubConsumerGroups", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListEventHubConsumerGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListEventHubConsumerGroups", resp, "Failure sending next results request")
	}

	result, err = client.ListEventHubConsumerGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListEventHubConsumerGroups", resp, "Failure responding to next results request")
	}

	return
}

// ListJobs get a list of all the jobs in an IoT hub. For more information,
// see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub.
func (client ResourceClient) ListJobs(resourceGroupName string, resourceName string) (result JobResponseListResult, err error) {
	req, err := client.ListJobsPreparer(resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListJobs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListJobs", resp, "Failure sending request")
		return
	}

	result, err = client.ListJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListJobs", resp, "Failure responding to request")
	}

	return
}

// ListJobsPreparer prepares the ListJobs request.
func (client ResourceClient) ListJobsPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListJobsSender sends the ListJobs request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) ListJobsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListJobsResponder handles the response to the ListJobs request. The method always
// closes the http.Response Body.
func (client ResourceClient) ListJobsResponder(resp *http.Response) (result JobResponseListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListJobsNextResults retrieves the next set of results, if any.
func (client ResourceClient) ListJobsNextResults(lastResults JobResponseListResult) (result JobResponseListResult, err error) {
	req, err := lastResults.JobResponseListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListJobs", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListJobs", resp, "Failure sending next results request")
	}

	result, err = client.ListJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListJobs", resp, "Failure responding to next results request")
	}

	return
}

// ListKeys get the security metadata for an IoT hub. For more information,
// see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
//
// resourceGroupName is the name of the resource group that contains the IoT
// hub. resourceName is the name of the IoT hub.
func (client ResourceClient) ListKeys(resourceGroupName string, resourceName string) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	req, err := client.ListKeysPreparer(resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListKeys", resp, "Failure responding to request")
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client ResourceClient) ListKeysPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-02-03"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceClient) ListKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client ResourceClient) ListKeysResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListKeysNextResults retrieves the next set of results, if any.
func (client ResourceClient) ListKeysNextResults(lastResults SharedAccessSignatureAuthorizationRuleListResult) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	req, err := lastResults.SharedAccessSignatureAuthorizationRuleListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListKeys", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListKeys", resp, "Failure sending next results request")
	}

	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceClient", "ListKeys", resp, "Failure responding to next results request")
	}

	return
}
