// Code generated by smithy-go-codegen DO NOT EDIT.

package apptest

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apptest/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets a test case.
func (c *Client) GetTestCase(ctx context.Context, params *GetTestCaseInput, optFns ...func(*Options)) (*GetTestCaseOutput, error) {
	if params == nil {
		params = &GetTestCaseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTestCase", params, optFns, c.addOperationGetTestCaseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTestCaseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTestCaseInput struct {

	// The request test ID of the test case.
	//
	// This member is required.
	TestCaseId *string

	// The test case version of the test case.
	TestCaseVersion *int32

	noSmithyDocumentSerde
}

type GetTestCaseOutput struct {

	// The creation time of the test case.
	//
	// This member is required.
	CreationTime *time.Time

	// The last update time of the test case.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The latest version of the test case.
	//
	// This member is required.
	LatestVersion *types.TestCaseLatestVersion

	// The name of the test case.
	//
	// This member is required.
	Name *string

	// The status of the test case.
	//
	// This member is required.
	Status types.TestCaseLifecycle

	// The steps of the test case.
	//
	// This member is required.
	Steps []types.Step

	// The Amazon Resource Name (ARN) of the test case.
	//
	// This member is required.
	TestCaseArn *string

	// The response test ID of the test case.
	//
	// This member is required.
	TestCaseId *string

	// The case version of the test case.
	//
	// This member is required.
	TestCaseVersion *int32

	// The description of the test case.
	Description *string

	// The status reason of the test case.
	StatusReason *string

	// The tags of the test case.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTestCaseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetTestCase{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetTestCase{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTestCase"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetTestCaseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTestCase(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTestCase(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTestCase",
	}
}
