// Code generated by smithy-go-codegen DO NOT EDIT.

package proton

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/proton/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Attempts to cancel an environment deployment on an UpdateEnvironment action, if
// the deployment is IN_PROGRESS . For more information, see Update an environment (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-update.html)
// in the Proton User guide. The following list includes potential cancellation
// scenarios.
//   - If the cancellation attempt succeeds, the resulting deployment state is
//     CANCELLED .
//   - If the cancellation attempt fails, the resulting deployment state is FAILED
//     .
//   - If the current UpdateEnvironment action succeeds before the cancellation
//     attempt starts, the resulting deployment state is SUCCEEDED and the
//     cancellation attempt has no effect.
func (c *Client) CancelEnvironmentDeployment(ctx context.Context, params *CancelEnvironmentDeploymentInput, optFns ...func(*Options)) (*CancelEnvironmentDeploymentOutput, error) {
	if params == nil {
		params = &CancelEnvironmentDeploymentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CancelEnvironmentDeployment", params, optFns, c.addOperationCancelEnvironmentDeploymentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CancelEnvironmentDeploymentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CancelEnvironmentDeploymentInput struct {

	// The name of the environment with the deployment to cancel.
	//
	// This member is required.
	EnvironmentName *string

	noSmithyDocumentSerde
}

type CancelEnvironmentDeploymentOutput struct {

	// The environment summary data that's returned by Proton.
	//
	// This member is required.
	Environment *types.Environment

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCancelEnvironmentDeploymentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCancelEnvironmentDeployment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCancelEnvironmentDeployment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CancelEnvironmentDeployment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCancelEnvironmentDeploymentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCancelEnvironmentDeployment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCancelEnvironmentDeployment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CancelEnvironmentDeployment",
	}
}
