// Code generated by smithy-go-codegen DO NOT EDIT.

package iot1clickprojects

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iot1clickprojects/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the placement(s) of a project.
func (c *Client) ListPlacements(ctx context.Context, params *ListPlacementsInput, optFns ...func(*Options)) (*ListPlacementsOutput, error) {
	if params == nil {
		params = &ListPlacementsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPlacements", params, optFns, c.addOperationListPlacementsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPlacementsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPlacementsInput struct {

	// The project containing the placements to be listed.
	//
	// This member is required.
	ProjectName *string

	// The maximum number of results to return per request. If not set, a default
	// value of 100 is used.
	MaxResults *int32

	// The token to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPlacementsOutput struct {

	// An object listing the requested placements.
	//
	// This member is required.
	Placements []types.PlacementSummary

	// The token used to retrieve the next set of results - will be effectively empty
	// if there are no further results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPlacementsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPlacements{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPlacements{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPlacements"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListPlacementsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPlacements(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPlacementsAPIClient is a client that implements the ListPlacements
// operation.
type ListPlacementsAPIClient interface {
	ListPlacements(context.Context, *ListPlacementsInput, ...func(*Options)) (*ListPlacementsOutput, error)
}

var _ ListPlacementsAPIClient = (*Client)(nil)

// ListPlacementsPaginatorOptions is the paginator options for ListPlacements
type ListPlacementsPaginatorOptions struct {
	// The maximum number of results to return per request. If not set, a default
	// value of 100 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPlacementsPaginator is a paginator for ListPlacements
type ListPlacementsPaginator struct {
	options   ListPlacementsPaginatorOptions
	client    ListPlacementsAPIClient
	params    *ListPlacementsInput
	nextToken *string
	firstPage bool
}

// NewListPlacementsPaginator returns a new ListPlacementsPaginator
func NewListPlacementsPaginator(client ListPlacementsAPIClient, params *ListPlacementsInput, optFns ...func(*ListPlacementsPaginatorOptions)) *ListPlacementsPaginator {
	if params == nil {
		params = &ListPlacementsInput{}
	}

	options := ListPlacementsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPlacementsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPlacementsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPlacements page.
func (p *ListPlacementsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPlacementsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListPlacements(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListPlacements(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPlacements",
	}
}
