// Code generated by smithy-go-codegen DO NOT EDIT.

package eks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/eks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of all insights checked for against the specified cluster. You
// can filter which insights are returned by category, associated Kubernetes
// version, and status.
func (c *Client) ListInsights(ctx context.Context, params *ListInsightsInput, optFns ...func(*Options)) (*ListInsightsOutput, error) {
	if params == nil {
		params = &ListInsightsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInsights", params, optFns, c.addOperationListInsightsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInsightsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInsightsInput struct {

	// The name of the Amazon EKS cluster associated with the insights.
	//
	// This member is required.
	ClusterName *string

	// The criteria to filter your list of insights for your cluster. You can filter
	// which insights are returned by category, associated Kubernetes version, and
	// status.
	Filter *types.InsightsFilter

	// The maximum number of identity provider configurations returned by ListInsights
	// in paginated output. When you use this parameter, ListInsights returns only
	// maxResults results in a single page along with a nextToken response element.
	// You can see the remaining results of the initial request by sending another
	// ListInsights request with the returned nextToken value. This value can be
	// between 1 and 100. If you don't use this parameter, ListInsights returns up to
	// 100 results and a nextToken value, if applicable.
	MaxResults *int32

	// The nextToken value returned from a previous paginated ListInsights request.
	// When the results of a ListInsights request exceed maxResults , you can use this
	// value to retrieve the next page of results. This value is null when there are
	// no more results to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListInsightsOutput struct {

	// The returned list of insights.
	Insights []types.InsightSummary

	// The nextToken value to include in a future ListInsights request. When the
	// results of a ListInsights request exceed maxResults , you can use this value to
	// retrieve the next page of results. This value is null when there are no more
	// results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInsightsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListInsights{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListInsights{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInsights"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListInsightsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInsights(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInsightsAPIClient is a client that implements the ListInsights operation.
type ListInsightsAPIClient interface {
	ListInsights(context.Context, *ListInsightsInput, ...func(*Options)) (*ListInsightsOutput, error)
}

var _ ListInsightsAPIClient = (*Client)(nil)

// ListInsightsPaginatorOptions is the paginator options for ListInsights
type ListInsightsPaginatorOptions struct {
	// The maximum number of identity provider configurations returned by ListInsights
	// in paginated output. When you use this parameter, ListInsights returns only
	// maxResults results in a single page along with a nextToken response element.
	// You can see the remaining results of the initial request by sending another
	// ListInsights request with the returned nextToken value. This value can be
	// between 1 and 100. If you don't use this parameter, ListInsights returns up to
	// 100 results and a nextToken value, if applicable.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInsightsPaginator is a paginator for ListInsights
type ListInsightsPaginator struct {
	options   ListInsightsPaginatorOptions
	client    ListInsightsAPIClient
	params    *ListInsightsInput
	nextToken *string
	firstPage bool
}

// NewListInsightsPaginator returns a new ListInsightsPaginator
func NewListInsightsPaginator(client ListInsightsAPIClient, params *ListInsightsInput, optFns ...func(*ListInsightsPaginatorOptions)) *ListInsightsPaginator {
	if params == nil {
		params = &ListInsightsInput{}
	}

	options := ListInsightsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInsightsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInsightsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInsights page.
func (p *ListInsightsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInsightsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListInsights(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListInsights(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInsights",
	}
}
