// Code generated by smithy-go-codegen DO NOT EDIT.

package transfer

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transfer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// If the IdentityProviderType of a file transfer protocol-enabled server is
// AWS_DIRECTORY_SERVICE or API_Gateway, tests whether your identity provider is
// set up successfully. We highly recommend that you call this operation to test
// your authentication method as soon as you create your server. By doing so, you
// can troubleshoot issues with the identity provider integration to ensure that
// your users can successfully use the service. The ServerId and UserName
// parameters are required. The ServerProtocol, SourceIp, and UserPassword are all
// optional. You cannot use TestIdentityProvider if the IdentityProviderType of
// your server is SERVICE_MANAGED.
//
// * If you provide any incorrect values for any
// parameters, the Response field is empty.
//
// * If you provide a server ID for a
// server that uses service-managed users, you get an error:  An error occurred
// (InvalidRequestException) when calling the TestIdentityProvider operation:
// s-server-ID not configured for external auth
//
// * If you enter a Server ID for the
// --server-id parameter that does not identify an actual Transfer server, you
// receive the following error: An error occurred (ResourceNotFoundException) when
// calling the TestIdentityProvider operation: Unknown server
func (c *Client) TestIdentityProvider(ctx context.Context, params *TestIdentityProviderInput, optFns ...func(*Options)) (*TestIdentityProviderOutput, error) {
	if params == nil {
		params = &TestIdentityProviderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TestIdentityProvider", params, optFns, c.addOperationTestIdentityProviderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TestIdentityProviderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TestIdentityProviderInput struct {

	// A system-assigned identifier for a specific server. That server's user
	// authentication method is tested with a user name and password.
	//
	// This member is required.
	ServerId *string

	// The name of the user account to be tested.
	//
	// This member is required.
	UserName *string

	// The type of file transfer protocol to be tested. The available protocols are:
	//
	// *
	// Secure Shell (SSH) File Transfer Protocol (SFTP)
	//
	// * File Transfer Protocol
	// Secure (FTPS)
	//
	// * File Transfer Protocol (FTP)
	ServerProtocol types.Protocol

	// The source IP address of the user account to be tested.
	SourceIp *string

	// The password of the user account to be tested.
	UserPassword *string

	noSmithyDocumentSerde
}

type TestIdentityProviderOutput struct {

	// The HTTP status code that is the response from your API Gateway.
	//
	// This member is required.
	StatusCode int32

	// The endpoint of the service used to authenticate a user.
	//
	// This member is required.
	Url *string

	// A message that indicates whether the test was successful or not. If an empty
	// string is returned, the most likely cause is that the authentication failed due
	// to an incorrect username or password.
	Message *string

	// The response that is returned from your API Gateway.
	Response *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTestIdentityProviderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpTestIdentityProvider{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpTestIdentityProvider{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpTestIdentityProviderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTestIdentityProvider(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTestIdentityProvider(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transfer",
		OperationName: "TestIdentityProvider",
	}
}
