// Code generated by smithy-go-codegen DO NOT EDIT.

package mediapackage

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mediapackage/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpConfigureLogs struct {
}

func (*validateOpConfigureLogs) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpConfigureLogs) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ConfigureLogsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpConfigureLogsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateChannel struct {
}

func (*validateOpCreateChannel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateChannel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateChannelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateChannelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateHarvestJob struct {
}

func (*validateOpCreateHarvestJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateHarvestJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateHarvestJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateHarvestJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateOriginEndpoint struct {
}

func (*validateOpCreateOriginEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateOriginEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateOriginEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateOriginEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteChannel struct {
}

func (*validateOpDeleteChannel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteChannel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteChannelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteChannelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteOriginEndpoint struct {
}

func (*validateOpDeleteOriginEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteOriginEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteOriginEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteOriginEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeChannel struct {
}

func (*validateOpDescribeChannel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeChannel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeChannelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeChannelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeHarvestJob struct {
}

func (*validateOpDescribeHarvestJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeHarvestJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeHarvestJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeHarvestJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeOriginEndpoint struct {
}

func (*validateOpDescribeOriginEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeOriginEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeOriginEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeOriginEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRotateChannelCredentials struct {
}

func (*validateOpRotateChannelCredentials) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRotateChannelCredentials) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RotateChannelCredentialsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRotateChannelCredentialsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRotateIngestEndpointCredentials struct {
}

func (*validateOpRotateIngestEndpointCredentials) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRotateIngestEndpointCredentials) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RotateIngestEndpointCredentialsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRotateIngestEndpointCredentialsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateChannel struct {
}

func (*validateOpUpdateChannel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateChannel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateChannelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateChannelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateOriginEndpoint struct {
}

func (*validateOpUpdateOriginEndpoint) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateOriginEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateOriginEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateOriginEndpointInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpConfigureLogsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpConfigureLogs{}, middleware.After)
}

func addOpCreateChannelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateChannel{}, middleware.After)
}

func addOpCreateHarvestJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateHarvestJob{}, middleware.After)
}

func addOpCreateOriginEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateOriginEndpoint{}, middleware.After)
}

func addOpDeleteChannelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteChannel{}, middleware.After)
}

func addOpDeleteOriginEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteOriginEndpoint{}, middleware.After)
}

func addOpDescribeChannelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeChannel{}, middleware.After)
}

func addOpDescribeHarvestJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeHarvestJob{}, middleware.After)
}

func addOpDescribeOriginEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeOriginEndpoint{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRotateChannelCredentialsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRotateChannelCredentials{}, middleware.After)
}

func addOpRotateIngestEndpointCredentialsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRotateIngestEndpointCredentials{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateChannelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateChannel{}, middleware.After)
}

func addOpUpdateOriginEndpointValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateOriginEndpoint{}, middleware.After)
}

func validate__listOfHlsManifestCreateOrUpdateParameters(v []types.HlsManifestCreateOrUpdateParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfHlsManifestCreateOrUpdateParameters"}
	for i := range v {
		if err := validateHlsManifestCreateOrUpdateParameters(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAuthorization(v *types.Authorization) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Authorization"}
	if v.CdnIdentifierSecret == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CdnIdentifierSecret"))
	}
	if v.SecretsRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretsRoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCmafEncryption(v *types.CmafEncryption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CmafEncryption"}
	if v.SpekeKeyProvider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SpekeKeyProvider"))
	} else if v.SpekeKeyProvider != nil {
		if err := validateSpekeKeyProvider(v.SpekeKeyProvider); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCmafPackageCreateOrUpdateParameters(v *types.CmafPackageCreateOrUpdateParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CmafPackageCreateOrUpdateParameters"}
	if v.Encryption != nil {
		if err := validateCmafEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if v.HlsManifests != nil {
		if err := validate__listOfHlsManifestCreateOrUpdateParameters(v.HlsManifests); err != nil {
			invalidParams.AddNested("HlsManifests", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDashEncryption(v *types.DashEncryption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DashEncryption"}
	if v.SpekeKeyProvider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SpekeKeyProvider"))
	} else if v.SpekeKeyProvider != nil {
		if err := validateSpekeKeyProvider(v.SpekeKeyProvider); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDashPackage(v *types.DashPackage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DashPackage"}
	if v.Encryption != nil {
		if err := validateDashEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEncryptionContractConfiguration(v *types.EncryptionContractConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionContractConfiguration"}
	if len(v.PresetSpeke20Audio) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PresetSpeke20Audio"))
	}
	if len(v.PresetSpeke20Video) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PresetSpeke20Video"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHlsEncryption(v *types.HlsEncryption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HlsEncryption"}
	if v.SpekeKeyProvider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SpekeKeyProvider"))
	} else if v.SpekeKeyProvider != nil {
		if err := validateSpekeKeyProvider(v.SpekeKeyProvider); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHlsManifestCreateOrUpdateParameters(v *types.HlsManifestCreateOrUpdateParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HlsManifestCreateOrUpdateParameters"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHlsPackage(v *types.HlsPackage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HlsPackage"}
	if v.Encryption != nil {
		if err := validateHlsEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMssEncryption(v *types.MssEncryption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MssEncryption"}
	if v.SpekeKeyProvider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SpekeKeyProvider"))
	} else if v.SpekeKeyProvider != nil {
		if err := validateSpekeKeyProvider(v.SpekeKeyProvider); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMssPackage(v *types.MssPackage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MssPackage"}
	if v.Encryption != nil {
		if err := validateMssEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Destination(v *types.S3Destination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Destination"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if v.ManifestKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ManifestKey"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSpekeKeyProvider(v *types.SpekeKeyProvider) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SpekeKeyProvider"}
	if v.EncryptionContractConfiguration != nil {
		if err := validateEncryptionContractConfiguration(v.EncryptionContractConfiguration); err != nil {
			invalidParams.AddNested("EncryptionContractConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceId"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.SystemIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SystemIds"))
	}
	if v.Url == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Url"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpConfigureLogsInput(v *ConfigureLogsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConfigureLogsInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateChannelInput(v *CreateChannelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateChannelInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateHarvestJobInput(v *CreateHarvestJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateHarvestJobInput"}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.OriginEndpointId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OriginEndpointId"))
	}
	if v.S3Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Destination"))
	} else if v.S3Destination != nil {
		if err := validateS3Destination(v.S3Destination); err != nil {
			invalidParams.AddNested("S3Destination", err.(smithy.InvalidParamsError))
		}
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateOriginEndpointInput(v *CreateOriginEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOriginEndpointInput"}
	if v.Authorization != nil {
		if err := validateAuthorization(v.Authorization); err != nil {
			invalidParams.AddNested("Authorization", err.(smithy.InvalidParamsError))
		}
	}
	if v.ChannelId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChannelId"))
	}
	if v.CmafPackage != nil {
		if err := validateCmafPackageCreateOrUpdateParameters(v.CmafPackage); err != nil {
			invalidParams.AddNested("CmafPackage", err.(smithy.InvalidParamsError))
		}
	}
	if v.DashPackage != nil {
		if err := validateDashPackage(v.DashPackage); err != nil {
			invalidParams.AddNested("DashPackage", err.(smithy.InvalidParamsError))
		}
	}
	if v.HlsPackage != nil {
		if err := validateHlsPackage(v.HlsPackage); err != nil {
			invalidParams.AddNested("HlsPackage", err.(smithy.InvalidParamsError))
		}
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.MssPackage != nil {
		if err := validateMssPackage(v.MssPackage); err != nil {
			invalidParams.AddNested("MssPackage", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteChannelInput(v *DeleteChannelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteChannelInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteOriginEndpointInput(v *DeleteOriginEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteOriginEndpointInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeChannelInput(v *DescribeChannelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeChannelInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeHarvestJobInput(v *DescribeHarvestJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeHarvestJobInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeOriginEndpointInput(v *DescribeOriginEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeOriginEndpointInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRotateChannelCredentialsInput(v *RotateChannelCredentialsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RotateChannelCredentialsInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRotateIngestEndpointCredentialsInput(v *RotateIngestEndpointCredentialsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RotateIngestEndpointCredentialsInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.IngestEndpointId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestEndpointId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateChannelInput(v *UpdateChannelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateChannelInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateOriginEndpointInput(v *UpdateOriginEndpointInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOriginEndpointInput"}
	if v.Authorization != nil {
		if err := validateAuthorization(v.Authorization); err != nil {
			invalidParams.AddNested("Authorization", err.(smithy.InvalidParamsError))
		}
	}
	if v.CmafPackage != nil {
		if err := validateCmafPackageCreateOrUpdateParameters(v.CmafPackage); err != nil {
			invalidParams.AddNested("CmafPackage", err.(smithy.InvalidParamsError))
		}
	}
	if v.DashPackage != nil {
		if err := validateDashPackage(v.DashPackage); err != nil {
			invalidParams.AddNested("DashPackage", err.(smithy.InvalidParamsError))
		}
	}
	if v.HlsPackage != nil {
		if err := validateHlsPackage(v.HlsPackage); err != nil {
			invalidParams.AddNested("HlsPackage", err.(smithy.InvalidParamsError))
		}
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.MssPackage != nil {
		if err := validateMssPackage(v.MssPackage); err != nil {
			invalidParams.AddNested("MssPackage", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
