// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"math"

	"entgo.io/ent/dialect/gremlin"
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/g"
	"entgo.io/ent/entc/integration/gremlin/ent/license"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
)

// LicenseQuery is the builder for querying License entities.
type LicenseQuery struct {
	config
	limit      *int
	offset     *int
	unique     *bool
	order      []OrderFunc
	fields     []string
	predicates []predicate.License
	// intermediate query (i.e. traversal path).
	gremlin *dsl.Traversal
	path    func(context.Context) (*dsl.Traversal, error)
}

// Where adds a new predicate for the LicenseQuery builder.
func (lq *LicenseQuery) Where(ps ...predicate.License) *LicenseQuery {
	lq.predicates = append(lq.predicates, ps...)
	return lq
}

// Limit adds a limit step to the query.
func (lq *LicenseQuery) Limit(limit int) *LicenseQuery {
	lq.limit = &limit
	return lq
}

// Offset adds an offset step to the query.
func (lq *LicenseQuery) Offset(offset int) *LicenseQuery {
	lq.offset = &offset
	return lq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (lq *LicenseQuery) Unique(unique bool) *LicenseQuery {
	lq.unique = &unique
	return lq
}

// Order adds an order step to the query.
func (lq *LicenseQuery) Order(o ...OrderFunc) *LicenseQuery {
	lq.order = append(lq.order, o...)
	return lq
}

// First returns the first License entity from the query.
// Returns a *NotFoundError when no License was found.
func (lq *LicenseQuery) First(ctx context.Context) (*License, error) {
	nodes, err := lq.Limit(1).All(ctx)
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{license.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (lq *LicenseQuery) FirstX(ctx context.Context) *License {
	node, err := lq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first License ID from the query.
// Returns a *NotFoundError when no License ID was found.
func (lq *LicenseQuery) FirstID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = lq.Limit(1).IDs(ctx); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{license.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (lq *LicenseQuery) FirstIDX(ctx context.Context) int {
	id, err := lq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single License entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one License entity is found.
// Returns a *NotFoundError when no License entities are found.
func (lq *LicenseQuery) Only(ctx context.Context) (*License, error) {
	nodes, err := lq.Limit(2).All(ctx)
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{license.Label}
	default:
		return nil, &NotSingularError{license.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (lq *LicenseQuery) OnlyX(ctx context.Context) *License {
	node, err := lq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only License ID in the query.
// Returns a *NotSingularError when more than one License ID is found.
// Returns a *NotFoundError when no entities are found.
func (lq *LicenseQuery) OnlyID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = lq.Limit(2).IDs(ctx); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{license.Label}
	default:
		err = &NotSingularError{license.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (lq *LicenseQuery) OnlyIDX(ctx context.Context) int {
	id, err := lq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of Licenses.
func (lq *LicenseQuery) All(ctx context.Context) ([]*License, error) {
	if err := lq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	return lq.gremlinAll(ctx)
}

// AllX is like All, but panics if an error occurs.
func (lq *LicenseQuery) AllX(ctx context.Context) []*License {
	nodes, err := lq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of License IDs.
func (lq *LicenseQuery) IDs(ctx context.Context) ([]int, error) {
	var ids []int
	if err := lq.Select(license.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (lq *LicenseQuery) IDsX(ctx context.Context) []int {
	ids, err := lq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (lq *LicenseQuery) Count(ctx context.Context) (int, error) {
	if err := lq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return lq.gremlinCount(ctx)
}

// CountX is like Count, but panics if an error occurs.
func (lq *LicenseQuery) CountX(ctx context.Context) int {
	count, err := lq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (lq *LicenseQuery) Exist(ctx context.Context) (bool, error) {
	if err := lq.prepareQuery(ctx); err != nil {
		return false, err
	}
	return lq.gremlinExist(ctx)
}

// ExistX is like Exist, but panics if an error occurs.
func (lq *LicenseQuery) ExistX(ctx context.Context) bool {
	exist, err := lq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the LicenseQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (lq *LicenseQuery) Clone() *LicenseQuery {
	if lq == nil {
		return nil
	}
	return &LicenseQuery{
		config:     lq.config,
		limit:      lq.limit,
		offset:     lq.offset,
		order:      append([]OrderFunc{}, lq.order...),
		predicates: append([]predicate.License{}, lq.predicates...),
		// clone intermediate query.
		gremlin: lq.gremlin.Clone(),
		path:    lq.path,
		unique:  lq.unique,
	}
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		CreateTime time.Time `json:"create_time,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.License.Query().
//		GroupBy(license.FieldCreateTime).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (lq *LicenseQuery) GroupBy(field string, fields ...string) *LicenseGroupBy {
	grbuild := &LicenseGroupBy{config: lq.config}
	grbuild.fields = append([]string{field}, fields...)
	grbuild.path = func(ctx context.Context) (prev *dsl.Traversal, err error) {
		if err := lq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		return lq.gremlinQuery(ctx), nil
	}
	grbuild.label = license.Label
	grbuild.flds, grbuild.scan = &grbuild.fields, grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		CreateTime time.Time `json:"create_time,omitempty"`
//	}
//
//	client.License.Query().
//		Select(license.FieldCreateTime).
//		Scan(ctx, &v)
func (lq *LicenseQuery) Select(fields ...string) *LicenseSelect {
	lq.fields = append(lq.fields, fields...)
	selbuild := &LicenseSelect{LicenseQuery: lq}
	selbuild.label = license.Label
	selbuild.flds, selbuild.scan = &lq.fields, selbuild.Scan
	return selbuild
}

func (lq *LicenseQuery) prepareQuery(ctx context.Context) error {
	if lq.path != nil {
		prev, err := lq.path(ctx)
		if err != nil {
			return err
		}
		lq.gremlin = prev
	}
	return nil
}

func (lq *LicenseQuery) gremlinAll(ctx context.Context) ([]*License, error) {
	res := &gremlin.Response{}
	traversal := lq.gremlinQuery(ctx)
	if len(lq.fields) > 0 {
		fields := make([]any, len(lq.fields))
		for i, f := range lq.fields {
			fields[i] = f
		}
		traversal.ValueMap(fields...)
	} else {
		traversal.ValueMap(true)
	}
	query, bindings := traversal.Query()
	if err := lq.driver.Exec(ctx, query, bindings, res); err != nil {
		return nil, err
	}
	var ls Licenses
	if err := ls.FromResponse(res); err != nil {
		return nil, err
	}
	ls.config(lq.config)
	return ls, nil
}

func (lq *LicenseQuery) gremlinCount(ctx context.Context) (int, error) {
	res := &gremlin.Response{}
	query, bindings := lq.gremlinQuery(ctx).Count().Query()
	if err := lq.driver.Exec(ctx, query, bindings, res); err != nil {
		return 0, err
	}
	return res.ReadInt()
}

func (lq *LicenseQuery) gremlinExist(ctx context.Context) (bool, error) {
	res := &gremlin.Response{}
	query, bindings := lq.gremlinQuery(ctx).HasNext().Query()
	if err := lq.driver.Exec(ctx, query, bindings, res); err != nil {
		return false, err
	}
	return res.ReadBool()
}

func (lq *LicenseQuery) gremlinQuery(context.Context) *dsl.Traversal {
	v := g.V().HasLabel(license.Label)
	if lq.gremlin != nil {
		v = lq.gremlin.Clone()
	}
	for _, p := range lq.predicates {
		p(v)
	}
	if len(lq.order) > 0 {
		v.Order()
		for _, p := range lq.order {
			p(v)
		}
	}
	switch limit, offset := lq.limit, lq.offset; {
	case limit != nil && offset != nil:
		v.Range(*offset, *offset+*limit)
	case offset != nil:
		v.Range(*offset, math.MaxInt32)
	case limit != nil:
		v.Limit(*limit)
	}
	if unique := lq.unique; unique == nil || *unique {
		v.Dedup()
	}
	return v
}

// LicenseGroupBy is the group-by builder for License entities.
type LicenseGroupBy struct {
	config
	selector
	fields []string
	fns    []AggregateFunc
	// intermediate query (i.e. traversal path).
	gremlin *dsl.Traversal
	path    func(context.Context) (*dsl.Traversal, error)
}

// Aggregate adds the given aggregation functions to the group-by query.
func (lgb *LicenseGroupBy) Aggregate(fns ...AggregateFunc) *LicenseGroupBy {
	lgb.fns = append(lgb.fns, fns...)
	return lgb
}

// Scan applies the group-by query and scans the result into the given value.
func (lgb *LicenseGroupBy) Scan(ctx context.Context, v any) error {
	query, err := lgb.path(ctx)
	if err != nil {
		return err
	}
	lgb.gremlin = query
	return lgb.gremlinScan(ctx, v)
}

func (lgb *LicenseGroupBy) gremlinScan(ctx context.Context, v any) error {
	res := &gremlin.Response{}
	query, bindings := lgb.gremlinQuery().Query()
	if err := lgb.driver.Exec(ctx, query, bindings, res); err != nil {
		return err
	}
	if len(lgb.fields)+len(lgb.fns) == 1 {
		return res.ReadVal(v)
	}
	vm, err := res.ReadValueMap()
	if err != nil {
		return err
	}
	return vm.Decode(v)
}

func (lgb *LicenseGroupBy) gremlinQuery() *dsl.Traversal {
	var (
		trs   []any
		names []any
	)
	for _, fn := range lgb.fns {
		name, tr := fn("p", "")
		trs = append(trs, tr)
		names = append(names, name)
	}
	for _, f := range lgb.fields {
		names = append(names, f)
		trs = append(trs, __.As("p").Unfold().Values(f).As(f))
	}
	return lgb.gremlin.Group().
		By(__.Values(lgb.fields...).Fold()).
		By(__.Fold().Match(trs...).Select(names...)).
		Select(dsl.Values).
		Next()
}

// LicenseSelect is the builder for selecting fields of License entities.
type LicenseSelect struct {
	*LicenseQuery
	selector
	// intermediate query (i.e. traversal path).
	gremlin *dsl.Traversal
}

// Scan applies the selector query and scans the result into the given value.
func (ls *LicenseSelect) Scan(ctx context.Context, v any) error {
	if err := ls.prepareQuery(ctx); err != nil {
		return err
	}
	ls.gremlin = ls.LicenseQuery.gremlinQuery(ctx)
	return ls.gremlinScan(ctx, v)
}

func (ls *LicenseSelect) gremlinScan(ctx context.Context, v any) error {
	var (
		traversal *dsl.Traversal
		res       = &gremlin.Response{}
	)
	if len(ls.fields) == 1 {
		if ls.fields[0] != license.FieldID {
			traversal = ls.gremlin.Values(ls.fields...)
		} else {
			traversal = ls.gremlin.ID()
		}
	} else {
		fields := make([]any, len(ls.fields))
		for i, f := range ls.fields {
			fields[i] = f
		}
		traversal = ls.gremlin.ValueMap(fields...)
	}
	query, bindings := traversal.Query()
	if err := ls.driver.Exec(ctx, query, bindings, res); err != nil {
		return err
	}
	if len(ls.fields) == 1 {
		return res.ReadVal(v)
	}
	vm, err := res.ReadValueMap()
	if err != nil {
		return err
	}
	return vm.Decode(v)
}
