// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package car

import (
	"github.com/google/uuid"
)

const (
	// Label holds the string label denoting the car type in the database.
	Label = "car"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldNumber holds the string denoting the number field in the database.
	FieldNumber = "number"
	// EdgeRentals holds the string denoting the rentals edge name in mutations.
	EdgeRentals = "rentals"
	// Table holds the table name of the car in the database.
	Table = "cars"
	// RentalsTable is the table that holds the rentals relation/edge.
	RentalsTable = "rentals"
	// RentalsInverseTable is the table name for the Rental entity.
	// It exists in this package in order to avoid circular dependency with the "rental" package.
	RentalsInverseTable = "rentals"
	// RentalsColumn is the table column denoting the rentals relation/edge.
	RentalsColumn = "car_id"
)

// Columns holds all SQL columns for car fields.
var Columns = []string{
	FieldID,
	FieldNumber,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultID holds the default value on creation for the "id" field.
	DefaultID func() uuid.UUID
)
