// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package auth

import (
	"context"

	"github.com/urfave/cli/v3"
)

func ForgeUserOption(prefix string) string {
	return prefix + "-user"
}

func ForgePasswordOption(prefix string) string {
	return prefix + "-password"
}

func ForgeTokenOption(prefix string) string {
	return prefix + "-token"
}

func ForgeURLOption(prefix string) string {
	return prefix + "-url"
}

func (o *ForgeAuth) FromFlags(ctx context.Context, c *cli.Command, prefix string) {
	o.SetUsername(c.String(ForgeUserOption(prefix)))
	o.SetPassword(c.String(ForgePasswordOption(prefix)))
	o.SetToken(c.String(ForgeTokenOption(prefix)))
	o.SetURL(c.String(ForgeURLOption(prefix)))
}

func (o *ForgeAuth) GetFlags(prefix, category string) []cli.Flag {
	flags := make([]cli.Flag, 0, 10)

	flags = append(flags, &cli.StringFlag{
		Name:     ForgeUserOption(prefix),
		Usage:    "`USER` to access the forge API",
		Category: prefix,
	})
	flags = append(flags, &cli.StringFlag{
		Name:     ForgePasswordOption(prefix),
		Usage:    "`PASSWORD` of the user",
		Category: prefix,
	})
	flags = append(flags, &cli.StringFlag{
		Name:     ForgeTokenOption(prefix),
		Usage:    "`TOKEN` of the user",
		Category: prefix,
	})
	flags = append(flags, &cli.StringFlag{
		Name:     ForgeURLOption(prefix),
		Usage:    "`URL` of the forge",
		Category: prefix,
	})

	return flags
}
