// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Card data parameters that are required to generate a Card Security Code (CSC2)
// for an AMEX payment card.
type AmexCardSecurityCodeVersion1 struct {

	// The expiry date of a payment card.
	//
	// This member is required.
	CardExpiryDate *string

	noSmithyDocumentSerde
}

// Card data parameters that are required to generate a Card Security Code (CSC2)
// for an AMEX payment card.
type AmexCardSecurityCodeVersion2 struct {

	// The expiry date of a payment card.
	//
	// This member is required.
	CardExpiryDate *string

	// The service code of the AMEX payment card. This is different from the Card
	// Security Code (CSC).
	//
	// This member is required.
	ServiceCode *string

	noSmithyDocumentSerde
}

// Parameters for plaintext encryption using asymmetric keys.
type AsymmetricEncryptionAttributes struct {

	// The padding to be included with the data.
	PaddingType PaddingType

	noSmithyDocumentSerde
}

// Card data parameters that are required to generate Card Verification Values
// (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security
// Codes (CSC).
//
// The following types satisfy this interface:
//
//	CardGenerationAttributesMemberAmexCardSecurityCodeVersion1
//	CardGenerationAttributesMemberAmexCardSecurityCodeVersion2
//	CardGenerationAttributesMemberCardHolderVerificationValue
//	CardGenerationAttributesMemberCardVerificationValue1
//	CardGenerationAttributesMemberCardVerificationValue2
//	CardGenerationAttributesMemberDynamicCardVerificationCode
//	CardGenerationAttributesMemberDynamicCardVerificationValue
type CardGenerationAttributes interface {
	isCardGenerationAttributes()
}

// Card data parameters that are required to generate a Card Security Code (CSC2)
// for an AMEX payment card.
type CardGenerationAttributesMemberAmexCardSecurityCodeVersion1 struct {
	Value AmexCardSecurityCodeVersion1

	noSmithyDocumentSerde
}

func (*CardGenerationAttributesMemberAmexCardSecurityCodeVersion1) isCardGenerationAttributes() {}

// Card data parameters that are required to generate a Card Security Code (CSC2)
// for an AMEX payment card.
type CardGenerationAttributesMemberAmexCardSecurityCodeVersion2 struct {
	Value AmexCardSecurityCodeVersion2

	noSmithyDocumentSerde
}

func (*CardGenerationAttributesMemberAmexCardSecurityCodeVersion2) isCardGenerationAttributes() {}

// Card data parameters that are required to generate a cardholder verification
// value for the payment card.
type CardGenerationAttributesMemberCardHolderVerificationValue struct {
	Value CardHolderVerificationValue

	noSmithyDocumentSerde
}

func (*CardGenerationAttributesMemberCardHolderVerificationValue) isCardGenerationAttributes() {}

// Card data parameters that are required to generate Card Verification Value
// (CVV) for the payment card.
type CardGenerationAttributesMemberCardVerificationValue1 struct {
	Value CardVerificationValue1

	noSmithyDocumentSerde
}

func (*CardGenerationAttributesMemberCardVerificationValue1) isCardGenerationAttributes() {}

// Card data parameters that are required to generate Card Verification Value
// (CVV2) for the payment card.
type CardGenerationAttributesMemberCardVerificationValue2 struct {
	Value CardVerificationValue2

	noSmithyDocumentSerde
}

func (*CardGenerationAttributesMemberCardVerificationValue2) isCardGenerationAttributes() {}

// Card data parameters that are required to generate CDynamic Card Verification
// Code (dCVC) for the payment card.
type CardGenerationAttributesMemberDynamicCardVerificationCode struct {
	Value DynamicCardVerificationCode

	noSmithyDocumentSerde
}

func (*CardGenerationAttributesMemberDynamicCardVerificationCode) isCardGenerationAttributes() {}

// Card data parameters that are required to generate CDynamic Card Verification
// Value (dCVV) for the payment card.
type CardGenerationAttributesMemberDynamicCardVerificationValue struct {
	Value DynamicCardVerificationValue

	noSmithyDocumentSerde
}

func (*CardGenerationAttributesMemberDynamicCardVerificationValue) isCardGenerationAttributes() {}

// Card data parameters that are required to generate a cardholder verification
// value for the payment card.
type CardHolderVerificationValue struct {

	// The transaction counter value that comes from a point of sale terminal.
	//
	// This member is required.
	ApplicationTransactionCounter *string

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// A random number generated by the issuer.
	//
	// This member is required.
	UnpredictableNumber *string

	noSmithyDocumentSerde
}

// Card data parameters that are requried to verify Card Verification Values
// (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security
// Codes (CSC).
//
// The following types satisfy this interface:
//
//	CardVerificationAttributesMemberAmexCardSecurityCodeVersion1
//	CardVerificationAttributesMemberAmexCardSecurityCodeVersion2
//	CardVerificationAttributesMemberCardHolderVerificationValue
//	CardVerificationAttributesMemberCardVerificationValue1
//	CardVerificationAttributesMemberCardVerificationValue2
//	CardVerificationAttributesMemberDiscoverDynamicCardVerificationCode
//	CardVerificationAttributesMemberDynamicCardVerificationCode
//	CardVerificationAttributesMemberDynamicCardVerificationValue
type CardVerificationAttributes interface {
	isCardVerificationAttributes()
}

// Card data parameters that are required to generate a Card Security Code (CSC2)
// for an AMEX payment card.
type CardVerificationAttributesMemberAmexCardSecurityCodeVersion1 struct {
	Value AmexCardSecurityCodeVersion1

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberAmexCardSecurityCodeVersion1) isCardVerificationAttributes() {}

// Card data parameters that are required to verify a Card Security Code (CSC2)
// for an AMEX payment card.
type CardVerificationAttributesMemberAmexCardSecurityCodeVersion2 struct {
	Value AmexCardSecurityCodeVersion2

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberAmexCardSecurityCodeVersion2) isCardVerificationAttributes() {}

// Card data parameters that are required to verify a cardholder verification
// value for the payment card.
type CardVerificationAttributesMemberCardHolderVerificationValue struct {
	Value CardHolderVerificationValue

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberCardHolderVerificationValue) isCardVerificationAttributes() {}

// Card data parameters that are required to verify Card Verification Value (CVV)
// for the payment card.
type CardVerificationAttributesMemberCardVerificationValue1 struct {
	Value CardVerificationValue1

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberCardVerificationValue1) isCardVerificationAttributes() {}

// Card data parameters that are required to verify Card Verification Value (CVV2)
// for the payment card.
type CardVerificationAttributesMemberCardVerificationValue2 struct {
	Value CardVerificationValue2

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberCardVerificationValue2) isCardVerificationAttributes() {}

// Card data parameters that are required to verify CDynamic Card Verification
// Code (dCVC) for the payment card.
type CardVerificationAttributesMemberDiscoverDynamicCardVerificationCode struct {
	Value DiscoverDynamicCardVerificationCode

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberDiscoverDynamicCardVerificationCode) isCardVerificationAttributes() {
}

// Card data parameters that are required to verify CDynamic Card Verification
// Code (dCVC) for the payment card.
type CardVerificationAttributesMemberDynamicCardVerificationCode struct {
	Value DynamicCardVerificationCode

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberDynamicCardVerificationCode) isCardVerificationAttributes() {}

// Card data parameters that are required to verify CDynamic Card Verification
// Value (dCVV) for the payment card.
type CardVerificationAttributesMemberDynamicCardVerificationValue struct {
	Value DynamicCardVerificationValue

	noSmithyDocumentSerde
}

func (*CardVerificationAttributesMemberDynamicCardVerificationValue) isCardVerificationAttributes() {}

// Card data parameters that are required to verify CVV (Card Verification Value)
// for the payment card.
type CardVerificationValue1 struct {

	// The expiry date of a payment card.
	//
	// This member is required.
	CardExpiryDate *string

	// The service code of the payment card. This is different from Card Security Code
	// (CSC).
	//
	// This member is required.
	ServiceCode *string

	noSmithyDocumentSerde
}

// Card data parameters that are required to verify Card Verification Value (CVV2)
// for the payment card.
type CardVerificationValue2 struct {

	// The expiry date of a payment card.
	//
	// This member is required.
	CardExpiryDate *string

	noSmithyDocumentSerde
}

// Parameters that are required for Authorization Response Cryptogram (ARPC)
// generation after Authorization Request Cryptogram (ARQC) verification is
// successful.
//
// The following types satisfy this interface:
//
//	CryptogramAuthResponseMemberArpcMethod1
//	CryptogramAuthResponseMemberArpcMethod2
type CryptogramAuthResponse interface {
	isCryptogramAuthResponse()
}

// Parameters that are required for ARPC response generation using method1 after
// ARQC verification is successful.
type CryptogramAuthResponseMemberArpcMethod1 struct {
	Value CryptogramVerificationArpcMethod1

	noSmithyDocumentSerde
}

func (*CryptogramAuthResponseMemberArpcMethod1) isCryptogramAuthResponse() {}

// Parameters that are required for ARPC response generation using method2 after
// ARQC verification is successful.
type CryptogramAuthResponseMemberArpcMethod2 struct {
	Value CryptogramVerificationArpcMethod2

	noSmithyDocumentSerde
}

func (*CryptogramAuthResponseMemberArpcMethod2) isCryptogramAuthResponse() {}

// Parameters that are required for ARPC response generation using method1 after
// ARQC verification is successful.
type CryptogramVerificationArpcMethod1 struct {

	// The auth code used to calculate APRC after ARQC verification is successful.
	// This is the same auth code used for ARQC generation outside of Amazon Web
	// Services Payment Cryptography.
	//
	// This member is required.
	AuthResponseCode *string

	noSmithyDocumentSerde
}

// Parameters that are required for ARPC response generation using method2 after
// ARQC verification is successful.
type CryptogramVerificationArpcMethod2 struct {

	// The data indicating whether the issuer approves or declines an online
	// transaction using an EMV chip card.
	//
	// This member is required.
	CardStatusUpdate *string

	// The proprietary authentication data used by issuer for communication during
	// online transaction using an EMV chip card.
	ProprietaryAuthenticationData *string

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify dCVC (Dynamic Card
// Verification Code).
type DiscoverDynamicCardVerificationCode struct {

	// The transaction counter value that comes from the terminal.
	//
	// This member is required.
	ApplicationTransactionCounter *string

	// The expiry date of a payment card.
	//
	// This member is required.
	CardExpiryDate *string

	// A random number that is generated by the issuer.
	//
	// This member is required.
	UnpredictableNumber *string

	noSmithyDocumentSerde
}

// Parameters that are used for Derived Unique Key Per Transaction (DUKPT)
// derivation algorithm.
type DukptAttributes struct {

	// The key type derived using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the BDK.
	// For example, you can't use AES_128 as a derivation type for a BDK of AES_128 or
	// TDES_2KEY .
	//
	// This member is required.
	DukptDerivationType DukptDerivationType

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from the
	// encrypting device unique identifier and an internal transaction counter.
	//
	// This member is required.
	KeySerialNumber *string

	noSmithyDocumentSerde
}

// Parameters required for encryption or decryption of data using DUKPT.
type DukptDerivationAttributes struct {

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from the
	// encrypting device unique identifier and an internal transaction counter.
	//
	// This member is required.
	KeySerialNumber *string

	// The key type derived using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the BDK.
	// For example, you can't use AES_128 as a derivation type for a BDK of AES_128 or
	// TDES_2KEY
	DukptKeyDerivationType DukptDerivationType

	// The type of use of DUKPT, which can be for incoming data decryption, outgoing
	// data encryption, or both.
	DukptKeyVariant DukptKeyVariant

	noSmithyDocumentSerde
}

// Parameters that are required to encrypt plaintext data using DUKPT.
type DukptEncryptionAttributes struct {

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from the
	// encrypting device unique identifier and an internal transaction counter.
	//
	// This member is required.
	KeySerialNumber *string

	// The key type encrypted using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the BDK.
	// For example, you can't use AES_128 as a derivation type for a BDK of AES_128 or
	// TDES_2KEY
	DukptKeyDerivationType DukptDerivationType

	// The type of use of DUKPT, which can be incoming data decryption, outgoing data
	// encryption, or both.
	DukptKeyVariant DukptKeyVariant

	// An input used to provide the intial state. If no value is provided, Amazon Web
	// Services Payment Cryptography defaults it to zero.
	InitializationVector *string

	// The block cipher method to use for encryption.
	//
	// The default is CBC.
	Mode DukptEncryptionMode

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Dynamic Card Verification
// Value (dCVV).
type DynamicCardVerificationCode struct {

	// The transaction counter value that comes from the terminal.
	//
	// This member is required.
	ApplicationTransactionCounter *string

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The data on the two tracks of magnetic cards used for financial transactions.
	// This includes the cardholder name, PAN, expiration date, bank ID (BIN) and
	// several other numbers the issuing bank uses to validate the data received.
	//
	// This member is required.
	TrackData *string

	// A random number generated by the issuer.
	//
	// This member is required.
	UnpredictableNumber *string

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Dynamic Card Verification
// Value (dCVV).
type DynamicCardVerificationValue struct {

	// The transaction counter value that comes from the terminal.
	//
	// This member is required.
	ApplicationTransactionCounter *string

	// The expiry date of a payment card.
	//
	// This member is required.
	CardExpiryDate *string

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The service code of the payment card. This is different from Card Security Code
	// (CSC).
	//
	// This member is required.
	ServiceCode *string

	noSmithyDocumentSerde
}

// Parameters for plaintext encryption using EMV keys.
type EmvEncryptionAttributes struct {

	// The EMV derivation mode to use for ICC master key derivation as per EMV version
	// 4.3 book 2.
	//
	// This member is required.
	MajorKeyDerivationMode EmvMajorKeyDerivationMode

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The Primary Account Number (PAN), a unique identifier for a payment credit or
	// debit card and associates the card to a specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	// The derivation value used to derive the ICC session key. It is typically the
	// application transaction counter value padded with zeros or previous ARQC value
	// padded with zeros as per EMV version 4.3 book 2.
	//
	// This member is required.
	SessionDerivationData *string

	// An input used to provide the intial state. If no value is provided, Amazon Web
	// Services Payment Cryptography defaults it to zero.
	InitializationVector *string

	// The block cipher method to use for encryption.
	Mode EmvEncryptionMode

	noSmithyDocumentSerde
}

// Parameters that are required to perform encryption and decryption operations.
//
// The following types satisfy this interface:
//
//	EncryptionDecryptionAttributesMemberAsymmetric
//	EncryptionDecryptionAttributesMemberDukpt
//	EncryptionDecryptionAttributesMemberEmv
//	EncryptionDecryptionAttributesMemberSymmetric
type EncryptionDecryptionAttributes interface {
	isEncryptionDecryptionAttributes()
}

// Parameters for plaintext encryption using asymmetric keys.
type EncryptionDecryptionAttributesMemberAsymmetric struct {
	Value AsymmetricEncryptionAttributes

	noSmithyDocumentSerde
}

func (*EncryptionDecryptionAttributesMemberAsymmetric) isEncryptionDecryptionAttributes() {}

// Parameters that are required to encrypt plaintext data using DUKPT.
type EncryptionDecryptionAttributesMemberDukpt struct {
	Value DukptEncryptionAttributes

	noSmithyDocumentSerde
}

func (*EncryptionDecryptionAttributesMemberDukpt) isEncryptionDecryptionAttributes() {}

// Parameters for plaintext encryption using EMV keys.
type EncryptionDecryptionAttributesMemberEmv struct {
	Value EmvEncryptionAttributes

	noSmithyDocumentSerde
}

func (*EncryptionDecryptionAttributesMemberEmv) isEncryptionDecryptionAttributes() {}

// Parameters that are required to perform encryption and decryption using
// symmetric keys.
type EncryptionDecryptionAttributesMemberSymmetric struct {
	Value SymmetricEncryptionAttributes

	noSmithyDocumentSerde
}

func (*EncryptionDecryptionAttributesMemberSymmetric) isEncryptionDecryptionAttributes() {}

// Parameters that are required to generate or verify Ibm3624 natural PIN.
type Ibm3624NaturalPin struct {

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is used
	// to convert the algorithm intermediate result from hexadecimal characters to
	// decimal.
	//
	// This member is required.
	DecimalizationTable *string

	// The unique data for cardholder identification.
	//
	// This member is required.
	PinValidationData *string

	// The padding character for validation data.
	//
	// This member is required.
	PinValidationDataPadCharacter *string

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
type Ibm3624PinFromOffset struct {

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is used
	// to convert the algorithm intermediate result from hexadecimal characters to
	// decimal.
	//
	// This member is required.
	DecimalizationTable *string

	// The PIN offset value.
	//
	// This member is required.
	PinOffset *string

	// The unique data for cardholder identification.
	//
	// This member is required.
	PinValidationData *string

	// The padding character for validation data.
	//
	// This member is required.
	PinValidationDataPadCharacter *string

	noSmithyDocumentSerde
}

// Pparameters that are required to generate or verify Ibm3624 PIN offset PIN.
type Ibm3624PinOffset struct {

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is used
	// to convert the algorithm intermediate result from hexadecimal characters to
	// decimal.
	//
	// This member is required.
	DecimalizationTable *string

	// The encrypted PIN block data. According to ISO 9564 standard, a PIN Block is an
	// encoded representation of a payment card Personal Account Number (PAN) and the
	// cardholder Personal Identification Number (PIN).
	//
	// This member is required.
	EncryptedPinBlock *string

	// The unique data for cardholder identification.
	//
	// This member is required.
	PinValidationData *string

	// The padding character for validation data.
	//
	// This member is required.
	PinValidationDataPadCharacter *string

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Ibm3624 PIN verification PIN.
type Ibm3624PinVerification struct {

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is used
	// to convert the algorithm intermediate result from hexadecimal characters to
	// decimal.
	//
	// This member is required.
	DecimalizationTable *string

	// The PIN offset value.
	//
	// This member is required.
	PinOffset *string

	// The unique data for cardholder identification.
	//
	// This member is required.
	PinValidationData *string

	// The padding character for validation data.
	//
	// This member is required.
	PinValidationDataPadCharacter *string

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Ibm3624 random PIN.
type Ibm3624RandomPin struct {

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is used
	// to convert the algorithm intermediate result from hexadecimal characters to
	// decimal.
	//
	// This member is required.
	DecimalizationTable *string

	// The unique data for cardholder identification.
	//
	// This member is required.
	PinValidationData *string

	// The padding character for validation data.
	//
	// This member is required.
	PinValidationDataPadCharacter *string

	noSmithyDocumentSerde
}

// Parameters required for DUKPT MAC generation and verification.
type MacAlgorithmDukpt struct {

	// The type of use of DUKPT, which can be MAC generation, MAC verification, or
	// both.
	//
	// This member is required.
	DukptKeyVariant DukptKeyVariant

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from the
	// encrypting device unique identifier and an internal transaction counter.
	//
	// This member is required.
	KeySerialNumber *string

	// The key type derived using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the BDK.
	// For example, you can't use AES_128 as a derivation type for a BDK of AES_128 or
	// TDES_2KEY .
	DukptDerivationType DukptDerivationType

	noSmithyDocumentSerde
}

// Parameters that are required for EMV MAC generation and verification.
type MacAlgorithmEmv struct {

	// The method to use when deriving the master key for EMV MAC generation or
	// verification.
	//
	// This member is required.
	MajorKeyDerivationMode MajorKeyDerivationMode

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The Primary Account Number (PAN), a unique identifier for a payment credit or
	// debit card and associates the card to a specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	// The method of deriving a session key for EMV MAC generation or verification.
	//
	// This member is required.
	SessionKeyDerivationMode SessionKeyDerivationMode

	// Parameters that are required to generate session key for EMV generation and
	// verification.
	//
	// This member is required.
	SessionKeyDerivationValue SessionKeyDerivationValue

	noSmithyDocumentSerde
}

// Parameters that are required for DUKPT, HMAC, or EMV MAC generation or
// verification.
//
// The following types satisfy this interface:
//
//	MacAttributesMemberAlgorithm
//	MacAttributesMemberDukptCmac
//	MacAttributesMemberDukptIso9797Algorithm1
//	MacAttributesMemberDukptIso9797Algorithm3
//	MacAttributesMemberEmvMac
type MacAttributes interface {
	isMacAttributes()
}

// The encryption algorithm for MAC generation or verification.
type MacAttributesMemberAlgorithm struct {
	Value MacAlgorithm

	noSmithyDocumentSerde
}

func (*MacAttributesMemberAlgorithm) isMacAttributes() {}

// Parameters that are required for MAC generation or verification using DUKPT
// CMAC algorithm.
type MacAttributesMemberDukptCmac struct {
	Value MacAlgorithmDukpt

	noSmithyDocumentSerde
}

func (*MacAttributesMemberDukptCmac) isMacAttributes() {}

// Parameters that are required for MAC generation or verification using DUKPT ISO
// 9797 algorithm1.
type MacAttributesMemberDukptIso9797Algorithm1 struct {
	Value MacAlgorithmDukpt

	noSmithyDocumentSerde
}

func (*MacAttributesMemberDukptIso9797Algorithm1) isMacAttributes() {}

// Parameters that are required for MAC generation or verification using DUKPT ISO
// 9797 algorithm3.
type MacAttributesMemberDukptIso9797Algorithm3 struct {
	Value MacAlgorithmDukpt

	noSmithyDocumentSerde
}

func (*MacAttributesMemberDukptIso9797Algorithm3) isMacAttributes() {}

// Parameters that are required for MAC generation or verification using EMV MAC
// algorithm.
type MacAttributesMemberEmvMac struct {
	Value MacAlgorithmEmv

	noSmithyDocumentSerde
}

func (*MacAttributesMemberEmvMac) isMacAttributes() {}

// Parameters that are required to generate, translate, or verify PIN data.
//
// The following types satisfy this interface:
//
//	PinDataMemberPinOffset
//	PinDataMemberVerificationValue
type PinData interface {
	isPinData()
}

// The PIN offset value.
type PinDataMemberPinOffset struct {
	Value string

	noSmithyDocumentSerde
}

func (*PinDataMemberPinOffset) isPinData() {}

// The unique data to identify a cardholder. In most cases, this is the same as
// cardholder's Primary Account Number (PAN). If a value is not provided, it
// defaults to PAN.
type PinDataMemberVerificationValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*PinDataMemberVerificationValue) isPinData() {}

// Parameters that are required for PIN data generation.
//
// The following types satisfy this interface:
//
//	PinGenerationAttributesMemberIbm3624NaturalPin
//	PinGenerationAttributesMemberIbm3624PinFromOffset
//	PinGenerationAttributesMemberIbm3624PinOffset
//	PinGenerationAttributesMemberIbm3624RandomPin
//	PinGenerationAttributesMemberVisaPin
//	PinGenerationAttributesMemberVisaPinVerificationValue
type PinGenerationAttributes interface {
	isPinGenerationAttributes()
}

// Parameters that are required to generate or verify Ibm3624 natural PIN.
type PinGenerationAttributesMemberIbm3624NaturalPin struct {
	Value Ibm3624NaturalPin

	noSmithyDocumentSerde
}

func (*PinGenerationAttributesMemberIbm3624NaturalPin) isPinGenerationAttributes() {}

// Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
type PinGenerationAttributesMemberIbm3624PinFromOffset struct {
	Value Ibm3624PinFromOffset

	noSmithyDocumentSerde
}

func (*PinGenerationAttributesMemberIbm3624PinFromOffset) isPinGenerationAttributes() {}

// Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
type PinGenerationAttributesMemberIbm3624PinOffset struct {
	Value Ibm3624PinOffset

	noSmithyDocumentSerde
}

func (*PinGenerationAttributesMemberIbm3624PinOffset) isPinGenerationAttributes() {}

// Parameters that are required to generate or verify Ibm3624 random PIN.
type PinGenerationAttributesMemberIbm3624RandomPin struct {
	Value Ibm3624RandomPin

	noSmithyDocumentSerde
}

func (*PinGenerationAttributesMemberIbm3624RandomPin) isPinGenerationAttributes() {}

// Parameters that are required to generate or verify Visa PIN.
type PinGenerationAttributesMemberVisaPin struct {
	Value VisaPin

	noSmithyDocumentSerde
}

func (*PinGenerationAttributesMemberVisaPin) isPinGenerationAttributes() {}

// Parameters that are required to generate or verify Visa PIN Verification Value
// (PVV).
type PinGenerationAttributesMemberVisaPinVerificationValue struct {
	Value VisaPinVerificationValue

	noSmithyDocumentSerde
}

func (*PinGenerationAttributesMemberVisaPinVerificationValue) isPinGenerationAttributes() {}

// Parameters that are required for PIN data verification.
//
// The following types satisfy this interface:
//
//	PinVerificationAttributesMemberIbm3624Pin
//	PinVerificationAttributesMemberVisaPin
type PinVerificationAttributes interface {
	isPinVerificationAttributes()
}

// Parameters that are required to generate or verify Ibm3624 PIN.
type PinVerificationAttributesMemberIbm3624Pin struct {
	Value Ibm3624PinVerification

	noSmithyDocumentSerde
}

func (*PinVerificationAttributesMemberIbm3624Pin) isPinVerificationAttributes() {}

// Parameters that are required to generate or verify Visa PIN.
type PinVerificationAttributesMemberVisaPin struct {
	Value VisaPinVerification

	noSmithyDocumentSerde
}

func (*PinVerificationAttributesMemberVisaPin) isPinVerificationAttributes() {}

// Parameters that are required to perform reencryption operation.
//
// The following types satisfy this interface:
//
//	ReEncryptionAttributesMemberDukpt
//	ReEncryptionAttributesMemberSymmetric
type ReEncryptionAttributes interface {
	isReEncryptionAttributes()
}

// Parameters that are required to encrypt plaintext data using DUKPT.
type ReEncryptionAttributesMemberDukpt struct {
	Value DukptEncryptionAttributes

	noSmithyDocumentSerde
}

func (*ReEncryptionAttributesMemberDukpt) isReEncryptionAttributes() {}

// Parameters that are required to encrypt data using symmetric keys.
type ReEncryptionAttributesMemberSymmetric struct {
	Value SymmetricEncryptionAttributes

	noSmithyDocumentSerde
}

func (*ReEncryptionAttributesMemberSymmetric) isReEncryptionAttributes() {}

// Parameters to derive session key for an Amex payment card.
type SessionKeyAmex struct {

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique
	// identifier for a payment credit or debit card and associates the card to a
	// specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	noSmithyDocumentSerde
}

// Parameters to derive a session key for Authorization Response Cryptogram (ARQC)
// verification.
//
// The following types satisfy this interface:
//
//	SessionKeyDerivationMemberAmex
//	SessionKeyDerivationMemberEmv2000
//	SessionKeyDerivationMemberEmvCommon
//	SessionKeyDerivationMemberMastercard
//	SessionKeyDerivationMemberVisa
type SessionKeyDerivation interface {
	isSessionKeyDerivation()
}

// Parameters to derive session key for an Amex payment card for ARQC verification.
type SessionKeyDerivationMemberAmex struct {
	Value SessionKeyAmex

	noSmithyDocumentSerde
}

func (*SessionKeyDerivationMemberAmex) isSessionKeyDerivation() {}

// Parameters to derive session key for an Emv2000 payment card for ARQC
// verification.
type SessionKeyDerivationMemberEmv2000 struct {
	Value SessionKeyEmv2000

	noSmithyDocumentSerde
}

func (*SessionKeyDerivationMemberEmv2000) isSessionKeyDerivation() {}

// Parameters to derive session key for an Emv common payment card for ARQC
// verification.
type SessionKeyDerivationMemberEmvCommon struct {
	Value SessionKeyEmvCommon

	noSmithyDocumentSerde
}

func (*SessionKeyDerivationMemberEmvCommon) isSessionKeyDerivation() {}

// Parameters to derive session key for a Mastercard payment card for ARQC
// verification.
type SessionKeyDerivationMemberMastercard struct {
	Value SessionKeyMastercard

	noSmithyDocumentSerde
}

func (*SessionKeyDerivationMemberMastercard) isSessionKeyDerivation() {}

// Parameters to derive session key for a Visa payment cardfor ARQC verification.
type SessionKeyDerivationMemberVisa struct {
	Value SessionKeyVisa

	noSmithyDocumentSerde
}

func (*SessionKeyDerivationMemberVisa) isSessionKeyDerivation() {}

// Parameters to derive session key value using a MAC EMV algorithm.
//
// The following types satisfy this interface:
//
//	SessionKeyDerivationValueMemberApplicationCryptogram
//	SessionKeyDerivationValueMemberApplicationTransactionCounter
type SessionKeyDerivationValue interface {
	isSessionKeyDerivationValue()
}

// The cryptogram provided by the terminal during transaction processing.
type SessionKeyDerivationValueMemberApplicationCryptogram struct {
	Value string

	noSmithyDocumentSerde
}

func (*SessionKeyDerivationValueMemberApplicationCryptogram) isSessionKeyDerivationValue() {}

// The transaction counter that is provided by the terminal during transaction
// processing.
type SessionKeyDerivationValueMemberApplicationTransactionCounter struct {
	Value string

	noSmithyDocumentSerde
}

func (*SessionKeyDerivationValueMemberApplicationTransactionCounter) isSessionKeyDerivationValue() {}

// Parameters to derive session key for an Emv2000 payment card for ARQC
// verification.
type SessionKeyEmv2000 struct {

	// The transaction counter that is provided by the terminal during transaction
	// processing.
	//
	// This member is required.
	ApplicationTransactionCounter *string

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique
	// identifier for a payment credit or debit card and associates the card to a
	// specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	noSmithyDocumentSerde
}

// Parameters to derive session key for an Emv common payment card for ARQC
// verification.
type SessionKeyEmvCommon struct {

	// The transaction counter that is provided by the terminal during transaction
	// processing.
	//
	// This member is required.
	ApplicationTransactionCounter *string

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique
	// identifier for a payment credit or debit card and associates the card to a
	// specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	noSmithyDocumentSerde
}

// Parameters to derive session key for Mastercard payment card for ARQC
// verification.
type SessionKeyMastercard struct {

	// The transaction counter that is provided by the terminal during transaction
	// processing.
	//
	// This member is required.
	ApplicationTransactionCounter *string

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique
	// identifier for a payment credit or debit card and associates the card to a
	// specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	// A random number generated by the issuer.
	//
	// This member is required.
	UnpredictableNumber *string

	noSmithyDocumentSerde
}

// Parameters to derive session key for Visa payment card for ARQC verification.
type SessionKeyVisa struct {

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// This member is required.
	PanSequenceNumber *string

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique
	// identifier for a payment credit or debit card and associates the card to a
	// specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	noSmithyDocumentSerde
}

// Parameters requried to encrypt plaintext data using symmetric keys.
type SymmetricEncryptionAttributes struct {

	// The block cipher method to use for encryption.
	//
	// This member is required.
	Mode EncryptionMode

	// An input used to provide the intial state. If no value is provided, Amazon Web
	// Services Payment Cryptography defaults it to zero.
	InitializationVector *string

	// The padding to be included with the data.
	PaddingType PaddingType

	noSmithyDocumentSerde
}

// Parameters that are required for translation between ISO9564 PIN block formats
// 0,1,3,4.
//
// The following types satisfy this interface:
//
//	TranslationIsoFormatsMemberIsoFormat0
//	TranslationIsoFormatsMemberIsoFormat1
//	TranslationIsoFormatsMemberIsoFormat3
//	TranslationIsoFormatsMemberIsoFormat4
type TranslationIsoFormats interface {
	isTranslationIsoFormats()
}

// Parameters that are required for ISO9564 PIN format 0 tranlation.
type TranslationIsoFormatsMemberIsoFormat0 struct {
	Value TranslationPinDataIsoFormat034

	noSmithyDocumentSerde
}

func (*TranslationIsoFormatsMemberIsoFormat0) isTranslationIsoFormats() {}

// Parameters that are required for ISO9564 PIN format 1 tranlation.
type TranslationIsoFormatsMemberIsoFormat1 struct {
	Value TranslationPinDataIsoFormat1

	noSmithyDocumentSerde
}

func (*TranslationIsoFormatsMemberIsoFormat1) isTranslationIsoFormats() {}

// Parameters that are required for ISO9564 PIN format 3 tranlation.
type TranslationIsoFormatsMemberIsoFormat3 struct {
	Value TranslationPinDataIsoFormat034

	noSmithyDocumentSerde
}

func (*TranslationIsoFormatsMemberIsoFormat3) isTranslationIsoFormats() {}

// Parameters that are required for ISO9564 PIN format 4 tranlation.
type TranslationIsoFormatsMemberIsoFormat4 struct {
	Value TranslationPinDataIsoFormat034

	noSmithyDocumentSerde
}

func (*TranslationIsoFormatsMemberIsoFormat4) isTranslationIsoFormats() {}

// Parameters that are required for tranlation between ISO9564 PIN format 0,3,4
// tranlation.
type TranslationPinDataIsoFormat034 struct {

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique
	// identifier for a payment credit or debit card and associates the card to a
	// specific account holder.
	//
	// This member is required.
	PrimaryAccountNumber *string

	noSmithyDocumentSerde
}

// Parameters that are required for ISO9564 PIN format 1 tranlation.
type TranslationPinDataIsoFormat1 struct {
	noSmithyDocumentSerde
}

// The request was denied due to an invalid request error.
type ValidationExceptionField struct {

	// The request was denied due to an invalid request error.
	//
	// This member is required.
	Message *string

	// The request was denied due to an invalid request error.
	//
	// This member is required.
	Path *string

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Visa PIN.
type VisaPin struct {

	// The value for PIN verification index. It is used in the Visa PIN algorithm to
	// calculate the PVV (PIN Verification Value).
	//
	// This member is required.
	PinVerificationKeyIndex *int32

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Visa PIN.
type VisaPinVerification struct {

	// The value for PIN verification index. It is used in the Visa PIN algorithm to
	// calculate the PVV (PIN Verification Value).
	//
	// This member is required.
	PinVerificationKeyIndex *int32

	// Parameters that are required to generate or verify Visa PVV (PIN Verification
	// Value).
	//
	// This member is required.
	VerificationValue *string

	noSmithyDocumentSerde
}

// Parameters that are required to generate or verify Visa PVV (PIN Verification
// Value).
type VisaPinVerificationValue struct {

	// The encrypted PIN block data to verify.
	//
	// This member is required.
	EncryptedPinBlock *string

	// The value for PIN verification index. It is used in the Visa PIN algorithm to
	// calculate the PVV (PIN Verification Value).
	//
	// This member is required.
	PinVerificationKeyIndex *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCardGenerationAttributes()       {}
func (*UnknownUnionMember) isCardVerificationAttributes()     {}
func (*UnknownUnionMember) isCryptogramAuthResponse()         {}
func (*UnknownUnionMember) isEncryptionDecryptionAttributes() {}
func (*UnknownUnionMember) isMacAttributes()                  {}
func (*UnknownUnionMember) isPinData()                        {}
func (*UnknownUnionMember) isPinGenerationAttributes()        {}
func (*UnknownUnionMember) isPinVerificationAttributes()      {}
func (*UnknownUnionMember) isReEncryptionAttributes()         {}
func (*UnknownUnionMember) isSessionKeyDerivation()           {}
func (*UnknownUnionMember) isSessionKeyDerivationValue()      {}
func (*UnknownUnionMember) isTranslationIsoFormats()          {}
