//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkubernetesconfiguration

import "time"

// BucketDefinition - Parameters to reconcile to the GitRepository source kind type.
type BucketDefinition struct {
	// Plaintext access key used to securely access the S3 bucket
	AccessKey *string `json:"accessKey,omitempty"`

	// The bucket name to sync from the url endpoint for the flux configuration.
	BucketName *string `json:"bucketName,omitempty"`

	// Specify whether to use insecure communication when puling data from the S3 bucket.
	Insecure *bool `json:"insecure,omitempty"`

	// Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided
	// configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`

	// The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`

	// The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`

	// The URL to sync for the flux configuration S3 bucket.
	URL *string `json:"url,omitempty"`
}

// BucketPatchDefinition - Parameters to reconcile to the GitRepository source kind type.
type BucketPatchDefinition struct {
	// Plaintext access key used to securely access the S3 bucket
	AccessKey *string `json:"accessKey,omitempty"`

	// The bucket name to sync from the url endpoint for the flux configuration.
	BucketName *string `json:"bucketName,omitempty"`

	// Specify whether to use insecure communication when puling data from the S3 bucket.
	Insecure *bool `json:"insecure,omitempty"`

	// Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided
	// configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`

	// The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`

	// The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`

	// The URL to sync for the flux configuration S3 bucket.
	URL *string `json:"url,omitempty"`
}

// ComplianceStatus - Compliance Status details
type ComplianceStatus struct {
	// Datetime the configuration was last applied.
	LastConfigApplied *time.Time `json:"lastConfigApplied,omitempty"`

	// Message from when the configuration was applied.
	Message *string `json:"message,omitempty"`

	// Level of the message.
	MessageLevel *MessageLevelType `json:"messageLevel,omitempty"`

	// READ-ONLY; The compliance state of the configuration.
	ComplianceState *ComplianceStateType `json:"complianceState,omitempty" azure:"ro"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Extension - The Extension object.
type Extension struct {
	// Identity of the Extension resource
	Identity *Identity `json:"identity,omitempty"`

	// Properties of an Extension resource
	Properties *ExtensionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExtensionProperties - Properties of an Extension resource
type ExtensionProperties struct {
	// Identity of the Extension resource in an AKS cluster
	AksAssignedIdentity *ExtensionPropertiesAksAssignedIdentity `json:"aksAssignedIdentity,omitempty"`

	// Flag to note if this extension participates in auto upgrade of minor version, or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Configuration settings that are sensitive, as name-value pairs for configuring this extension.
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings,omitempty"`

	// Configuration settings, as name-value pairs for configuring this extension.
	ConfigurationSettings map[string]*string `json:"configurationSettings,omitempty"`

	// Type of the Extension, of which this resource is an instance of. It must be one of the Extension Types registered with
	// Microsoft.KubernetesConfiguration by the Extension publisher.
	ExtensionType *string `json:"extensionType,omitempty"`

	// ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion
	// is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`

	// Scope at which the extension is installed.
	Scope *Scope `json:"scope,omitempty"`

	// Status from this extension.
	Statuses []*ExtensionStatus `json:"statuses,omitempty"`

	// User-specified version of the extension for this extension to 'pin'. To use 'version', autoUpgradeMinorVersion must be
	// 'false'.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; Custom Location settings properties.
	CustomLocationSettings map[string]*string `json:"customLocationSettings,omitempty" azure:"ro"`

	// READ-ONLY; Error information from the Agent - e.g. errors during installation.
	ErrorInfo *ErrorDetail `json:"errorInfo,omitempty" azure:"ro"`

	// READ-ONLY; Installed version of the extension.
	InstalledVersion *string `json:"installedVersion,omitempty" azure:"ro"`

	// READ-ONLY; Uri of the Helm package
	PackageURI *string `json:"packageUri,omitempty" azure:"ro"`

	// READ-ONLY; Status of installation of this extension.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ExtensionPropertiesAksAssignedIdentity - Identity of the Extension resource in an AKS cluster
type ExtensionPropertiesAksAssignedIdentity struct {
	// The identity type.
	Type *AKSIdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ExtensionStatus - Status from the extension.
type ExtensionStatus struct {
	// Status code provided by the Extension
	Code *string `json:"code,omitempty"`

	// Short description of status of the extension.
	DisplayStatus *string `json:"displayStatus,omitempty"`

	// Level of the status.
	Level *LevelType `json:"level,omitempty"`

	// Detailed message of the status from the Extension.
	Message *string `json:"message,omitempty"`

	// DateLiteral (per ISO8601) noting the time of installation status.
	Time *string `json:"time,omitempty"`
}

// ExtensionsClientBeginCreateOptions contains the optional parameters for the ExtensionsClient.BeginCreate method.
type ExtensionsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientBeginDeleteOptions contains the optional parameters for the ExtensionsClient.BeginDelete method.
type ExtensionsClientBeginDeleteOptions struct {
	// Delete the extension resource in Azure - not the normal asynchronous delete.
	ForceDelete *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientBeginUpdateOptions contains the optional parameters for the ExtensionsClient.BeginUpdate method.
type ExtensionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtensionsClientGetOptions contains the optional parameters for the ExtensionsClient.Get method.
type ExtensionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsClientListOptions contains the optional parameters for the ExtensionsClient.List method.
type ExtensionsClientListOptions struct {
	// placeholder for future optional parameters
}

// ExtensionsList - Result of the request to list Extensions. It contains a list of Extension objects and a URL link to get
// the next set of results.
type ExtensionsList struct {
	// READ-ONLY; URL to get the next set of extension objects, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Extensions within a Kubernetes cluster.
	Value []*Extension `json:"value,omitempty" azure:"ro"`
}

// FluxConfigOperationStatusClientGetOptions contains the optional parameters for the FluxConfigOperationStatusClient.Get
// method.
type FluxConfigOperationStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// FluxConfiguration - The Flux Configuration object returned in Get & Put response.
type FluxConfiguration struct {
	// Properties to create a Flux Configuration resource
	Properties *FluxConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FluxConfigurationPatch - The Flux Configuration Patch Request object.
type FluxConfigurationPatch struct {
	// Updatable properties of an Flux Configuration Patch Request
	Properties *FluxConfigurationPatchProperties `json:"properties,omitempty"`
}

// FluxConfigurationPatchProperties - Updatable properties of an Flux Configuration Patch Request
type FluxConfigurationPatchProperties struct {
	// Parameters to reconcile to the Bucket source kind type.
	Bucket *BucketPatchDefinition `json:"bucket,omitempty"`

	// Key-value pairs of protected configuration settings for the configuration
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings,omitempty"`

	// Parameters to reconcile to the GitRepository source kind type.
	GitRepository *GitRepositoryPatchDefinition `json:"gitRepository,omitempty"`

	// Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
	Kustomizations map[string]*KustomizationPatchDefinition `json:"kustomizations,omitempty"`

	// Source Kind to pull the configuration data from.
	SourceKind *SourceKindType `json:"sourceKind,omitempty"`

	// Whether this configuration should suspend its reconciliation of its kustomizations and sources.
	Suspend *bool `json:"suspend,omitempty"`
}

// FluxConfigurationProperties - Properties to create a Flux Configuration resource
type FluxConfigurationProperties struct {
	// Parameters to reconcile to the Bucket source kind type.
	Bucket *BucketDefinition `json:"bucket,omitempty"`

	// Key-value pairs of protected configuration settings for the configuration
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings,omitempty"`

	// Parameters to reconcile to the GitRepository source kind type.
	GitRepository *GitRepositoryDefinition `json:"gitRepository,omitempty"`

	// Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
	Kustomizations map[string]*KustomizationDefinition `json:"kustomizations,omitempty"`

	// The namespace to which this configuration is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and
	// period only.
	Namespace *string `json:"namespace,omitempty"`

	// Scope at which the operator will be installed.
	Scope *ScopeType `json:"scope,omitempty"`

	// Source Kind to pull the configuration data from.
	SourceKind *SourceKindType `json:"sourceKind,omitempty"`

	// Whether this configuration should suspend its reconciliation of its kustomizations and sources.
	Suspend *bool `json:"suspend,omitempty"`

	// READ-ONLY; Combined status of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed
	// objects.
	ComplianceState *FluxComplianceState `json:"complianceState,omitempty" azure:"ro"`

	// READ-ONLY; Error message returned to the user in the case of provisioning failure.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Status of the creation of the fluxConfiguration.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Public Key associated with this fluxConfiguration (either generated within the cluster or provided by the user).
	RepositoryPublicKey *string `json:"repositoryPublicKey,omitempty" azure:"ro"`

	// READ-ONLY; Branch and/or SHA of the source commit synced with the cluster.
	SourceSyncedCommitID *string `json:"sourceSyncedCommitId,omitempty" azure:"ro"`

	// READ-ONLY; Datetime the fluxConfiguration synced its source on the cluster.
	SourceUpdatedAt *time.Time `json:"sourceUpdatedAt,omitempty" azure:"ro"`

	// READ-ONLY; Datetime the fluxConfiguration synced its status on the cluster with Azure.
	StatusUpdatedAt *time.Time `json:"statusUpdatedAt,omitempty" azure:"ro"`

	// READ-ONLY; Statuses of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed objects
	// provisioned by the fluxConfiguration.
	Statuses []*ObjectStatusDefinition `json:"statuses,omitempty" azure:"ro"`
}

// FluxConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the FluxConfigurationsClient.BeginCreateOrUpdate
// method.
type FluxConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FluxConfigurationsClientBeginDeleteOptions contains the optional parameters for the FluxConfigurationsClient.BeginDelete
// method.
type FluxConfigurationsClientBeginDeleteOptions struct {
	// Delete the extension resource in Azure - not the normal asynchronous delete.
	ForceDelete *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FluxConfigurationsClientBeginUpdateOptions contains the optional parameters for the FluxConfigurationsClient.BeginUpdate
// method.
type FluxConfigurationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FluxConfigurationsClientGetOptions contains the optional parameters for the FluxConfigurationsClient.Get method.
type FluxConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FluxConfigurationsClientListOptions contains the optional parameters for the FluxConfigurationsClient.List method.
type FluxConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// FluxConfigurationsList - Result of the request to list Flux Configurations. It contains a list of FluxConfiguration objects
// and a URL link to get the next set of results.
type FluxConfigurationsList struct {
	// READ-ONLY; URL to get the next set of configuration objects, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Flux Configurations within a Kubernetes cluster.
	Value []*FluxConfiguration `json:"value,omitempty" azure:"ro"`
}

// GitRepositoryDefinition - Parameters to reconcile to the GitRepository source kind type.
type GitRepositoryDefinition struct {
	// Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
	HTTPSCACert *string `json:"httpsCACert,omitempty"`

	// Plaintext HTTPS username used to access private git repositories over HTTPS
	HTTPSUser *string `json:"httpsUser,omitempty"`

	// Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided
	// configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`

	// The source reference for the GitRepository object.
	RepositoryRef *RepositoryRefDefinition `json:"repositoryRef,omitempty"`

	// Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
	SSHKnownHosts *string `json:"sshKnownHosts,omitempty"`

	// The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`

	// The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`

	// The URL to sync for the flux configuration git repository.
	URL *string `json:"url,omitempty"`
}

// GitRepositoryPatchDefinition - Parameters to reconcile to the GitRepository source kind type.
type GitRepositoryPatchDefinition struct {
	// Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
	HTTPSCACert *string `json:"httpsCACert,omitempty"`

	// Plaintext HTTPS username used to access private git repositories over HTTPS
	HTTPSUser *string `json:"httpsUser,omitempty"`

	// Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided
	// configuration secrets.
	LocalAuthRef *string `json:"localAuthRef,omitempty"`

	// The source reference for the GitRepository object.
	RepositoryRef *RepositoryRefDefinition `json:"repositoryRef,omitempty"`

	// Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
	SSHKnownHosts *string `json:"sshKnownHosts,omitempty"`

	// The interval at which to re-reconcile the cluster git repository source with the remote.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`

	// The maximum time to attempt to reconcile the cluster git repository source with the remote.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`

	// The URL to sync for the flux configuration git repository.
	URL *string `json:"url,omitempty"`
}

// HelmOperatorProperties - Properties for Helm operator.
type HelmOperatorProperties struct {
	// Values override for the operator Helm chart.
	ChartValues *string `json:"chartValues,omitempty"`

	// Version of the operator Helm chart.
	ChartVersion *string `json:"chartVersion,omitempty"`
}

// HelmReleasePropertiesDefinition - Properties for HelmRelease objects
type HelmReleasePropertiesDefinition struct {
	// Total number of times that the HelmRelease failed to install or upgrade
	FailureCount *int64 `json:"failureCount,omitempty"`

	// The reference to the HelmChart object used as the source to this HelmRelease
	HelmChartRef *ObjectReferenceDefinition `json:"helmChartRef,omitempty"`

	// Number of times that the HelmRelease failed to install
	InstallFailureCount *int64 `json:"installFailureCount,omitempty"`

	// The revision number of the last released object change
	LastRevisionApplied *int64 `json:"lastRevisionApplied,omitempty"`

	// Number of times that the HelmRelease failed to upgrade
	UpgradeFailureCount *int64 `json:"upgradeFailureCount,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// KustomizationDefinition - The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.
type KustomizationDefinition struct {
	// Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies
	// have completed their reconciliation.
	DependsOn []*string `json:"dependsOn,omitempty"`

	// Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
	Force *bool `json:"force,omitempty"`

	// The path in the source reference to reconcile on the cluster.
	Path *string `json:"path,omitempty"`

	// Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
	Prune *bool `json:"prune,omitempty"`

	// The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
	RetryIntervalInSeconds *int64 `json:"retryIntervalInSeconds,omitempty"`

	// The interval at which to re-reconcile the Kustomization on the cluster.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`

	// The maximum time to attempt to reconcile the Kustomization on the cluster.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`

	// READ-ONLY; Name of the Kustomization, matching the key in the Kustomizations object map.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// KustomizationPatchDefinition - The Kustomization defining how to reconcile the artifact pulled by the source type on the
// cluster.
type KustomizationPatchDefinition struct {
	// Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies
	// have completed their reconciliation.
	DependsOn []*string `json:"dependsOn,omitempty"`

	// Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
	Force *bool `json:"force,omitempty"`

	// The path in the source reference to reconcile on the cluster.
	Path *string `json:"path,omitempty"`

	// Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
	Prune *bool `json:"prune,omitempty"`

	// The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
	RetryIntervalInSeconds *int64 `json:"retryIntervalInSeconds,omitempty"`

	// The interval at which to re-reconcile the Kustomization on the cluster.
	SyncIntervalInSeconds *int64 `json:"syncIntervalInSeconds,omitempty"`

	// The maximum time to attempt to reconcile the Kustomization on the cluster.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
}

// ObjectReferenceDefinition - Object reference to a Kubernetes object on a cluster
type ObjectReferenceDefinition struct {
	// Name of the object
	Name *string `json:"name,omitempty"`

	// Namespace of the object
	Namespace *string `json:"namespace,omitempty"`
}

// ObjectStatusConditionDefinition - Status condition of Kubernetes object
type ObjectStatusConditionDefinition struct {
	// Last time this status condition has changed
	LastTransitionTime *time.Time `json:"lastTransitionTime,omitempty"`

	// A more verbose description of the object status condition
	Message *string `json:"message,omitempty"`

	// Reason for the specified status condition type status
	Reason *string `json:"reason,omitempty"`

	// Status of the Kubernetes object condition type
	Status *string `json:"status,omitempty"`

	// Object status condition type for this object
	Type *string `json:"type,omitempty"`
}

// ObjectStatusDefinition - Statuses of objects deployed by the user-specified kustomizations from the git repository.
type ObjectStatusDefinition struct {
	// Object reference to the Kustomization that applied this object
	AppliedBy *ObjectReferenceDefinition `json:"appliedBy,omitempty"`

	// Compliance state of the applied object showing whether the applied object has come into a ready state on the cluster.
	ComplianceState *FluxComplianceState `json:"complianceState,omitempty"`

	// Additional properties that are provided from objects of the HelmRelease kind
	HelmReleaseProperties *HelmReleasePropertiesDefinition `json:"helmReleaseProperties,omitempty"`

	// Kind of the applied object
	Kind *string `json:"kind,omitempty"`

	// Name of the applied object
	Name *string `json:"name,omitempty"`

	// Namespace of the applied object
	Namespace *string `json:"namespace,omitempty"`

	// List of Kubernetes object status conditions present on the cluster
	StatusConditions []*ObjectStatusConditionDefinition `json:"statusConditions,omitempty"`
}

// OperationStatusClientGetOptions contains the optional parameters for the OperationStatusClient.Get method.
type OperationStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationStatusClientListOptions contains the optional parameters for the OperationStatusClient.List method.
type OperationStatusClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationStatusList - The async operations in progress, in the cluster.
type OperationStatusList struct {
	// READ-ONLY; URL to get the next set of Operation Result objects, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of async operations in progress, in the cluster.
	Value []*OperationStatusResult `json:"value,omitempty" azure:"ro"`
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string `json:"status,omitempty"`

	// Fully qualified ID for the async operation.
	ID *string `json:"id,omitempty"`

	// Name of the async operation.
	Name *string `json:"name,omitempty"`

	// Additional information, if available.
	Properties map[string]*string `json:"properties,omitempty"`

	// READ-ONLY; If present, details of the operation error.
	Error *ErrorDetail `json:"error,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PatchExtension - The Extension Patch Request object.
type PatchExtension struct {
	// Updatable properties of an Extension Patch Request
	Properties *PatchExtensionProperties `json:"properties,omitempty"`
}

// PatchExtensionProperties - Updatable properties of an Extension Patch Request
type PatchExtensionProperties struct {
	// Flag to note if this extension participates in auto upgrade of minor version, or not.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Configuration settings that are sensitive, as name-value pairs for configuring this extension.
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings,omitempty"`

	// Configuration settings, as name-value pairs for configuring this extension.
	ConfigurationSettings map[string]*string `json:"configurationSettings,omitempty"`

	// ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion
	// is 'true'.
	ReleaseTrain *string `json:"releaseTrain,omitempty"`

	// Version of the extension for this extension, if it is 'pinned' to a specific version. autoUpgradeMinorVersion must be 'false'.
	Version *string `json:"version,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RepositoryRefDefinition - The source reference for the GitRepository object.
type RepositoryRefDefinition struct {
	// The git repository branch name to checkout.
	Branch *string `json:"branch,omitempty"`

	// The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
	Commit *string `json:"commit,omitempty"`

	// The semver range used to match against git repository tags. This takes precedence over tag.
	Semver *string `json:"semver,omitempty"`

	// The git repository tag name to checkout. This takes precedence over branch.
	Tag *string `json:"tag,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceProviderOperation - Supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`

	// Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; Origin of the operation
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// ResourceProviderOperationDisplay - Display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Description of this operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Resource provider: Microsoft KubernetesConfiguration.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// ResourceProviderOperationList - Result of the request to list operations.
type ResourceProviderOperationList struct {
	// List of operations supported by this resource provider.
	Value []*ResourceProviderOperation `json:"value,omitempty"`

	// READ-ONLY; URL to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Scope of the extension. It can be either Cluster or Namespace; but not both.
type Scope struct {
	// Specifies that the scope of the extension is Cluster
	Cluster *ScopeCluster `json:"cluster,omitempty"`

	// Specifies that the scope of the extension is Namespace
	Namespace *ScopeNamespace `json:"namespace,omitempty"`
}

// ScopeCluster - Specifies that the scope of the extension is Cluster
type ScopeCluster struct {
	// Namespace where the extension Release must be placed, for a Cluster scoped extension. If this namespace does not exist,
	// it will be created
	ReleaseNamespace *string `json:"releaseNamespace,omitempty"`
}

// ScopeNamespace - Specifies that the scope of the extension is Namespace
type ScopeNamespace struct {
	// Namespace where the extension will be created for an Namespace scoped extension. If this namespace does not exist, it will
	// be created
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// SourceControlConfiguration - The SourceControl Configuration object returned in Get & Put response.
type SourceControlConfiguration struct {
	// Properties to create a Source Control Configuration resource
	Properties *SourceControlConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SourceControlConfigurationList - Result of the request to list Source Control Configurations. It contains a list of SourceControlConfiguration
// objects and a URL link to get the next set of results.
type SourceControlConfigurationList struct {
	// READ-ONLY; URL to get the next set of configuration objects, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Source Control Configurations within a Kubernetes cluster.
	Value []*SourceControlConfiguration `json:"value,omitempty" azure:"ro"`
}

// SourceControlConfigurationProperties - Properties to create a Source Control Configuration resource
type SourceControlConfigurationProperties struct {
	// Name-value pairs of protected configuration settings for the configuration
	ConfigurationProtectedSettings map[string]*string `json:"configurationProtectedSettings,omitempty"`

	// Option to enable Helm Operator for this git configuration.
	EnableHelmOperator *bool `json:"enableHelmOperator,omitempty"`

	// Properties for Helm operator.
	HelmOperatorProperties *HelmOperatorProperties `json:"helmOperatorProperties,omitempty"`

	// Instance name of the operator - identifying the specific configuration.
	OperatorInstanceName *string `json:"operatorInstanceName,omitempty"`

	// The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period
	// only.
	OperatorNamespace *string `json:"operatorNamespace,omitempty"`

	// Any Parameters for the Operator instance in string format.
	OperatorParams *string `json:"operatorParams,omitempty"`

	// Scope at which the operator will be installed.
	OperatorScope *OperatorScopeType `json:"operatorScope,omitempty"`

	// Type of the operator
	OperatorType *OperatorType `json:"operatorType,omitempty"`

	// Url of the SourceControl Repository.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`

	// Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
	SSHKnownHostsContents *string `json:"sshKnownHostsContents,omitempty"`

	// READ-ONLY; Compliance Status of the Configuration
	ComplianceStatus *ComplianceStatus `json:"complianceStatus,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource provider.
	ProvisioningState *ProvisioningStateType `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Public Key associated with this SourceControl configuration (either generated within the cluster or provided
	// by the user).
	RepositoryPublicKey *string `json:"repositoryPublicKey,omitempty" azure:"ro"`
}

// SourceControlConfigurationsClientBeginDeleteOptions contains the optional parameters for the SourceControlConfigurationsClient.BeginDelete
// method.
type SourceControlConfigurationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SourceControlConfigurationsClientCreateOrUpdateOptions contains the optional parameters for the SourceControlConfigurationsClient.CreateOrUpdate
// method.
type SourceControlConfigurationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SourceControlConfigurationsClientGetOptions contains the optional parameters for the SourceControlConfigurationsClient.Get
// method.
type SourceControlConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SourceControlConfigurationsClientListOptions contains the optional parameters for the SourceControlConfigurationsClient.List
// method.
type SourceControlConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
