//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armeducation

import "time"

// Amount - The amount.
type Amount struct {
	// The type of currency being used for the value.
	Currency *string `json:"currency,omitempty"`

	// Amount value.
	Value *float32 `json:"value,omitempty"`
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponseBody - Error response indicates that the service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponseBody struct {
	// The details of the error.
	Error *ErrorResponse `json:"error,omitempty"`
}

// GrantDetailProperties - Grant detail properties
type GrantDetailProperties struct {
	// READ-ONLY; allocated budget
	AllocatedBudget *Amount `json:"allocatedBudget,omitempty" azure:"ro"`

	// READ-ONLY; Grant Effective Date
	EffectiveDate *time.Time `json:"effectiveDate,omitempty" azure:"ro"`

	// READ-ONLY; Expiration Date
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Offer Cap
	OfferCap *Amount `json:"offerCap,omitempty" azure:"ro"`

	// READ-ONLY; Grant Offer Type
	OfferType *GrantType `json:"offerType,omitempty" azure:"ro"`

	// READ-ONLY; Grant status
	Status *GrantStatus `json:"status,omitempty" azure:"ro"`
}

// GrantDetails - Grant details.
type GrantDetails struct {
	// Grant detail properties.
	Properties *GrantDetailProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GrantListResponse - List of Grants info.
type GrantListResponse struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of labs.
	Value []*GrantDetails `json:"value,omitempty" azure:"ro"`
}

// GrantsClientGetOptions contains the optional parameters for the GrantsClient.Get method.
type GrantsClientGetOptions struct {
	// May be used to include information about budget that has been allocated.
	IncludeAllocatedBudget *bool
}

// GrantsClientListAllOptions contains the optional parameters for the GrantsClient.ListAll method.
type GrantsClientListAllOptions struct {
	// May be used to include information about budget that has been allocated.
	IncludeAllocatedBudget *bool
}

// GrantsClientListOptions contains the optional parameters for the GrantsClient.List method.
type GrantsClientListOptions struct {
	// May be used to include information about budget that has been allocated.
	IncludeAllocatedBudget *bool
}

// InviteCodeGenerateRequest - invite code generate request.
type InviteCodeGenerateRequest struct {
	// the total number of students that can be accepted to the lab.
	MaxStudentCount *float32 `json:"maxStudentCount,omitempty"`
}

// JoinRequestDetails - join requests.
type JoinRequestDetails struct {
	// join request properties.
	Properties *JoinRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JoinRequestList - list of join requests.
type JoinRequestList struct {
	// READ-ONLY; the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of requests.
	Value []*JoinRequestDetails `json:"value,omitempty" azure:"ro"`
}

// JoinRequestProperties - Join request properties.
type JoinRequestProperties struct {
	// join request email
	Email *string `json:"email,omitempty"`

	// First Name
	FirstName *string `json:"firstName,omitempty"`

	// Last Name
	LastName *string `json:"lastName,omitempty"`

	// Join request status
	Status *JoinRequestStatus `json:"status,omitempty"`
}

// JoinRequestsClientApproveOptions contains the optional parameters for the JoinRequestsClient.Approve method.
type JoinRequestsClientApproveOptions struct {
	// placeholder for future optional parameters
}

// JoinRequestsClientDenyOptions contains the optional parameters for the JoinRequestsClient.Deny method.
type JoinRequestsClientDenyOptions struct {
	// placeholder for future optional parameters
}

// JoinRequestsClientGetOptions contains the optional parameters for the JoinRequestsClient.Get method.
type JoinRequestsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JoinRequestsClientListOptions contains the optional parameters for the JoinRequestsClient.List method.
type JoinRequestsClientListOptions struct {
	// Include denied
	IncludeDenied *bool
}

// LabDetails - Lab details.
type LabDetails struct {
	// Get lab response properties.
	Properties *LabProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LabListResult - List of labs.
type LabListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of labs.
	Value []*LabDetails `json:"value,omitempty" azure:"ro"`
}

// LabProperties - Lab detail result properties.
type LabProperties struct {
	// REQUIRED; Default monetary cap for each student in this lab
	BudgetPerStudent *Amount `json:"budgetPerStudent,omitempty"`

	// REQUIRED; Detail description of this lab
	Description *string `json:"description,omitempty"`

	// REQUIRED; Lab Display Name
	DisplayName *string `json:"displayName,omitempty"`

	// REQUIRED; Default expiration date for each student in this lab
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// READ-ONLY; Lab creation date
	EffectiveDate *time.Time `json:"effectiveDate,omitempty" azure:"ro"`

	// READ-ONLY; invitation code for redeemable lab
	InvitationCode *string `json:"invitationCode,omitempty" azure:"ro"`

	// READ-ONLY; the total number of students that can be accepted to the lab.
	MaxStudentCount *float32 `json:"maxStudentCount,omitempty" azure:"ro"`

	// READ-ONLY; The status of this lab
	Status *LabStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Total allocated budget
	TotalAllocatedBudget *Amount `json:"totalAllocatedBudget,omitempty" azure:"ro"`

	// READ-ONLY; Total budget
	TotalBudget *Amount `json:"totalBudget,omitempty" azure:"ro"`
}

// LabsClientCreateOrUpdateOptions contains the optional parameters for the LabsClient.CreateOrUpdate method.
type LabsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// LabsClientDeleteOptions contains the optional parameters for the LabsClient.Delete method.
type LabsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LabsClientGenerateInviteCodeOptions contains the optional parameters for the LabsClient.GenerateInviteCode method.
type LabsClientGenerateInviteCodeOptions struct {
	// set this flag to true if you want to update student count without generating a new invite code
	OnlyUpdateStudentCountParameter *bool
}

// LabsClientGetOptions contains the optional parameters for the LabsClient.Get method.
type LabsClientGetOptions struct {
	// May be used to include budget information.
	IncludeBudget *bool
}

// LabsClientListAllOptions contains the optional parameters for the LabsClient.ListAll method.
type LabsClientListAllOptions struct {
	// May be used to include budget information.
	IncludeBudget *bool
	// May be used to show deleted items.
	IncludeDeleted *bool
}

// LabsClientListOptions contains the optional parameters for the LabsClient.List method.
type LabsClientListOptions struct {
	// May be used to include budget information.
	IncludeBudget *bool
}

// ManagementClientRedeemInvitationCodeOptions contains the optional parameters for the ManagementClient.RedeemInvitationCode
// method.
type ManagementClientRedeemInvitationCodeOptions struct {
	// placeholder for future optional parameters
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// RedeemRequest - redeem request.
type RedeemRequest struct {
	// REQUIRED; first name of requester
	FirstName *string `json:"firstName,omitempty"`

	// REQUIRED; last name of requester
	LastName *string `json:"lastName,omitempty"`

	// REQUIRED; redeem code
	RedeemCode *string `json:"redeemCode,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StudentDetails - Student details.
type StudentDetails struct {
	// Get student response properties.
	Properties *StudentProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StudentLabDetails - Student lab details.
type StudentLabDetails struct {
	// Student lab properties.
	Properties *StudentLabProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StudentLabListResult - List of labs.
type StudentLabListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of labs.
	Value []*StudentLabDetails `json:"value,omitempty" azure:"ro"`
}

// StudentLabProperties - Student lab detail properties
type StudentLabProperties struct {
	// READ-ONLY; Student Budget
	Budget *Amount `json:"budget,omitempty" azure:"ro"`

	// READ-ONLY; Detail description of this lab
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Student lab Display Name
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; User Added Date
	EffectiveDate *time.Time `json:"effectiveDate,omitempty" azure:"ro"`

	// READ-ONLY; Date the lab will expire and by default will be the expiration date for each student in this lab
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Lab Scope. /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default
	LabScope *string `json:"labScope,omitempty" azure:"ro"`

	// READ-ONLY; Student Role
	Role *StudentRole `json:"role,omitempty" azure:"ro"`

	// READ-ONLY; Student Lab Status
	Status *StudentLabStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Subscription Id
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// StudentLabsClientGetOptions contains the optional parameters for the StudentLabsClient.Get method.
type StudentLabsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StudentLabsClientListAllOptions contains the optional parameters for the StudentLabsClient.ListAll method.
type StudentLabsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// StudentListResult - List of students.
type StudentListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of students.
	Value []*StudentDetails `json:"value,omitempty" azure:"ro"`
}

// StudentProperties - Student detail properties
type StudentProperties struct {
	// REQUIRED; Student Budget
	Budget *Amount `json:"budget,omitempty"`

	// REQUIRED; Student Email
	Email *string `json:"email,omitempty"`

	// REQUIRED; Date this student is set to expire from the lab.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// REQUIRED; First Name
	FirstName *string `json:"firstName,omitempty"`

	// REQUIRED; Last Name
	LastName *string `json:"lastName,omitempty"`

	// REQUIRED; Student Role
	Role *StudentRole `json:"role,omitempty"`

	// Subscription alias
	SubscriptionAlias *string `json:"subscriptionAlias,omitempty"`

	// subscription invite last sent date
	SubscriptionInviteLastSentDate *time.Time `json:"subscriptionInviteLastSentDate,omitempty"`

	// READ-ONLY; Date student was added to the lab
	EffectiveDate *time.Time `json:"effectiveDate,omitempty" azure:"ro"`

	// READ-ONLY; Student Lab Status
	Status *StudentLabStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Subscription Id
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// StudentsClientCreateOrUpdateOptions contains the optional parameters for the StudentsClient.CreateOrUpdate method.
type StudentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// StudentsClientDeleteOptions contains the optional parameters for the StudentsClient.Delete method.
type StudentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StudentsClientGetOptions contains the optional parameters for the StudentsClient.Get method.
type StudentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StudentsClientListOptions contains the optional parameters for the StudentsClient.List method.
type StudentsClientListOptions struct {
	// May be used to show deleted items.
	IncludeDeleted *bool
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
