/*
  actionvalidator.h

  This file is part of GammaRay, the Qt application inspection and
  manipulation tool.

  Copyright (C) 2012-2020 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com
  Author: Kevin Funk <kevin.funk@kdab.com>

  Licensees holding valid commercial KDAB GammaRay licenses may use this file in
  accordance with GammaRay Commercial License Agreement provided with the Software.

  Contact info@kdab.com if any conditions of this licensing are not clear to you.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GAMMARAY_ACTIONINSPECTOR_ACTIONVALIDATOR_H
#define GAMMARAY_ACTIONINSPECTOR_ACTIONVALIDATOR_H

#include <QObject>

#include <QHash>
#include <QKeySequence>

QT_BEGIN_NAMESPACE
class QAction;
QT_END_NAMESPACE

namespace GammaRay {
class ActionValidator : public QObject
{
    Q_OBJECT

public:
    explicit ActionValidator(QObject *parent = nullptr);

    QList<QAction *> actions() const;
    QList<QAction *> actions(const QKeySequence &sequence) const;

    void setActions(const QList<QAction *> &actions);
    void clearActions();

    void insert(QAction *action);
    void remove(QAction *action);

    /// helper method to find out if action has an ambiguous shortcut
    bool hasAmbiguousShortcut(const QAction *action) const;
    bool isAmbigous(const QAction *action, const QKeySequence &sequence) const;
    QVector<QKeySequence> findAmbiguousShortcuts(const QAction *action) const;

private Q_SLOTS:
    void handleActionDestroyed(QObject *object);

private:
    /// Does not deref the action pointer
    void safeRemove(QAction *action);

    // Multi-Map
    QHash<QKeySequence, QAction *> m_shortcutActionMap;
};
}

#endif // GAMMARAY_ACTIONVALIDATOR_H
